# Generics goals

<!--
Part of the Carbon Language project, under the Apache License v2.0 with LLVM
Exceptions. See /LICENSE for license information.
SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
-->

[Pull request](https://github.com/carbon-language/carbon-lang/pull/24)

## Problem

The "generics" feature of Carbon is a large design effort that needs to be
broken up into manageable steps. The first thing we need is a high-level goals
document:

-   to make sure we agree on the approach we are taking,
-   to clearly communicate expectations to contributors for future steps,
-   to encourage us to solve problems in the design in a consistent way,
-   to provide a yardstick for measuring different alternatives under
    consideration.

## Background

The question of what a generics feature would look like in Carbon has been an
ongoing discussion, with many alternative proposals. Of course there have been a
number of use cases that we want to address with this feature, but over the
course of this process we have discovered a number of desirable properties we
would like to achieve with any solution.

## Proposal

See the [generics goals document](/docs/design/generics/goals.md).

## Rationale

The goals here well reflect Carbon's goals as applied to the specifics of the
generics feature.
