# Conduct and moderation transparency reports

<!--
Part of the Carbon Language project, under the Apache License v2.0 with LLVM
Exceptions. See /LICENSE for license information.
SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
-->

## Overview

Carbon regularly publishes transparency reports that cover conduct issues that
have come up in our spaces as well as the moderation and other actions taken in
response. We prioritize keeping the Carbon community
[welcoming and inclusive](/docs/project/goals.md#community-and-culture) and
believe this kind of transparency is essential to sustaining that.

## Cadence and publishing

We publish a report quarterly in a GitHub discussion thread in the
[transparency reports](https://github.com/carbon-language/carbon-lang/discussions/categories/transparency-reports)
topic. We use the following template for each of these reports.

We may publish outside of the quarterly cycle if needed for an urgent response.

## Template

The Carbon community works to be welcoming and kind among itself and to others,
with a deep commitment to psychological safety, and we want to ensure that
doesn’t change as we grow and evolve. To that end, we have a few ground rules
that we ask all community members to adhere to:

-   be welcoming,
-   be friendly and patient,
-   be considerate,
-   be kind,
-   be careful in the words that we choose,
-   when we disagree, try to understand why, and
-   recognize when progress has stopped, and take a step back.

The following summary is intended to help the community understand what kinds of
Code of Conduct (CoC) incidents were brought to our attention lately, and how we
dealt with them.

Publishing such transparency reports in the future will help us track progress
and hold ourselves accountable to high standards of community culture.

### Summary

_[overview with overall number of interventions and mention of major community
related events during that period]_

Please note that some incidents may have escaped our attention. Please help us
keep our spaces welcoming and fostering a spirit of collaboration, and report
any situation that may require our intervention:
https://github.com/carbon-language/carbon-lang/blob/trunk/CODE_OF_CONDUCT.md

### Our interventions from _[YYYY-MM-DD (start date)]_ through _[YYYY-MM-DD (end date)]_

_[mention of preventive measures if applicable]_

These are the conduct incidents that were brought to our attention during the
last documentation period with the relevant sections of the Carbon community
Code of Conduct when this report was published:

-   > _[Quote1 from the Code of Conduct related to the following interventions]_

    _[Number of related incidents, and corresponding moderation interventions]_

-   > _[Quote2 from the Code of Conduct related to the following interventions]_

    _[Number of related incidents, and corresponding moderation interventions]_

-   > _[Quote3 from the Code of Conduct related to the following interventions]_

    _[Number of related incidents, and corresponding moderation interventions]_

### Closing observations

Thank you all for helping us keep such a fantastic Carbon community,

-- The Carbon Language community moderation team, together with the Carbon
leads.
