# Moderators

<!--
Part of the Carbon Language project, under the Apache License v2.0 with LLVM
Exceptions. See /LICENSE for license information.
SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
-->

## Overview

Moderation is primarily focused on Carbon's Discord and GitHub, but generally
applies to the [collaboration systems](/CONTRIBUTING.md#collaboration-systems).
Moderators are empowered to improve community discussion and enforce the
[Code of Conduct](/CODE_OF_CONDUCT.md). Conduct decisions are ultimately the
domain of the [Conduct team](/CODE_OF_CONDUCT.md#conduct-team), although
moderators will often act in order to protect the community.

All moderators will have the "moderator" role on Discord. Some moderators are
_senior moderators_, and will have extra privileges to help address harmful
conduct. Senior moderators will have the "senior-moderator" role on Discord.

## Becoming a moderator

TODO: Need to figure out right process for asking. (that is, how?)

The Conduct team reviews new moderators. Community members will be considered
mainly based on their history in Carbon Language community spaces (Discord,
GitHub, etc.), although applicants may also note history in other communities.

Prior to being granted moderation privileges, new moderators will need to attend
a workshop in order to help orient them with the Carbon Language community's
values and moderator expectations.

## Promotion to senior moderator

The Conduct team reviews promotions to senior moderator. Moderators will be
considered for promotion to senior moderators when:

-   They have demonstrated that they will be active moderators.
-   They are making decisions consistent with the
    [Code of Conduct](/CODE_OF_CONDUCT.md).
-   Senior moderators are taking actions which require senior moderator
    privileges at the moderator's request.

## Moderation powers

There is a moderation playbook for moderators with instructions on how to use
these powers. This enumerates specific actions a moderator may take.

-   **Discord**

    -   **Timeout user** (all): Prevent a user from sending messages on the
        Discord server for up to a week.

    -   **Delete message** (senior): Delete a message owned by another user.

    -   **Kick user** (senior): Temporarily remove a user from the Discord
        server. Note that users can rejoin the server, and so banning is
        typically preferred.

    -   **Ban user** (senior): Permanently remove a user from the Discord
        server.

    -   **Slow-mode** (senior): Limit the rate of discussion on a channel.

        -   Slow-mode is tied to the ability to generically edit channels.
            Moderators are generally expected to use the channel edit power
            judiciously, preferring to leave channel edits for admins.

-   **GitHub**

    -   **Convert issue to discussion** (all): Moves an issue to a discussion.
        This is mainly organizational.

    -   **Hide message** (all): Collapses a message so that its text is not
        immediately visible, reducing distractions. Recommended for moderators
        when a particular message is unproductive. Users can still view the
        original content.

        -   This cannot be done with the first message in a conversation.

    -   **Lock conversation** (senior): Prevent more discussion on a topic.

    -   **Edit message** (senior): Edits content of a message. Users can still
        view the original content.

    -   **Edit title** (senior): Edits the title of a thread.

    -   **Delete message** (senior): Removes a single message from a
        conversation. Hiding or editing messages is preferred.

        -   This cannot be done to the first message in a conversation.

    -   **Delete conversation** (senior): Deletes a full GitHub conversation.
        Hiding or editing messages is preferred.

    -   **Block user** (senior): Blocks a user from all repositories.

    -   Note: We use custom roles which have
        [limited access options](https://docs.github.com/en/enterprise-cloud@latest/organizations/managing-peoples-access-to-your-organization-with-roles/managing-custom-repository-roles-for-an-organization)
        versus what
        [base permissions](https://docs.github.com/en/organizations/managing-access-to-your-organizations-repositories/repository-roles-for-an-organization)
        allow.

-   **Google Docs**

    -   There are limited powers for moderators on Google Docs, but access to
        Google Docs is already restricted. At present, the right action is to
        respond or comment on an issue as needed, and report to the Conduct team
        if further steps are necessary.
