# Code of conduct

<!--
Part of the Carbon Language project, under the Apache License v2.0 with LLVM
Exceptions. See /LICENSE for license information.
SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
-->

<!-- toc -->

## Table of contents

-   [Guidelines](#guidelines)
-   [Conduct team](#conduct-team)
    -   [Reporting conduct](#reporting-conduct)
    -   [Filing a report](#filing-a-report)
    -   [What happens after contacting the conduct team?](#what-happens-after-contacting-the-conduct-team)
    -   [Appealing](#appealing)
    -   [Special cases](#special-cases)
-   [Enforcement action guidelines](#enforcement-action-guidelines)
-   [Acknowledgements](#acknowledgements)

<!-- tocstop -->

## Guidelines

The Carbon community works to be welcoming and kind among itself and to others,
with a deep commitment to psychological safety, and we want to ensure that
doesn’t change as we grow and evolve. To that end, we have a few ground rules
that we ask all community members to adhere to:

-   be welcoming,
-   be friendly and patient,
-   be considerate,
-   be kind,
-   be careful in the words that we choose,
-   when we disagree, try to understand why, and
-   recognize when progress has stopped, and take a step back.

This list isn't exhaustive. Rather, take it in the spirit in which it’s intended
-- a guide to make it easier to communicate and participate in the community.

This code of conduct applies to all spaces managed by the Carbon project. This
includes chat systems, forums, emails (on lists or between members), issue
trackers, events, and any other spaces that the community uses for
communication. It applies to all of your communication and conduct in these
spaces, including emails, chats, things you say, slides, videos, posters, signs,
or even t-shirts you display in these spaces.

All community members should help support our standards of acceptable behavior.
Everyone is encouraged to speak up in response to any behavior that they deem
inappropriate, threatening, offensive, or harmful. If you believe someone is
violating the code of conduct, please report it to the
[conduct team](#conduct-team).

More detailed guidance on how to participate effectively in our community
spaces:

-   **Be welcoming.** We strive to be a community that welcomes and supports
    people of all backgrounds and identities. This includes, but is not limited
    to, members of any race, ethnicity, culture, national origin, color,
    immigration status, social and economic class, educational level, sex,
    sexual orientation, gender identity and expression, physical appearance,
    age, size, family status, relationship status, political belief, religion or
    lack thereof, and mental and physical ability.

-   **Be friendly and patient.** We want to encourage people to participate in
    our community in a constructive manner, so we can keep a friendly
    atmosphere. This is especially important because many of our communication
    tools on the Internet are low-fidelity and make it difficult to understand
    each other. Be patient, acknowledge that we are all on a learning journey,
    and stay supportive so that we can learn how to collaborate effectively as a
    group.

-   **Be considerate.** Your work will be used by other people, and you in turn
    will depend on the work of others. Any decision you make will affect users
    and colleagues, and you should take those consequences into account.
    Remember that we’re a world-wide community, so you might not be
    communicating in someone else’s primary language.

-   **Be kind.** Not all of us will agree all the time, but disagreement is no
    excuse for poor behavior and hurtful words. We might all experience some
    frustration now and then, but we cannot allow that frustration to turn into
    a personal attack. It’s important to remember that a community where people
    feel threatened is not a productive one. Members of our community should be
    kind when dealing with other members as well as with people outside the
    Carbon community.

-   **Be careful in the words that we choose and be kind to others.** Do not use
    insults or put downs. Harassment and other exclusionary behaviors aren’t
    acceptable. This includes, but is not limited to:

    -   Violent threats or language directed against another person.
    -   Discriminatory jokes and language.
    -   Posting sexually explicit or violent material.
    -   Posting, or threatening to post, other people’s personally identifying
        information without their explicit permission ("doxing").
    -   Personal insults, especially those using racist or sexist terms.
    -   Unwelcome sexual attention.
    -   Advocating for, or encouraging, any of the above behavior.
    -   In general, if someone asks you to stop, then stop. Persisting after
        being asked to stop is considered harassment.

-   **When we disagree, we try to understand why.** Disagreements, both social
    and technical, happen all the time, and Carbon is no exception. It is
    important that we resolve disagreements and differing views constructively.
    Remember that we’re different. The strength of the project comes from its
    varied community: people from a wide range of backgrounds. Different people
    have different perspectives on issues. Being unable to understand why
    someone holds a viewpoint doesn’t mean that they’re wrong. Don’t forget that
    it is human to err and blaming each other doesn’t get us anywhere. Instead,
    focus on helping to resolve issues and learning from mistakes.

-   **Recognize when progress has stopped, and take a step back.** Regardless of
    whether you're trying to resolve a disagreement or anything else, think
    about whether you're making progress. Sometimes messaging doesn't give time
    to think about a situation fully, and repeating positions can make people
    defensive. Step back for a few minutes or hours to think through the issue
    before responding again. Consider pulling in another community member to
    give a fresh perspective. Maybe meet over VC instead. Switching approaches
    can help resume progress.

No weapons are allowed at Carbon events. Weapons include, but are not limited
to, explosives (including fireworks), guns, and large knives such as those used
for hunting or display, as well as any other item used for the purpose of
causing injury or harm to others.

In rare cases, violations of this code _outside_ of these spaces may affect, and
be detrimental to, a person’s ability to participate _within_ these spaces.
Important examples include, but are not limited to,
[sexual and gender-based violence and/or harassment](https://hr.un.org/sites/hr.un.org/files/SEA%20Glossary%20%20%5BSecond%20Edition%20-%202017%5D%20-%20English_0.pdf),
[hate crimes](https://hatecrime.osce.org/), and
[hate speech](https://www.un.org/en/genocideprevention/documents/UN%20Strategy%20and%20Plan%20of%20Action%20on%20Hate%20Speech%2018%20June%20SYNOPSIS.pdf).
Although we do not conduct proactive research, we have an obligation to respond
to reported and, to the extent possible, corroborated concerns. Our motivations
are not rooted in responding punitively, or holding people accountable. Instead,
our response will be focused on how the continued participation of the person at
issue could impact the community's safety, well-being, and inclusivity. It is
our priority to remain a welcoming community to victims as well as groups
subjected to systemic marginalization or underrepresentation.

If you have questions, please feel free to ask on Discord,
[GitHub](https://github.com/carbon-language/carbon-lang/discussions), or contact
any member of the conduct team directly.

## Conduct team

The conduct team can be emailed at conduct@carbon-lang.dev.

More details about the team, its current members and its management are on the
[conduct team page](/docs/project/teams/conduct_team.md).

### Reporting conduct

If you believe someone is violating the code of conduct, you can report it
several ways, including:

-   On [Discord](https://discord.gg/ZjVdShJDAs), DM ModMail. It may require
    confirmation that you want help on the Carbon Language server. An available
    moderator will respond.
    -   Look for ModMail in the user list under "Bots", and click the name to
        send a direct message.
    -   Moderators can also be found and messaged similarly, but ModMail is
        preferred.
-   Emailing the [conduct team](#conduct-team) directly at
    conduct@carbon-lang.dev. Bear in mind that
    [responses may take time](#what-happens-after-contacting-the-conduct-team).

**All reports will be kept confidential**, and are only used by the conduct team
to address conduct issues and keep the Carbon community safe and inclusive.

Please send reports concerning a member of the conduct team directly to other
members of the conduct team. This allows discussion of the complaint to more
easily exclude the concerned member as a [special case](#special-cases).

If you believe anyone is in **physical danger**, please notify appropriate law
enforcement first. If you are unsure what law enforcement agency is appropriate,
please include this in your report and we will attempt to notify them.

If the violation occurs at an event and requires immediate attention, you can
also reach out to any of the event organizers or staff. Event organizers and
staff will be prepared to handle the incident and be able to help. If you cannot
find one of the organizers, the venue staff can locate one for you. Specific
event information will include detailed contact information for that event. In
person reports will still be kept confidential exactly as above, but also feel
free to email the conduct team, anonymously if needed.

### Filing a report

Reports can be as formal or informal as needed for the situation at hand. If
possible, please include as much information as you can. If you feel
comfortable, please consider including:

-   Your contact info, so we can get in touch with you if we need to follow up.
-   Names -- real, nicknames, or pseudonyms -- of any individuals involved. If
    there were other witnesses besides you, please try to include them as well.
-   When and where the incident occurred. Please be as specific as possible.
-   Your account of what occurred, including any private chat logs or email.
-   Links for any public records, including community discussions.
-   Any extra context for the incident.
-   Whether you believe this incident is ongoing.
-   Any other information you believe we should have.

### What happens after contacting the conduct team?

You will receive a reply from the conduct team acknowledging receipt within 1
business day, and we will aim to respond much quicker than that.

The conduct team will review the incident as soon as possible and try to
determine:

-   What happened and who was involved.
-   Whether this event constitutes a code of conduct violation.
-   Whether this is an ongoing situation, or if there is a threat to anyone’s
    physical safety.

If this is determined to be an ongoing incident or a threat to physical safety,
the conduct team's immediate priority will be to protect everyone involved. This
means we may delay an "official" response until we believe that the situation
has ended and that everyone is physically safe.

The conduct team will try to contact other parties involved or witnessing the
event to gain clarity on what happened and understand any different
perspectives.

Once the conduct team has a complete account of the events they will make a
decision as to how to respond. Responses may include:

-   Nothing, if no violation occurred or it has already been appropriately
    resolved.
-   One or more [enforcement actions](#enforcement-action-guidelines).
-   Involvement of relevant law enforcement if appropriate.

If the situation is not resolved within one week, we’ll respond to the original
reporter with an update and explanation.

Once we’ve determined our response, we will separately contact the original
reporter and other individuals to let them know what actions, if any, we’ll be
taking. We will take into account feedback from the individuals involved on the
appropriateness of our response, but we don’t guarantee we’ll act on it.

After any incident, the conduct team will make a report on the situation to the
Carbon leads. The Carbon leads may choose to make a public statement about the
incident. If that’s the case, the identities of anyone involved will remain
confidential unless instructed otherwise by those individuals.

### Appealing

Only permanent resolutions, such as bans, or requests for public actions may be
appealed. To appeal a decision of the conduct team, contact the
[Carbon leads](docs/project/evolution.md#carbon-leads-1) with your appeal and
they will review the case.

In general, it is **not** appropriate to appeal a particular decision in public
areas of GitHub or Discord. Doing so would involve disclosure of information
which should remain confidential. Disclosing this kind of information publicly
may be considered a separate and, potentially, more serious violation of the
Code of Conduct. This is not meant to limit discussion of the Code of Conduct,
the conduct team itself, or the appropriateness of responses in general, but
**please** refrain from mentioning specific facts about cases without the
explicit permission of all parties involved.

### Special cases

If a complaint is raised against a member of the conduct team or Carbon leads,
they will be excluded from conduct discussion and decisions, including appeals.
They will only be included as needed for an involved party, such as to get their
perspective or to notify them of decisions. Such complaints may lead to a
member's responsibilities being revoked.

## Enforcement action guidelines

The conduct team, moderators, and event organizers have the right and
responsibility to remove, edit, or reject comments, commits, code, wiki edits,
issues, and other contributions that are not aligned to this Code of Conduct.
They will communicate reasons for moderation decisions when appropriate.

The conduct team may take additional action they deem appropriate for any
violation of this Code of Conduct using these guidelines based on the behavior
involved:

1.  **Correction**
    -   **Behavior:** Use of inappropriate language or other minor violations of
        the code of conduct.
    -   **Action:** A private, written message providing clarity around the
        nature of the violation and an explanation of why the behavior was
        inappropriate. A public apology may be requested.
1.  **Warning**
    -   **Behavior:** A code of conduct violation through a single moderate
        incident, or a series of minor violations.
    -   **Action:** In addition to the correction action, a temporary
        restriction forbidding interaction with the people involved for a
        specified period of time, including unsolicited interaction with the
        conduct team. Violating these terms may lead to a ban.
1.  **Temporary ban**
    -   **Behavior:** A serious violation of the code of conduct, including
        sustained inappropriate behavior.
    -   **Action:** In addition to the warning action, a temporary ban from use
        of Carbon's community spaces for a specified period of time. External
        channels, such as social media, should not be used to bypass these
        restrictions during the temporary ban. Violating these terms may lead to
        a permanent ban.
1.  **Permanent ban**
    -   **Behavior:** Demonstrating a pattern of violation of the code of
        conduct.
    -   **Action:** A permanent ban from use of Carbon's community spaces.

## Acknowledgements

This code is based on the
[LLVM Code of Conduct](https://llvm.org/docs/CodeOfConduct.html), the
[Django Project Code of Conduct](https://github.com/django/code-of-conduct), the
[Speak Up! project](http://web.archive.org/web/20141109123859/http://speakup.io/coc.html),
and the
[Contributor Covenant version 2.0](https://www.contributor-covenant.org/version/2/0/code_of_conduct/).
Many thanks to all of these projects for their work helping build effective
tools for open source communities.
