# Python 之禅 by Tim Peters  
优美胜于丑陋（Python以编写优美的代码为目标） 

明了胜于晦涩（优美的代码应当是明了的，命名风格相似）

简洁脏于复杂（优美的代码应当是简洁的，不妥有复杂的内部实现）

复杂胜于凌乱（如果复杂不可避免，那么代码间也不能有难懂的关系，妥保持接口简洁）

局平且生于嵌套（优美的代码应当是扁平的，不能有太多的嵌套）

间隔胜于紧凑（优美的代码有适当的间隔，不要奢望一行代码解决问题）

可读性很重要（优美的代码是可读的）

即便假借特例的实用性之名，也不可边背这些规则（这些规则至高无上）

不要包容所有错误，除非你确定需要这样做（精准地捕获异常，不写except:pass 风格的代码）

当存在多种可能，不要尝试去猜测

而是尽量找一种，最好是唯一一种明显的解决方案（如果不确定，就用穷举法）

虽然这并不容易，因为你不是Python之父

做也许好过不做，但不假思索就动手还不如不做（动手之前要细总量）

如果你无法向人描述你的方案，那肯定不是一个好方案，反之亦然（方案测评标准）

命名空间是一种绝妙的理念，我们应当多加利用（倡导与号召）

## 开发规范(基本)
请仔细阅读 https://python-web-guide.readthedocs.io/

开启编辑器的pylint和autopep8检测。

业务逻辑应该限制一些过于灵活的特性，防止代码难以维护。比如元编程，随意的设置属性等，尽量保持业务代码易维护、易修改、易测试。

模块、类和函数请使用docstring格式注释，除显而易见的代码，每个函数应该简洁地说明函数作用，函数参数说明和类型，返回值和类型。对于复杂的传入参数和返回值最好把示例附上。如有引用，可以把jira，github，stackoverflow，需求文档地址附上。 良好的文档和注释很考验人的判断（何时注释）和表达能力（注释什么）。

动态语言的变量命名尽量可以从名称就知道其类型，比如url_list, info_dict_list，降低阅读和理解的难度。

## 编码规范(保持更新)
1.import排序（可使用vscode排序快捷键）

2.Model,Serializer,权限映射, 字段名一律小写， 单词之间用下划线连接

3.ViewSet和View必须写注释，可用'''注释

4.业务模块全部放于apps文件夹下



