var Config = require('../config.js');

module.exports = {
  // TODO: remove dep on DOM event
  handleInstallEvent: function(event, model, onchange) {
    if (event) {
      event.preventDefault();
    }

    var status = model.get('status');
    var isInstallable = model.get('isInstallable');

    if (!isInstallable) {
      return;
    }

    if (status === Config.INSTALL_STATE.INSTALLED ||
        status === Config.INSTALL_STATE.ACTIVE) {
      // remove
      model.set({
        status: Config.INSTALL_STATE.REMOVING
      });
      model.destroy({
        dataType : 'json',
        silent: true
      });

      if (onchange) {
        model.on("change:status", onchange)
        model.on("change:download_progress", onchange)
      }
    } else if (status === Config.INSTALL_STATE.REMOVED) {
      // install
      model.save({
        status: Config.INSTALL_STATE.INSTALLING
      }, {
        dataType : 'json'
      });
    } else if (status === Config.INSTALL_STATE.INSTALLING) {
      model.save({
        status: "cancel"
      }, {
        dataType : 'json',
        type: 'post'
      });
    }

    return false;
  },
  handleEnableEvent: function(event, model) {
    if (event) {
      event.preventDefault();
    }

    var status = model.get('status');
    var isInstalled = model.get('isInstalled');

    if (!isInstalled) {
      return;
    }

    if (status === Config.INSTALL_STATE.INSTALLED) {
      //
      model.save({
        status: Config.INSTALL_STATE.ENABLING
      }, {
        dataType : 'json',
        type: 'post'
      });
    } if (status === Config.INSTALL_STATE.ACTIVE) {
      model.save({
        status: Config.INSTALL_STATE.DISABLING
      }, {
        dataType : 'json',
        type: 'post'
      });
    }

    return false;
  },
  getShowSnapUrlFor: function(model) {
    if (!model) {
      return;
    }
    var name = model['id'];
    return '/snap/' + name;
  },
};
