


import sys
sys.path.append('/Users/owatts/repos/ossian_2017_MOD/Ossian/scripts/')
sys.path.append('/Users/owatts/repos/ossian_2017_MOD/Ossian/scripts/processors')
from Tokenisers import RegexTokeniser
from Phonetisers import NaivePhonetiser
from FeatureExtractor import WorldExtractor
from FeatureDumper import FeatureDumper
from Aligner import StateAligner
from SKLProcessors import SKLDecisionTreePausePredictor 
from PhraseMaker import PhraseMaker
from AcousticModel import AcousticModelWorld

import default.const as c







## ----------------------------------------------------------------
## First define a few things used later:

## Some useful Xpaths and regex:--
#CONTENT_NODES = "//token[@token_class='word'] | //token[@token_class='punctuation']"
JUNCTURE_NODES = "//token[@token_class='space'] | //token[@token_class='punctuation']"

LETTER_PATT = '[\p{L}||\p{N}||\p{M}]'
PUNC_PATT = '[\p{C}||\p{P}||\p{S}]'
SPACE_PATT = '\p{Z}'
PUNC_OR_SPACE_PATT = '[\p{Z}||\p{C}||\p{P}||\p{S}]'

## 
speech_coding_config = {'order': 39, 'static_window': '1', 'delta_window': '-0.5 0.0 0.5', 'delta_delta_window': '1.0 -2.0 1.0'}


pause_predictor_features = [        
        ('response', './attribute::has_silence="yes"'), 
        ('token_is_punctuation', './attribute::token_class="punctuation"'),
        ('since_start_utterance_in_words', "count(preceding::token[@token_class='word'])"),
        ('till_end_utterance_in_words', "count(following::token[@token_class='word'])")
]     

        # L_vsm_d1 = ./preceding::token[@token_class!='space'][1]/attribute::word_vsm_d1
        # L_vsm_d2 = ./preceding::token[@token_class!='space'][1]/attribute::word_vsm_d2
        # L_vsm_d3 = ./preceding::token[@token_class!='space'][1]/attribute::word_vsm_d3
        # L_vsm_d4 = ./preceding::token[@token_class!='space'][1]/attribute::word_vsm_d4
        # L_vsm_d5 = ./preceding::token[@token_class!='space'][1]/attribute::word_vsm_d5
        # L_vsm_d6 = ./preceding::token[@token_class!='space'][1]/attribute::word_vsm_d6
        # L_vsm_d7 = ./preceding::token[@token_class!='space'][1]/attribute::word_vsm_d7
        # L_vsm_d8 = ./preceding::token[@token_class!='space'][1]/attribute::word_vsm_d8
        # L_vsm_d9 = ./preceding::token[@token_class!='space'][1]/attribute::word_vsm_d9
        # L_vsm_d10 = ./preceding::token[@token_class!='space'][1]/attribute::word_vsm_d10

        # C_vsm_d1 = ./attribute::word_vsm_d1
        # C_vsm_d2 = ./attribute::word_vsm_d2
        # C_vsm_d3 = ./attribute::word_vsm_d3
        # C_vsm_d4 = ./attribute::word_vsm_d4
        # C_vsm_d5 = ./attribute::word_vsm_d5
        # C_vsm_d6 = ./attribute::word_vsm_d6
        # C_vsm_d7 = ./attribute::word_vsm_d7
        # C_vsm_d8 = ./attribute::word_vsm_d8
        # C_vsm_d9 = ./attribute::word_vsm_d9
        # C_vsm_d10 = ./attribute::word_vsm_d10
        
        # R_vsm_d1 = ./following::token[@token_class!='space'][1]/attribute::word_vsm_d1
        # R_vsm_d2 = ./following::token[@token_class!='space'][1]/attribute::word_vsm_d2
        # R_vsm_d3 = ./following::token[@token_class!='space'][1]/attribute::word_vsm_d3
        # R_vsm_d4 = ./following::token[@token_class!='space'][1]/attribute::word_vsm_d4
        # R_vsm_d5 = ./following::token[@token_class!='space'][1]/attribute::word_vsm_d5
        # R_vsm_d6 = ./following::token[@token_class!='space'][1]/attribute::word_vsm_d6
        # R_vsm_d7 = ./following::token[@token_class!='space'][1]/attribute::word_vsm_d7
        # R_vsm_d8 = ./following::token[@token_class!='space'][1]/attribute::word_vsm_d8
        # R_vsm_d9 = ./following::token[@token_class!='space'][1]/attribute::word_vsm_d9
        # R_vsm_d10 = ./following::token[@token_class!='space'][1]/attribute::word_vsm_d10
        


    
label_contexts = [
        ## special named features:
        ('htk_monophone', './attribute::pronunciation'),
        ('start_time', './attribute::start'),
        ('end_time', './attribute::end'),

        ## normal features:
        ('ll_segment', 'preceding::segment[2]/attribute::pronunciation'),
        ('l_segment', 'preceding::segment[1]/attribute::pronunciation'),
        ('c_segment', './attribute::pronunciation'),
        ('r_segment', 'following::segment[1]/attribute::pronunciation'),
        ('rr_segment', 'following::segment[2]/attribute::pronunciation'),

        ## letter VSM features
        # ('l_segment_vsm_d1 =      preceding::segment[1]/attribute::segment_vsm_d1
        # ('l_segment_vsm_d2 =      preceding::segment[1]/attribute::segment_vsm_d2
        # ('l_segment_vsm_d3 =      preceding::segment[1]/attribute::segment_vsm_d3
        # l_segment_vsm_d4 =      preceding::segment[1]/attribute::segment_vsm_d4
        # l_segment_vsm_d5 =      preceding::segment[1]/attribute::segment_vsm_d5
        # c_segment_vsm_d1 =                          ./attribute::segment_vsm_d1
        # c_segment_vsm_d2 =                          ./attribute::segment_vsm_d2
        # c_segment_vsm_d3 =                          ./attribute::segment_vsm_d3
        # c_segment_vsm_d4 =                          ./attribute::segment_vsm_d4
        # c_segment_vsm_d5 =                          ./attribute::segment_vsm_d5
        # r_segment_vsm_d1 =      following::segment[1]/attribute::segment_vsm_d1
        # r_segment_vsm_d2 =      following::segment[1]/attribute::segment_vsm_d2
        # r_segment_vsm_d3 =      following::segment[1]/attribute::segment_vsm_d3
        # r_segment_vsm_d4 =      following::segment[1]/attribute::segment_vsm_d4
        # r_segment_vsm_d5 =      following::segment[1]/attribute::segment_vsm_d5
        
        
        ## WORD LEVEL:
        ('length_left_word', "count(ancestor::token/preceding::token[@token_class='word'][1]/descendant::segment)"),
        ('length_current_word', 'count(ancestor::token/descendant::segment)'),
        ('length_right_word', "count(ancestor::token/following::token[@token_class='word'][1]/descendant::segment)"),

        ('since_beginning_of_word', 'count(./preceding-sibling::segment)'),
        ('till_end_of_word', 'count(./following-sibling::segment)'),

        ## phrase LEVEL:
        ('length_l_phrase_in_words', "count(ancestor::phrase/preceding::phrase[1]/descendant::token[@token_class='word'])"),
        ('length_c_phrase_in_words', "count(ancestor::phrase/descendant::token[@token_class='word'])"),
        ('length_r_phrase_in_words', "count(ancestor::phrase/following::phrase[1]/descendant::token[@token_class='word'])"),

        ('length_l_phrase_in_segments', 'count(ancestor::phrase/preceding::phrase[1]/descendant::segment)'),
        ('length_c_phrase_in_segments', 'count(ancestor::phrase/descendant::segment)'),
        ('length_r_phrase_in_segments', 'count(ancestor::phrase/following::phrase[1]/descendant::segment)'),

        ('since_phrase_start_in_segs', 'count(ancestor::token/preceding-sibling::token/descendant::segment)'),
        ('till_phrase_end_in_segs', 'count(ancestor::token/following-sibling::token/descendant::segment)'),

        ('since_phrase_start_in_words', "count(ancestor::token/preceding-sibling::token[@token_class='word'])"),
        ('till_phrase_end_in_words', "count(ancestor::token/following-sibling::token[@token_class='word'])"),

        ## UTT LEVEL:
        ('since_start_utterance_in_segments', 'count(preceding::segment)'),
        ('since_start_utterance_in_words', "count(preceding::token[@token_class='word'])"),
        ('since_start_utterance_in_phrases', 'count(preceding::phrase)'),

        ('till_end_utterance_in_segments', 'count(following::segment)'),
        ('till_end_utterance_in_words', "count(following::token[@token_class='word'])"),
        ('till_end_utterance_in_phrases', 'count(following::phrase)'),

        ('length_utterance_in_segments', 'count(ancestor::utt/descendant::segment)'),
        ('length_utterance_in_words', "count(ancestor::utt/descendant::token[@token_class='word'])"),
        ('length_utterance_in_phrases', 'count(ancestor::utt/descendant::phrase)')
]



## ----------------------------------------------------------------
## Now, a number of utterance processors are defined:--

tokeniser = RegexTokeniser('word_splitter', target_nodes='//utt', split_attribute='text', \
                            child_node_type='token', add_terminal_tokens=True, \
                            class_patterns = [('space', '\A'+SPACE_PATT+'+\Z'), ('punctuation', '\A'+PUNC_OR_SPACE_PATT+'+\Z')], \
                            split_pattern='('+SPACE_PATT+'*'+PUNC_PATT+'*'+SPACE_PATT+'+|'+SPACE_PATT+'*'+PUNC_PATT+'+\Z)'  )
                                                    ## modified to handle word-internal hyphens

# phonetiser = RegexTokeniser('letter_splitter', target_nodes="//token[@token_class='word']", split_attribute='text', \
#                             child_node_type='segment', add_terminal_tokens=False, add_safetext=True, \
#                             split_pattern = '(.)', add_token_classes=False )

phonetiser = NaivePhonetiser('segment_adder', target_nodes="//token", target_attribute='text', child_node_type='segment', \
                            class_attribute='token_class', output_attribute='pronunciation', word_classes = ['word'], \
                            probable_pause_classes = ['punctuation', c.TERMINAL], possible_pause_classes=['space'])

speech_feature_extractor = WorldExtractor('acoustic_feature_extractor', input_filetype='wav', output_filetype='cmp', \
                            coding_config=speech_coding_config)

align_label_dumper = FeatureDumper(target_nodes='//segment', output_filetype='align_lab', contexts=[('segment', './attribute::pronunciation')])
 
aligner = StateAligner(target_nodes='//segment', target_attribute='pronunciation', input_label_filetype='align_lab', acoustic_feature_filetype='cmp', \
                    output_label_filetype='time_lab', silence_tag='has_silence', min_silence_duration=50, viterbi_beam_width='1000 100000 1000000', \
                    acoustic_subrecipe='standard_alignment')

pause_predictor = SKLDecisionTreePausePredictor(target_nodes=JUNCTURE_NODES, output_attribute='silence_predicted', contexts=pause_predictor_features)
        
phrase_adder = PhraseMaker(node_type_to_regroup='token', parent_node_type='phrase', \
                 attribute_with_silence='pronunciation', silence_symbol='sil')

label_maker = FeatureDumper(processor_name='labelmaker', target_nodes='//segment', context_separators='numbers', output_filetype='lab', \
                question_file='questions.hed', question_filter_threshold = 5, contexts=label_contexts)

acoustic_model = AcousticModelWorld(acoustic_subrecipe='quick_voicebuild_01', input_label_filetype='lab', \
    acoustic_feature_filetype='cmp', output_filetype='wav', vuv = 0.51, speech_coding_config=speech_coding_config, \
    training_settings={'NREEST': 3, 'NRECLUSTER': 2, 'BINMOD': " -B ", 'SUBSET': '60minutes'})


## -----------------------------------------------------------------
## The processors are grouped for convenience into several 'stages':

text_proc = [tokeniser, phonetiser]
alignment = [align_label_dumper, speech_feature_extractor, aligner, pause_predictor, phrase_adder]
pause_prediction = [pause_predictor, phrase_adder] 
speech_generation = [label_maker, acoustic_model]



## ----------------------------------------------------------------
## The final part of the config specifies which stages are run in each of the modes
## "train" and "runtime" (and optionally extra, specialised, modes):

train_stages   = [text_proc, alignment,        speech_generation]

runtime_stages = [text_proc, pause_prediction, speech_generation]

