#include <iostream>
#include <random>
#include <iomanip>
#include <string>

// FUNCTION OVERLOAD 1 
//-----------------------
// Note: The return type of this function must not be set to std::function<TInt (void)>
// or that will have a performance penalty as this container uses type erasure and heap allocation.
// This function returns lambda or an anonymous callable object, in other words, an object that overloads
// the operator()(), generated by the compiler.
template<typename TInt> 
auto make_uniform_random_distribution(TInt a, TInt b, long seed) 
{	    
	// std::default_random_engine engine(seed);
	std::mt19937 engine(seed);
	std::uniform_int_distribution<TInt> dist(a, b);
	// std::cout << " [INFO] seed = " << seed << std::endl;
	return [=]() mutable -> TInt { return dist(engine); };
}

// FUNCTION OVERLOADING 2
//----------------------------
template<typename TInt> 
auto make_uniform_random_distribution(TInt a, TInt b) 
{
   std::random_device rd;
   return make_uniform_random_distribution(a, b, rd()) ;
}

int main()
{
    #if 1 
	std::cout << "\n ===== Random numbers with a random seed ===="
			  << std::endl;
	{
		auto rnd = make_uniform_random_distribution<int>(1, 10);
        for(int i = 0; i < 15; i++){
			auto field = std::string(" x[") + std::to_string(i) + "] = "; 
			std::cout << std::setw(10)
					  << field
					  << std::setw(5) << rnd() << std::endl;
		}		
	}	
    #endif 

	std::cout << "\n ===== Random numbers with a non-random seed ===="
			  << std::endl;
	{
		// Initialize Random generator object with known and fixed
		// seed to reproduce computation results. 
		unsigned int seed = 1195785783;
		auto rnd = make_uniform_random_distribution<int>(1, 10, seed);
		
		/* Expected sequence: 6, 10, 2, 4, 1, 9, 10, 3, 6, ... */ 
		for(int i = 0; i < 15; i++)
        {
			auto field = std::string(" x[") + std::to_string(i) + "] = "; 
			std::cout << std::setw(10)
					  << field
					  << std::setw(5) << rnd() << std::endl;
		}		
	}	
	
	return 0;
}
