[bits 32]
global idt_load
extern idtp
idt_load:
	lidt [idtp]
	ret

global isr0
global isr1
global isr2
global isr3
global isr4
global isr5
global isr6
global isr7
global isr8
global isr9
global isr10
global isr11
global isr12
global isr13
global isr14
global isr15
global isr16
global isr17
global isr18
global isr19
global isr20
global isr21
global isr22
global isr23
global isr24
global isr25
global isr26
global isr27
global isr28
global isr29
global isr30
global isr31

%macro ISR_NOCODE 1 ;These are ISRs that don't have codes already pushed onto the stack
	isr%1:
		push dword 0
		push dword %1
		jmp isr_common
%endmacro

%macro ISR_CODE 1 ;These are ISRs that have codes already pushed onto the stack
	isr%1:
		push dword %1
		jmp isr_common
%endmacro

ISR_NOCODE 0  ;Generated by CPU: Divide by zero
ISR_NOCODE 1  ;Generated by CPU: Debug
ISR_NOCODE 2  ;Generated by CPU: Non Maskable Interrupt
ISR_NOCODE 3  ;Generated by CPU: Breakpoint
ISR_NOCODE 4  ;Generated by CPU: Detected Overflow
ISR_NOCODE 5  ;Generated by CPU: Out of Bounds
ISR_NOCODE 6  ;Generated by CPU: Invalid Opcode
ISR_NOCODE 7  ;Generated by CPU: No Coprocessor
ISR_CODE 8  ;Generated by CPU: Double Fault
ISR_NOCODE 9  ;Generated by CPU: Coprocessor Segment Overrun
ISR_CODE 10 ;Generated by CPU: Bad TSS
ISR_CODE 11 ;Generated by CPU: Segment Not Present
ISR_CODE 12 ;Generated by CPU: Stack Fault
ISR_CODE 13 ;Generated by CPU: General Protection Fault
ISR_CODE 14 ;Generated by CPU: Page Fault
ISR_NOCODE 15 ;Generated by CPU: Unknown Interrupt
ISR_NOCODE 16 ;Generated by CPU: Coprocessor Fault
ISR_CODE 17 ;Generated by CPU: Alignment Check
ISR_NOCODE 18 ;Generated by CPU: Machine Check
ISR_NOCODE 19
ISR_NOCODE 20
ISR_CODE 21
ISR_NOCODE 22
ISR_NOCODE 23
ISR_NOCODE 24
ISR_NOCODE 25
ISR_NOCODE 26
ISR_NOCODE 27
ISR_NOCODE 28
ISR_NOCODE 29
ISR_NOCODE 30
ISR_NOCODE 31

[extern fault_handler]

isr_common:
    pusha
    push ds
    push es
    push fs
    push gs
    mov ax, 0x10
    mov ds, ax
    mov es, ax
    mov fs, ax
    mov gs, ax
    mov eax, esp
    push eax
    mov eax, fault_handler
    call eax
    add esp, 4
    pop gs
    pop fs
    pop es
    pop ds
    popa
    add esp, 8
    iret

global irq0
global irq1
global irq2
global irq3
global irq4
global irq5
global irq6
global irq7
global irq8
global irq9
global irq10
global irq11
global irq12
global irq13
global irq14
global irq15

%macro irq 1
	irq%1:
		push byte 0
		push byte %1+32
		jmp irq_common
%endmacro

irq 0
irq 1
irq 2
irq 3
irq 4
irq 5
irq 6
irq 7
irq 8
irq 9
irq 10
irq 11
irq 12
irq 13
irq 14
irq 15

[extern irq_handler]

irq_common:
    pusha
    push ds
    push es
    push fs
    push gs
    mov ax, 0x10
    mov ds, ax
    mov es, ax
    mov fs, ax
    mov gs, ax
    cld
    push esp
    call irq_handler
    add esp, 4
    pop gs
    pop fs
    pop es
    pop ds
    popa
    add esp, 8
    iret

global _iret
_iret:
	iret
