Contributing to the Minum web framework
=======================================

This is an opinionated minimalist web framework to develop
server-side-rendered monolith hypermedia html-first web applications.

The thinking behind this project is described in the
[development handbook](docs/development_handbook.md/#on-minimalism).

Emphasis is on developing the leanest interface with the fewest
technologies, written as frugally and plainly as possible.
Performance, security, and maintainability are vital.

What is needed
--------------

* Clear documentation
* Examples
* Refinements and refactorings
* Fresh ideas (but staying minimalist)
* Reporting security vulnerabilities
* Performance tuning
* Bug removal
* Expanded testing


Please create a discussion to explain the situation before getting into coding.

If desiring to add a new capability to the system, describe how it
will benefit the user, with sufficient examples.  New features will
require a compelling explanation of the anticipated benefits.

The system will stay at 100% statement and branch coverage.  While it is not absolutely necessary
that your code get to that level, it is appreciated to provide good testing for
any new functionality. This is a good time to repeat that any new functionality should
start with a discussion, so that your effort is not wasted.
