<?php
/*
 * This document has been generated with
 * https://mlocati.github.io/php-cs-fixer-configurator/#version:3.12.0|configurator
 * you can change this configuration by importing this file.
 *
 * Thank you mlocati! ~ megasteve19
 */
$config = new PhpCsFixer\Config();

return $config
    ->setRules([
        'align_multiline_comment' => true,
        'array_syntax' => true,
        'blank_line_after_namespace' => true,
        'blank_line_after_opening_tag' => true,
        'blank_line_before_statement' => ['statements'=>['case', 'for', 'foreach', 'if', 'phpdoc', 'return', 'switch', 'throw', 'try', 'while']],
        'braces' => ['position_after_anonymous_constructs'=>'next', 'position_after_control_structures'=>'next'],
        'cast_spaces' => true,
        'class_attributes_separation' => true,
        'class_definition' => true,
        'class_reference_name_casing' => true,
        'clean_namespace' => true,
        'combine_consecutive_issets' => true,
        'combine_consecutive_unsets' => true,
        'compact_nullable_typehint' => true,
        'concat_space' => ['spacing'=>'one'],
        'constant_case' => true,
        'control_structure_braces' => true,
        'control_structure_continuation_position' => ['position'=>'next_line'],
        'curly_braces_position' => ['allow_single_line_anonymous_functions'=>false, 'allow_single_line_empty_anonymous_classes'=>false, 'anonymous_classes_opening_brace'=>'next_line_unless_newline_at_signature_end', 'anonymous_functions_opening_brace'=>'same_line', 'control_structures_opening_brace'=>'next_line_unless_newline_at_signature_end', 'functions_opening_brace'=>'next_line_unless_newline_at_signature_end'],
        'declare_equal_normalize' => ['space'=>'single'],
        'declare_parentheses' => true,
        'echo_tag_syntax' => ['format'=>'short'],
        'elseif' => true,
        'encoding' => true,
        'explicit_indirect_variable' => true,
        'explicit_string_variable' => true,
        'full_opening_tag' => true,
        'fully_qualified_strict_types' => true,
        'function_declaration' => ['closure_function_spacing'=>'none'],
        'function_typehint_space' => true,
        'heredoc_indentation' => true,
        'include' => true,
        'increment_style' => ['style'=>'post'],
        'indentation_type' => true,
        'lambda_not_used_import' => true,
        'line_ending' => true,
        'linebreak_after_opening_tag' => true,
        'list_syntax' => true,
        'lowercase_cast' => true,
        'lowercase_keywords' => true,
        'lowercase_static_reference' => true,
        'magic_constant_casing' => true,
        'magic_method_casing' => true,
        'method_argument_space' => true,
        'method_chaining_indentation' => true,
        'multiline_comment_opening_closing' => true,
        'multiline_whitespace_before_semicolons' => true,
        'native_function_casing' => true,
        'native_function_type_declaration_casing' => true,
        'new_with_braces' => true,
        'no_alias_language_construct_call' => true,
        'no_blank_lines_after_class_opening' => true,
        'no_blank_lines_after_phpdoc' => true,
        'no_closing_tag' => true,
        'no_empty_comment' => true,
        'no_empty_phpdoc' => true,
        'no_empty_statement' => true,
        'no_leading_namespace_whitespace' => true,
        'no_multiline_whitespace_around_double_arrow' => true,
        'no_multiple_statements_per_line' => true,
        'no_null_property_initialization' => true,
        'no_short_bool_cast' => true,
        'no_singleline_whitespace_before_semicolons' => true,
        'no_space_around_double_colon' => true,
        'no_spaces_after_function_name' => true,
        'no_spaces_around_offset' => true,
        'no_spaces_inside_parenthesis' => true,
        'no_trailing_comma_in_singleline' => true,
        'no_trailing_whitespace' => true,
        'no_trailing_whitespace_in_comment' => true,
        'no_unneeded_import_alias' => true,
        'no_unused_imports' => true,
        'no_useless_concat_operator' => true,
        'no_useless_else' => true,
        'no_useless_nullsafe_operator' => true,
        'no_useless_return' => true,
        'no_whitespace_before_comma_in_array' => true,
        'no_whitespace_in_blank_line' => true,
        'normalize_index_brace' => true,
        'nullable_type_declaration_for_default_null_value' => true,
        'object_operator_without_whitespace' => true,
        'operator_linebreak' => true,
        'ordered_imports' => true,
        'phpdoc_align' => ['align'=>'left'],
        'phpdoc_indent' => true,
        'phpdoc_line_span' => true,
        'phpdoc_no_access' => true,
        'phpdoc_no_alias_tag' => true,
        'phpdoc_order' => true,
        'phpdoc_separation' => true,
        'phpdoc_single_line_var_spacing' => true,
        'phpdoc_summary' => true,
        'phpdoc_tag_casing' => true,
        'phpdoc_tag_type' => true,
        'phpdoc_trim' => true,
        'phpdoc_trim_consecutive_blank_line_separation' => true,
        'phpdoc_types' => true,
        'phpdoc_types_order' => ['null_adjustment'=>'always_last'],
        'phpdoc_var_annotation_correct_order' => true,
        'phpdoc_var_without_name' => true,
        'return_type_declaration' => true,
        'semicolon_after_instruction' => true,
        'short_scalar_cast' => true,
        'simple_to_complex_string_variable' => true,
        'simplified_null_return' => true,
        'single_blank_line_before_namespace' => true,
        'single_class_element_per_statement' => true,
        'single_import_per_statement' => true,
        'single_line_after_imports' => true,
        'single_line_comment_spacing' => true,
        'single_line_throw' => true,
        'single_space_after_construct' => ['constructs'=>['abstract', 'as', 'attribute', 'break', 'case', 'comment', 'echo', 'if', 'implements', 'namespace', 'new', 'private', 'protected', 'public', 'readonly', 'var']],
        'space_after_semicolon' => true,
        'standardize_increment' => true,
        'standardize_not_equals' => true,
        'statement_indentation' => true,
        'switch_case_space' => true,
        'switch_continue_to_break' => true,
        'ternary_operator_spaces' => true,
        'ternary_to_null_coalescing' => true,
        'trailing_comma_in_multiline' => true,
        'trim_array_spaces' => true,
        'types_spaces' => true,
        'unary_operator_spaces' => true,
        'whitespace_after_comma_in_array' => ['ensure_single_space'=>false],
    ])
    ->setFinder(
        PhpCsFixer\Finder::create()
            ->exclude('vendor')
            ->in(__DIR__)
    );
