# Contributing

This Project welcomes contributions, suggestions, and feedback. All contributions, suggestions, and feedback you submitted are accepted under the Project's license. You represent that if you do not own copyright in the code that you have the authority to submit it under the Project's license. All feedback, suggestions, or contributions are not confidential.

## Organisation Contributing
The Project abides by the Organization's code of conduct and trademark policy. Please refer to our [Builtree Contributing Guidelines](https://github.com/bui`ltree/builtree/blob/main/governance/CODE-OF-CONDUCT.md).

# Contributing to Handwrite

Contributions can come in many forms, we always need help in improving the project. If you find issues with the documentation, usability, code, or even a question, please open an [issue](https://github.com/builtree/handwrite/issues) to let us know and or post in [Builtree Discord Server](https://discord.gg/9BtRZhJb9G)'s relevant channel.

## We Develop with Github
We use github to host code, to track issues and feature requests, as well as accept pull requests.

## We Use [Github Flow](https://docs.github.com/en/get-started/quickstart/github-flow), So All Code Changes Happen Through Pull Requests
Pull requests are the best way to propose changes to the codebase (we use [Github Flow](https://docs.github.com/en/get-started/quickstart/github-flow)). We actively welcome your pull requests:

1. Make sure there is an issue existing for your pull request. If not, get in touch with a maintainer/mentor and create one.
2. Make sure that issue has been acknowledged by the maintainer/mentor before you start working.
3. Fork the repo and create your branch from `main`.
4. If you've added code that should be tested, add tests (if the project supports tests or has a testing guideline). Ensure the test suite passes.
5. If you've changed a feature,API,etc., update the documentation.
6. Make sure your code lints.
7. Properly attach that pull request to its issue!

## Any contributions you make will be under the MIT License
In short, when you submit code changes, your submissions are understood to be under the same [MIT License](./LICENSE) that covers the project. Feel free to contact the maintainers if that's a concern.

## Report bugs using Github's [issues](https://github.com/builtree/handwrite/issues)
We use GitHub issues to track public bugs. Report a bug by [opening a new issue](https://github.com/builtree/handwrite/issues/new/choose); it's that easy!

## Write bug reports with detail
Make sure the bug reports are detaild and follow the bug issue template in the project.

**Great Bug Reports** tend to have:

- A quick summary and/or background
- Steps to reproduce
  - Be specific!
- What you expected would happen
- What actually happens
- Notes (possibly including why you think this might be happening, or stuff you tried that didn't work)

People *love* thorough bug reports!

## Coding Style

* Style point 1
* Style point 2

---
Part of MVG-0.1-beta.
Made with love by GitHub. Licensed under the [CC-BY 4.0 License](https://creativecommons.org/licenses/by-sa/4.0/).
