# Contributing

Follow these guidelines if you'd like to contribute to the project!

---

## Table of contents

Read through these guidelines before you get started:

1. [Questions & Concerns](#questions--concerns)
2. [Issues & Bugs](#issues--bugs)
3. [Feature Requests](#feature-requests)
4. [Submitting Pull Requests](#submitting-pull-requests)
5. [Code Style](#code-style)

## Questions & concerns

If you have any questions about using or developing for this project, reach out to @bugfishtm.

## Issues & bugs

Submit an issue or pull request with a fix if you find any bugs in
the project. When submitting an issue or pull request, make sure you're as detailed as possible and fill in all answers to questions asked in the templates. For example, an issue that simply states "X/Y/Z isn't working!" will be closed.

## Feature requests

Submit an issue to request a new feature. Features fall into one of two
categories:

1. **Major**: Major changes should be discussed via email. I'm
   always open to suggestions and will get back to you as soon as I can!
2. **Minor**: A minor feature can simply be added via a pull request.

## Submitting pull requests

Before you do anything, make sure you check the current list of pull requests 
to ensure you aren't duplicating anyone's work. Then, do the following:

1. Fork the repository and make your changes in a git branch: `git checkout -b my-branch base-branch`
2. Read and follow the code style guidelines.
3. Make sure your feature or fix doesn't break the project! Test thoroughly.
4. Commit your changes, and be sure to leave a detailed commit message.
5. Push your branch to your forked repo on GitHub: `git push origin my-branch`
6. Submit a pull request and hold tight!
7. If any changes are requested by the project maintainers, make them and follow this process again until the changes are merged in.

## Code style

Please mark your changes by comments inside the code structure.