# PHP Functions

## Documentation

Discover a collection of indispensable PHP functions crafted for seamless integration across various projects. Witness how these functions expedite and refine coding processes within web development. Comprehensive documentation for each function is provided below. To incorporate these functions seamlessly, include the PHP files within the designated `_functions` subfolder in the overarching `_framework` folder. This strategic approach optimizes coding efficiency and enhances web project performance.

Presenting our professional PHP Function Library, a valuable resource brimming with functions tailored for swift website deployment and efficiency. Explore the comprehensive collection within our framework's `/framework/functions/x_*` directory to streamline your development process and enhance your website's performance.

## CURL Functions

Functions to work with fast Curl Requests inside `x_curl.php`:

| CURL Function Name                 | Description                                 |
|-----------------------------------|---------------------------------------------|
| `x_curl_getfile($file, $newFileName)` | Download a file with Curl and save to `NewFileName`. |
| `x_curl_gettext($url)`              | Get text content of a Curl request to URL. |

## Thumbnail Functions

Functions to generate/work with thumbnails inside `x_library.php`:

| Thumbnail Function Name   | Description                                                                                         |
|---------------------------|-----------------------------------------------------------------------------------------------------|
| `x_thumbnail`             | Creates a thumbnail image from a URL and saves it to a file. Parameters include:                  |
|                           | - `url`: The URL of the image to create a thumbnail from.                                          |
|                           | - `filename`: The filename for the saved thumbnail.                                                |
|                           | - `width`: The width of the thumbnail.                                                             |
|                           | - `height`: The height of the thumbnail (or `true` to maintain aspect ratio).                       |
| `x_thumbnail_save`        | Creates a thumbnail image from a URL and optionally saves it to a file. Parameters include:       |
|                           | - `url`: The URL of the image to create a thumbnail from.                                          |
|                           | - `save_path`: An optional path to save the thumbnail file.                                        |
|                           | - `width`: The width of the thumbnail.                                                             |
|                           | - `height`: The height of the thumbnail (or `true` to maintain aspect ratio).                       |

## Library Functions

Some functions that do not fit into other sections inside `x_library.php`:

### Various Functions

| Library Function Name                | Description                                                             | Parameter                                                                                                                     |
|-------------------------------------|-------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------|
| `x_copy_directory($src, $dst)`       | Copy content of a folder recursively to another folder.                 | - `src`: Folder Path (FULL) to Copy.<br>- `dst`: Destination Folder Name to Copy to.                                         |
| `x_htaccess_secure($path)`           | Secure a folder by placing an `.htaccess` file to deny folder content.   | - `path`: Path where the `.htaccess` should be placed.                                                                       |
| `x_getRelativeFolderFromURL($url)`   | Extract relative path from full URL string.                             | - `url`: The URL the relative folder should be extracted from.                                                               |
| `x_firstimagetext`                  | Get first image out of "a" tag from text string.                        | - `text`: Input text containing HTML.<br>- `all`: Whether to return all image tags or just the first one.                    |
| `x_connection_check`                | Check a connection with `fsockopen`.                                    | - `host`: Hostname or IP address to check the connection to.<br>- `port`: Port number to check.<br>- `timeout`: Timeout duration in seconds. |
| `x_inCLI`                           | Check if the current script execution is handled via CGI and not in a web browser. | Checks if the script is running in a Command Line Interface (CLI) environment and returns `true` if it is, `false` otherwise. |
| `x_rmdir`                           | Recursively delete a folder.                                            | - `dir`: Directory path to be deleted recursively.                                                                          |
| `x_html_redirect`                   | Spawn HTML redirect meta tag for simple HTML redirects.                 | - `url`: URL to redirect to.<br>- `seconds`: Number of seconds before the redirection occurs.                                 |

### Validation Functions

| **Function**               | **Description**                                                                                                                                                     | **Explanation**                                                                                                                                                                                                                                                                                                                                                                                                                     |
|----------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `x_isset($val)`            | Checks if a value is not null and has a length greater than 0 after trimming.                                                                                       | The function returns `true` if `$val` is set, is not empty after trimming, and has a length greater than 0. The `@` operator suppresses errors in case `$val` is undefined, and the null coalescing operator (`??`) ensures a fallback to an empty string if `$val` is null.                                                                                                              |
| `x_imgValid($url)`         | Validates if a string is a valid image URL by checking its existence and if it is an image.                                                                         | The function checks if `$url` is set and is a string with a length greater than 3. It then attempts to fetch the image size using `getimagesize()`, which confirms if the URL points to a valid image. If these conditions aren't met, it returns `false`.                                                                                                                                                                          |
| `x_hsc($string)`           | Safely encodes special characters in a string to HTML entities.                                                                                                     | The function uses `htmlspecialchars()` to convert special characters to HTML entities, helping to prevent XSS attacks. If `$string` is null or undefined, it defaults to an empty string.                                                                                                                                                                                                                                         |
| `x_het($string)`           | Converts all applicable characters in a string to HTML entities.                                                                                                    | The function uses `htmlentities()` to convert all applicable characters to HTML entities, ensuring that the string is safe for output in an HTML context. Similar to `x_hsc()`, it handles null or undefined values gracefully.                                                                                                                                                                                                    |
| `x_trim($string)`          | Trims whitespace from both sides of a string.                                                                                                                       | The function uses `trim()` to remove whitespace from the beginning and end of the string. The `@` operator handles cases where `$string` might be undefined.                                                                                                                                                                                                                                                                       |
| `x_contains_cyrillic($val)`| Checks if a string contains Cyrillic characters.                                                                                                                    | The function uses a regular expression to check if `$val` contains any Cyrillic characters. If it does, it returns `true`; otherwise, it returns `false`. The regular expression pattern `[\p{Cyrillic}]` matches any Cyrillic character.                                                                                                                                                                                          |
| `x_contains_bad_word($val)`| Checks if a string contains the word "porn" or "Porn".                                                                                                              | The function checks if the string contains " porn " or " Porn " (with spaces around). If either is found, the function returns `false` (indicating it's a "bad" word). If neither is found, it returns `true`.                                                                                                                                                                                                                      |
| `x_contains_url($val)`      | Checks if a string contains an HTTP or HTTPS URL.                                                                                                                  | The function looks for the substrings "http://" or "https://" within `$val`. If found, it returns `false` (indicating that a URL is present). If neither is found, it returns `true`.                                                                                                                                                                                                                                             |
| `x_getint($val)`           | Retrieves a value from the `$_GET` array if it's numeric.                                                                                                           | The function checks if the value associated with the key `$val` in the `$_GET` array is numeric. If it is, it returns the value; otherwise, it returns `false`. The `@` operator handles cases where the key does not exist.                                                                                                                                                                                                        |
| `x_postint($val)`          | Retrieves a value from the `$_POST` array if it's numeric.                                                                                                          | Similar to `x_getint()`, this function checks if the value associated with the key `$val` in the `$_POST` array is numeric. If so, it returns the value; otherwise, it returns `false`. The `@` operator handles cases where the key does not exist.                                                                                                                                                                              |
| `x_get($val)`              | Retrieves a value from the `$_GET` array if it exists.                                                                                                              | The function checks if the key `$val` exists in the `$_GET` array. If it does, it returns the corresponding value; otherwise, it returns `false`. The `@` operator handles undefined keys.                                                                                                                                                                                                                                         |
| `x_post($val)`             | Retrieves a value from the `$_POST` array if it exists.                                                                                                             | Similar to `x_get()`, this function checks if the key `$val` exists in the `$_POST` array. If it does, it returns the corresponding value; otherwise, it returns `false`. The `@` operator handles undefined keys.                                                                                                                                                                                                                 |
| `x_datediff_before($d1, $d2, $length)` | Checks if the difference between two dates is greater than a specified length (in days).                                                            | The function calculates the difference between two dates (`$d1` and `$d2`) and returns `true` if the difference (in days) is greater than `$length`. If either date is `false`, it returns `false`. The `date_diff()` function is used to calculate the interval, and `format('%a')` returns the difference in days.                                                                                                              |


## Button Functions

Functions to work with buttons, which can execute code and more inside `x_button.php`:

| **Function**                    | **Description**                                                                                                                                                                                                                                                                                                                                                                             | **Explanation**                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
|---------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `x_executionButton($db, $name, $url, $query, $get, $msgerr = "Fehler!", $msgok = "Erfolgreich!", $break = false, $style = "")` | Creates an execution button that performs a database query when clicked and refreshes the page.                                                                                                                                                                                                                                                                                          | The function constructs a URL with the specified `$get` parameter and generates an anchor tag (`<a>`) styled as a button. If the URL contains the query parameter `?`, it appends the `$get` parameter; otherwise, it adds it. If the button is clicked, it checks for the `$get` parameter in `$_GET`. If found, it executes the given SQL query using the database connection (`$db`). If successful, it refreshes the page with the updated URL after removing the `$get` parameter. |
| `x_button($name, $url, $break = false, $style = "", $reacttourl = true)`                 | Creates a simple button that links to a specified URL, optionally applying a different style if the current URL matches the link.                                                                                                                                                                                                                                                       | The function generates an anchor tag (`<a>`) styled as a button, with the specified `$url` and `$name`. If `$reacttourl` is `true` and the current URL matches the `$url`, the button style is modified to indicate it as inactive. Optionally, the button can be followed by a line break if `$break` is `true`.                                                                                                                                                                                                                         |

## Eventbox Functions

Functions to spawn notification boxes for users inside `x_eventbox.php`:

| **Function**                     | **Description**                                                                                                                                                                                                                                                                                                                                                                                                                                   | **Explanation**                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
|----------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `x_eventBoxPrep($text, $type = "x", $precookie = "", $morecss = "", $buttontext = "X", $imgok = false, $imgfail = false, $imgwarn = false, $imgelse = false)` | Prepares an event box with specified text, style, and optional images, saving it to a session variable for later display.                                                                                                                                                                                                                                                                                 | The function creates an event box with a message (`$text`) and a specific type (`$type`), such as "success", "warning", or "error". It can include an image depending on the type. The event box's HTML and CSS are generated, including a close button (`$buttontext`). The generated content is stored in a session variable (`$_SESSION`) using the prefix `$precookie`. The box styling can be customized with the `$morecss` parameter.                                                                                         |
| `x_eventBoxShow($precookie = "")`              | Displays the prepared event box by echoing the stored session variable, then clears the session variable.                                                                                                                                                                                                                                                                                                 | The function checks if the event box should be skipped (using a session variable). If not, it echoes the HTML stored in the session variable created by `x_eventBoxPrep()`, then unsets (deletes) the session variable to prevent repeated display. The `$precookie` parameter allows handling of multiple event boxes with different prefixes.                                                                                                                                                                                 |
| `x_eventBoxSet($precookie = "")`               | Checks if an event box has been prepared and is stored in the session.                                                                                                                                                                                                                                                                                                                                   | The function checks if a session variable for an event box exists, returning `true` if it does and `false` otherwise. This can be used to determine if an event box has already been prepared. The `$precookie` parameter allows for checking different prefixed session variables.                                                                                                                                                                                                                                          |
| `x_eventBoxSkip($precookie = "")`              | Sets a session variable to skip displaying the event box.                                                                                                                                                                                                                                                                                                                                                | The function sets a session variable that prevents the event box from being displayed. This is useful if the event box should be temporarily skipped without clearing its content. The `$precookie` parameter allows this behavior to be controlled for specific prefixed event boxes.                                                                                                                                                                                                                                      |

## Cookie Banner Functions

Function to spawn a simple cookie banner for users inside `x_cookiebanner.php`:

| **Function**                                    | **Description**                                                                                                                                                                                                                                             | **Explanation**                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
|-------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `x_cookieBanner_Pre($precookie = "", $redirect = true)` | Prepares the cookie banner by setting a session variable if the banner is acknowledged, and optionally redirects to the current page.                                                                                                                    | The function checks if a session is active; if not, it starts one. It then checks if the cookie banner has been acknowledged by looking for a specific session variable. If the banner is acknowledged (via POST or GET request), it sets this session variable and optionally redirects to the current page. This helps to prevent showing the banner repeatedly after acknowledgment.                                                                                                          |
| `x_cookieBanner($precookie = "", $use_post = false, $text = false, $url_cookies = "", $redirect_url = false, $button_text = "I Agree")` | Displays a cookie consent banner with options for custom text, a redirect URL, and POST/GET submission handling.                                                                                      | The function checks if a session is active; if not, it starts one. It determines whether to display the banner based on a session variable. If the banner is not acknowledged, it displays the banner with customizable text. The form can use GET or POST methods depending on the `$use_post` parameter. If a `$redirect_url` is provided, the form action will redirect to this URL upon submission. The `$button_text` parameter sets the button label.  |

## RSS Functions

Functions related to RSS feeds inside `x_rss.php`:

| **Function**                 | **Description**                                                                                                                                                                                                                                                                                                                                                                                                       | **Explanation**                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
|------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `x_rss_list($urltemp, $defaultcover, $limit = 25)` | Fetches RSS feed items from a given URL, processes them, and displays them with a default cover image if needed. Limits the number of items displayed.                                                                                                                                                                                                                                                               | The function loads the RSS feed from the provided URL (`$urltemp`) using `DOMDocument`. It extracts the title, link, publication date, and image URL from each feed item. It processes up to `$limit` items, ensuring that if no cover image is provided, a default image (`$defaultcover`) is used. It formats the date and displays each item as a clickable div with an image and title. If the image URL does not start with "http", it prepends "https://". |
| `x_rss_array($urltemp)`       | Fetches RSS feed items from a given URL and returns them as an array.                                                                                                                                                                                                                                                                                                                                                 | The function loads the RSS feed from the provided URL (`$urltemp`) using `DOMDocument`. It extracts the title, link, publication date, and image URL from each feed item and stores them in an associative array. The resulting array of feed items is returned. This array can be used for further processing or display.                                                                                                                                           |


## Table Functions

Functions to spawn tables inside `x_table.php`:

| **Function**                                    | **Description**                                                                                                                                                                                                                                                | **Explanation**                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
|-------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `x_table_div($array, $titlelist, $alignarray = false, $percentarray = false, $title = false)` | Renders a styled table in a `div` container, with customizable column alignment, width percentages, and optional title.                                                                                                                                       | The function creates a `div` containing a table with column titles and rows of data. It starts by optionally displaying a title. Column titles are styled based on alignment (`$alignarray`) and width percentages (`$percentarray`). It then populates rows of the table using data from `$array`, alternating row colors. Each column's width and alignment are controlled by the given parameters. If no cover image is provided, a default image is used.                |
| `x_table_complex($array, $titlelist, $formid = "", $alignarray = false)` | Generates a table with search functionality, allowing filtering of data through input fields in the table headers.                                                                                                        | This function creates an HTML form with a table that includes search input fields in the headers. Each input field corresponds to a column in the table and allows users to filter rows based on their input. The table displays rows from `$array` that match the search criteria. The `$formid` parameter helps generate a unique ID for the form. Data filtering is performed using POST requests and the search fields' values.                  |
| `x_table_simple($array, $titlelist, $tableid = "x_table_simple", $alignarray = false)` | Displays a simple table with specified column titles and alignment, and an optional ID for the table.                                                                                                                                 | The function generates a basic HTML table with headers and rows from `$array`. It allows for customizable column alignment through `$alignarray` and sets the table ID via `$tableid`. If `$array` is empty, a message indicating no data is shown. Each cell's text alignment is determined based on the provided alignment array or defaults to left, right, or center. The table displays data without additional styling or features. |


## Captcha Functions

Functions to spawn captchas inside `x_captcha.php`:

| **Function**                         | **Description**                                                                                                 | **Explanation**                                                                                                                                                                                                                                                                                                                                                                                                                             |
|--------------------------------------|---------------------------------------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `x_captcha($preecookie = "", $width = 550, $height = 250, $square_count = 5, $eclipse_count = 5, $color_ar = false, $font = "", $code = "")` | Generates a CAPTCHA image with customizable dimensions, shapes, colors, and text.                                                                           | The function creates a CAPTCHA image for verification purposes. It initializes colors for squares, ellipses, background, and text. It then creates an image of specified dimensions and draws randomly placed squares and ellipses. The CAPTCHA code is stored in the session and rendered onto the image using a specified font. Headers are set to prevent caching of the image. The resulting image is output as JPEG. |
| `x_captcha_key($preecookie = "")`    | Retrieves the CAPTCHA code stored in the session.                                                            | This function returns the CAPTCHA code stored in the session variable specified by `$preecookie`. This allows for the comparison of user input against the generated CAPTCHA code to verify correctness.                                                                                                                                                                                                                          |



## Search Functions

**Warning: This function is experimental!**
Functions to search with scoring inside `x_search.php`:

| **Section**                       | **Description**                                                                                                           |
|-----------------------------------|---------------------------------------------------------------------------------------------------------------------------|
| **Function Signature**            | `function x_search($mysql, $table, $search_fields = array(), $get_fields = array(), $search_string = "", $uniqueref = "id")` |
| **Purpose**                       | Searches a database table based on a search string, scores the results, and returns them sorted by relevance.             |
| **Parameters**                    | - `$mysql`: Database connection object. <br> - `$table`: Name of the table to search. <br> - `$search_fields`: Fields to search within. <br> - `$get_fields`: Fields to return in the results. <br> - `$search_string`: The search term or terms. <br> - `$uniqueref`: Unique identifier field for sorting. |
| **Abort Condition**               | Checks if the search string is empty or null. If true, returns `false`.                                                   |
| **Trim Search String**            | Removes extra whitespace from the search string.                                                                         |
| **Split Search String**           | Splits the search string into an array of terms if it contains spaces; otherwise, treats it as a single term.               |
| **Initialize Query and Bind Array**| Prepares the SQL query and binds array for parameterized queries.                                                            |
| **Build Query**                   | Constructs the SQL query with conditions for each search term. <br> - For the first term, includes specific fields. <br> - For subsequent terms, adds conditions for additional search fields. |
| **Prepare Bind Array**            | Adds each search term to the binding array for the SQL query.                                                                |
| **Execute Query**                 | Executes the SQL query using the `$mysql` object and retrieves the results.                                                 |
| **Score Calculation**             | Calculates a relevance score for each result based on term frequency and weight.                                             |
| **Sort Results**                  | Sorts the results by the calculated score in descending order using `array_multisort()`.                                      |
| **Return Results**                | Constructs and returns an array of results sorted by relevance.                                                              |
| **Fallback**                      | Returns an empty array if no results are found or if the scoring array is empty.                                            |