

![Bugfish](https://img.shields.io/badge/Bugfish-Framework-orange)
![Status](https://img.shields.io/badge/Status-Finished-green)
![License](https://img.shields.io/badge/License-GPLv3-black)
![Version](https://img.shields.io/badge/Version-3.00-white)

# Bugfish Framework Documentation

**Repository:** [Bugfish Framework on GitHub](https://github.com/bugfishtm/bugfish-framework)  
**Documentation:** [Bugfish Framework Documentation](https://bugfishtm.github.io/bugfish-framework/)

![a](./logo.jpg)

**Comprehensive Documentation Available:** The Bugfish Framework project is proud to provide a detailed documentation that elucidates every function and class within the framework. This extensive documentation can be found at [bugfish-github.de](https://bugfishtm.github.io/bugfish-framework/) and offers invaluable insights into the operation of each component.

## Bugfish Framework

The Bugfish Framework is a robust toolkit designed to empower web developers to create high-performance web applications while maintaining the highest standards of security and flexibility. By embracing the Bugfish PHP Framework, you gain access to a community dedicated to unlocking the full potential of your web development endeavors.

### Folder Description

The Bugfish Framework repository is organized into various folders, each serving a distinct purpose. You can find release packages, the core framework, and additional development-related documents within the repository's folders. The documentation for the framework and this repository's GitHub Page can be found in the "docs" folder.

| Folder     | Description                                          |
|------------|------------------------------------------------------|
| _release   | Release Packages                                    |
| _framework | The Core Framework                                  |
| _misc      | Miscellaneous Documents for Development            |
| _images      | Images related to this Framework            |
| docs       | Framework Documentation and GitHub Page            |

## PHP Functions

Within the Bugfish Framework, you will discover a professional PHP Function Library filled with functions optimized for swift website deployment and efficiency. To streamline your development process and enhance your website's performance, explore the comprehensive collection located within our framework's /framework/functions/x_* directory.

## PHP Classes

The Bugfish Framework features essential PHP classes renowned for their exceptional functionality, time-saving capabilities, and rigorous testing across various websites. These invaluable resources can be found within the /_framework/classes/x_* directory, ensuring a seamless and efficient development experience. Some classes may require a database connection, and the necessary tables will be automatically installed by the classes if you provide the required parameters in the configuration functions. For more details, refer to the comprehensive documentation available on [bugfish-github.de](https://bugfishtm.github.io/bugfish-framework/).

| Name                   | Description                                                                                                                           | License    |
|------------------------|---------------------------------------------------------------------------------------------------------------------------------------|------------|
| ✅x_class_api          | Facilitates the creation of simple and secure API requests. Requires PHP Module CURL. Supports token-authentication and more.          | GPLv3      |
| ✅x_class_benchmark    | Benchmarks resource consumption for sites on your website. Values saved in a database per URL.                                        | GPLv3      |
| ✅x_class_block        | Facilitates session-based user counting and block operations. Makes it easy to block users from various areas.                          | GPLv3      |
| ✅x_class_table        | Simplifies the creation of dynamic HTML tables with quick PHP editing capabilities.                                                  | GPLv3      |
| ✅x_class_eventbox     | Simplifies the display of user notifications and messages on a web page.                                                              | GPLv3      |
| ✅x_class_comment      | Enables commenting functionality, suitable for guestbooks or website comment sections.                                                | GPLv3      |
| ✅x_class_csrf         | Provides robust CSRF protection for web forms, supporting external actions.                                                           | GPLv3      |
| ✅x_class_curl         | Efficiently handles Curl requests and logs them for web operations. Requires PHP Module CURL.                                          | GPLv3      |
| ✅x_class_debug        | Aids in debugging and offers development notifications and functions.                                                                | GPLv3      |
| ✅x_class_phpmailer    | Manages email sending operations within the framework using the PHPMailer Class.                                                      | LGPL-2.1   |
| ✅x_class_hitcounter   | Counts website visitors per page URL with configurable functions.                                                                     | GPLv3      |
| ✅x_class_referer      | Logs visitor referrers with configurable functions.                                                                                   | GPLv3      |
| ✅x_class_ipbl         | Implements IP blacklisting for enhanced website security.                                                                             | GPLv3      |
| ✅x_class_log          | Provides a class for logging operations with easy and smart log entries for various possibilities.                                   | GPLv3      |
| ✅x_class_mail         | Handles mail sending operations, with a subclass for sending operation items. Depends on x_class_phpmailer.                           | GPLv3      |
| ✅x_class_mail_template | Creates mail templates with substitutions and footer/header options, compatible with x_class_mail.                                   | GPLv3      |
| ✅x_class_perm         | Controls permissions for users, including single-item permission objects. 1-n Relation.                                               | GPLv3      |
| ✅x_class_lang         | Manages language translation for multi-language websites with various functions and parameters.                                     | GPLv3      |
| ✅x_class_redis        | Offers control over Redis functionality for caching content on a Redis server. Requires PHP Module REDIS.                              | GPLv3      |
| ✅x_class_crypt        | Provides file and string encryption capabilities using a simple encryption method.                                                   | GPLv3      |
| ✅x_class_zip          | Enables file compression and decompression, compatible with x_class_crypt for direct encryption and decryption. Requires PHP Module ZIP.| GPLv3      |
| ✅x_class_user         | Creates various types of user logins with full functionality for password recovery, mail editing with token operations, and more.   | GPLv3      |
| ✅x_class_var          | Controls setup variables for use on websites and includes a function to create forms for changing these values.                       | GPLv3      |
| ✅x_class_mysql        | Provides MySQL database handling capabilities, along with additional features. Requires an x_class_mysql object for proper functioning.| GPLv3      |
| ✅x_class_mysql_item   | Companion class to x_class_mysql, offering MySQL database handling capabilities with additional features.                             | GPLv3      |

## CSS Classes

Simplify your web development process with our extensive collection of pre-built classes, designed to expedite the creation of responsive web layouts. The Bugfish CSS Framework offers a streamlined design experience, eliminating coding complexities. To get started, include the required file from the "_css" directory within the framework's folder. For enhanced importance, append "_f" to a class name. This resource encompasses style definitions for XML and HTML classes, ensuring efficiency and precision in your styling process.

## Javascript Functions

Explore an array of JavaScript functions designed for universal integration across diverse projects, enhancing coding speed and efficiency within web development. To incorporate these functions seamlessly, include the JavaScript file within your project's designated _javascript subfolder, located within the central _framework folder. These pre-built functions and modules expedite the creation of dynamic, interactive web applications, simplifying your programming experience. Access the JavaScript Function file at: /_framework/javascript/*.js.

## Support us for our work!

If you want to support us, include this image somewhere in your project, that people can see this project has been created with help of this framework:


![a](./banner.jpg)


## Get Support

Should you encounter any issues or have questions while using this software, please do not hesitate to reach out to us on our forum at [Bugfish Forum](www.bugfish.eu/forum). Additionally, you can request assistance via email at request@bugfish.eu, and we are dedicated to providing the support you require. We highly value your feedback and are committed to ensuring your success with our web project.

## Licensing Information

The Bugfish Framework is released under the GPLv3 License, affording you the freedom to use, modify, and distribute the project as you see fit. It is imperative to note that the "_vendor" folder contains various libraries, each with its own unique licenses. To ensure full compliance and understanding of the licensing terms associated with these included libraries, we encourage you to consult our comprehensive documentation on our GitHub page. This documentation provides exhaustive information regarding the specific licenses and any additional requirements tied to individual libraries. Your responsible adherence to these licenses is pivotal when utilizing this project. Your interest and collaboration are greatly appreciated. See Documentation of this Project in the _docs folder to get more insights about licenses of libraries used in this framework. All of them are LGPL or GPL Licenses.
