{
/* -----------------------------------------------
object: n64code{}
  a translation table for the N64 font code used
  in note name and note extension.
*/
MPKEdit.App.n64code = {
      0:  "",  15: " ",  16: "0",
     17: "1",  18: "2",  19: "3",  20: "4",
     21: "5",  22: "6",  23: "7", 24: "8",
     25: "9",  26: "A",  27: "B",  28: "C",
     29: "D",  30: "E",  31: "F", 32: "G",
     33: "H",  34: "I",  35: "J",  36: "K",
     37: "L",  38: "M",  39: "N", 40: "O",
     41: "P",  42: "Q",  43: "R",  44: "S",
     45: "T",  46: "U",  47: "V", 48: "W",
     49: "X",  50: "Y",  51: "Z",  52: "!",
     53: '"',  54: "#",  55: "'", 56: "*",
     57: "+",  58: ",",  59: "-",  60: ".",
     61: "/",  62: ":",  63: "=", 64: "?",
     65: "@",  66: "。",  67: "゛",  68: "゜",
     69: "ァ",  70: "ィ",  71: "ゥ",  72: "ェ",
     73: "ォ",  74: "ッ",  75: "ャ",  76: "ュ",
     77: "ョ",  78: "ヲ",  79: "ン",  80: "ア",
     81: "イ",  82: "ウ",  83: "エ",  84: "オ",
     85: "カ",  86: "キ",  87: "ク",  88: "ケ",
     89: "コ",  90: "サ",  91: "シ",  92: "ス",
     93: "セ",  94: "ソ",  95: "タ",  96: "チ",
     97: "ツ",  98: "テ",  99: "ト", 100: "ナ",
    101: "ニ", 102: "ヌ", 103: "ネ", 104: "ノ",
    105: "ハ", 106: "ヒ", 107: "フ", 108: "ヘ",
    109: "ホ", 110: "マ", 111: "ミ", 112: "ム",
    113: "メ", 114: "モ", 115: "ヤ", 116: "ユ",
    117: "ヨ", 118: "ラ", 119: "リ", 120: "ル",
    121: "レ", 122: "ロ", 123: "ワ", 124: "ガ",
    125: "ギ", 126: "グ", 127: "ゲ", 128: "ゴ",
    129: "ザ", 130: "ジ", 131: "ズ", 132: "ゼ",
    133: "ゾ", 134: "ダ", 135: "ヂ", 136: "ヅ",
    137: "デ", 138: "ド", 139: "バ", 140: "ビ",
    141: "ブ", 142: "ベ", 143: "ボ", 144: "パ",
    145: "ピ", 146: "プ", 147: "ペ", 148: "ポ"
};


MPKEdit.App.media = {
    "N" : "Cartridge",
    "C" : "Expandable Cartridge (e.g. for 64DD)",
    "D" : "64DD Disk",
    "E" : "64DD Expansion",
    "Z" : "Aleck64"
};

/*
Verified N64 region codes are:
A = All (Only used in 1080 Snowboarding [USA/JAP] - later "region-free" in Wii)
B = Brazil (Not in GC/Wii thus possibly unlicensed, but exists in ROM data)
D = Germany (German only)
E = North America (USA, Canada, Mexico)
F = France (French only)
I = Italy (Italian only)
J = Japan
P = Europe (sometimes including Australia)
S = Spain (Spanish only)
U = Australia (English-only PAL games)
X = Europe (Alt. Languages 1)
Y = Europe (Alt. Languages 2)
G = Lodgenet/Gateway 64 (NTSC, mentioned in N64 SDKs)
L = Lodgenet/Gateway 64 (PAL, mentioned in N64 SDKs)

Verified GC/Wii codes are:
K = South Korea (GC/Wii only, Comboy 64 uses E or J codes)
H = Netherlands (GC/Wii)
R = Russia (Wii)
V = Sweden (Wii)
W = Taiwan (GC/Wii)
M = Sweden (GC) - Wii VC Import (USA>PAL)
T = Wii VC Import (JAP>KOR)
N = Wii VC Import (JAP>USA)
L = Wii VC Import (JAP>PAL)
Z = Europe (Alt. 3)

Unverified codes:
C = China (No reliable source, not even used officially in Wii or iQue)
W = Scandinavia (No reliable source, probably wrong)
N = Canada (No reliable source, probably wrong)
*/

MPKEdit.App.region = {
    "A" : "All",
    "B" : "Brazil", // Unlicensed?
    "C" : "China", // Unused?
    "D" : "Germany",
    "E" : "North America",
    "F" : "France",
    "G" : "Gateway 64 (NTSC)",
    "H" : "Netherlands", // Unused. GC/Wii only.
    "I" : "Italy",
    "J" : "Japan",
    "K" : "South Korea", // Unused. GC/Wii only.
    "L" : "Gateway 64 (PAL)",
    "P" : "Europe",
    "R" : "Russia", // Unused. Wii only.
    "S" : "Spain",
    "U" : "Australia", // Although some AU games used standard P codes.
    "W" : "Taiwan", // Unused. GC/Wii only.
    "X" : "Europe (Alt. 1)", // Alternative PAL version (Other languages)
    "Y" : "Europe (Alt. 2)", // Alternative PAL version (Other languages)
    "Z" : "Europe (Alt. 3)" // Unused. Alternative PAL version 3. Possibly Wii only.
};

/*
Publisher DB

Keep in mind these publisher codes below may not be 100% accurate as they are based
on GB/GBA/NES/SNES/GC sources. Sometimes they even contradict themselves, but from
what I could verify, they have been correct 29 out of 30 times (and I've fixed some
issues already).

Do due the difficulty in extracting these codes from N64 games, this is the best I
can do without painstakingly playing through every game (for each region as well),
trying to create a save file on the Controller Pak where it is easily extractable.

The research that went into this was vast--I didn't do it, credit goes to FluBBa aka
Fredrik Olsson. 

These are verified publisher  codes on N64:

    "01": "Nintendo",
    "37": "Human Entertainment", // Questionable--this had a conflict in the original list as Taito/GAGA.
    "41": "Ubisoft",
    "4X": "GT Interactive",
    "4Y": "Rare",
    "4Z": "Crave Entertainment",
    "51": "Acclaim",
    "52": "Activision",
    "5D": "Midway",
    "5H": "3DO",
    "5P": "Vatical Entertainment",
    "5W": "Red Storm Entertainment",
    "60": "Titus", // They also mistakenly used '6O' in Xena Warrior?
    "67": "Ocean",
    "69": "Electronic Arts",
    "6F": "Electro Brain",
    "6O": "Titus",
    "78": "THQ",
    "7F": "Kemco",
    "92": "Video System",
    "A4": "Konami",
    "A7": "Takara",
    "AF": "Namco",
    "B1": "ASCII",
    "B4": "Enix",
    "BB": "Sunsoft",
    "C8": "Koei",
    "E8": "Asmik Ace",
    "EB": "Atlus",
    "B2": "Bandai",
    "9C": "Imagineer",
    "D9": "Banpresto",
    "18": "Hudson Soft",
    "BA": "Culture Brain",
    "E7": "Athena",
    "A0": "Telenet",
    "9H": "Bottom Up",
    "99": "Marvelous Interactive",
    "29": "SETA",
    "13": "Electronic Arts Japan",
    "E4": "T&E Soft",
    "AL": "Media Factory",
    "C0": "Taito",
    "1L": "ASCII Something Good",
*/

MPKEdit.App.pubDB = {
    //"--": "",
    //"úÞ": "",
    //"\u00124": ""
    "-\x01": "Nintendo", // Wave Race 64 uses this, perhaps a bug on N's part.
    "01": "Nintendo",
    "02": "Rocket Games (unlicensed?)",
    "03": "Imagineer-Zoom",
    "04": "Gray Matter?",
    "05": "Zamuse",
    "06": "Falcom",
    "07": "Enix?",
    "08": "Capcom",
    "09": "Hot B Co.",
    "0A": "Jaleco",
    "0B": "Coconuts Japan",
    "0C": "Coconuts Japan/G.X.Media",
    "0D": "Micronet?",
    "0E": "Technos",
    "0F": "Mebio Software",
    "0G": "Shouei System",
    "0H": "Starfish",
    "0J": "Mitsui Fudosan/Dentsu",
    "0L": "Warashi Inc.",
    "0N": "Nowpro",
    "0P": "Game Village",
    "0Q": "IE Institute",
    //"10": "?????????????",
    "12": "Infocom",
    "13": "Electronic Arts Japan",
    "15": "Cobra Team",
    "16": "Human/Field",
    "17": "KOEI",
    "18": "Hudson Soft",
    "19": "S.C.P.",
    "1A": "Yanoman",
    "1C": "Tecmo Products",
    "1D": "Japan Glary Business",
    "1E": "Forum/OpenSystem",
    "1F": "Virgin Games (Japan)",
    "1G": "SMDE",
    "1J": "Daikokudenki",
    "1P": "Creatures Inc.",
    "1L": "ASCII Something Good", // bryc: New company code (AI Shogi 3).
    "1Q": "TDK Deep Impresion",
    "20": "Destination Software",
    "21": "Sunsoft/Tokai Engineering??",
    "22": "POW (Planning Office Wada)",
    "23": "Micro World",
    "25": "San-X",
    "26": "Enix",
    "27": "Loriciel/Electro Brain",
    "28": "Kemco Japan",
    "29": "SETA",
    "2A": "Culture Brain",
    "2C": "Palsoft",
    "2D": "Visit Co.,Ltd.",
    "2E": "Intec",
    "2F": "System Sacom",
    "2G": "Poppo",
    "2H": "Ubisoft Japan",
    "2J": "Media Works",
    "2K": "NEC InterChannel",
    "2L": "Tam",
    "2M": "Jordan",
    "2N": "Smilesoft ???",
    "2Q": "Mediakite",
    "30": "Viacom",
    "31": "Carrozzeria",
    "32": "Dynamic",
    "33": "NOT A COMPANY!",
    "34": "Magifact",
    "35": "Hect",
    "36": "Codemasters",
    "37": "Human Entertainment", // Originally Taito/GAGA Communications
    "38": "Laguna",
    "39": "Telstar Fun & Games",
    "3B": "Arcade Zone Ltd",
    "3C": "Entertainment International/Empire Software?",
    "3D": "Loriciel",
    "3E": "Gremlin Graphics",
    "3F": "K.Amusement Leasing Co.",
    "40": "Seika Corp.",
    "41": "Ubisoft",
    "42": "Sunsoft US?",
    "44": "Life Fitness",
    "46": "System 3",
    "47": "Spectrum Holobyte",
    "49": "IREM",
    "4B": "Raya Systems",
    "4C": "Renovation Products",
    "4D": "Malibu Games",
    "4F": "Eidos",
    "4G": "Playmates Interactive?",
    "4J": "Fox Interactive",
    "4K": "Time Warner Interactive",
    "4Q": "Disney Interactive",
    "4S": "Black Pearl",
    "4U": "Advanced Productions",
    "4X": "GT Interactive",
    "4Y": "Rare",
    "4Z": "Crave Entertainment",
    "50": "Absolute Entertainment",
    "51": "Acclaim",
    "52": "Activision",
    "53": "American Sammy",
    "54": "Take 2 Interactive",
    "55": "Hi Tech",
    "56": "LJN LTD.",
    "58": "Mattel",
    "5A": "Mindscape",
    "5B": "Romstar",
    "5C": "Taxan",
    "5D": "Midway",
    "5F": "American Softworks",
    "5G": "Majesco Sales Inc",
    "5H": "3DO",
    "5K": "Hasbro",
    "5L": "NewKidCo",
    "5M": "Telegames",
    "5N": "Metro3D",
    "5P": "Vatical Entertainment",
    "5Q": "LEGO Media",
    "5S": "Xicat Interactive",
    "5T": "Cryo Interactive",
    "5W": "Red Storm Entertainment",
    "5X": "Microids",
    "5Z": "Conspiracy/Swing",
    "60": "Titus",
    "6O": "Titus", // One of Titus games uses O instead of 0 (Xena)
    "61": "Virgin Interactive",
    "62": "Maxis",
    "64": "LucasArts Entertainment",
    "67": "Ocean",
    "69": "Electronic Arts",
    "6B": "Laser Beam",
    "6E": "Elite Systems",
    "6F": "Electro Brain",
    "6G": "The Learning Company",
    "6H": "BBC",
    "6J": "Software 2000",
    "6L": "BAM! Entertainment",
    "6M": "Studio 3",
    "6Q": "Classified Games",
    "6S": "TDK Mediactive",
    "6U": "DreamCatcher",
    "6V": "JoWood Produtions",
    "6W": "SEGA",
    "6X": "Wannado Edition",
    "6Y": "LSP (Light & Shadow Prod.)",
    "6Z": "ITE Media",
    "70": "Infogrames",
    "71": "Interplay",
    "72": "JVC (Us)",
    "73": "Parker Brothers",
    "75": "Sales Curve(Storm/SCI)",
    "78": "THQ",
    "79": "Accolade",
    "7A": "Triffix Entertainment",
    "7C": "Microprose Software",
    "7D": "Universal Interactive",
    "7F": "Kemco",
    "7G": "Rage Software",
    "7H": "Encore",
    "7J": "Zoo",
    "7K": "Kiddinx",
    "7N": "Empire Interactive?",
    "7Q": "Jester Interactive",
    "7S": "Rockstar Games?",
    "7T": "Scholastic",
    "7U": "Ignition Entertainment",
    "7V": "Summitsoft",
    "7W": "Stadlbauer",
    "80": "Misawa",
    "81": "Teichiku",
    "82": "Namco Ltd.",
    "83": "LOZC",
    "84": "KOEI",
    "86": "Tokuma Shoten Intermedia",
    "87": "Tsukuda Original",
    "88": "DATAM-Polystar",
    "8B": "BulletProof Software(BPS)",
    "8C": "Vic Tokai Inc.",
    "8E": "Character Soft",
    "8F": "I'Max",
    "8G": "Saurus",
    "8J": "General Entertainment",
    "8N": "Success",
    "8P": "SEGA Japan",
    "90": "Takara Amusement",
    "91": "Chun Soft",
    "92": "Video System",
    "93": "BEC",
    "95": "Varie",
    "96": "Yonezawa/S'pal",
    "97": "Kaneko",
    "99": "Marvelous Interactive", // bryc: New code (Nushi Tsuri 64)
    "9A": "Nichibutsu/Nihon Bussan",
    "9B": "Tecmo",
    "9C": "Imagineer",
    "9F": "Nova (pirate?)",
    "9G": "Den'Z",
    "9H": "Bottom Up",
    "9J": "TGL(Technical Group Laboratory)",
    "9L": "Hasbro Japan?",
    "9N": "Marvelous Entertainment",
    "9P": "Keynet Inc.",
    "9Q": "Hands-On Entertainment",
    "A0": "Telenet",
    "A1": "Hori",
    "A4": "Konami",
    "A5": "K.Amusement Leasing Co.",
    "A6": "Kawada",
    "A7": "Takara",
    "A9": "Technos Japan Corp.",
    "AA": "JVC (Europe/Japan?)",
    "AC": "Toei Animation",
    "AD": "Toho",
    "AF": "Namco",
    "AG": "Media Rings Corporation",
    "AH": "J-Wing",
    "AJ": "Pioneer LDC",
    "AK": "KID",
    "AL": "Media Factory",
    "AP": "Infogrames Hudson",
    "AQ": "Kiratto. Ludic Inc",
    "B0": "Acclaim Japan",
    "B1": "ASCII",
    "B2": "Bandai",
    "B4": "Enix",
    "B6": "HAL Laboratory",
    "B7": "SNK",
    "B9": "Pony Canyon (Hanbai/Inc?)",
    "BA": "Culture Brain",
    "BB": "Sunsoft",
    "BC": "Toshiba EMI",
    "BD": "Sony Imagesoft",
    "BF": "Sammy",
    "BG": "Magical",
    "BH": "Visco",
    "BJ": "Compile",
    "BL": "MTO Inc.",
    "BN": "Sunrise Interactive",
    "BP": "Global A Entertainment",
    "BQ": "Fuuki",
    "C0": "Taito",
    "C2": "Kemco (1990-92)",
    "C3": "Square",
    "C4": "Tokuma Shoten",
    "C5": "Data East",
    "C6": "Tonkin House",
    "C8": "Koei",
    "CA": "Konami/Ultra/Palcom",
    "CB": "NTVIC/VAP",
    "CC": "Use Co.,Ltd.",
    "CD": "Meldac",
    "CE": "Pony Canyon(J)/FCI(U)",
    "CF": "Angel",
    "CG": "Yumedia/Aroma Co., Ltd",
    "CJ": "Boss",
    "CK": "Axela/Crea-Tech?",
    "CL": "Sekaibunka-Sha, Sumire kobo?",
    "CN": "NEC Interchannel",
    "CP": "Enterbrain",
    "D0": "Taito/Disco",
    "D1": "Sofel",
    "D2": "Quest",
    "D3": "Sigma",
    "D4": "Ask Kodansha",
    "D6": "Naxat",
    "D7": "Copya System",
    "D8": "Capcom Co., Ltd.",
    "D9": "Banpresto",
    "DA": "TOMY",
    "DB": "LJN Japan",
    "DD": "NCS",
    "DE": "Human Entertainment",
    "DF": "Altron",
    "DG": "Jaleco???",
    "DH": "Gaps Inc.",
    //"DL": "????",
    "DN": "Elf",
    "E0": "Jaleco",
    //"E1": "????",
    "E2": "Yutaka",
    "E3": "Varie",
    "E4": "T&E Soft",
    "E5": "Epoch",
    "E7": "Athena",
    "E8": "Asmik Ace",
    "E9": "Natsume",
    "EA": "King Records",
    "EB": "Atlus",
    "EC": "Epic/Sony Records(J)",
    "EE": "IGS (Information Global Service)",
    "EG": "Chatnoir",
    "EH": "Right Stuff",
    //"EJ": "????",
    "EL": "Spike",
    "EN": "Alphadream Corporation",
    "EP": "Sting(?)",
    "F0": "A Wave",
    "F1": "Motown Software",
    "F2": "Left Field Entertainment",
    "F3": "Extreme Ent. Grp.",
    "F4": "TecMagik",
    "F9": "Cybersoft",
    "FB": "Psygnosis",
    "FE": "Davidson/Western Tech.",
    "FK": "The Game Factory (E)",
    "FL": "Hip Games",
    "FM": "Aspyr",
    "FP": "Mastiff?",
    "FQ": "iQue",
    "FR": "Digital Tainment Pool",
    "FS": "XS Games",
    "FT": "Daiwon",
    "G1": "PCCW Japan",
    "G4": "KiKi Co Ltd",
    "G5": "Open Sesame Inc???",
    "G6": "Sims",
    "G7": "Broccoli",
    "G8": "Avex",
    "G9": "D3 Publisher",
    "GD": "Square-Enix",
    "GE": "KSG?",
    "GF": "Micott & Basara Inc.",
    "GH": "Orbital Media",
    "GY": "The Game Factory (U)",
    "H1": "Treasure",
    "H2": "Aruze",
    "H3": "Ertain",
    "H4": "SNK Playmore",
    "IH": "Yojigen",
    "LH": "Trend Verlag",
    "NK": "Diffusion",
    "TK": "Tasuke/Works",
    "VN": "Valcon Games"
};

/*
gameCode database.

Initial list is sorted alphabetically. Some games with weird codes might be out of
place such as NB5J and NREE (Biohazard 2 / Resident Evil 2).

Additional games should be appended to the end.

*/
MPKEdit.App.codeDB = {
    "CDZJ": "Dezaemon 3D (J)",
    "CFZE": "F-ZERO X (U)",
    "CFZJ": "F-ZERO X (J)",
    "CLBE": "Mario Party (U)",
    "CLBJ": "Mario Party (J)",
    "CP2J": "Pocket Monsters Stadium 2 (J)",
    "CPSJ": "Pocket Monsters Stadium (J)",
    "CZLE": "Legend of Zelda, The - Ocarina of Time (U)",
    "CZLJ": "Zelda no Densetsu - Toki no Ocarina (J)",
    "N22E": "Ready 2 Rumble Boxing - Round 2 (U)",
    "N2ME": "Madden NFL 2002 (U)",
    "N2PE": "Rampage 2 - Universal Tour (U)",
    "N2PP": "Rampage 2 - Universal Tour (E)",
    "N2VE": "Chameleon Twist 2 (U)",
    "N2VP": "Chameleon Twist 2 (E)",
    "N32E": "Army Men - Sarge's Heroes 2 (U)",
    "N3DJ": "Doraemon 3 - Nobita no Machi SOS! (J)",
    "N3HE": "International Track & Field 2000 (U)",
    "N3HJ": "Ganbare Nippon! Olympics 2000 (J)",
    "N3HP": "International Track & Field Summer Games (E)",
    "N3PE": "Triple Play 2000 (U)",
    "N3TE": "Tony Hawk's Pro Skater 3 (U)",
    "N64J": "Kira to Kaiketsu! 64 Tanteidan (J)",
    "N7IE": "FIFA Soccer 64 (U)",
    "N7IP": "FIFA Soccer 64 (E)",
    "N8IE": "FIFA - Road to World Cup 98 (U)",
    "N8IJ": "FIFA - Road to World Cup 98 - World Cup heno Michi (J)",
    "N8IP": "FIFA - Road to World Cup 98 (E)",
    "N8ME": "Madden Football 64 (U)",
    "N8MP": "Madden Football 64 (E)",
    "N8WE": "World Cup 98 (U)",
    "N8WP": "World Cup 98 (E)",
    "N9BE": "NBA Live 99 (U)",
    "N9BP": "NBA Live 99 (E)",
    "N9CE": "NASCAR 99 (U)",
    "N9CP": "NASCAR 99 (E)",
    "N9FE": "FIFA 99 (U)",
    "N9FP": "FIFA 99 (U)",
    "N9HE": "NHL 99 (U)",
    "N9HP": "NHL 99 (E)",
    "N9ME": "Madden NFL 99 (U)",
    "N9MP": "Madden NFL 99 (E)",
    "NA2J": "Virtual Pro Wrestling 2 - Oudou Keishou (J)",
    "NABJ": "Airboarder 64 (J)",
    "NABP": "Airboarder 64 (E)",
    "NACE": "Army Men - Air Combat (U)",
    "NADE": "Worms - Armageddon (U)",
    "NAFJ": "Doubutsu no Mori (J)",
    "NAGE": "AeroGauge (U)",
    "NAGJ": "AeroGauge (J)",
    "NAGP": "AeroGauge (E)",
    "NAHE": "Asteroids Hyper 64 (U)",
    "NAIE": "Midway's Greatest Arcade Hits Volume 1 (U)",
    "NALE": "Super Smash Bros. (U)",
    "NALJ": "Nintendo All-Star! Dairantou Smash Brothers (J)",
    "NALP": "Super Smash Bros. (E)",
    "NALU": "Super Smash Bros. (A)",
    "NAME": "Army Men - Sarge's Heroes (U)",
    "NAMP": "Army Men - Sarge's Heroes (E)",
    "NARD": "Armorines - Project S.W.A.R.M. (G)",
    "NARE": "Armorines - Project S.W.A.R.M. (U)",
    "NARP": "Armorines - Project S.W.A.R.M. (E)",
    "NASE": "All-Star Baseball 2001 (U)",
    "NAYE": "Aidyn Chronicles - The First Mage (U)",
    "NAYP": "Aidyn Chronicles - The First Mage (E)",
    "NB2E": "NBA In the Zone '99 (U)",
    "NB2J": "NBA In the Zone 2 (J)",
    "NB2P": "NBA Pro 99 (E)",
    "NB3E": "Bust-A-Move '99 (U)",
    "NB3P": "Bust-A-Move 3 DX (E)",
    "NB4E": "Bassmasters 2000 (U)",
    "NB5J": "Biohazard 2 (J)",
    "NB6J": "Super B-Daman - Battle Phoenix 64 (J)",
    "NB7E": "Banjo-Tooie (U)",
    "NB7J": "Banjo to Kazooie no Daibouken 2 (J)",
    "NB7P": "Banjo-Tooie (E)",
    "NB7U": "Banjo-Tooie (A)",
    "NB8J": "Beetle Adventure Racing! (J)",
    "NB9E": "NBA Jam 99 (U)",
    "NB9P": "NBA Jam 99 (E)",
    "NBAE": "NBA In the Zone '98 (U)",
    "NBAJ": "NBA In the Zone '98 (U)",
    "NBAP": "NBA Pro 98 (E)",
    "NBCE": "Blast Corps (U)",
    "NBCJ": "Blast Dozer (J)",
    "NBCP": "Blast Corps (E)",
    "NBDE": "Bomberman Hero (U)",
    "NBDJ": "Bomberman Hero - Mirian Oujo wo Sukue! (J)",
    "NBDP": "Bomberman Hero (E)",
    "NBEE": "All-Star Baseball 2000 (U)",
    "NBEP": "All-Star Baseball 2000 (E)",
    "NBFE": "Bio F.R.E.A.K.S. (U)",
    "NBFP": "Bio F.R.E.A.K.S. (E)",
    "NBHE": "Body Harvest (U)",
    "NBHP": "Body Harvest (E)",
    "NBIE": "NFL Blitz 2000 (U)",
    "NBJJ": "Bakushou Jinsei 64 - Mezase! Resort Ou (J)",
    "NBKE": "Banjo-Kazooie (U)",
    "NBKJ": "Banjo to Kazooie no Daibouken (J)",
    "NBKP": "Banjo-Kazooie (E)",
    "NBLE": "Buck Bumble (U)",
    "NBLJ": "Buck Bumble (J)",
    "NBLP": "Buck Bumble (E)",
    "NBME": "Bomberman 64 (U)",
    "NBMJ": "Baku Bomberman (J)",
    "NBMP": "Bomberman 64 (E)",
    "NBNJ": "Bakuretsu Muteki Bangai-O (J)",
    "NBOE": "Bottom of the 9th (U)",
    "NBPE": "Blues Brothers 2000 (U)",
    "NBPP": "Blues Brothers 2000 (E)",
    "NBQE": "BattleTanx - Global Assault (U)",
    "NBQP": "BattleTanx - Global Assault (E)",
    "NBRE": "Milo's Astro Lanes (U)",
    "NBRP": "Milo's Astro Lanes (E)",
    "NBSE": "All-Star Baseball '99 (U)",
    "NBSP": "All-Star Baseball '99 (E)",
    "NBUE": "Bust-A-Move 2 - Arcade Edition (U)",
    "NBUP": "Bust-A-Move 2 - Arcade Edition (E)",
    "NBVE": "Bomberman 64 - The Second Attack! (U)",
    "NBVJ": "Baku Bomberman 2 (J)",
    "NBWE": "Super Bowling 64 (U)",
    "NBWJ": "Super Bowling (J)",
    "NBXE": "BattleTanx (U)",
    "NBYD": "Bug's Life, A (G)",
    "NBYE": "Bug's Life, A (U)",
    "NBYF": "Bug's Life, A (F)",
    "NBYI": "Bug's Life, A (I)",
    "NBYP": "Bug's Life, A (E)",
    "NBZE": "NFL Blitz (U)",
    "NC2E": "Clay Fighter - Sculptor's Cut (U)",
    "NCBE": "Charlie Blast's Territory (U)",
    "NCBP": "Charlie Blast's Territory (E)",
    "NCCD": "Command & Conquer (G)",
    "NCCE": "Command & Conquer (U)",
    "NCCP": "Command & Conquer (E)",
    "NCDE": "Carmageddon 64 (U)",
    "NCDX": "Carmageddon 64 (Europe) (En,Fr,De,Es)",
    "NCDY": "Carmageddon 64 (Europe) (En,Fr,Es,It)",
    "NCED": "Nuclear Strike 64 (G)",
    "NCEE": "Nuclear Strike 64 (U)",
    "NCEP": "Nuclear Strike 64 (E)",
    "NCFE": "Clay Fighter 63 1-3 (U)",
    "NCFP": "Clay Fighter 63 1-3 (E)",
    "NCGJ": "Choro Q 64 II - Hacha Mecha Grand Prix Race (J)",
    "NCHE": "Chopper Attack (U)",
    "NCHP": "Chopper Attack (E)",
    "NCKE": "NBA Courtside 2 - Featuring Kobe Bryant (U)",
    "NCLE": "California Speed (U)",
    "NCOE": "Jeremy McGrath Supercross 2000 (U)",
    "NCOP": "Jeremy McGrath Supercross 2000 (E)",
    "NCRE": "Penny Racers (U)",
    "NCRJ": "Choro Q 64 (J)",
    "NCRP": "Penny Racers (E)",
    "NCSE": "S.C.A.R.S. (U)",
    "NCSP": "S.C.A.R.S. (E)",
    "NCTE": "Chameleon Twist (U)",
    "NCTJ": "Chameleon Twist (J)",
    "NCTP": "Chameleon Twist (E)",
    "NCUE": "Cruis'n USA (U)",
    "NCUP": "Cruis'n USA (E)",
    "NCWE": "Cruis'n World (U)",
    "NCWP": "Cruis'n World (E)",
    "NCXJ": "Custom Robo (J)",
    "NCYE": "South Park - Chef's Luv Shack (U)",
    "NCYP": "South Park - Chef's Luv Shack (E)",
    "NCZJ": "Custom Robo V2 (J)",
    "ND2J": "Doraemon 2 - Nobita to Hikari no Shinden (J)",
    "ND3E": "Castlevania (U)",
    "ND3J": "Akumajou Dracula Mokushiroku - Real Action Adventure (J)",
    "ND3P": "Castlevania (E)",
    "ND4E": "Castlevania - Legacy of Darkness (U)",
    "ND4J": "Akumajou Dracula Mokushiroku Gaiden - Legend of Cornell (J)",
    "ND4P": "Castlevania - Legacy of Darkness (E)",
    "ND6J": "Densha de Go! 64 (J)",
    "NDAJ": "Derby Stallion 64 (J)",
    "NDCJ": "SD Hiryuu no Ken Densetsu (J)",
    "NDEE": "Destruction Derby 64 (U)",
    "NDEP": "Destruction Derby 64 (E)",
    "NDFJ": "Dance Dance Revolution - Disney Dancing Museum (J)",
    "NDHE": "Dual Heroes (U)",
    "NDHJ": "Dual Heroes (J)",
    "NDHP": "Dual Heroes (E)",
    "NDKE": "Dark Rift (U)",
    "NDKJ": "Space Dynamites (J)",
    "NDKP": "Dark Rift (E)",
    "NDME": "Doom 64 (U)",
    "NDMJ": "Doom 64 (J)",
    "NDMP": "Doom 64 (E)",
    "NDNE": "Duke Nukem 64 (U)",
    "NDNF": "Duke Nukem 64 (F)",
    "NDNP": "Duke Nukem 64 (E)",
    "NDOE": "Donkey Kong 64 (U)",
    "NDOJ": "Donkey Kong 64 (J)",
    "NDOP": "Donkey Kong 64 (E)",
    "NDQE": "Disney's Donald Duck - Goin' Quackers (U)",
    "NDQP": "Donald Duck - Quack Attack (E)",
    "NDRJ": "Doraemon - Nobita to 3tsu no Seireiseki (J)",
    "NDSJ": "J.League Dynamite Soccer 64 (J)",
    "NDTD": "South Park (G)",
    "NDTE": "South Park (U)",
    "NDTP": "South Park (E)",
    "NDUE": "Duck Dodgers Starring Daffy Duck (U)",
    "NDUP": "Looney Tunes - Duck Dodgers (E)",
    "NDWE": "John Romero's Daikatana (U)",
    "NDWJ": "John Romero's Daikatana (J)",
    "NDWP": "John Romero's Daikatana (E)",
    "NDYE": "Diddy Kong Racing (U)",
    "NDYJ": "Diddy Kong Racing (J)",
    "NDYP": "Diddy Kong Racing (E)",
    "NDZE": "Duke Nukem - ZER0 H0UR (U)",
    "NDZF": "Duke Nukem - ZER0 H0UR (F)",
    "NDZP": "Duke Nukem - ZER0 H0UR (E)",
    "NEAE": "PGA European Tour (U)",
    "NEAP": "PGA European Tour (E)",
    "NEGE": "Extreme-G (U)",
    "NEGJ": "Extreme-G (J)",
    "NEGP": "Extreme-G (E)",
    "NELE": "Elmo's Letter Adventure (U)",
    "NENE": "Elmo's Number Journey (U)",
    "NEPE": "Star Wars Episode I - Racer (U)",
    "NEPJ": "Star Wars Episode I - Racer (J)",
    "NEPP": "Star Wars Episode I - Racer (E)",
    "NERE": "AeroFighters Assault (U)",
    "NETD": "Holy Magic Century (G)",
    "NETE": "Quest 64 (U)",
    "NETF": "Holy Magic Century (F)",
    "NETJ": "Eltale Monsters (J)",
    "NETP": "Holy Magic Century (E)",
    "NEVJ": "Neon Genesis Evangelion (J)",
    "NF2P": "F-1 World Grand Prix II (E)",
    "NF9E": "Fox Sports College Hoops '99 (U)",
    "NFBE": "NFL Blitz 2001 (U)",
    "NFDE": "Flying Dragon (U)",
    "NFDP": "Flying Dragon (E)",
    "NFFE": "Fighting Force 64 (U)",
    "NFFP": "Fighting Force 64 (E)",
    "NFGE": "Fighter Destiny 2 (U)",
    "NFHE": "In-Fisherman Bass Hunter 64 (U)",
    "NFHP": "Bass Hunter 64 (E)",
    "NFLE": "Madden NFL 2001 (U)",
    "NFOD": "Forsaken 64 (G)",
    "NFOE": "Forsaken 64 (U)",
    "NFOP": "Forsaken 64 (E)",
    "NFQE": "Razor Freestyle Scooter (U)",
    "NFRP": "F1 Racing Championship (E)",
    "NFSJ": "Famista 64 (J)",
    "NFUE": "Conker's Bad Fur Day (U)",
    "NFUP": "Conker's Bad Fur Day (E)",
    "NFWD": "F-1 World Grand Prix (G)",
    "NFWE": "F-1 World Grand Prix (U)",
    "NFWF": "F-1 World Grand Prix (F)",
    "NFWJ": "F-1 World Grand Prix (J)",
    "NFWP": "F-1 World Grand Prix (E)",
    "NFXE": "Star Fox 64 (U)",
    "NFXJ": "Star Fox 64 (J)",
    "NFXP": "Lylat Wars (E)",
    "NFXU": "Lylat Wars (A)",
    "NFYJ": "Kakutou Denshou - F-Cup Maniax (J)",
    "NFZP": "F-ZERO X (E)",
    "NG2E": "Extreme-G XG2 (U)",
    "NG2J": "Extreme-G XG2 (J)",
    "NG2P": "Extreme-G XG2 (E)",
    "NG5E": "Mystical Ninja Starring Goemon (U)",
    "NG5J": "Ganbare Goemon - Neo Momoyama Bakufu no Odori (J)",
    "NG5P": "Mystical Ninja Starring Goemon (E)",
    "NG6J": "Ganbare Goemon - Derodero Douchuu Obake Tenkomori (J)",
    "NGAE": "Deadly Arts (U)",
    "NGAJ": "G.A.S.P!! Fighter's NEXTream (J)",
    "NGAP": "G.A.S.P!! Fighter's NEXTream (E)",
    "NGBE": "Top Gear Hyper Bike (U)",
    "NGBJ": "Top Gear Hyper Bike (J)",
    "NGBP": "Top Gear Hyper Bike (E)",
    "NGCE": "GT 64 - Championship Edition (U)",
    "NGCP": "GT 64 - Championship Edition (E)",
    "NGDJ": "Gauntlet Legends (J)",
    "NGEE": "GoldenEye 007 (U)",
    "NGEJ": "GoldenEye 007 (J)",
    "NGEP": "GoldenEye 007 (E)",
    "NGLJ": "Getter Love!! (J)",
    "NGME": "Goemon's Great Adventure (U)",
    "NGMP": "Mystical Ninja 2 Starring Goemon (E)",
    "NGNE": "Golden Nugget 64 (U)",
    "NGPJ": "Ganbare Goemon - Mononoke Sugoroku (J)",
    "NGRE": "Top Gear Rally (U)",
    "NGSJ": "Jikkyou G1 Stable (J)",
    "NGTJ": "City-Tour GP - Zennihon GT Senshuken (J)",
    "NGUJ": "Tsumi to Batsu - Hoshi no Keishousha (J)",
    "NGVE": "Glover (U)",
    "NGVP": "Glover (E)",
    "NGXE": "Gauntlet Legends (U)",
    "NGXP": "Gauntlet Legends (E)",
    "NH5E": "Nagano Winter Olympics '98 (U)",
    "NH5J": "Hyper Olympics Nagano 64 (J)",
    "NH5P": "Nagano Winter Olympics '98 (E)",
    "NH9E": "NHL Breakaway 99 (U)",
    "NH9P": "NHL Breakaway 99 (E)",
    "NHAJ": "Bomberman 64 - Arcade Edition (J)",
    "NHBJ": "Nintama Rantarou 64 Game Gallery (J)",
    "NHCE": "Hercules - The Legendary Journeys (U)",
    "NHCP": "Hercules - The Legendary Journeys (E)",
    "NHFJ": "64 Hanafuda - Tenshi no Yakusoku (J)",
    "NHGE": "F-1 Pole Position 64 (U)",
    "NHGJ": "Human Grand Prix - New Generation (J)",
    "NHGP": "F-1 Pole Position 64 (E)",
    "NHKJ": "Hiryuu no Ken Twin (J)",
    "NHLE": "NHL Breakaway 98 (U)",
    "NHLP": "NHL Breakaway 98 (E)",
    "NHME": "Mia Hamm Soccer 64 (U)",
    "NHNE": "Olympic Hockey Nagano '98 (U)",
    "NHNJ": "Olympic Hockey Nagano '98 (J)",
    "NHNP": "Olympic Hockey Nagano '98 (E)",
    "NHOE": "NHL Blades of Steel '99 (U)",
    "NHOP": "NHL Pro 99 (E)",
    "NHPJ": "Heiwa Pachinko World 64 (J)",
    "NHSJ": "Hamster Monogatari 64 (J)",
    "NHTE": "Hydro Thunder (U)",
    "NHTF": "Hydro Thunder (F)",
    "NHTP": "Hydro Thunder (E)",
    "NHVE": "Hybrid Heaven (U)",
    "NHVP": "Hybrid Heaven (E)",
    "NHWE": "Hot Wheels Turbo Racing (U)",
    "NHWP": "Hot Wheels Turbo Racing (E)",
    "NHXD": "Hexen (G)",
    "NHXE": "Hexen (U)",
    "NHXF": "Hexen (F)",
    "NHXJ": "Hexen (J)",
    "NHXP": "Hexen (E)",
    "NHYJ": "Hybrid Heaven (J)",
    "NIBJ": "Shigesato Itoi's No. 1 Bass Fishing! Definitive Edition (J)",
    "NICE": "Indy Racing 2000 (U)",
    "NIJE": "Indiana Jones and the Infernal Machine (U)",
    "NIMJ": "Ide Yosuke no Mahjong Juku (J)",
    "NIRJ": "Uchhannanchan no Hono no Challenger - Denryu IraIra Bou (J)",
    "NISE": "International Superstar Soccer 2000 (U)",
    "NISX": "International Superstar Soccer 2000 (Europe) (En,De)",
    "NISY": "International Superstar Soccer 2000 (Europe) (Fr,It)",
    "NIVE": "Space Invaders (U)",
    "NJ2J": "Wonder Project J2 - Koruro no Mori no Jozet (J)",
    "NJ3J": "Jikkyou World Soccer 3 (J)",
    "NJ5J": "Jikkyou Powerful Pro Yakyuu 5 (J)",
    "NJAE": "NBA Jam 2000 (U)",
    "NJAP": "NBA Jam 2000 (E)",
    "NJEJ": "J.League Eleven Beat 1997 (J)",
    "NJFE": "Jet Force Gemini (U)",
    "NJFJ": "Star Twins (J)",
    "NJFP": "Jet Force Gemini (E)",
    "NJGJ": "Jinsei Game 64 (J)",
    "NJLJ": "J.League Live 64 (J)",
    "NJME": "Earthworm Jim 3D (U)",
    "NJMP": "Earthworm Jim 3D (E)",
    "NJOE": "Jeopardy! (U)",
    "NJPE": "International Superstar Soccer 64 (U)",
    "NJPJ": "Jikkyou J.League Perfect Striker (J)",
    "NJPP": "International Superstar Soccer 64 (E)",
    "NJQE": "Batman Beyond - Return of the Joker (U)",
    "NJQP": "Batman of the Future - Return of the Joker (E)",
    "NK2E": "Snowboard Kids 2 (U)",
    "NK2J": "Chou Snobow Kids (J)",
    "NK2P": "Snowboard Kids 2 (E)",
    "NK4E": "Kirby 64 - The Crystal Shards (U)",
    "NK4J": "Kirby 64 - The Crystal Shards (U)",
    "NK4P": "Kirby 64 - The Crystal Shards (E)",
    "NKAD": "Fighter's Destiny (G)",
    "NKAE": "Fighter's Destiny (U)",
    "NKAF": "Fighter's Destiny (F)",
    "NKAJ": "Fighting Cup (J)",
    "NKAP": "Fighter's Destiny (E)",
    "NKEE": "Knife Edge - Nose Gunner (U)",
    "NKEJ": "Knife Edge - Nose Gunner (J)",
    "NKEP": "Knife Edge - Nose Gunner (E)",
    "NKGE": "Major League Baseball Featuring Ken Griffey Jr. (U)",
    "NKGP": "Major League Baseball Featuring Ken Griffey Jr. (E)",
    "NKIE": "Killer Instinct Gold (U)",
    "NKIP": "Killer Instinct Gold (E)",
    "NKJE": "Ken Griffey Jr.'s Slugfest (U)",
    "NKKE": "Knockout Kings 2000 (U)",
    "NKKP": "Knockout Kings 2000 (E)",
    "NKMJ": "Pro Mahjong Kiwame 64 (J)",
    "NKRJ": "Rakuga Kids (J)",
    "NKRP": "Rakuga Kids (E)",
    "NKTE": "Mario Kart 64 (U)",
    "NKTJ": "Mario Kart 64 (J)",
    "NKTP": "Mario Kart 64 (E)",
    "NL2E": "Top Gear Rally 2 (U)",
    "NL2J": "Top Gear Rally 2 (J)",
    "NL2P": "Top Gear Rally 2 (E)",
    "NL2X": "TG Rally 2 (E)",
    "NLBP": "Mario Party (E)",
    "NLCE": "Automobili Lamborghini (U)",
    "NLCJ": "Super Speed Race 64 (J)",
    "NLCP": "Automobili Lamborghini (E)",
    "NLGE": "LEGO Racers (U)",
    "NLGP": "LEGO Racers (E)",
    "NLLJ": "Last Legion UX (J)",
    "NLRE": "Lode Runner 3-D (U)",
    "NLRJ": "Lode Runner 3-D (J)",
    "NLRP": "Lode Runner 3-D (E)",
    "NM3E": "Monster Truck Madness 64 (U)",
    "NM3P": "Monster Truck Madness 64 (E)",
    "NM4E": "Mortal Kombat 4 (U)",
    "NM4P": "Mortal Kombat 4 (E)",
    "NM6E": "Mega Man 64 (U)",
    "NM8E": "Mario Tennis (U)",
    "NM8J": "Mario Tennis 64 (J)",
    "NM8P": "Mario Tennis (E)",
    "NM9J": "Harukanaru Augusta Masters 98 (J)",
    "NMAJ": "Jangou Simulation Mahjong Do 64 (J)",
    "NMBE": "Mike Piazza's Strike Zone (U)",
    "NMDE": "Madden NFL 2000 (U)",
    "NMEE": "Mace - The Dark Age (U)",
    "NMEP": "Mace - The Dark Age (E)",
    "NMFE": "Mario Golf (U)",
    "NMFJ": "Mario Golf 64 (J)",
    "NMFP": "Mario Golf (E)",
    "NMGD": "Racing Simulation 2 (G)",
    "NMGE": "Monaco Grand Prix (U)",
    "NMGP": "Monaco Grand Prix - Racing Simulation 2 (E)",
    "NMHJ": "Mahjong Hourouki Classic (J)",
    "NMID": "Mission Impossible (G)",
    "NMIE": "Mission Impossible (U)",
    "NMIF": "Mission Impossible (F)",
    "NMII": "Mission Impossible (I)",
    "NMIP": "Mission Impossible (E)",
    "NMIS": "Mission Impossible (S)",
    "NMJJ": "Mahjong 64 (J)",
    "NMKE": "Mortal Kombat Trilogy (U)",
    "NMKP": "Mortal Kombat Trilogy (E)",
    "NMLE": "Mickey's Speedway USA (U)",
    "NMLJ": "Mickey no Racing Challenge USA (J)",
    "NMLP": "Mickey's Speedway USA (E)",
    "NMMJ": "Mahjong Master (J)",
    "NMOE": "Monopoly (U)",
    "NMPJ": "Mario no Photopie (J)",
    "NMQE": "Paper Mario (U)",
    "NMQJ": "Mario Story (J)",
    "NMQP": "Paper Mario (E)",
    "NMRE": "MRC - Multi Racing Championship (U)",
    "NMRJ": "MRC - Multi Racing Championship (J)",
    "NMRP": "MRC - Multi Racing Championship (E)",
    "NMSJ": "Morita Shougi 64 (J)",
    "NMTD": "Magical Tetris Challenge (G)",
    "NMTE": "Magical Tetris Challenge (U)",
    "NMTF": "Defi au Tetris Magique (F)",
    "NMTJ": "Magical Tetris Challenge Featuring Mickey (J)",
    "NMTP": "Magical Tetris Challenge (E)",
    "NMUE": "Big Mountain 2000 (U)",
    "NMVE": "Mario Party 3 (U)",
    "NMVJ": "Mario Party 3 (J)",
    "NMVP": "Mario Party 3 (E)",
    "NMWE": "Mario Party 2 (U)",
    "NMWJ": "Mario Party 2 (J)",
    "NMWP": "Mario Party 2 (E)",
    "NMXE": "Excitebike 64 (U)",
    "NMXJ": "Excitebike 64 (J)",
    "NMXP": "Excitebike 64 (E)",
    "NMYE": "Mortal Kombat Mythologies - Sub-Zero (U)",
    "NMYP": "Mortal Kombat Mythologies - Sub-Zero (E)",
    "NMZJ": "Zool - Majou Tsukai Densetsu (J)",
    "NN2E": "NASCAR 2000 (U)",
    "NN6E": "Dr. Mario 64 (U)",
    "NNAE": "Star Wars Episode I - Battle for Naboo (U)",
    "NNAP": "Star Wars Episode I - Battle for Naboo (E)",
    "NNBE": "Kobe Bryant's NBA Courtside (U)",
    "NNBP": "Kobe Bryant in NBA Courtside (E)",
    "NNCE": "Nightmare Creatures (U)",
    "NNLE": "NBA Live 2000 (U)",
    "NNLP": "NBA Live 2000 (E)",
    "NNME": "Namco Museum 64 (U)",
    "NNRJ": "Pro Mahjong Tsuwamono 64 - Jansou Battle ni Chousen (J)",
    "NNSE": "Beetle Adventure Racing! (U)",
    "NNSP": "Beetle Adventure Racing! (E)",
    "NNSX": "HSV Adventure Racing (A)",
    "NO2J": "64 Oozumou 2 (J)",
    "NO7E": "007 - The World is Not Enough (U)",
    "NO7P": "007 - The World is Not Enough (E)",
    "NOBE": "Ogre Battle 64 - Person of Lordly Caliber (U)",
    "NOBJ": "Ogre Battle 64 - Person of Lordly Caliber (J)",
    "NOFE": "Off Road Challenge (U)",
    "NOFP": "Off Road Challenge (E)",
    "NOHE": "Transformers - Beast Wars Transmetal (U)",
    "NOMJ": "Onegai Monsters (J)",
    "NOSJ": "64 Oozumou (J)",
    "NOWE": "Brunswick Circuit Pro Bowling (U)",
    "NP2J": "Chou Kuukan Night Pro Yakyuu King 2 (J)",
    "NP3D": "Pokemon Stadium 2 (G)",
    "NP3E": "Pokemon Stadium 2 (U)",
    "NP3F": "Pokemon Stadium 2 (F)",
    "NP3I": "Pokemon Stadium 2 (I)",
    "NP3J": "Pocket Monsters Stadium Kin Gin (J)",
    "NP3P": "Pokemon Stadium 2 (E)",
    "NP3S": "Pokemon Stadium 2 (S)",
    "NP4J": "Jikkyou Powerful Pro Yakyuu 4 (J)",
    "NP6J": "Jikkyou Powerful Pro Yakyuu 6 (J)",
    "NP9E": "Ms. Pac-Man - Maze Madness (U)",
    "NPAJ": "Jikkyou Powerful Pro Yakyuu 2000 (J)",
    "NPBJ": "Puzzle Bobble 64 (J)",
    "NPCJ": "Pachinko 365 Nichi (J)",
    "NPDE": "Perfect Dark (U)",
    "NPDJ": "Perfect Dark (J)",
    "NPDP": "Perfect Dark (E)",
    "NPEJ": "Jikkyou Powerful Pro Yakyuu - Basic Han 2001 (J)",
    "NPFD": "Pokemon Snap (G)",
    "NPFE": "Pokemon Snap (U)",
    "NPFF": "Pokemon Snap (F)",
    "NPFI": "Pokemon Snap (I)",
    "NPFJ": "Pocket Monsters Snap (J)",
    "NPFP": "Pokemon Snap (E)",
    "NPFS": "Pokemon Snap (S)",
    "NPFU": "Pokemon Snap (A)",
    "NPGE": "Hey You, Pikachu! (U)",
    "NPGJ": "Pikachu Genki Dechu (J)",
    "NPKJ": "Chou Kuukan Night Pro Yakyuu King (J)",
    "NPLJ": "Power League Baseball 64 (J)",
    "NPMP": "Premier Manager 64 (E)",
    "NPND": "Pokemon Puzzle League (G)",
    "NPNE": "Pokemon Puzzle League (U)",
    "NPNF": "Pokemon Puzzle League (F)",
    "NPNP": "Pokemon Puzzle League (E)",
    "NPOD": "Pokemon Stadium (G)",
    "NPOE": "Pokemon Stadium (U)",
    "NPOF": "Pokemon Stadium (F)",
    "NPOI": "Pokemon Stadium (I)",
    "NPOP": "Pokemon Stadium (E)",
    "NPOS": "Pokemon Stadium (S)",
    "NPPJ": "Parlor! Pro 64 - Pachinko Jikki Simulation Game (J)",
    "NPRE": "South Park Rally (U)",
    "NPRP": "South Park Rally (E)",
    "NPSJ": "Jikkyou J.League 1999 - Perfect Striker 2 (J)",
    "NPTJ": "Puyo Puyo 4 - Puyo Puyo Party (J)",
    "NPUE": "Power Rangers - Lightspeed Rescue (U)",
    "NPUP": "Power Rangers - Lightspeed Rescue (E)",
    "NPWE": "Pilotwings 64 (U)",
    "NPWJ": "Pilotwings 64 (J)",
    "NPWP": "Pilotwings 64 (E)",
    "NPXE": "Polaris SnoCross (U)",
    "NPYJ": "Puyo Puyo Sun 64 (J)",
    "NPZJ": "Susume! Taisen Puzzle-Dama - Toukon! Marutama Chou (J)",
    "NQ2E": "Quake II (U)",
    "NQ2P": "Quake II (E)",
    "NQ8E": "NFL Quarterback Club 98 (U)",
    "NQ8P": "NFL Quarterback Club 98 (E)",
    "NQ9E": "NFL Quarterback Club 99 (U)",
    "NQ9P": "NFL Quarterback Club 99 (E)",
    "NQBE": "NFL Quarterback Club 2000 (U)",
    "NQBP": "NFL Quarterback Club 2000 (E)",
    "NQCE": "NFL Quarterback Club 2001 (U)",
    "NQKE": "Quake 64 (U)",
    "NQKP": "Quake 64 (E)",
    "NR2E": "Rush 2 - Extreme Racing USA (U)",
    "NR2P": "Rush 2 - Extreme Racing USA (E)",
    "NR3E": "Stunt Racer 64 (U)",
    "NR6D": "Tom Clancy's Rainbow Six (G)",
    "NR6E": "Tom Clancy's Rainbow Six (U)",
    "NR6F": "Tom Clancy's Rainbow Six (F)",
    "NR6P": "Tom Clancy's Rainbow Six (E)",
    "NR7J": "Robot Ponkotsu 64 - 7tsu no Umi no Caramel (J)",
    "NRAJ": "Rally '99 (J)",
    "NRCE": "Top Gear Overdrive (U)",
    "NRCJ": "Top Gear Overdrive (J)",
    "NRCP": "Top Gear Overdrive (E)",
    "NRDE": "Ready 2 Rumble Boxing (U)",
    "NRDP": "Ready 2 Rumble Boxing (E)",
    "NREE": "Resident Evil 2 (U)",
    "NREP": "Resident Evil 2 (E)",
    "NRGD": "Rugrats - Die grosse Schatzsuche (G)",
    "NRGE": "Rugrats - Scavenger Hunt (U)",
    "NRGF": "Les Razmoket - La Chasse Aux Tresors (F)",
    "NRGP": "Rugrats - Treasure Hunt (E)",
    "NRHJ": "Rockman Dash (J)",
    "NRIE": "New Tetris, The (U)",
    "NRIP": "New Tetris, The (E)",
    "NRKE": "Rugrats in Paris - The Movie (U)",
    "NRKP": "Rugrats in Paris - The Movie (E)",
    "NROE": "Road Rash 64 (U)",
    "NROP": "Road Rash 64 (E)",
    "NRPE": "Rampage - World Tour (U)",
    "NRPP": "Rampage - World Tour (E)",
    "NRRE": "Roadsters Trophy (U)",
    "NRRP": "Roadsters Trophy (E)",
    "NRSE": "Star Wars - Rogue Squadron (U)",
    "NRSJ": "Star Wars - Shutsugeki! Rogue Chuutai (J)",
    "NRSP": "Star Wars - Rogue Squadron (E)",
    "NRTE": "Rat Attack (U)",
    "NRTP": "Rat Attack (E)",
    "NRUE": "San Francisco Rush 2049 (U)",
    "NRUP": "San Francisco Rush 2049 (E)",
    "NRVE": "Re-Volt (U)",
    "NRVP": "Re-Volt (E)",
    "NRWD": "Turok - Legenden des Verlorenen Landes (G)",
    "NRWE": "Turok - Rage Wars (U)",
    "NRWP": "Turok - Rage Wars (E)",
    "NRWX": "Turok - Rage Wars (Europe) (En,Fr,It)",
    "NRXE": "Robotron 64 (U)",
    "NRXP": "Robotron 64 (E)",
    "NRZE": "RR64 - Ridge Racer 64 (U)",
    "NRZP": "RR64 - Ridge Racer 64 (E)",
    "NS2J": "Sim City 2000 (J)",
    "NS3J": "AI Shogi 3 (J)",
    "NS4J": "Super Robot Wars 64 (J)",
    "NS6E": "Star Soldier - Vanishing Earth (U)",
    "NS6J": "Star Soldier - Vanishing Earth (J)",
    "NSAJ": "Sonic Wings Assault (J)",
    "NSAP": "AeroFighters Assault (E)",
    "NSBE": "Twisted Edge Extreme Snowboarding (U)",
    "NSBJ": "King Hill 64 - Extreme Snowboarding (J)",
    "NSBP": "Twisted Edge Extreme Snowboarding (E)",
    "NSCE": "Starshot - Space Circus Fever (U)",
    "NSCP": "Starshot - Space Circus Fever (E)",
    "NSDD": "Shadow Man (G)",
    "NSDE": "Shadow Man (U)",
    "NSDF": "Shadow Man (F)",
    "NSDP": "Shadow Man (E)",
    "NSFE": "San Francisco Rush - Extreme Racing (U)",
    "NSFP": "San Francisco Rush - Extreme Racing (E)",
    "NSGE": "Shadowgate 64 - Trials Of The Four Towers (U)",
    "NSGJ": "Shadowgate 64 - Trials Of The Four Towers (J)",
    "NSGP": "Shadowgate 64 - Trials Of The Four Towers (E)",
    "NSGX": "Shadowgate 64 - Trials Of The Four Towers (Europe) (Es,It)",
    "NSGY": "Shadowgate 64 - Trials Of The Four Towers (Europe) (Fr,De,Nl)",
    "NSHJ": "Saikyou Habu Shougi (J)",
    "NSIJ": "Fushigi no Dungeon - Fuurai no Shiren 2 - Oni Shuurai! Shiren Jou! (J)",
    "NSJJ": "J.League Tactics Soccer (J)",
    "NSKE": "Snowboard Kids (U)",
    "NSKJ": "Snobow Kids (J)",
    "NSKP": "Snowboard Kids (E)",
    "NSLE": "Spider-Man (U)",
    "NSME": "Super Mario 64 (U)",
    "NSMJ": "Super Mario 64 (J)",
    "NSMP": "Super Mario 64 (E)",
    "NSNJ": "Snow Speeder (J)",
    "NSOE": "NBA Showtime - NBA on NBC (U)",
    "NSPE": "Superman (U)",
    "NSPP": "Superman (E)",
    "NSQE": "StarCraft 64 (U)",
    "NSQP": "StarCraft 64 (E)",
    "NSSJ": "Super Robot Spirits (J)",
    "NSTJ": "Eikou no Saint Andrews (J)",
    "NSUE": "Rocket - Robot on Wheels (U)",
    "NSUP": "Rocket - Robot on Wheels (E)",
    "NSVE": "Space Station Silicon Valley (U)",
    "NSVP": "Space Station Silicon Valley (E)",
    "NSWE": "Star Wars - Shadows of the Empire (U)",
    "NSWJ": "Star Wars - Teikoku no Kage (J)",
    "NSWP": "Star Wars - Shadows of the Empire (E)",
    "NSXE": "Supercross 2000 (U)",
    "NSXP": "Supercross 2000 (E)",
    "NSYE": "Scooby-Doo! - Classic Creep Capers (U)",
    "NSYP": "Scooby-Doo! - Classic Creep Capers (E)",
    "NSZE": "NFL Blitz - Special Edition (U)",
    "NT2D": "Turok 2 - Seeds of Evil (G)",
    "NT2E": "Turok 2 - Seeds of Evil (U)",
    "NT2J": "Violence Killer - Turok New Generation (J)",
    "NT2P": "Turok 2 - Seeds of Evil (E)",
    "NT2X": "Turok 2 - Seeds of Evil (Europe) (En,Fr,Es,It)",
    "NT3J": "Shin Nihon Pro Wrestling - Toukon Road 2 - The Next Generation (J)",
    "NT4E": "CyberTiger (U)",
    "NT4P": "CyberTiger (E)",
    "NT6J": "Tetris 64 (J)",
    "NT9E": "Tigger's Honey Hunt (U)",
    "NT9P": "Tigger's Honey Hunt (E)",
    "NTAD": "Disney's Tarzan (G)",
    "NTAE": "Disney's Tarzan (U)",
    "NTAF": "Disney's Tarzan (F)",
    "NTAP": "Disney's Tarzan (E)",
    "NTBJ": "Transformers - Beast Wars Metals 64 (J)",
    "NTCJ": "64 Trump Collection - Alice no Wakuwaku Trump World (J)",
    "NTEA": "1080 Snowboarding (JU)",
    "NTEP": "1080 Snowboarding (E)",
    "NTFE": "Tony Hawk's Pro Skater (U)",
    "NTFP": "Tony Hawk's Pro Skater (E)",
    "NTHD": "Toy Story 2 (G)",
    "NTHE": "Toy Story 2 (U)",
    "NTHF": "Toy Story 2 (F)",
    "NTHP": "Toy Story 2 (E)",
    "NTID": "WWF Attitude (G)",
    "NTIE": "WWF Attitude (U)",
    "NTIP": "WWF Attitude (E)",
    "NTJE": "Tom and Jerry in Fists of Furry (U)",
    "NTJP": "Tom and Jerry in Fists of Furry (E)",
    "NTKE": "Turok 3 - Shadow of Oblivion (U)",
    "NTKP": "Turok 3 - Shadow of Oblivion (E)",
    "NTME": "Mischief Makers (U)",
    "NTMJ": "Yuke Yuke!! Trouble Makers (J)",
    "NTMP": "Mischief Makers (E)",
    "NTNE": "All Star Tennis '99 (U)",
    "NTNP": "All Star Tennis '99 (E)",
    "NTOJ": "Shin Nihon Pro Wrestling - Toukon Road - Brave Spirits (J)",
    "NTPE": "Tetrisphere (U)",
    "NTPP": "Tetrisphere (E)",
    "NTQE": "Tony Hawk's Pro Skater 2 (U)",
    "NTQP": "Tony Hawk's Pro Skater 2 (E)",
    "NTRJ": "Top Gear Rally (J)",
    "NTRP": "Top Gear Rally (E)",
    "NTSJ": "Let's Smash Tennis (J)",
    "NTSP": "Centre Court Tennis (E)",
    "NTTE": "Tonic Trouble (U)",
    "NTTP": "Tonic Trouble (E)",
    "NTUD": "Turok - Dinosaur Hunter (G)",
    "NTUE": "Turok - Dinosaur Hunter (U)",
    "NTUJ": "Tokisora Senshi Turok (J)",
    "NTUP": "Turok - Dinosaur Hunter (E)",
    "NTWJ": "64 de Hakken!! Tamagotchi Minna de Tamagotchi World (J)",
    "NTXP": "Taz Express (E)",
    "NUBJ": "PD Ultraman Battle Collection 64 (J)",
    "NUMJ": "Nushi Tsuri 64 - Shiokaze ni Notte (J)",
    "NUTJ": "Nushi Tsuri 64 (J)",
    "NV2J": "Chameleon Twist 2 (J)",
    "NV3E": "Micro Machines 64 Turbo (U)",
    "NV3P": "Micro Machines 64 Turbo (E)",
    "NV8D": "Vigilante 8 (G)",
    "NV8E": "Vigilante 8 (U)",
    "NV8F": "Vigilante 8 (F)",
    "NV8P": "Vigilante 8 (E)",
    "NVBJ": "Bass Rush - ECOGEAR PowerWorm Championship (J)",
    "NVCE": "Virtual Chess 64 (U)",
    "NVCP": "Virtual Chess 64 (E)",
    "NVGE": "Vigilante 8 - 2nd Offense (U)",
    "NVGP": "Vigilante 8 - 2nd Offence (E)",
    "NVLE": "V-Rally Edition 99 (U)",
    "NVLP": "V-Rally Edition 99 (E)",
    "NVPJ": "Virtual Pro Wrestling 64 (J)",
    "NVRE": "Virtual Pool 64 (U)",
    "NVRP": "Virtual Pool 64 (E)",
    "NVYJ": "V-Rally Edition 99 (J)",
    "NW2E": "WCW-nWo Revenge (U)",
    "NW2P": "WCW-nWo Revenge (E)",
    "NW3E": "WCW Nitro (U)",
    "NW4E": "WWF No Mercy (U)",
    "NW4P": "WWF No Mercy (E)",
    "NW8E": "Wayne Gretzky's 3D Hockey '98 (U)",
    "NW8P": "Wayne Gretzky's 3D Hockey '98 (E)",
    "NWAE": "War Gods (U)",
    "NWAP": "War Gods (E)",
    "NWBE": "Iggy's Reckin' Balls (U)",
    "NWBJ": "Iggy-kun no Bura Bura Poyon (J)",
    "NWBP": "Iggy's Reckin' Balls (E)",
    "NWCJ": "Wild Choppers (J)",
    "NWDE": "WinBack - Covert Operations (U)",
    "NWDJ": "WinBack (J)",
    "NWDP": "Operation WinBack (E)",
    "NWFE": "Wheel of Fortune (U)",
    "NWGE": "Wayne Gretzky's 3D Hockey (U)",
    "NWGJ": "Wayne Gretzky's 3D Hockey (J)",
    "NWGP": "Wayne Gretzky's 3D Hockey (E)",
    "NWIE": "ECW Hardcore Revolution (U)",
    "NWIP": "ECW Hardcore Revolution (E)",
    "NWID": "ECW Hardcore Revolution (G)",
    "NWKD": "RTL World League Soccer 2000 (G)",
    "NWKF": "Telefoot Soccer 2000 (F)",
    "NWKX": "Michael Owens WLS 2000 (E)",
    "NWLE": "Waialae Country Club - True Golf Classics (U)",
    "NWLP": "Waialae Country Club - True Golf Classics (E)",
    "NWME": "WCW Mayhem (U)",
    "NWMP": "WCW Mayhem (E)",
    "NWNE": "WCW vs. nWo - World Tour (U)",
    "NWNP": "WCW vs. nWo - World Tour (E)",
    "NWOE": "World Driver Championship (U)",
    "NWOP": "World Driver Championship (E)",
    "NWPE": "Wipeout 64 (U)",
    "NWPP": "Wipeout 64 (E)",
    "NWQE": "Rally Challenge 2000 (U)",
    "NWRE": "Wave Race 64 (U)",
    "NWRJ": "Wave Race 64 (J)",
    "NWRP": "Wave Race 64 (E)",
    "NWSE": "International Superstar Soccer '98 (U)",
    "NWSJ": "Jikkyou World Soccer - World Cup France '98 (J)",
    "NWSP": "International Superstar Soccer '98 (E)",
    "NWTE": "Wetrix (U)",
    "NWTJ": "Wetrix (J)",
    "NWTP": "Wetrix (E)",
    "NWUP": "Worms - Armageddon (E)",
    "NWVE": "WCW Backstage Assault (U)",
    "NWWE": "WWF - War Zone (U)",
    "NWWP": "WWF - War Zone (E)",
    "NWXE": "WWF WrestleMania 2000 (U)",
    "NWXJ": "WWF WrestleMania 2000 (J)",
    "NWXP": "WWF WrestleMania 2000 (E)",
    "NWZE": "NBA In the Zone 2000 (U)",
    "NWZP": "NBA In the Zone 2000 (E)",
    "NX2E": "Gex 64 - Enter the Gecko (U)",
    "NX2P": "Gex 64 - Enter the Gecko (E)",
    "NX3E": "Gex 3 - Deep Cover Gecko (U)",
    "NX3P": "Gex 3 - Deep Cover Gecko (Europe) (En,Es,It)",
    "NX3X": "Gex 3 - Deep Cover Gecko (Europe) (Fr,De)",
    "NXFE": "Xena Warrior Princess - The Talisman of Fate (U)",
    "NXFP": "Xena Warrior Princess - The Talisman of Fate (E)",
    "NXGE": "NBA Hangtime (U)",
    "NXGP": "NBA Hangtime (E)",
    "NXOE": "Cruis'n Exotica (U)",
    "NY2E": "Rayman 2 - The Great Escape (U)",
    "NY2P": "Rayman 2 - The Great Escape (E)",
    "NYKJ": "Yakouchuu II - Satsujin Kouru (J)",
    "NYPE": "Paperboy (U)",
    "NYPP": "Paperboy (E)",
    "NYSE": "Yoshi's Story (U)",
    "NYSJ": "Yoshi Story (J)",
    "NYSP": "Yoshi's Story (U)",
    "NYWE": "Harvest Moon 64 (U)",
    "NYWJ": "Bokujou Monogatari 2 (J)",
    "NZLP": "Legend of Zelda, The - Ocarina of Time (E)",
    "NZOE": "Battlezone - Rise of the Black Dogs (U)",
    "NZSE": "Legend of Zelda, The - Majora's Mask (U)",
    "NZSJ": "Zelda no Densetsu - Mujura no Kamen (J)",
    "NZSP": "Legend of Zelda, The - Majora's Mask (E)",
    /* ------------------------------------------------------------- */
    "DKDJ": "Doshin the Giant (J) [64DD]",
    "DKIJ": "Doshin the Giant Demo (J) [64DD]",
    "DKKJ": "Doshin the Giant 2 (J) [64DD]",
    "DSCJ": "Sim City 64 (J) [64DD]",
    "DMTJ": "Mario Artist Talent Studio (J) [64DD]",
    "DMGJ": "Mario Artist Polygon Studio (J) [64DD]",
    "DMPJ": "Mario Artist Paint Studio (J) [64DD]",
    "DMBJ": "Mario Artist Communication Kit (J) [64DD]",
    "DPGJ": "Japan Pro Golf Tour 64 (J) [64DD]",
    "DRDJ": "Randnet Browser (J) [64DD]",
    "EFZJ": "F-Zero X Expansion Kit (J) [64DD]",
    "EFZE": "F-Zero X Expansion Kit (U) [64DD]",
    /* ------------------------------------------------------------- */
    "ZCAJ": "Magical Tetris Challenge Featuring Mickey (J) [Aleck64]",
    "ZHAJ": "Eleven Beat (J) [Aleck64]",
    "ZHBJ": "Star Soldier: Vanishing Earth ARCADE (J) [Aleck64]",
    "ZSEJ": "Super Real Mahjong VS (J) [Aleck64]",
    "ZSAJ": "Vivid Dolls (J) [Aleck64]",
    "ZSCJ": "Mayjinsen 3 (J) [Aleck64]",
    /* ------------------------------------------------------------- */
    "\x3B\xAD\xD1\xE5": "Cart save (Gameshark/Action Replay)",
    "\xDE\xAD\xBE\xEF": "Cart save (BlackBag's Memory Manager)",
    "ROAD": "Off Road Challenge (E) [b1]", // INVALID/CORRUPT ROM
    "NHHE": "Mario Kart 64 (Super W00ting Hack) (U)", // HyperHacker @ acmlmboard
    "NHHP": "Mario Kart 64 (Super W00ting Hack) (E)", // HyperHacker @ acmlmboard
    "NNiE": "Turok - Dinosaur Hunter (U) (V1.0) [t2]", // HACKED ROM
    "NNiJ": "Virtual Pro Wrestling 64 (J) [h1C]", // HACKED ROM
    "NDPE": "Donkey Kong 64 (U) (Kiosk Demo)",
    "NDLE": "Legend of Zelda, The - Majora's Mask - Preview Demo (U)",
    "NNXE": "Excitebike 64 (U) (Kiosk Demo)",
    "NJDE": "Jet Force Gemini (U) (Kiosk Demo)",
    "NSED": "Turok 3 - Shadow of Oblivion (E) (Beta) (2000-07-10) [b]",
    "NSHT": "Turok 3 - Shadow of Oblivion (E) (Beta) (2000-07-16)",
    "ABCD": "Turok 3 - Shadow of Oblivion (U) (Beta) (2000-07-21)",
    "CMDJ": "Nintendo 64 Modem (Japan) (Add-on)",
    "NPHE": "Pokemon Snap Station (U)",
    "NZLE": "Legend of Zelda, The - Ocarina of Time (U)", // Doesn't exist in No-Intro.
    "CZGE": "Legend of Zelda, The - Ocarina of Time (U)", // Doesn't exist in No-Intro.
    "NTYE": "Turok 2 - Seeds of Evil (U) (Kiosk Demo)",
    "NTYP": "Turok 2 - Seeds of Evil (E) (Kiosk Demo)",
    "NPQE": "The Powerpuff Girls: Chemical X-Traction (U)",
    "NDTB": "South Park (Brazil)",
    "NSDB": "Shadow Man (Brazil)",
    "NFRE": "F1 Racing Championship (Brazil) (En,Fr)",
    "NIJP": "Indiana Jones and the Infernal Machine (A) (Prototype)",
    "NSVJ": "Space Station Silicon Valley (J) (Prototype)",
    "NSQD": "StarCraft 64 (G) (Prototype)",
    "NTXE": "Tax Express (U) (Prototype)",
    "MGVP": "Dragon Sword 64 (E) (Prototype)",
    "NCLP": "California Speed (Europe) (Proto)",
    "NGRX": "Top Gear Rally (Asia) (En)",
    "NMSE": "Duke Nukem 64 (Europe) (Beta)",
    "N4WX": "40 Winks (E) (Proto) (1999-10-07)",
    "N4WE": "40 Winks (U)",
    "N4WZ": "40 Winks (U) (Proto) (2000-01-10)",
    "NTDE": "O.D.T. (U)",
    "NTDP": "O.D.T. (E)",
};
}
