/*
 * Brutos Web MVC http://www.brutosframework.com.br/
 * Copyright (C) 2009-2017 Afonso Brandao. (afonso.rbn@gmail.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.brandao.brutos.web;

import org.brandao.brutos.DispatcherType;

/**
 * 
 * @author Brandao
 *
 */
public class WebDispatcherType extends DispatcherType{

	public static final WebDispatcherType INCLUDE  = new WebDispatcherType("include");

	public static final WebDispatcherType REDIRECT = new WebDispatcherType("redirect");
	
	static {
		defaultDispatcher.put(INCLUDE.getName(),  INCLUDE);
		defaultDispatcher.put(REDIRECT.getName(), REDIRECT);
	}
	
	public WebDispatcherType(String name) {
		super(name);
	}

	public static DispatcherType valueOf(String value) {
		return DispatcherType.valueOf(value);
	}
	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((this.getName() == null) ? 0 : this.getName().hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		DispatcherType other = (DispatcherType) obj;
		if (this.getName() == null) {
			if (other.getName() != null)
				return false;
		} else if (!this.getName().equals(other.getName()))
			return false;
		return true;
	}
	
}
