\connect room-mapping

/*drop basic infra for mapping if exists*/
DROP INDEX IF EXISTS ivfflat;
DROP TABLE IF EXISTS Rooms;
DROP EXTENSION IF EXISTS vector;

/*recreate basic infra for mapping*/
CREATE EXTENSION vector;
CREATE TABLE Rooms
(
    id bigserial primary key,
    hotelName varchar(200) not null,
    roomName varchar(200) not null,
    embedding vector(1536) not null,
    createdDate date not null default CURRENT_DATE
);
CREATE INDEX ON Rooms USING ivfflat (embedding vector_l2_ops);

/*insert some testing data with real vectors from OpenAI Embedding Api*/
/*For more documentation about open ia embeddings , https://platform.openai.com/docs/guides/embeddings/what-are-embeddings*/
INSERT INTO ROOMS(hotelName,roomName,embedding) values('Mallorca Rocks','Serenity Suite','[0.0110960305,0.002809228,-0.0074599674,-0.0036461262,-0.008513218,0.027062507,-0.010586177,-0.009646973,-0.00087966566,0.01632874,0.007674643,0.025197515,0.007922861,-0.00792957,0.0014364797,-0.0037299837,0.009895191,0.0024419317,0.01811323,-0.007708186,0.01224991,0.00085618556,-0.0012553475,-0.012115738,-0.0030071316,-0.007090994,0.0005823907,-0.023345942,-0.009459131,-0.003310696,0.02056858,0.0015060815,-0.009640263,-0.04564534,-0.0014264169,-0.027693117,-0.007124537,0.0044612214,-0.003087635,-0.018394992,0.00797653,0.0025375294,-0.009942151,0.0049174065,-0.03166461,-0.004679251,-0.009204204,-0.0056486446,-0.02873966,0.019978222,0.020716168,0.0042733806,-0.018314488,-0.020863758,0.0036763148,-0.00091069296,-0.02661974,0.011136282,0.022433572,0.0023480114,-0.004592039,-0.020031892,-0.012679261,0.0046054567,-0.009714059,-0.0029433998,-0.0124377515,-0.00044696074,-0.005454095,-0.009532926,0.03738034,0.015080942,-0.011907772,-0.00078826095,0.016570251,-0.023761874,0.0053199227,0.007178206,0.011263746,0.0064402595,0.01893168,-0.020219732,-0.022836087,-0.0029048254,0.021145519,0.012773181,-0.008902317,0.031074254,-0.009653681,-0.0036192918,0.008003364,0.032415975,-0.0053366944,0.020259984,-0.012746347,0.0042197118,0.0051823966,0.011592467,-0.0005241097,-0.02868599,-0.0036427719,0.014114902,-0.021346778,-0.012075487,-0.02166879,-0.038239043,-0.0074264244,-0.012900645,0.014181988,0.01431616,-0.01595306,0.011303998,0.019280527,-0.041163992,0.00013385761,0.005601684,0.025143847,-0.0018079687,-0.00903649,-0.02017948,-0.008808397,0.006155144,0.028471315,-0.026767328,0.012196242,0.010901481,-0.016556835,-0.030242385,0.01037821,0.0023530428,0.013122029,0.017294781,0.029813036,-0.016583668,-0.028390812,0.013497711,-0.017724132,0.031530436,0.0026549299,-0.029410519,0.001521176,0.01624824,-0.026606323,-0.023963133,0.011411335,-0.0024469632,-0.0076411,0.005108602,0.005594976,-0.023439862,0.002554301,-0.030430228,0.009700641,0.0011413012,0.0067186668,0.010002528,-0.0047295657,0.035582434,-0.015590795,0.0059270514,-0.0036461262,0.018220568,0.002589521,-0.0034280967,0.023896046,0.009942151,0.008479675,0.0007530408,-0.007010491,0.0060377433,-0.008794979,0.038695227,-0.0026163554,0.014088068,-0.015362702,0.025854958,-0.009358502,-0.017589958,-0.0026951816,-0.02863232,-0.028981168,0.003399585,0.017589958,0.005165625,-0.0068763187,0.0018130002,0.02503651,0.0059572402,0.029142175,-0.014893101,-0.0073928814,0.013189116,0.016087232,-0.021615122,-0.677086,-0.025157264,-0.007265418,-0.0027253702,0.00946584,0.021105267,0.020166064,0.031503603,-0.00034821845,-0.037165664,-0.0027421417,0.008808397,0.012806725,0.010740475,0.0067253755,-0.0074733845,-0.0044176155,-0.0069836564,-0.023292273,0.011887646,-0.007869192,0.031369433,0.013953896,0.01513461,0.04194219,-0.0202734,0.007151372,0.00046457082,-0.01604698,0.006685124,0.00020639438,0.04108349,0.0002026208,0.0069635306,0.04661138,-0.018555999,-0.023037346,0.013350122,0.016570251,0.044759806,-0.016154317,0.003089312,-0.0026431899,-0.013417208,0.009398754,-0.0031765238,0.009781145,-0.0032268385,-0.00927129,-0.009975694,0.049804676,-0.025465861,-0.008647391,0.027800454,-0.014584505,-0.008345503,0.04674555,-0.010727057,-0.0020192896,-0.0031983268,0.008285126,0.0031262094,-0.0022356422,-0.0031094379,-0.011840686,0.014141737,-0.017308198,-0.016100649,0.0002450737,-0.0057593365,0.006943405,0.0119144805,-0.012893937,-0.0028025194,0.017737549,0.017885137,0.018341323,0.011766891,-0.0004922438,-0.009720767,0.019200023,-0.013819724,-0.021494366,-0.007882609,0.02551953,-0.009700641,-0.02959836,0.018502329,0.016476331,-0.0012268359,0.020300236,0.0073459214,0.025989132,-0.011230202,0.003454931,0.010418462,0.0028930854,0.010083032,0.0062155216,-0.03281849,-0.00564529,-0.0070708683,-0.0021920362,-0.002334594,-0.013967313,-0.029195843,-0.009472549,-0.003911116,0.049294822,-0.007708186,0.0077618547,-0.010170244,-0.020769838,-0.018394992,-0.0061819786,-0.028766492,0.022446988,-0.0074935104,0.0005341726,-0.038829397,0.010794143,-0.009895191,0.02488892,-0.007184915,0.007922861,0.019132938,0.0036360633,-0.010921607,0.0028763139,-0.0061920416,0.024486404,0.013859975,0.012753055,-0.0020243211,-0.0026297728,0.005376946,0.02743819,-0.011230202,0.026700243,-0.035528764,-0.03204029,-0.0161409,-0.017227694,0.025492694,-0.0007895188,-0.02109185,-0.015818888,-0.016395828,-0.041298166,-0.023681372,-0.0002465412,0.008251582,-0.031503603,0.011109448,0.011116156,-0.008493093,-0.008519927,-0.016194569,-0.023949716,-0.009626847,0.023520365,0.0029534628,-0.055278897,0.01316899,-0.0038373214,-0.0057157306,-0.00020534616,0.023265438,-0.00994886,-0.025452442,-0.004555142,-0.00005628938,0.008224748,0.022433572,0.016087232,-0.007090994,-0.016261656,-0.026606323,0.00811741,-0.0005651999,0.003810487,0.021655373,-0.028068798,-0.015148028,0.040278457,0.016489748,0.019468369,0.02734427,-0.013967313,-0.0078490665,-0.0073056696,0.019776965,-0.009009655,0.00555137,-0.01993797,0.007077577,-0.0047161486,0.00057232776,0.0074599674,0.001027255,0.022889756,0.015912808,0.00386751,-0.022178644,0.016409244,-0.025479278,0.0068125874,-0.020836923,0.039822273,0.003766881,-0.0025056635,-0.03421388,-0.022433572,-0.036011785,0.011632719,0.004699377,0.016784927,0.00295514,-0.006698541,0.0031597523,-0.003099375,0.0007681351,0.012243202,0.008674225,-0.015443206,-0.006232293,0.013007983,0.020313652,0.02421806,0.017603377,-0.017428953,0.0019958096,0.010680097,-0.009244456,-0.005202522,0.0110289445,0.0052897343,-0.032415975,0.0060042003,-0.019803798,-0.006111538,0.014852849,0.010706931,-0.023922881,-0.00061341794,0.0043572383,0.025210934,0.0012243201,0.0012276745,-0.024902338,-0.032711152,-0.0058029424,-0.01643608,0.010921607,0.015644465,0.015000438,0.0069635306,0.00080964464,0.011109448,0.019428117,0.0012645718,0.006732084,0.020890592,-0.010123284,0.009781145,0.001965621,0.016516583,0.010713641,-0.00012641525,0.02220548,0.02272875,-0.007245292,0.002779039,0.0013215949,-0.012384083,-0.00052117463,-0.003355979,-0.0015563961,0.015483458,-0.01230358,0.0024335461,-0.038024366,0.017589958,0.0018633148,-0.011303998,-0.006658289,-0.022420155,-0.010861229,-0.0058398396,0.0488118,0.0038608015,0.0054708663,-0.007533762,-0.00020387866,-0.010103158,-0.029464187,0.003498537,-0.041539676,0.007701477,0.0053501115,0.0016578637,-0.0007144663,-0.006648226,-0.008580305,0.005454095,-0.008687642,-0.034348052,-0.018717004,-0.006530826,-0.030349724,0.005158916,-0.0026532528,-0.01124362,-0.021588286,-0.0026566072,-0.0037065037,-0.018636502,-0.017294781,0.019776965,-0.00010634185,-0.014356412,-0.011699805,-0.00355556,0.0011446555,0.10256114,0.0152553655,0.016798344,0.010210495,0.007896027,0.010693515,-0.025237767,-0.0156176295,-0.00012085969,-0.007942987,-0.016744675,0.004125791,0.005064996,0.013994148,0.0044478043,0.007520345,0.019790381,-0.023869213,0.003144658,-0.015657881,-0.005185751,-0.003498537,-0.0068058786,0.03450906,0.0044511585,-0.009137118,0.020944262,0.037756022,0.012451169,-0.014772345,-0.0053366944,0.022701915,-0.01504069,0.001133754,-0.0082582915,-0.0010104835,0.011283872,0.014181988,0.030349724,-0.020877175,0.02047466,-0.0054507405,0.009063324,-0.019629374,0.007996656,-0.0010415107,-0.006208813,0.0104385875,0.014061234,0.01412832,0.010988693,0.017509457,0.0032134212,0.000016941845,0.009398754,0.021038182,-0.0010280935,0.0011312383,0.014047816,-0.019441534,-0.026874667,-0.041673847,0.016207987,-0.015885973,-0.03848055,-0.03252331,-0.009365211,-0.008452841,-0.025787873,-0.005142145,0.019884301,0.008392463,-0.025009675,0.006976948,0.038400047,0.005963949,0.011283872,-0.009479257,0.010935024,0.037943862,0.006755564,-0.009016364,-0.009392045,0.0022641537,-0.004665834,0.009170662,0.022473823,-0.012357248,-0.002222225,0.024808416,0.016194569,-0.0032805072,0.01359834,-0.028337143,-0.0029836516,0.011142991,-0.0017542999,0.00622223,0.0072721266,-0.0027471732,0.050529204,-0.02330569,0.022634828,-0.0072050407,0.03815854,-0.016154317,-0.011813851,0.0034717026,-0.021802962,-0.0027706535,0.0028628968,-0.024875503,-0.01807298,0.0024419317,-0.01734845,0.0074264244,-0.02777362,0.00091153156,-0.008090576,0.0075270534,0.01744237,-0.032254968,0.021682208,-0.0075069275,0.0040486422,-0.011974858,0.023802126,0.013350122,-0.0015044044,0.02503651,-0.008835231,0.035448264,-0.017764382,-0.031315763,-0.00087379565,-0.02397655,-0.023023928,0.012330414,0.0070708683,-0.014517419,-0.03204029,0.005594976,-0.019495202,-0.0014272555,-0.03579711,-0.012001692,-0.025385357,-0.010049488,-0.0036025203,0.030349724,-0.014919935,0.011116156,-0.017724132,0.024419317,0.0052897343,-0.02868599,-0.027988296,-0.009351794,0.0043069236,0.010706931,0.0049610124,0.022876339,0.012531672,0.00027400453,-0.00085953984,-0.010653263,-0.0041828146,0.0006536696,-0.019964805,0.037621852,0.013383664,0.026659992,0.013142155,0.0028712824,0.008781563,0.024808416,-0.0073056696,-0.03268432,-0.023265438,-0.008828523,-0.01311532,-0.013316578,-0.02796146,-0.016100649,-0.006121601,-0.0025174036,0.018717004,-0.006158498,-0.022245731,-0.00071740133,0.03386503,-0.010727057,0.023694789,-0.016905682,0.024110721,0.013953896,-0.0054473863,-0.009922025,-0.01316228,-0.0017308198,-0.0038373214,0.018140065,0.018153481,0.010780727,0.007701477,0.039178245,-0.012833559,-0.018435244,0.009573177,0.00045366935,-0.028981168,-0.01725453,-0.008929152,-0.037353504,0.0014339641,0.000566877,-0.006711958,0.038078036,-0.005511118,0.0021350132,-0.005007973,-0.0043740096,0.025532946,0.0047698175,0.024244893,0.00715808,-0.017831469,-0.0129140625,0.015845722,-0.014383246,-0.020233149,0.025063343,0.019213442,-0.0015874234,0.0025643639,0.0054708663,-0.0036394175,-0.0137325125,-0.014826015,0.010539217,0.009284708,-0.0021299818,-0.024486404,-0.007996656,0.004568559,0.031745113,-0.001900212,0.011948023,0.003833967,0.02470108,-0.0052528367,0.02959836,-0.021172354,0.007647808,-0.0002685538,-0.014168572,0.0009928733,0.014852849,-0.012900645,-0.017804634,-0.0068427757,0.03354302,-0.029920373,-0.015738385,0.017227694,0.042103197,0.002297697,0.0015522032,0.004608811,0.028122468,-0.014020982,-0.018488912,0.025237767,-0.009331668,0.01835474,-0.0022239021,-0.0031832326,-0.004078831,-0.018247403,-0.014651591,-0.0020863758,0.022889756,-0.0003306084,-0.0054507405,-0.0018817633,-0.005581558,-0.006114892,0.0034146793,0.012176116,-0.01859625,-0.0015597504,-0.026727078,-0.010250746,0.025304854,-0.0156176295,0.002265831,0.0022020992,0.02109185,-0.016543416,0.010921607,0.006567723,0.0122096585,-0.004665834,0.01316899,0.008043616,-0.013229366,0.012994566,-0.019709878,-0.03171828,-0.015295616,-0.0034683482,0.008613847,0.007963113,0.01412832,-0.003666252,0.0053836545,-0.0053098598,-0.007030617,-0.01090819,0.009714059,-0.00050062954,-0.0017140483,-0.0058096508,-0.010009237,-0.0018566061,0.01893168,0.0012419303,-0.004954304,-0.026633156,0.012276745,0.003921179,0.015778637,0.0058666742,-0.020836923,0.00037966506,-0.016704423,-0.009673807,0.021158937,0.0037031493,-0.0017526228,0.008714477,0.009432297,0.010626429,0.017670462,-0.005608393,-0.015000438,-0.02531827,-0.018180316,-0.025439026,-0.030215552,-0.006400008,0.015000438,0.0026515757,-0.023654537,0.0054406775,0.00037232751,-0.028605487,0.01249142,-0.023010511,0.025170682,0.01954887,-0.0032268385,0.004125791,0.00658114,-0.0034482223,0.0007496865,-0.0106666805,-0.015563961,0.015429789,-0.003099375,0.015778637,-0.009291416,-0.034911573,-0.005031453,0.024432736,0.0048905723,-0.0073593385,-0.008942569,0.0110960305,-0.0054943464,0.021252858,0.008211331,0.018864594,0.011740057,0.023252022,-0.00045325005,-0.0056486446,-0.006832713,0.011089322,-0.015684716,0.022433572,0.01716061,-0.005521181,-0.018005893,-0.018421827,0.01249142,-0.0016142578,-0.020313652,0.00039916192,-0.00009004204,-0.0042465464,0.006624746,-0.0013090164,-0.028363977,-0.0073928814,0.0028461253,-0.017522873,-0.02407047,0.015966477,-0.02036732,-0.012699387,0.00089056714,-0.005732502,0.008533344,-0.0024369003,-0.0009132087,0.020300236,-0.017563125,-0.004622228,0.030591233,-0.012176116,0.02258116,-0.05227344,-0.019776965,0.0022289336,-0.0020243211,0.006524117,-0.015161444,-0.009774435,0.005454095,-0.03045706,-0.0122096585,0.009942151,0.010552634,0.010820978,0.014061234,0.22283298,0.013336704,-0.028659156,0.020152645,0.02047466,0.014812597,0.010820978,0.00049140526,-0.017093522,0.034992076,-0.02753211,-0.0076276828,0.03909774,-0.009009655,-0.0130951945,-0.027210098,-0.037299838,-0.020219732,-0.018676752,-0.025640285,0.014477167,-0.0051052477,-0.003144658,-0.021065015,0.005833131,-0.020944262,-0.01522853,-0.015872557,0.0048972806,0.034535892,-0.006554306,-0.0059605944,-0.0066281008,0.006685124,-0.007902735,0.005024744,0.0062390016,-0.008231457,0.018368157,-0.0017727485,-0.04194219,-0.006064578,-0.020488076,0.006641518,-0.005209231,0.0059605944,-0.028954335,0.011827269,0.032362305,0.010384919,-0.023909464,0.015657881,0.0047932975,0.020836923,0.0041056657,0.01595306,0.00564529,0.005967303,-0.0072587095,0.029571526,-0.003733338,0.010009237,-0.023238603,0.0062490646,-0.0011865844,0.0072855437,-0.018394992,0.010009237,0.028498149,-0.019119522,-0.00025220157,-0.013195824,-0.015818888,-0.0037970697,-0.029410519,-0.018408408,0.02916901,0.0077819806,0.015778637,0.023989968,-0.021454114,-0.034026038,-0.019065851,0.004152626,0.0014205469,-0.03432122,0.019535454,0.013859975,-0.00032285156,0.0041928776,-0.015188279,-0.027089342,0.0006109022,0.000916563,0.013967313,0.02965203,-0.010727057,0.012994566,-0.016798344,-0.0016109035,-0.023748457,0.009989111,0.0027958106,-0.008057034,-0.03429438,-0.015013855,-0.000324948,-0.0011756829,0.016073816,-0.02311785,-0.0177778,-0.023721622,0.016100649,-0.0045719133,0.0028293536,0.017361866,0.0027304017,-0.032791656,0.01677151,-0.003810487,0.01311532,-0.02349353,-0.005199168,0.0112570375,0.009740893,0.0032150983,-0.0074130073,-0.005078413,-0.0029484313,-0.03896357,-0.003666252,-0.0019723296,0.023010511,-0.027062507,0.0049039894,0.014718677,0.00079119595,0.007023908,-0.005511118,-0.0051823966,0.02771995,-0.016945934,0.0024251603,0.005400426,-0.018368157,-0.015309034,0.029947208,-0.021561453,-0.008338794,-0.009821396,0.0048805093,-0.018824343,0.01431616,-0.016825179,0.031208426,-0.0190256,-0.0152822,-0.022769002,0.0015781991,0.04094932,-0.023359358,-0.0021652018,0.011840686,-0.020434408,-0.03268432,-0.013792889,-0.17431636,-0.0021014703,0.0110289445,-0.033757694,0.001744237,0.014745511,-0.004568559,0.02339961,-0.027236931,-0.009445714,-0.004742983,-0.009445714,-0.0445988,-0.018381575,0.008003364,0.031879287,-0.012692679,-0.0022020992,-0.010452005,0.00593376,0.021145519,-0.023949716,-0.014101485,0.012524963,0.022165228,-0.004119083,-0.024459569,0.016033564,-0.0010079677,0.004987847,-0.003599166,0.011418044,0.024419317,0.0144369155,0.005766045,0.0120956125,0.0030406746,-0.0073459214,0.012115738,0.014517419,-0.0053937174,0.003221807,0.014758929,0.020769838,-0.0014364797,0.015456623,0.024835251,0.017200861,0.015577378,-0.013189116,0.0042532547,-0.025868377,0.009787853,0.010264164,0.031557273,0.01571155,-0.0095128,0.02796146,-0.016127484,-0.0043471754,-0.02075642,-0.021145519,-0.002542561,-0.019535454,0.0035723315,-0.017174026,0.0077484376,-0.00009774645,-0.0067153126,0.019495202,-0.014678425,-0.01023062,-0.006275899,-0.031825617,0.02613672,0.009123702,-0.026566071,0.0069031534,-0.013698969,-0.032308634,-0.019119522,0.04577951,-0.011572341,-0.017375285,0.008680933,0.008466258,-0.006165207,-0.013792889,0.01388681,0.023949716,0.028954335,-0.029249514,0.0024318688,-0.015563961,0.011303998,0.0048301946,-0.014919935,0.014342995,-0.013128738,0.010270872,0.0057727536,0.000121698264,0.009170662,0.0021551389,0.03987594,0.012142573,0.030537564,0.0063899453,0.023627702,-0.010317832,0.0098482305,0.014678425,0.0063932994,0.016758092,0.0106868055,0.014490584,0.013537963,-0.017576542,0.023869213,0.0011823914,0.028712824,0.0069031534,-0.011679679,0.0023832314,0.006554306,-0.019092686,-0.064402595,0.0002136271,0.010566051,0.018368157,-0.0034146793,0.020836923,-0.00807045,0.033704024,-0.00079496956,0.0077484376,-0.009204204,-0.029920373,-0.0053803003,-0.011612593,0.012343831,-0.011968149,-0.0010633137,-0.010713641,0.004377364,0.014450333,0.013336704,0.010163534,0.022084724,-0.009445714,-0.0063932994,0.010478839,-0.037997533,0.02306418,0.026780747,0.017335033,0.02488892,0.0077618547,-0.013927061,-0.0010297707,-0.026780747,-0.0047631087,-0.015349286,-0.010290998,0.03646797,-0.018971931,0.0074599674,0.002297697,-0.0059605944,-0.04170068,-0.010867938,0.017214278,-0.035394594,0.0078490665,0.01677151,-0.016503165,0.0007480093,-0.0011874229,0.0019958096,-0.010384919,0.027505275,-0.0045719133,0.021400446,0.014262492,-0.016825179,-0.019884301,0.009197496,0.024150973,-0.004199586,0.015416372,-0.031315763,0.0024369003,0.0034012622,-0.005018036,0.02056858,-0.00012610079,0.003522017,-0.008405881,-0.021937134,0.012189534,-0.026364813,0.005584913,-0.03407971,-0.02421806,0.0005874221,-0.02551953,-0.01898535,-0.0080301985,-0.0035085997,0.0037065037,0.014181988,0.023949716,0.018394992,-0.0022389966,0.0070507424,-0.0038641558,0.003934596,0.02046124,-0.0054842834,0.0010935024,-0.0058499025,-0.01398073,-0.024325397,-0.016154317,0.004612165,0.017710714,-0.037460845,-0.021628538,-0.08817789,0.017724132,0.02825664,0.00048637378,0.007533762,0.0048234863,-0.0011974858,0.007540471,0.0023731687,-0.011183242,-0.02378871,0.011679679,0.020743003,0.0031631067,-0.026834415,-0.015872557,0.03311367,-0.018663336,0.003297279,0.0120285265,-0.010364793,-0.00007023069,0.0013501066,0.012940897,-0.001137947,0.00058909925,-0.008909026,0.009264582,-0.016556835,-0.0025811354,0.016181152,-0.0150943585,0.0039513675,0.06005542,-0.02460716,-0.016516583,0.0073056696,-0.0034817653,-0.005075059,-0.033838198,-0.02248724,-0.012692679,-0.0016327065,-0.0058163595,-0.016395828,0.020139229,0.0009199173,0.023855796,0.020045308,-0.0004176106,0.013558088,0.025626866,0.0081442455,0.018247403,-0.020353904,-0.014758929,-0.0017224341,-0.020447824,0.0012519932,-0.0072385836,0.008680933,0.006567723,0.02594888,0.012820142,-0.0004507343,0.009116992,0.0029601716,0.0057291477,0.0053970716,0.009559761,-0.023480114,0.020125812,0.0063262135,0.011713223,0.015631046,-0.0064704483,0.0059069255,-0.020005057,-0.022071306,0.037111998,0.017616794,0.00032893123,-0.017589958,-0.011780309,0.008526635,0.018569415,0.0010079677,0.015429789,0.008385755,0.015215114,0.003632709,-0.00559833,-0.005256191,-0.002465412,-0.012122447,0.033999205,0.0064469683,-0.0037199208,0.029437354,0.01042517,-0.017294781,0.019213442,0.0036025203,0.0023714914,-0.032174464,-0.006232293,-0.009888482,-0.027451606,0.018609667,0.0030389975,0.011954732,0.015590795,-0.009566469,0.02042099,0.0006633132,0.000625158,0.01355138,-0.016637338,-0.025747621,-0.010673389,0.007030617,0.022514075,0.025532946,-0.0126188835,0.003887636,0.011236912,-0.019857468,0.013477585,0.0036394175,0.005018036,-0.0009668775,-0.026646575,0.005487638,-0.0055714953,-0.004602102,-0.0010431879,-0.02267508,0.00417946,-0.010317832,0.052971136,0.014544253,-0.016811762,0.0080301985,-0.037890196,0.03161094,-0.0062255845,0.016221404,-0.023198351,-0.006158498,0.023439862,-0.008244874,0.012786599,0.009962277,-0.0082582915,-0.010767309,-0.012169408,0.0085065095,0.012357248,0.0027706535,0.00658114,-0.012739639,0.019924553,-0.022809252,0.003790361,-0.021051599,0.00016320775,-0.010841104,-0.0023798773,-0.009452423,0.006701895,-0.003079249,-0.015872557,-0.030510731,0.004266672,0.005665416,-0.0023698143,-0.0053803003,-0.026606323,0.010311124,-0.026740495,0.017013019,-0.02349353,-0.035448264,0.029866705,-0.011203368,-0.006990365,-0.003666252,-0.030966915]');
INSERT INTO ROOMS(hotelName,roomName,embedding) values('Mallorca Rocks','Ocean View Deluxe','[-0.00013282787,-0.000797816,0.0034934157,-0.011950266,-0.019853737,0.04280368,-0.029984303,-0.013790335,0.0005529544,0.010130566,-0.0065420913,0.016309397,-0.03177684,-0.018034037,-0.025312835,0.0013885393,0.009505893,-0.014163781,0.018359954,-0.0035137855,-0.025353575,0.016418036,0.033460744,-0.019174743,0.00018990568,0.0012035139,-0.0124255605,-0.005411569,0.015671143,0.011658299,0.026018986,0.013118132,-0.00059921073,-0.016608153,-0.02301784,-0.0056695864,-0.012900854,-0.008500984,0.021211721,0.009539843,0.014910672,0.00010641084,-0.0013214889,-0.01241877,0.0030452807,0.017952558,0.007971371,-0.0014089091,-0.018495752,0.0054387287,0.0040671644,0.025638752,0.024701742,-0.018930307,0.0036971134,0.009682431,-0.020247553,-0.013756385,0.016689632,-0.016716791,0.005591502,-0.01515511,-0.037833456,-0.01157682,-0.030744774,0.02569307,-0.014163781,-0.0020335822,0.014652655,-0.03674707,0.025312835,0.0062467298,-0.028028805,0.003361012,0.0043998705,-0.021673435,-0.0027753813,0.009594162,0.023601774,-0.0068272683,0.0077065635,-0.018305633,-0.024498044,0.004165618,0.013450839,0.024280766,-0.01864513,0.025516532,-0.0056186616,-0.030989211,0.0009437994,0.03636683,0.0052078716,-0.0034934157,-0.031450927,0.0069393017,-0.00885406,0.015385967,-0.020559888,-0.0018553466,0.0023527085,0.02132036,-0.027702888,-0.018088356,-0.03443849,-0.0043116016,-0.0036360042,-0.00081012276,0.017572323,0.0060192673,-0.013620587,0.016540254,0.018061196,-0.028164603,-0.014285999,-0.0053844093,-0.0044609797,-0.0015285816,-0.004335366,-0.015535345,0.0058121746,0.0176538,-0.001965683,-0.00971638,0.00092003465,-0.00111864,-0.010768819,-0.008168278,0.019894477,0.019337703,0.035742156,0.0031878692,0.01338294,-0.012717527,-0.028164603,0.014897092,-0.017124187,0.012928015,0.0030486756,-0.009071338,0.0106466,0.03270027,-0.008188648,-0.005503233,0.005513418,0.017938979,-0.0027855663,0.017599482,0.0028585577,-0.016553834,0.010381794,-0.04535669,0.010069457,0.0049939887,0.011984215,0.020722847,-0.0031148775,0.013973663,-0.03462861,-0.000059411832,-0.0040332144,0.008209018,0.0047495514,0.0077676727,0.04266788,0.009288616,0.017585902,0.017151346,-0.012744687,0.006222965,-0.022556126,0.028191762,-0.007387437,0.0036597687,0.010809558,0.020030275,0.00036432184,-0.023398077,-0.007387437,-0.010429323,-0.045845564,-0.0016440102,0.0025665911,0.0071497895,-0.0059072333,0.009607742,0.00796458,-0.0017670776,0.017192086,-0.025027659,0.02132036,0.0033389449,0.008412715,-0.00978428,-0.6648693,-0.025502954,-0.021524059,-0.010497222,0.036801387,0.020315452,0.0060803764,0.02046483,-0.0060090823,-0.029631227,-0.019052526,0.0077948323,0.014000823,0.01781676,0.008256547,-0.017219245,0.0021761705,0.0023051791,-0.0052961404,0.0022287925,-0.01605138,-0.005686561,-0.015385967,0.018984627,0.011169424,-0.01780318,-0.0028585577,-0.015711883,-0.03365086,0.026942417,-0.0029417344,0.028001646,-0.016648892,-0.011848417,0.04723071,-0.025258515,-0.016852591,0.014476117,0.0043930807,0.03761618,0.0006768705,0.0014360688,0.021890713,0.00028984487,0.0028687427,0.010911407,0.029441109,-0.021687016,0.0056390315,-0.00441345,0.045981362,0.000398908,-0.010551541,0.008473825,0.009166397,-0.033406425,0.03392246,-0.005622057,0.009879339,-0.015250169,-0.00097435404,0.013790335,-0.027607828,-0.036149554,-0.00012815981,0.011407072,-0.025557272,0.012079274,0.01678469,-0.005622057,-0.013654537,0.042043205,-0.0066473354,0.0041316687,0.0065760408,0.007760883,0.041744452,-0.029142352,-0.017558742,0.012391611,0.035687838,-0.022501808,-0.005523603,-0.004213148,0.020627787,-0.008636783,-0.040522262,-0.0009488918,0.029604066,-0.022569707,0.0106466,0.031695362,0.02752635,0.015902001,-0.007299168,0.016214337,-0.017626641,0.014421797,0.011020046,-0.039788954,-0.00087420264,-0.009424414,0.0034017516,-0.011067576,0.0057340907,0.0024223053,-0.015752623,-0.009825019,0.029685546,-0.0080189,0.009336145,-0.010789189,-0.020885805,0.0035137855,0.0023730784,-0.031586725,-0.00018979958,0.0062569147,-0.005937788,-0.014489697,0.0021982377,-0.020967284,0.005835939,-0.012873695,0.004620543,0.03367802,0.004980409,-0.00289081,-0.0011890854,-0.001380052,0.024579523,0.015195849,0.00796458,0.0025071793,-0.010463272,0.011087946,-0.0032116338,-0.009186767,-0.0019928426,-0.021754915,-0.0053266953,0.0024240026,-0.017164927,0.00711584,0.00017908424,-0.026168365,0.0088269,-0.009302195,-0.031342287,0.000698089,-0.0027821711,-0.01427242,-0.018427853,0.017232826,-0.012160753,0.0015192454,0.029169511,-0.019772258,-0.03541624,-0.0020030274,0.028110284,-0.0040400047,-0.01420452,0.001030371,0.005272376,-0.017952558,0.004342156,0.013070603,-0.0033236677,-0.02747203,0.0034543737,-0.004101114,0.008657153,0.021659857,0.0131520815,0.014340319,0.003184474,-0.020736426,0.029196672,-0.008806531,0.023791892,-0.0040162397,-0.022624025,0.004705417,0.009030598,0.006752579,0.017273566,0.0337595,0.003276138,0.0044983244,0.018943887,0.032455835,-0.010178096,0.016390875,-0.008833691,-0.0031080875,0.02669798,0.02041051,0.024538783,0.033134826,0.031206489,0.0056526116,0.02231169,0.00064079906,0.030608976,-0.02663008,0.008385556,-0.024294347,0.009614532,0.022080831,0.025448633,-0.030880572,-0.012520619,-0.01163114,0.031342287,0.005353855,0.016513094,0.013186032,0.0044813496,-0.016390875,0.0023238515,0.008555303,0.008378766,0.0025394314,-0.033406425,0.00088099256,-0.0036699537,0.0014089091,0.0015786572,-0.014530436,-0.029821344,0.0028653478,-0.024321506,0.010911407,0.0077065635,0.0047427616,0.001046497,-0.0039856853,-0.0010320684,0.011739778,0.020478409,0.020288292,0.011053995,-0.013477998,-0.00581557,0.0034866259,0.014041562,0.008467034,-0.006559066,0.0021982377,-0.010857088,-0.022501808,-0.015318068,0.01769454,0.006385923,-0.008433085,0.011712618,0.009186767,0.013674906,0.006216175,-0.0068714027,0.016458774,0.0048310305,0.0004190656,0.008657153,0.0023561034,0.0020216997,0.0020777166,0.01856365,-0.010571911,0.0045186942,-0.013253931,0.021537637,-0.0032846255,0.0043964754,-0.019392021,-0.0068747974,-0.0017161532,0.002485112,0.012391611,-0.019894477,-0.019419182,0.019717937,0.015168689,0.0050856527,-0.019269804,-0.027051056,0.009920078,-0.0063553685,0.036801387,0.01686617,0.0052791657,-0.0037887774,-0.033189148,-0.011909526,-0.029957144,0.0065183267,-0.022393169,-0.010279944,-0.0023357337,0.017518003,-0.01694765,-0.0028110284,-0.022882042,0.0018061197,-0.003391567,-0.025720231,0.0011305222,-0.0032982053,-0.017314306,-0.010286734,-0.0154946055,-0.005693351,-0.009410834,-0.0043014167,-0.004233517,-0.01686617,-0.016146438,0.0068680076,-0.0022016328,-0.021822814,-0.009689221,-0.011345962,0.012602098,0.07349414,-0.012099644,0.0033389449,0.0037650126,0.008738631,-0.015087211,-0.03272743,-0.0110607855,-0.000059783157,0.015834102,-0.013579847,0.0033559196,0.00355113,0.005245216,0.009451574,0.005228241,0.0016660775,-0.038621087,0.008473825,-0.016458774,-0.021483319,-0.002121851,0.005605082,0.029522588,0.007448546,0.0071294196,0.0141502,0.027784368,0.0047427616,-0.0010592281,0.016513094,0.01511437,0.01332183,-0.004342156,0.00050245435,-0.013851444,-0.00035243947,0.0021405234,0.013736015,0.013647746,0.021958614,0.016268658,0.008731842,-0.026358483,-0.01328109,0.014367478,-0.02224379,0.024117809,-0.014027982,-0.0051841065,0.023316598,0.013029863,-0.011332382,0.0020233972,-0.002766894,0.012608889,-0.018998206,-0.0017568928,0.021211721,-0.021170981,-0.011407072,-0.03101637,-0.008555303,-0.016431615,-0.005584712,-0.025584431,0.027865846,0.0041146935,-0.014761294,-0.016377296,0.011284853,0.005180712,-0.021700596,-0.0062637045,0.025896769,0.017355045,0.006318024,-0.020356191,0.020763587,0.025625171,0.00973675,0.00023955699,-0.02565233,0.008643573,-0.0044983244,0.0022949942,0.03886552,-0.018074777,0.009478733,0.023370918,0.017490843,0.006311234,0.017151346,0.0036563738,0.017069869,-0.009159607,0.017640222,0.010891037,-0.009139237,-0.011203374,0.026277004,-0.018509332,-0.006430058,-0.0026769275,0.015372387,-0.0066133854,-0.012880485,0.013763175,0.0034611635,0.0027380367,0.004634123,0.006066797,-0.021537637,0.0008835388,-0.033949617,0.040196348,-0.005160342,0.010137356,-0.022257369,0.015576085,0.014679815,-0.041500013,0.02747203,-0.019772258,-0.0014700184,0.008324446,0.009845389,-0.012941594,0.009295406,0.0044779545,0.019364862,-0.003921181,-0.012004585,-0.009621322,-0.0030860202,-0.005065283,-0.010293524,0.014802033,-0.019378442,-0.03826801,-0.00971638,-0.004596778,0.0037106932,0.013192821,0.0049396693,-0.019405602,-0.014652655,-0.024498044,0.0033542223,0.050136797,0.0071294196,-0.01427242,-0.00029748352,0.0091731865,-0.005713721,-0.021456158,-0.018237734,-0.008813321,0.008331236,0.016499514,0.016064959,-0.0077133533,0.021917874,-0.0020318846,0.014027982,-0.008460245,-0.000747316,-0.0019028761,-0.011441021,0.014829193,0.024117809,0.007760883,0.021469738,0.0002550465,-0.018821668,0.01153608,0.0039449455,-0.013736015,-0.018862408,-0.010931777,0.01332862,-0.013865024,-0.01595632,-0.022596866,0.010524382,0.0011339172,0.045601126,0.02402275,0.004522089,-0.00032846254,-0.0023561034,-0.02301784,0.021605536,0.0068714027,0.0001782355,0.014530436,0.0024732298,-0.0073399073,-0.013240351,0.021836394,0.014706975,-0.0023204563,0.014557596,0.005506628,0.012853325,0.027974484,-0.0030962052,-0.013213191,-0.022447487,-0.014055142,-0.010436113,-0.036040913,-0.023167219,-0.0533688,0.009268246,0.010768819,-0.01864513,0.043971546,0.014123041,-0.027702888,-0.017680962,-0.013206401,0.020220393,0.0064232675,0.020559888,0.0051263925,-0.002311969,-0.023235118,-0.013158872,-0.0073534874,-0.003914391,0.0099472385,0.017164927,-0.005272376,-0.0026820197,0.0051739216,0.008786161,-0.009050968,-0.028897915,0.019134006,0.008446665,0.013892184,-0.01770812,0.0031522221,-0.0007867824,0.031804003,-0.012642838,-0.011637929,-0.0091052875,0.0060939565,-0.03028306,-0.0024375825,-0.020274712,0.0077744625,0.016064959,0.0005117905,-0.00444061,0.0032812306,-0.0043082065,-0.0011559845,-0.0061550657,0.025014078,-0.012934804,0.0013690183,0.007842362,0.016404456,-0.0017051195,0.0024681373,0.0051128124,0.023900531,-0.02752635,-0.01423168,0.025638752,0.00709547,0.012887275,-0.0013231863,-0.008066429,-0.0115836095,-0.009743541,-0.008297287,-0.00062297547,-0.0055711325,-0.0050177537,-0.0045764083,0.0012374636,-0.04255924,0.011712618,-0.011162634,-0.016282236,-0.030500337,-0.008759001,-0.021266041,-0.00888801,0.028897915,0.010218835,0.01952782,0.004532274,0.025122717,-0.033705182,0.027784368,-0.00975712,0.0069732517,-0.020967284,0.022379588,0.01511437,0.0004935426,0.0011237323,-0.019731518,-0.0194735,-0.032428674,-0.019975955,-0.0014148504,0.0024935994,0.019799417,-0.0017212456,-0.009879339,0.011603979,-0.0049634343,-0.045927044,0.016282236,-0.0040467945,-0.014299579,0.005975133,0.004012845,0.010042297,0.032347195,-0.019704359,-0.004274257,-0.01868587,0.0021846578,-0.007726933,0.024348667,-0.006497957,-0.026236264,-0.026847357,-0.028870756,0.000025833537,0.020247553,-0.0072380584,-0.011923105,0.030717615,0.022135152,-0.006328209,0.013138502,0.0023136665,-0.013450839,-0.022542546,0.0054760734,-0.0024800196,-0.03359654,-0.025964668,0.022420328,0.012961964,-0.018183416,-0.007638664,-0.0129483845,-0.03729026,0.018129095,-0.0050924425,0.007462126,0.034465652,-0.012846535,0.005228241,0.013987242,0.004450795,0.0065285116,-0.013219981,-0.007054731,-0.000117762735,-0.027716467,0.012581728,-0.005859704,-0.024606682,-0.00712263,0.0028721376,0.00795779,-0.0018689265,0.011237323,0.00018746554,0.007801622,-0.0077065635,-0.0072516385,0.014802033,0.034166895,0.0036088445,-0.03902848,0.002357801,0.014679815,0.015739042,0.006026057,0.008494195,0.0041486435,-0.02054631,0.016540254,-0.018835248,-0.0037887774,0.01068055,-0.020967284,-0.020682108,0.017110607,-0.0052689807,0.0109249875,0.0036937185,-0.013294671,0.0043693157,-0.006409688,-0.028571999,-0.016187178,0.0003263407,-0.018930307,-0.0055473675,-0.025258515,0.010300314,-0.016513094,-0.0025054817,-0.0005652611,0.006783134,-0.012249022,0.0065251165,0.027893007,-0.027064634,-0.0021999353,-0.008704682,0.0035307603,-0.011352752,-0.009336145,0.016146438,-0.016064959,0.0020233972,0.012751477,-0.0070683104,0.0040332144,0.010021927,-0.007917051,0.009404045,0.0039958702,0.22227494,-0.001399573,-0.029821344,0.036312513,0.0130162835,0.03742606,0.019337703,0.0024766247,-0.0033983567,0.030853413,-0.017259985,-0.011203374,0.014666235,-0.001991145,-0.0095602125,-0.026317744,-0.019011786,-0.028816435,-0.027363392,0.0000106424095,0.0043048114,-0.01783034,-0.008840481,-0.0008071522,0.026820198,-0.022121571,-0.02566591,0.003921181,0.004090929,0.03270027,0.003063953,-0.020817906,-0.010415743,0.01332183,-0.007204109,0.008806531,-0.0031420372,-0.0120385345,0.029848505,0.037751976,-0.02214873,0.01072129,-0.0035273654,-0.014027982,0.009234296,0.018821668,-0.0045186942,-0.009383675,0.016499514,-0.010775609,-0.009465153,0.034139737,-0.017124187,0.010449693,0.023737572,-0.010184885,0.006942697,-0.015698303,-0.020138914,-0.0075911344,-0.008209018,0.037969254,-0.023601774,-0.004566224,-0.01156324,-0.0033100878,-0.0153588075,-0.0056695864,0.019025367,-0.013505158,0.0104700625,-0.023696834,-0.015521766,-0.01338294,-0.015087211,-0.012126803,0.028680637,-0.017192086,0.03202128,0.010232415,-0.0116515085,-0.008446665,-0.04068522,-0.015318068,-0.00097011036,-0.050028156,0.03924576,-0.0033016002,0.006158461,0.0043285764,-0.010476852,-0.020587048,-0.006813688,0.009363305,0.018047618,0.026114047,-0.00012720497,0.027023897,-0.008385556,0.010877457,0.002753314,0.013783545,0.0003403449,0.0006985134,-0.017626641,-0.0058427295,0.0023951456,0.015725464,0.0044609797,0.01237803,-0.0075096553,-0.009648481,0.0034934157,-0.004698627,-0.018848827,-0.0052689807,0.021836394,-0.028571999,0.0016550439,-0.00887443,0.013898973,-0.026127625,-0.0124934595,0.013036653,-0.010571911,-0.011522501,-0.011366332,0.01063981,-0.0017619851,-0.03995191,0.03191264,0.016064959,0.035144646,-0.008663942,-0.004634123,0.02854484,0.026358483,-0.016703213,0.002583566,-0.014992151,0.020301871,0.0014462537,0.016255077,-0.0028976,-0.008270127,-0.024199288,0.019351283,-0.011882367,-0.006942697,0.00890159,-0.01068055,-0.025068399,0.012581728,-0.009655272,0.008759001,-0.010028717,-0.038702566,-0.024701742,-0.0015175479,0.005516813,-0.0037751975,0.0050177537,0.025258515,-0.023275858,-0.03378666,0.018387113,-0.17610346,0.015372387,-0.0018740189,-0.034248374,-0.014666235,0.0053844093,0.024416566,0.0018875988,-0.019975955,0.0065556713,0.014625495,-0.010633021,-0.049322005,-0.0059038387,0.01330825,-0.020722847,-0.029060872,-0.0010091524,-0.016458774,-0.002968894,0.02652144,0.0060837716,0.0072516385,-0.018971046,-0.00038575253,-0.0023034816,-0.013715645,0.022963522,-0.0071633696,-0.012602098,0.002364591,0.01951424,0.02585603,-0.0072380584,-0.01061944,0.016295817,-0.0045017195,0.0049838037,-0.010911407,0.004705417,-0.009933658,0.029169511,0.03185832,0.018835248,-0.01243914,0.02223021,0.010456482,-0.004515299,0.021428999,0.009139237,0.01869945,-0.031532407,0.0062331497,-0.016241496,0.009940448,0.025435055,0.010524382,0.010694129,0.00711584,-0.015603244,-0.03484589,-0.02846336,-0.01072129,-0.018305633,0.0060837716,-0.016743952,-0.010884248,0.012099644,0.0070683104,0.0006255217,-0.020519149,-0.015752623,0.019609299,-0.00710226,0.017993297,0.029848505,-0.0030979028,0.007801622,0.0073127476,-0.014557596,-0.043211073,0.047882542,-0.036882866,0.020329032,0.00026268518,-0.0027584066,-0.02927815,0.015087211,0.012995914,-0.0038668616,0.008012109,-0.015725464,0.0196772,-0.00890838,0.033270627,0.015290908,0.022461068,0.020559888,-0.004977014,-0.002298389,-0.021211721,0.0031046926,-0.023832632,0.02400917,0.023805473,0.011250904,0.019038945,0.027132535,0.033297785,-0.014679815,-0.00019605905,0.02224379,0.01150892,0.01678469,-0.017585902,0.003430609,-0.008935539,-0.02045125,0.010449693,0.013369359,0.016227918,-0.0031301547,-0.029468268,0.0091052875,-0.0116515085,-0.0026463727,-0.05850198,-0.022719085,0.015413127,0.02038335,-0.0229771,0.01591558,0.0068102935,0.04188025,0.008324446,0.009268246,0.0106737595,-0.0021558008,-0.010999676,-0.000033843524,0.0372631,-0.025869608,-0.009920078,-0.018196994,-0.0040535843,-0.018115517,-0.0017959347,-0.017382205,-0.0029807764,-0.012792216,-0.0058800736,0.0025173642,-0.016458774,0.04462338,0.020043854,0.003070743,0.04073954,0.006029452,-0.0026599525,0.0021829605,-0.018237734,-0.0008495892,-0.010259574,0.00884727,0.021048764,-0.033324946,0.017015548,0.0072244788,-0.014435378,-0.024063488,-0.0409025,0.018414272,0.0043693157,0.009858969,0.009179977,-0.0009650179,0.011074365,0.006290864,-0.02223021,0.0029909613,0.021347519,-0.0005041518,0.0049023246,0.01963646,-0.013783545,-0.006589621,0.002615818,0.02398201,-0.02036977,0.018495752,0.0042403075,-0.0044474,0.00095143804,-0.00620599,0.015657565,-0.0037412478,0.0135391075,0.015508185,0.0024155152,0.027920166,-0.018455012,0.014082301,-0.04769242,-0.015277328,-0.00332197,-0.010979307,-0.0049464596,-0.017938979,-0.0047020223,-0.017477263,-0.004019635,0.02581529,-0.010463272,-0.010565121,0.012113224,-0.031125009,-0.023805473,0.0074145966,0.0065081418,-0.0020811115,-0.007054731,-0.023588195,0.02854484,-0.023479557,-0.004505114,0.02041051,-0.044080183,-0.011006466,-0.104945056,0.0013002703,0.0071701594,-0.012737896,-0.018332794,-0.0038532817,-0.003826122,0.010375003,-0.00034183022,-0.0010965726,-0.008358396,-0.00067814364,0.025177037,0.0034679535,-0.02664366,-0.024511624,-0.0024053305,0.0010736567,0.0042199376,0.0057340907,-0.01161077,0.017001968,0.026535021,-0.006338394,-0.024402985,0.0066269655,-0.015806941,0.018196994,-0.00080290844,0.017300725,0.014095881,-0.014652655,-0.0133422,0.066867165,-0.03989759,-0.016390875,-0.021157403,-0.0054896534,-0.010857088,-0.032211397,-0.01864513,-0.01769454,0.019201905,-0.00061618554,-0.014625495,0.0056492165,-0.0017772625,0.013797125,-0.00353755,-0.015725464,0.0071497895,0.02483754,0.0021201537,0.012941594,0.017246407,-0.008623203,0.013960083,-0.0075639747,0.0109249875,-0.004556039,0.008242968,0.0087182615,0.023588195,-0.0077065635,-0.0026107256,0.004162223,0.0012714132,0.00794421,0.0020267921,0.010286734,-0.019256223,0.007570765,0.026928836,-0.0013842956,0.0148563525,-0.030636135,0.0266165,0.0015065143,-0.026711559,0.024565944,0.030174421,-0.000048908667,-0.04603568,0.01683901,0.0043862904,-0.009954028,-0.018115517,0.015440286,0.011434231,0.009634902,-0.009186767,0.018251315,0.004803871,-0.010870668,0.029685546,0.016119279,0.010565121,-0.027118955,0.012955174,0.031396605,-0.003014726,0.005968343,-0.004169013,0.0033525247,-0.019717937,-0.002615818,-0.009336145,-0.033270627,0.032510154,0.014353898,0.01861797,-0.010239204,0.011678669,0.030364538,-0.018183416,-0.0031369447,0.009587372,-0.041174095,-0.024633843,-0.0050143586,-0.018780928,0.015453866,0.017884659,-0.013192821,-0.007842362,0.022135152,0.003074138,0.00068450917,0.011013256,-0.014367478,-0.012602098,-0.020668527,0.0124255605,-0.008344816,-0.019201905,0.0037174833,-0.01950066,0.008962699,-0.019106844,0.05866494,0.0135391075,-0.008080009,0.009892919,-0.021958614,0.022379588,0.0026141205,0.013851444,-0.024538783,-0.022012932,-0.010388583,-0.006559066,-0.0054387287,0.027214013,-0.038539607,-0.022596866,0.0089694895,0.012989123,-0.011977425,0.00016380691,0.018875988,-0.005493048,0.019378442,0.00029493732,-0.02384621,-0.010592281,-0.018468592,0.008270127,-0.027159695,-0.02739055,0.009017019,0.013023074,-0.023330178,-0.027363392,0.0023357337,-0.0068272683,0.012052114,-0.010938567,-0.016322976,0.01336257,0.007407807,0.031804003,-0.036991503,-0.0064741923,0.011732988,-0.024389405,-0.025951087,-0.007699773,-0.014747714]');
INSERT INTO ROOMS(hotelName,roomName,embedding) values('Mallorca Rocks','Garden Terrace Room','[0.0006562092,-0.00046979086,-0.012656474,-0.003691749,0.0203196,0.029027998,-0.007276973,-0.018615203,-0.0039414163,0.006897479,-0.016165134,0.01049269,-0.016924122,0.005262989,-0.010059932,0.0032456764,0.023661815,0.019906815,0.03286289,-0.007476707,0.008894818,0.014673786,0.0014805278,0.011078576,-0.015379514,-0.017110541,0.011464728,-0.018535309,-0.004127835,0.01632492,0.019094564,-0.0066478113,-0.022143835,-0.03930764,0.0017659809,-0.011717725,0.005902138,0.006065254,0.013095888,0.02394144,0.02155795,-0.007929438,0.00068075984,-0.0010727377,-0.00042193793,0.016964069,0.0045273025,0.007390156,-0.041677814,0.027403496,0.005632497,0.00038490395,-0.014660471,-0.011364861,0.010459401,0.014593893,-0.015126517,0.025619207,0.008029304,-0.0073235775,0.0060685826,-0.008695084,-0.021544633,-0.0021571266,-0.018508678,0.015925452,-0.0012766328,0.007336893,0.0010519321,-0.0174168,0.027962752,0.02560589,0.012896155,-0.023848232,0.010972051,-0.026404826,-0.016524654,-0.003555264,0.0023868205,0.012130508,-0.0005276305,-0.011444755,-0.009334233,-0.00146638,0.016631179,0.030439451,-0.004640485,0.021051956,0.008695084,-0.024540642,0.03171775,0.016444761,0.0033189123,0.00073859945,-0.017270328,0.0040978747,-0.011091892,0.009760331,0.015978714,-0.01665781,-0.0028362218,0.010599215,-0.028655162,-0.011118523,-0.044553984,-0.019520663,0.020705752,-0.0036351576,0.0049534016,-0.009454073,-0.019161142,0.015286304,0.017909477,-0.034540657,-0.004983362,0.0011443091,0.034327608,0.008635164,-0.027110552,-0.019027986,0.0094607305,0.0063515394,0.015605878,-0.022157151,0.0108988155,0.0049300995,0.0023984718,-0.010392822,-0.0072636576,0.0148735205,0.0005763156,0.011824249,0.017576586,0.01043277,-0.030279664,0.013435436,-0.005033295,-0.0076631256,-0.015019992,-0.01496673,-0.009027974,0.023901494,-0.014474053,-0.012037299,0.025805624,0.002514983,-0.00288782,0.014567262,-0.009027974,-0.018402154,0.016458077,-0.025392842,0.008548613,-0.011637831,0.0014231043,-0.0071904217,-0.0027879528,0.022356885,-0.04114519,0.011038629,0.003921443,0.015579247,0.017802952,-0.0059087956,0.039840262,0.018495362,0.007243684,0.03552601,-0.011704409,0.0069307676,0.006384828,0.015486038,0.0008093386,0.011757671,-0.011864196,0.0063515394,-0.025872203,-0.0113715185,0.012922786,-0.018255683,-0.04085225,-0.007410129,-0.000052118074,0.002003997,-0.02203731,-0.014940099,0.00444408,0.015552616,0.017603219,-0.013508672,0.0058755064,0.024567274,0.008834898,-0.0021138508,-0.6834629,-0.012942759,0.0054494077,0.010592557,0.03131828,0.012043957,-0.004377502,0.03491349,0.009793621,-0.046631217,-0.009407468,0.018828252,0.019760344,0.0031974073,-0.017523324,-0.019893501,-0.016431445,-0.008328905,-0.0077696503,0.005406132,-0.015219726,0.031850904,-0.0051897536,-0.005073242,0.01913451,-0.0041677817,-0.00368842,-0.0037949448,-0.018069264,0.02234357,-0.01139815,0.009027974,0.023209084,-0.0064414195,0.05073242,0.003428766,-0.016937438,0.013342227,0.004251004,0.04804267,-0.0047336943,-0.0042976085,0.014846889,-0.014513999,0.0005921279,0.009047948,0.026977398,-0.018162472,-0.017430115,-0.019906815,0.037629873,-0.01085221,0.014181109,0.016191764,0.019427454,-0.0047836276,0.04599207,-0.0075832317,0.0069973455,-0.009074579,-0.00516978,0.00622837,0.00032560792,-0.02412786,-0.007010661,-0.0039747055,-0.03174438,0.007949411,-0.008868187,-0.022170467,-0.014913468,0.011591226,-0.028149169,0.008129171,-0.0018891501,0.015672456,0.015059939,-0.01245674,-0.006734363,0.007956069,0.008082567,-0.007177106,-0.019360876,0.019014671,0.023142505,-0.015938768,-0.007183764,0.007283631,0.015739035,-0.00009903475,0.026657823,0.01617845,-0.0018725056,-0.0030675803,-0.010772317,0.020253021,-0.010133169,0.0034986727,0.034540657,-0.03821576,0.0016769329,-0.001218377,0.0054394207,0.011977378,0.015326251,-0.004027968,-0.0118575385,0.009973382,0.0339814,0.0036085264,0.0029560623,0.008002673,-0.007390156,0.01789616,-0.0005243016,-0.030279664,0.025499366,0.019760344,-0.01027964,-0.021837577,-0.0045972094,-0.014114532,0.031797644,-0.0029444112,0.028921474,0.01496673,0.014127847,-0.015352882,-0.0030043314,0.010506005,-0.009580571,0.0073302356,0.027776333,-0.013095888,0.017616533,0.010466059,0.016005347,-0.015286304,0.017350221,-0.028308956,-0.032889523,-0.02225036,-0.010545952,0.032782998,-0.008521982,-0.020506017,-0.010193089,-0.009793621,-0.030918814,0.00037117224,-0.016964069,-0.003380497,-0.030466083,0.0071238438,0.0012741361,-0.01396806,0.008215723,-0.022330254,-0.03712388,-0.02336887,0.032543316,-0.023262346,-0.020452755,0.006897479,-0.0065612597,-0.018708412,-0.011284968,0.027376866,-0.003298939,-0.032010693,0.012510003,-0.0056125238,0.003954732,0.0015920459,-0.0052996073,-0.015885506,-0.018908147,-0.0015471058,0.0112250475,0.0013290629,-0.0129693905,0.024647169,-0.014194425,0.00837551,0.022090573,0.01027964,0.023821602,0.020093234,-0.003495344,0.002506661,-0.002714717,0.0022636512,-0.0148868365,0.0059720445,0.009167788,-0.00408123,0.033155832,-0.011664462,-0.0008430437,0.012549949,0.007822912,0.012609869,0.012183771,-0.021518003,0.0148735205,-0.011318256,-0.0012583238,-0.011557938,0.040798984,0.006524642,0.009427442,-0.033422146,-0.029880198,-0.011924116,0.022516673,0.011478043,0.00293276,0.008235696,-0.0021870865,-0.014127847,0.012556607,-0.0004473208,0.0035319617,0.010053275,-0.03307594,0.009600544,-0.003761656,-0.00012597803,0.01290947,-0.005872178,-0.02841548,0.0043009375,-0.0037383535,0.002669777,0.007150475,-0.014567262,0.0063049346,-0.023741707,0.015312935,-0.007290289,0.005339554,0.009267654,0.020093234,-0.015206411,0.0108988155,0.0041145193,0.030732395,-0.009387495,-0.0194674,0.005795613,0.0005047443,-0.006857532,-0.010992024,0.016005347,0.025419472,-0.009600544,0.014447422,-0.0034553972,0.00964715,0.012296952,-0.0013273985,0.009141156,0.011291625,-0.012250348,-0.014340897,0.003555264,0.0027779662,-0.013415463,0.0128096035,0.011498017,0.034700442,-0.020545965,0.00091960834,0.0033538658,-0.034008034,-0.0041810973,-0.009327575,-0.004660459,-0.016191764,-0.0085153235,-0.006038623,-0.019161142,0.020093234,0.0060752407,-0.013189098,-0.013555276,-0.019494032,0.000518476,0.00082889583,0.036564626,0.022183783,-0.0093142595,0.022276992,-0.0044573955,-0.015326251,-0.025579259,-0.027203763,-0.039414164,0.007889491,-0.006334895,0.012556607,-0.021398162,-0.007130502,0.001995675,0.0030193115,-0.012656474,-0.03217048,-0.008322247,-0.0036284998,-0.015832243,-0.0024167807,-0.005705733,-0.0056824307,-0.0058122575,-0.00080975465,-0.00013794126,-0.012416793,-0.011544622,-0.0057922844,-0.01665781,-0.019041302,-0.01732359,-0.008395483,-0.003854865,0.0890547,-0.0013099217,0.0058455467,0.008881503,-0.000440663,-0.015259673,-0.019533979,-0.024021335,-0.0036717756,0.00426432,-0.013095888,-0.00016426036,0.016138501,0.009267654,0.0075166537,0.012882839,-0.011284968,-0.02276967,0.0021055285,-0.020412808,-0.0007302772,-0.00710387,-0.012043957,0.025978727,0.005569248,-0.00085968815,0.0056225103,-0.004640485,0.016737703,-0.009407468,-0.0002125294,0.012083903,-0.0035020018,0.005725706,-0.024021335,0.014434106,0.013588565,-0.0035419485,0.031611223,-0.00589548,0.013115861,0.0053195804,0.015552616,-0.0024201095,0.008428772,-0.0045006713,0.010446085,0.023089243,-0.016031977,-0.009740358,0.007743019,0.018029317,0.006391486,-0.008994685,-0.0056225103,-0.0031125206,-0.0016711073,0.0023834917,-0.01653797,-0.02972041,-0.008069251,-0.054593943,0.011284968,0.0019823594,-0.0043941466,-0.0075366274,0.0067243758,0.0016994029,-0.016138501,-0.01810921,0.0014389165,-0.0031940786,-0.0129760485,0.0068375585,0.032756366,0.0039247717,0.012197086,-0.020572595,-0.019960077,0.042130545,-0.0062050675,-0.0151930945,-0.025046635,-0.010592557,-0.021384846,0.023089243,0.037736397,-0.0006304102,-0.0043209107,0.03147807,0.012197086,-0.032010693,0.03528633,-0.024367541,-0.0009121183,0.00034391688,-0.012703079,0.00027879528,-0.004846877,-0.010193089,0.0075366274,-0.028149169,0.005466052,0.0029244376,0.022210414,0.0072969464,-0.0040645855,0.012223717,-0.0038016026,0.011697751,0.015539301,-0.016378183,-0.03264984,-0.0077629923,-0.0035352907,0.0063448814,-0.0019906815,0.006434762,-0.0033122546,-0.0004302602,0.0016361538,-0.02113185,0.019414138,-0.0227963,0.0022686447,0.0011551279,0.00441412,0.00087217154,-0.009920119,-0.017070593,-0.002073904,0.008814924,-0.016431445,-0.01808258,-0.020399492,-0.030253034,-0.0004968382,0.011744356,0.010752344,-0.02972041,-0.057576638,0.010565925,-0.013648486,0.005599208,-0.027829595,-0.015406145,-0.011664462,-0.018908147,0.026378196,0.04223707,-0.015392829,0.022396833,-0.026324933,0.03555264,-0.019267667,-0.030253034,-0.007869517,-0.0062117255,0.01508657,0.00882824,-0.020772329,-0.017510008,0.024567274,0.008868187,0.0015263002,-0.007996015,0.017296959,0.0034071282,-0.019507349,0.021451425,0.0034820284,0.020292968,0.018668465,0.0028395508,-0.014953414,0.006458064,0.004057928,0.005269647,-0.016830914,-0.017976055,-0.015512669,-0.026990714,-0.018095896,-0.012723052,0.021078588,-0.007276973,0.038402177,-0.018282313,0.0121704545,0.010499347,0.020452755,-0.03280963,0.009001343,-0.011424781,0.028149169,0.015113201,-0.024713745,-0.009533967,-0.020572595,0.0052496735,0.012130508,0.000086083244,0.016577916,-0.011870854,0.022276992,0.021265006,-0.0053229094,-0.022516673,0.004217715,-0.026418142,-0.048814975,-0.02560589,0.011031971,-0.032729734,0.015019992,-0.00550267,-0.0047969436,0.035925478,-0.0021354887,0.018295629,-0.012350216,0.0007032299,0.03486023,0.0064114593,0.0033022678,0.005369514,0.002255329,-0.0015870526,0.036910832,-0.0096271755,-0.0087084,0.029027998,0.00051223434,0.00039010536,-0.022103889,0.01342212,0.025419472,-0.00402131,-0.017549956,0.023648499,0.025632521,0.0004677103,-0.007549943,0.015778981,-0.00441412,0.021091904,0.00003180659,-0.02394144,-0.022450095,0.010286298,-0.031504698,0.013675117,-0.01744343,0.010412796,-0.007523312,-0.010539294,-0.0026198435,-0.009320918,-0.009327575,0.009207735,0.0071438174,0.027802965,-0.022969402,-0.002273638,0.01587219,0.009593887,0.0025382855,0.0063415524,0.009087894,0.026870873,-0.020639174,-0.03374172,0.018268997,0.030119877,0.03981363,-0.010632503,0.012703079,0.0065812333,0.008841556,-0.011025313,-0.012296952,0.014953414,-0.0011468057,-0.00041070292,-0.018908147,-0.008175775,0.009247681,-0.012916128,-0.004540618,-0.014980045,-0.009014659,-0.016231712,-0.0076032053,0.037736397,-0.023608552,-0.0069307676,-0.0058422177,0.019826923,-0.033928137,0.0063948147,0.016444761,0.006388157,-0.0050466107,0.00888816,0.013688433,-0.00045897195,0.00592544,-0.0256991,-0.02579231,-0.034354236,0.00015416964,-0.001351533,-0.013149151,0.0018408811,0.008462061,-0.010113195,0.008968053,-0.01073237,-0.015885506,0.011944089,-0.0151930945,-0.004936757,0.0035952108,-0.030013353,0.019960077,0.032916155,-0.0053928164,0.011824249,-0.020945432,-0.0052929493,0.007842886,0.025312947,0.00019536476,-0.017376853,-0.0039480743,0.0036817621,-0.012143823,0.01033956,-0.0129760485,0.004057928,0.031105231,0.015139832,0.013442094,0.020399492,-0.009940092,-0.021438109,-0.026045306,-0.017363537,-0.021810945,-0.036138527,-0.012410135,0.010625846,-0.0019973393,-0.016338237,-0.002400136,0.00955394,-0.034940124,-0.0041045323,-0.00085552706,0.0043308977,0.006268317,0.007483365,-0.0014097887,0.012090561,-0.008655137,0.013981376,-0.02303598,-0.009127841,0.0052563315,-0.024034651,0.008908134,-0.004816917,-0.044047993,-0.021478057,0.017709743,-0.001425601,-0.0014755345,-0.0048368904,0.021304954,0.01668444,0.0118575385,0.016577916,0.0013548619,0.025832256,0.001507159,-0.027776333,-0.016830914,0.0064647216,0.010139827,-0.026271671,0.0023052625,0.024713745,-0.014500684,0.0020838908,0.0101598,-0.017483378,0.007083897,-0.0052996073,0.03280963,0.0042043994,-0.026125198,-0.0093076015,0.00888816,-0.021584582,-0.0038282338,0.0018708413,-0.025432788,-0.025273,0.01689749,-0.008189091,-0.01239682,-0.014820258,0.018042631,-0.0075366274,-0.0007606534,-0.003159125,-0.0046538007,-0.0054427497,0.02055928,0.025179792,-0.02065249,0.021917472,-0.018042631,-0.003147474,-0.0097869625,-0.0066045355,0.015392829,-0.025872203,-0.021171797,0.013355543,-0.0094673885,-0.010299614,0.020292968,0.029587254,0.010938762,0.0009645485,0.22732385,-0.014034638,-0.009607202,0.018149158,0.02793612,0.012223717,0.025712416,0.000129619,0.0018342233,0.023355555,-0.032756366,-0.003277301,0.024926795,-0.004057928,-0.018042631,-0.0097337,-0.024527328,-0.03717714,-0.02769644,-0.0079827,0.007942753,-0.025379525,-0.014567262,-0.01188417,0.04047941,-0.009014659,-0.026045306,-0.0132889645,0.021930786,0.013355543,0.0024633852,-0.00014345474,-0.0017859543,-0.003180763,0.012549949,0.005342883,0.021158481,-0.0057157194,0.020958748,0.022276992,-0.02908126,0.0008705071,0.004743681,0.014580578,-0.007962726,0.004550605,-0.02929431,0.0026481391,0.0073036044,0.0025749034,-0.008934765,0.004407462,-0.010625846,0.01454063,0.0032906167,0.0019457415,0.024846902,-0.0067410204,-0.0068009407,-0.0045539336,-0.020093234,0.042876218,-0.03504665,0.013395489,-0.004617183,-0.0029294312,-0.018508678,0.019174458,0.032543316,-0.013402147,0.0018092566,-0.028255694,-0.01675102,-0.009021316,-0.03488686,-0.023595236,0.015752349,-0.011011998,0.02258325,0.013482041,-0.007676441,-0.0039680474,-0.0069307676,0.012862866,0.0013140829,-0.034034662,0.008009331,0.012296952,0.010286298,0.003551935,-0.0038016026,-0.015392829,-0.005542617,0.011751013,0.0132823065,0.03081229,-0.0058189156,0.010299614,-0.021078588,0.0019990038,-0.01272971,-0.017390167,0.0131358355,-0.004770312,-0.03491349,0.013488699,0.007130502,0.009720385,0.014727049,0.011198416,-0.0131291775,0.0049966774,0.017257012,0.025139844,0.0018758345,-0.0073036044,-0.009620518,-0.027043976,0.009014659,0.0019424126,0.004151137,-0.02155795,-0.012856208,0.022996034,-0.0014047953,-0.011657804,-0.023209084,-0.0013831576,-0.0065812333,-0.055286355,0.014926783,0.012030641,0.021171797,0.004237688,-0.0046271696,-0.00035348747,0.022157151,-0.0060918853,-0.015206411,0.00737684,0.032543316,-0.02926768,0.006461393,-0.0041777682,0.0013040962,-0.0028345576,0.012829577,-0.02838885,0.019360876,-0.022929456,0.004074572,-0.01808258,-0.01910788,-0.023741707,0.024261016,-0.013794958,-0.011298283,-0.012150481,0.0060885563,0.018482046,-0.0131225195,0.0017210408,0.018575257,-0.0029161156,-0.019241037,-0.009167788,-0.17320926,0.020292968,0.037523348,-0.035898846,0.016338237,0.0023452092,-0.0032157165,0.014261004,-0.011837564,0.023422133,0.020878855,0.005535959,-0.04002668,-0.008621848,0.015139832,0.031451438,0.0023368872,-0.0066744424,0.009081236,0.027323602,0.023302292,-0.010559267,0.012922786,-0.017004017,0.013295623,-0.0048302324,-0.017709743,0.014527315,-0.016498024,-0.00046479751,-0.008641821,0.018521994,0.016378183,-0.005632497,0.017922793,0.011717725,0.011424781,0.00019952588,-0.007543285,0.012529976,0.0023135848,0.009727043,0.026577929,-0.0013249018,-0.027017344,0.021265006,0.00095955515,0.01632492,0.020625858,-0.003065916,-0.0018092566,-0.013954745,0.008142487,0.0007394317,0.026790978,0.010306271,-0.00072819664,0.015752349,-0.0067909537,-0.00050890545,-0.021850893,-0.026884189,-0.013675117,-0.010925447,-0.0009329239,-0.027323602,0.009380837,-0.004943415,0.007243684,0.0058588623,-0.013342227,-0.033475406,0.026098568,-0.006284961,0.02548605,-0.0059554004,-0.0045539336,-0.015139832,0.00982691,-0.01384822,-0.002318578,0.038748384,-0.020932117,0.003328899,-0.0023535315,-0.0032090587,-0.0030159825,0.0065113264,-0.0058422177,-0.0022636512,0.028042644,-0.030759027,0.029107893,-0.024008019,0.025193108,0.003240683,0.007283631,0.011804276,-0.010033301,-0.010193089,0.0097869625,0.013914797,-0.016591232,-0.0027613216,0.021331584,0.009593887,-0.0067243758,0.001344043,0.027643178,-0.010599215,-0.0041045323,0.013328912,0.008821582,0.024420803,-0.002388485,0.021051956,-0.0025715744,-0.032942783,0.014806943,0.00082140585,0.013222387,-0.00067410205,-0.011990694,0.017976055,0.0038149182,-0.020852223,-0.045006715,0.003754998,0.021797631,0.009560598,-0.012004009,0.0108988155,-0.004633827,0.009014659,0.005146478,-0.0108988155,-0.017976055,-0.010632503,-0.003528633,-0.022396833,0.011977378,-0.008408799,0.0048635215,-0.013508672,-0.0029044643,0.016604548,0.0064048017,-0.007083897,0.013488699,-0.0056857592,-0.008648479,-0.012876181,-0.03667115,0.020852223,0.0057190484,0.028841581,0.029587254,0.018122526,0.0039314297,-0.008801609,-0.020359546,-0.0051830956,0.0009495684,-0.0063715125,0.017363537,-0.006571247,-0.010466059,0.008941422,-0.0012724716,-0.03981363,-0.007083897,-0.02300935,-0.021584582,0.0035219751,0.011504675,-0.032303635,-0.0024683785,-0.016245026,-0.0036284998,-0.013142494,-0.00020784813,-0.0060419515,0.0060219783,0.019880185,-0.0037350247,-0.009354206,0.00028503698,0.021731053,0.007736361,0.012383504,-0.0015579247,-0.002485023,-0.021331584,-0.030359559,0.026471404,0.0037450113,0.009061263,-0.003751669,-0.0028062619,0.0060053337,-0.024806956,-0.027190447,-0.043541998,-0.017683111,0.0039380873,-0.0045572626,-0.029454097,-0.015233042,0.005702404,0.0076498096,0.021384846,0.021597896,-0.012536634,-0.012756341,0.008728373,-0.015672456,-0.008209065,0.0034653838,-0.016964069,-0.022383517,-0.01877499,-0.0038848252,0.005755666,-0.015206411,0.009061263,0.015352882,-0.035472747,-0.023488712,-0.0920374,0.01956061,0.0026265013,0.005266318,-0.013215729,-0.002485023,0.02013318,0.010685766,-0.0024633852,-0.01889483,-0.007177106,-0.009707069,0.00049600593,0.0003214468,-0.015446091,-0.043089267,0.011957405,0.00816246,0.0059454134,0.0046970765,-0.015778981,0.012616527,0.011751013,0.012237033,-0.010818922,0.019201089,-0.02500669,0.021171797,-0.0025449432,-0.010998682,0.014047953,-0.014380843,-0.0048368904,0.058002736,-0.0033006032,-0.02065249,-0.010073248,0.019081248,-0.0031025338,-0.03195743,-0.023568604,-0.02769644,0.030039985,0.0110586025,-0.018921461,0.0134487515,-0.008002673,0.005642484,-0.0003010573,-0.012436766,0.004151137,0.023515342,-0.0061351606,0.008748346,-0.0032323608,-0.009580571,0.014860205,-0.022210414,0.0074633914,-0.015352882,0.012283637,0.013162467,0.0129760485,0.016458077,0.014513999,-0.008921449,-0.0040013366,-0.0047303652,0.0009495684,0.0023535315,-0.00852864,0.009081236,0.018841568,0.021810945,0.02790949,0.007809597,0.014167794,-0.0045006713,-0.036751043,0.035605904,0.0368842,0.027403496,-0.021664474,-0.012283637,0.019733714,-0.0014538966,-0.016338237,-0.010352876,0.015739035,0.02303598,-0.010093221,0.006551273,-0.004870179,0.0039247717,0.008135829,0.025858887,0.0074034715,-0.00402131,0.019720398,0.02615183,0.010366191,-0.0009578907,-0.009207735,0.0101598,0.006035294,-0.013701748,-0.023728391,-0.02391481,0.009287628,0.0055126566,0.009540624,0.02255662,0.003458726,0.022929456,-0.013555276,0.018761674,0.013415463,-0.017217066,-0.028468745,-0.004184426,-0.0010910466,0.021105219,0.008535297,-0.011571253,0.006684429,0.03933427,-0.004870179,0.009900145,0.0057190484,-0.011711067,-0.006521313,-0.0034520682,-0.0018059277,-0.0013756675,-0.00034100408,0.0096271755,0.009560598,0.011318256,-0.00006642194,0.05408795,0.028308956,0.005732364,0.018002685,-0.0055559324,0.028175801,0.02153132,0.01980029,-0.028894844,-0.03573906,0.0077629923,0.006324908,0.0040446124,-0.005762324,-0.031105231,-0.019121196,-0.008388826,-0.0079827,0.0030392848,-0.0050000064,0.007523312,-0.016857544,0.021904156,0.0020389506,-0.01998671,-0.02336887,-0.004916784,0.015406145,-0.0043242397,-0.0121704545,0.007849543,0.0038781674,-0.03826902,0.00022636513,0.0071238438,-0.011478043,-0.021105219,-0.0012208737,0.00041964932,-0.008402141,-0.0018342233,0.01732359,-0.029134523,-0.028548637,0.012656474,-0.008215723,-0.008748346,0.0051564644,-0.012476713]');
INSERT INTO ROOMS(hotelName,roomName,embedding) values('Mallorca Rocks','Urban Escape Penthouse','[-0.0032153244,-0.0031483385,0.0055363867,-0.026660398,-0.0029339835,0.022574257,-0.016411552,-0.00590146,-0.008768458,-0.017912036,0.01075794,0.009538796,-0.014696712,-0.010905309,-0.0022239326,-0.0138660865,0.019010605,-0.03065276,0.0038048006,-0.005111026,-0.011997179,-0.015031641,0.008915827,-0.023565648,0.0009294297,-0.012995269,0.006939742,-0.017577106,-0.009156976,0.00035670004,0.02146229,-0.020095777,-0.0036172399,-0.028991507,-0.019104386,0.0005936627,0.0038282457,0.0008038311,0.014401974,0.0077837645,0.0027665186,-0.00766319,-0.0043038456,-0.007837353,-0.004749302,-0.0014887622,0.008654581,-0.010818227,-0.02869677,0.000781642,-0.0090765925,0.019600082,-0.015688103,-0.023378087,0.00005934534,-0.012968475,-0.023230718,0.019573286,0.026767576,-0.016049828,0.0067689274,-0.033198223,-0.032153245,0.006209595,-0.0094785085,0.0045215497,-0.012425889,-0.0017215383,0.006671798,-0.015567529,0.030491993,0.026070923,0.00090347265,-0.00532873,0.014093839,-0.014629726,0.003374416,0.011662249,0.02612451,0.0009336163,0.019626876,-0.012312013,-0.020403912,0.01132732,0.021730233,0.02075224,-0.012727326,0.043889176,-0.00074145047,-0.00264092,-0.014160824,0.010222052,-0.00024345197,0.0130756525,-0.03226042,0.010027793,-0.010429708,-0.014549343,0.00023047345,-0.006015336,0.020189557,0.0033576696,-0.037806857,-0.009438316,-0.030706348,-0.023364691,0.0077368743,-0.018340746,0.011367511,0.027705379,-0.008929224,0.019064194,0.023136938,-0.033332195,0.032447983,-0.007622998,0.013115844,0.0026878102,-0.022534065,-0.0025588623,0.008580897,0.010054587,0.027022121,-0.001446896,0.008688075,0.009264153,-0.014026852,-0.032340806,-0.0095187,0.007294767,-0.0051947585,0.0022976173,0.036440343,-0.007837353,-0.0124593815,0.015621117,-0.005278491,0.0152593935,-0.020256544,-0.034243204,0.022212533,0.02517331,-0.0050138966,0.0004542483,0.028937919,-0.0071473983,-0.010489996,0.0032421187,0.0030344625,-0.004555043,0.013933072,-0.035958044,0.0146699175,0.018863237,0.004655522,0.01313594,-0.013531157,0.01751012,-0.014602931,-0.0042268117,0.012104357,0.004411023,0.013316802,-0.009739754,0.029179068,0.0228422,0.017188588,0.016170403,-0.01203737,-0.0030210651,-0.0029925962,0.014482357,-0.037378147,0.016826864,0.017818255,0.02503934,-0.0069464403,0.013490966,-0.007100508,-0.0045751384,-0.0038684371,-0.002217234,0.01756371,0.01594265,0.00013062255,-0.004260305,0.0148708755,-0.006464142,0.006480888,-0.013691923,0.0014812263,0.016907247,0.0044713104,-0.011628756,-0.66921616,-0.009920616,-0.0006485075,-0.013444075,0.009927314,0.02360584,0.024141727,0.030625965,-0.009773246,-0.027571406,0.007964626,-0.00604548,0.0021770427,0.012023973,-0.017135,-0.019814437,-0.017402943,-0.006799071,0.018193377,-0.013645032,-0.014375179,0.016384756,-0.010550283,-0.011394306,0.02355225,0.012439286,0.016210593,-0.0059215557,-0.017912036,0.01746993,-0.0065311277,0.055089224,-0.0032538413,-0.018528307,0.053133234,-0.015085231,-0.0122718215,0.016907247,0.013758909,0.044773392,-0.006444046,0.0024047948,0.008453623,0.0068426123,-0.0008984487,0.008634485,0.058358137,-0.020403912,0.009974204,-0.013042159,0.015621117,0.0075828065,-0.010824925,0.03459153,0.0060421303,0.0004969518,0.021502482,-0.012586655,0.008862237,-0.020899609,0.0060756234,0.0005714737,-0.0214221,-0.0275982,-0.018153185,0.014000058,-0.011106267,-0.0010290713,-0.030920703,-0.017858448,-0.0025220201,0.0071406993,-0.01746993,0.019171372,0.026620205,-0.0073215617,0.02968816,-0.023954166,-0.016545523,0.015808677,-0.0023160384,-0.008989511,-0.030947497,-0.00065813673,0.007475629,-0.022574257,-0.034430765,-0.003392837,0.030304432,-0.004930164,0.00038328508,0.00067237124,0.0008029938,0.00456844,-0.026901547,0.0021854157,-0.0062899785,0.033385783,0.014763698,-0.03459153,0.0062263417,-0.028294854,0.006239739,0.0014276375,0.013484267,-0.0075024236,0.0054258597,-0.004102888,0.04177242,-0.005445956,0.0040225047,-0.020470899,-0.012546464,-0.0075292177,0.007911038,-0.023565648,0.029473806,-0.0096660685,0.006986632,-0.02845562,0.006872756,-0.0126603395,0.0032722624,-0.015956048,0.013758909,0.028375238,0.0124660805,-0.03435038,-0.014616328,-0.014120633,0.017965624,0.00039354232,0.031001085,0.0006137585,0.023471868,0.0069263447,0.007134001,-0.021167552,0.01646514,-0.010791432,-0.04083462,-0.012084261,-0.0104765985,-0.003888533,0.0047794455,-0.03893222,-0.000629249,-0.009759849,-0.01717519,0.0012057467,-0.030009694,0.0046421248,-0.015661309,0.010128272,-0.00027506094,-0.013839292,0.016317772,-0.028643182,-0.025119722,-0.015393365,0.018662278,-0.0004050555,-0.018246965,0.004478009,-0.008741663,0.0038483413,0.01232541,0.021690043,-0.004869877,-0.029661367,-0.0007833167,0.001746658,0.0025789582,0.011762728,0.0006543688,-0.0019543143,-0.01489767,-0.032769512,-0.007609601,0.004896671,0.013959867,0.018501513,-0.024302494,0.0014611305,-0.010818227,0.00918377,0.009337838,0.029661367,-0.012914886,-0.011347416,-0.011126362,0.02008238,-0.0038282457,0.022788612,0.003821547,0.017965624,0.037806857,0.014911067,-0.010409612,0.014549343,0.0058076796,-0.010034491,0.010536886,-0.03335899,0.042549457,-0.025735993,0.003788054,-0.0069598374,0.038610686,0.009290948,0.017081412,-0.024423068,-0.02789294,0.0061761024,0.0028251314,0.015446954,-0.0126670385,0.032447983,-0.0112603335,-0.024811586,0.013584745,-0.018876633,0.017871846,0.011742633,-0.030063283,0.0047359047,0.019667067,0.022333108,0.020176161,-0.017550312,-0.01879625,0.027089108,0.013578047,-0.005214854,0.005211505,-0.0035536033,0.012700532,-0.018970413,-0.0128479,-0.013008666,0.026513029,0.025588622,0.012734024,-0.012553162,0.0059215557,0.006323471,0.036011633,0.01827376,-0.021609658,0.00057691627,-0.0076363953,-0.0067655784,-0.0051378203,0.015768487,0.0075828065,-0.0029557538,-0.0002962034,0.0030344625,0.022641242,0.010543585,-0.0046856655,-0.015902458,0.017590504,0.0067923726,0.018059405,-0.007897641,-0.0057808855,-0.0124727795,-0.0004797867,-0.0018404382,0.0016453417,-0.021529276,-0.0033961863,0.0136718275,-0.010503393,0.006648353,-0.012941681,-0.023110144,0.019090988,-0.006350266,-0.021140758,-0.0074153417,0.018930223,0.03445756,-0.0056569614,-0.016639303,-0.021609658,-0.0049033696,-0.000052594416,0.03065276,0.007622998,0.01413403,-0.0023880482,-0.010925405,-0.013504363,-0.020738842,0.0049536093,-0.025159914,0.0014259629,-0.012023973,0.010550283,-0.01603643,-0.011501484,0.009244057,0.012968475,0.024757998,-0.002622499,-0.021971384,-0.012097658,-0.028509209,-0.017871846,0.0006878617,-0.009036401,0.02746423,-0.034859475,-0.015299585,-0.012097658,-0.017081412,0.03622599,0.011032581,0.013571348,-0.018501513,-0.011628756,-0.0057272967,0.10583776,0.01680007,0.024088139,0.009853629,-0.0036507328,-0.010570379,-0.0109455,0.0040392512,-0.0053320797,-0.00021812292,-0.010255545,0.003774657,0.0024265652,-0.008011516,0.026633603,0.0027564708,0.01722878,-0.033305403,0.0076029026,-0.025320679,0.0030830272,-0.0020430707,-0.02603073,0.03451115,0.007971325,0.008018215,0.03059917,-0.00022775214,0.013290008,-0.004920116,0.0014762023,0.0039488203,0.0136718275,0.0038382935,-0.0055698794,-0.033519756,0.004491406,-0.00670864,0.036842257,0.00086830504,0.025012543,0.02308335,0.013718718,-0.016773276,0.0094718095,0.014093839,-0.017416341,0.028911125,0.0056938035,0.0061794515,0.030625965,0.0029289594,-0.008647882,0.0011345741,-0.0012936656,0.0003347203,0.044049945,-0.010543585,-0.017831653,-0.035529334,-0.00275982,-0.031670947,0.0030780032,-0.01746993,0.0020933102,-0.026526427,0.008554103,0.0019492904,-0.020310132,-0.015755089,0.011380909,-0.004896671,-0.0012727325,0.021730233,0.017684285,-0.008534007,0.014147427,-0.014482357,-0.0037411638,0.033037458,-0.008440226,0.002098334,0.01071105,-0.028375238,-0.008165584,0.0030729794,0.0152593935,-0.0323676,-0.0132766105,0.010952199,0.012171342,-0.016679496,0.019278549,0.012526368,-0.001837089,-0.010074683,-0.004146429,0.008962717,0.012559861,0.007495725,0.02108717,-0.029259453,-0.0010868466,-0.0085675,0.02688815,0.00223733,0.0010315833,0.01232541,-0.01817998,0.009311044,0.010999089,-0.008158886,-0.028107293,-0.012834503,-0.015768487,0.008386638,-0.013042159,-0.01051679,-0.008393336,-0.008460322,-0.018166583,-0.029902516,0.00908999,0.020109175,-0.0060521783,-0.0088823335,0.0051947585,-0.0032756117,0.007917737,0.012740723,-0.014428768,0.015098628,-0.003493316,-0.0021619706,-0.016049828,-0.0051411698,-0.007844051,-0.023833591,0.012064165,-0.011287129,-0.03603843,0.012988571,-0.028000116,0.019935012,-0.02968816,-0.01726897,-0.012948379,0.023257513,-0.023713017,0.014401974,-0.008312954,0.0010190234,-0.0011546699,0.014911067,-0.021623056,-0.045711193,0.00022838013,-0.031992476,0.0132699115,0.01746993,0.023069952,0.036815464,0.024061345,-0.0030964243,0.017711079,0.006554573,-0.015192407,-0.0049167667,-0.023873784,0.046729382,0.02207856,0.022252724,0.010938802,-0.0015884037,-0.026218291,0.03231401,0.0006480888,0.0034330287,-0.00461533,-0.014214413,-0.019814437,-0.024262302,-0.030063283,-0.019774245,-0.011528278,-0.016197197,0.02108717,0.0041397302,-0.0053488263,-0.0037009723,0.016210593,-0.040915,0.018206773,-0.014884273,0.0008532332,0.017188588,0.00014098444,-0.004411023,-0.016625907,0.0066784965,-0.0046890145,-0.0015406762,-0.005204806,-0.008011516,0.012432587,0.03820877,0.0068024206,-0.024463259,0.015688103,-0.00014642705,-0.018380938,-0.018555101,-0.01661251,-0.039843228,0.010128272,0.0033007315,0.009103387,0.034993447,-0.014602931,-0.0038985808,-0.012934982,-0.00775697,0.013377089,0.020484295,0.012218232,0.016987631,-0.005023944,-0.00031881113,0.0072545754,-0.005824426,-0.01089861,0.018099597,0.026620205,-0.0038717864,-0.009826835,-0.007890942,0.005097629,0.002583982,-0.0060521783,0.037324555,0.010342627,0.027919734,-0.004246908,0.0030378117,-0.0032739372,0.017001027,-0.011668948,0.0018303904,-0.0204575,0.012506272,-0.028482415,0.030170461,-0.025012543,0.013785703,0.012499574,-0.024141727,0.019667067,-0.017912036,-0.018166583,0.0042000175,-0.004565091,0.030867115,-0.0049167667,-0.0039387722,0.02455704,0.0094785085,-0.01251967,0.012358903,0.010556982,0.024396274,-0.0056703584,-0.015406762,0.030867115,-0.0084670205,0.032019272,-0.008594294,-0.013531157,-0.023579046,-0.0019593383,-0.0130689535,-0.020926403,0.006685195,-0.011079472,-0.008761759,-0.01860869,-0.021837411,-0.004886623,-0.0058880625,0.0031583863,-0.0065612714,0.008808649,-0.029875722,-0.019278549,-0.002602403,-0.010021094,0.0063301697,0.011246936,0.023766605,-0.026057525,0.0006962349,0.0128612975,0.024932161,-0.016974233,0.016599111,0.0032622146,-0.0022657989,0.011856508,-0.019439315,-0.00571055,-0.01042301,-0.019573286,-0.0076363953,-0.009438316,-0.0009989276,0.018046008,-0.00014203109,0.008299556,-0.01232541,-0.0118699055,0.020269942,0.0044847075,0.008219173,0.006162705,-0.00043038456,0.020296736,0.020109175,0.006162705,0.010978993,-0.037270967,-0.0014820636,0.008554103,0.0067923726,-0.0075024236,-0.04640785,-0.025655609,-0.007978024,-0.010429708,0.025963744,0.016063225,0.012934982,0.014160824,0.011233539,0.0014234509,-0.0015172312,-0.010556982,-0.02146229,-0.037699677,-0.021046977,-0.015862267,-0.032474775,-0.0069330432,0.02431589,0.011106267,-0.037297763,0.002379675,0.009290948,-0.036145605,-0.005074184,-0.005097629,0.013223021,0.038530305,-0.005744043,-0.0038751357,0.003788054,0.024449863,0.0007632209,0.0013522784,-0.0045851865,0.015889062,-0.031001085,0.004149778,-0.0073215617,-0.018916825,-0.0073885475,0.007944531,0.0271293,-0.003278961,0.0038818342,-0.0046890145,0.018823044,0.03477909,0.009364632,0.0134641705,0.016746482,0.02036372,-0.031724535,0.005449305,0.019399123,0.00675888,-0.0017650791,-0.0061894995,0.005023944,-0.0077368743,-0.001475365,0.0057172487,-0.015647912,0.008018215,-0.017791461,0.005077533,-0.009465111,-0.0026710636,0.0011454594,0.018568499,-0.030250844,-0.015567529,0.0077703674,-0.018555101,-0.021891,0.020095777,-0.012566559,0.0023629286,-0.021636454,0.007991421,-0.016585715,0.006728736,0.000030640826,0.009304345,0.0010014395,0.013618238,0.041531272,-0.0053856685,0.00866128,-0.037619296,-0.004307195,-0.007194288,-0.00057691627,0.011019184,-0.03065276,-0.008721568,-0.004260305,-0.012727326,-0.024811586,0.0116756465,0.006772277,0.0138660865,0.02636566,0.23214641,0.0020313482,0.0040225047,0.029661367,0.019305343,0.03496665,0.0061928486,-0.0012878045,-0.0019693861,0.016103417,-0.02118095,0.0017684284,0.015286188,0.00031190322,-0.0071273022,-0.014884273,-0.037110202,-0.020135969,-0.01827376,-0.0076162997,0.007622998,0.0074019446,0.0052985866,-0.003878485,0.012345506,-0.007562711,-0.0124727795,-0.0015289537,0.011521579,0.024476657,0.00031211253,-0.020470899,0.024677614,0.012914886,0.025066134,0.010309134,0.03593125,-0.010208655,0.03646714,0.0024433115,-0.012512971,0.0034330287,-0.020899609,0.010577077,-0.0058177277,-0.003911978,-0.027383845,0.0018220171,0.033626933,-0.005596674,-0.032528363,-0.007522519,0.01517901,0.011689044,0.004374181,0.0059215557,0.02826806,0.015045038,-0.0045282487,0.0008331374,-0.012452683,0.033064254,-0.028107293,0.0074019446,-0.0052985866,0.0059416513,0.010148368,0.0018220171,0.023485266,-0.004287099,-0.0028904427,-0.00523495,-0.013772306,0.01203737,-0.023029761,-0.028669976,0.011956988,-0.006464142,0.02992931,0.018756058,0.008982812,-0.004169874,-0.0053756204,0.008942621,0.009290948,-0.04370162,0.017617298,0.012312013,-0.02412833,-0.01394647,0.0007431251,-0.02612451,0.002436613,-0.0018136438,0.022091959,0.021609658,-0.004588536,0.020015394,-0.013162734,0.007134001,-0.020618267,-0.001775127,0.021743631,-0.009009607,-0.038557097,0.003250492,0.0043038456,0.011561771,0.009893821,0.00092356844,0.003103123,-0.010322531,-0.010637364,-0.0005739856,0.013022063,0.01789864,0.0050674854,-0.032394394,0.0036038428,-0.016317772,-0.0005392367,-0.025200104,0.000843604,0.003263889,0.01542016,0.0026945088,-0.017148396,-0.002707906,0.009491906,-0.051070068,0.018019214,0.0134708695,0.020095777,-0.004159826,-0.008460322,0.014750301,0.014750301,-0.033278607,0.016733084,0.013249815,0.007067015,-0.0031299174,0.015540735,0.004005758,-0.026017332,-0.02084602,0.02351206,-0.00842013,-0.0029574286,-0.016023032,-0.0033911625,-0.016532127,-0.0055129416,-0.016920645,0.018260363,-0.0299829,-0.021100566,-0.022386696,-0.010409612,0.009766548,-0.033332195,0.0137991,0.025883362,-0.007643094,-0.018756058,0.0077301757,-0.1737347,0.023217322,0.02707571,-0.026097717,0.0055263387,0.008587595,-0.00551964,0.0023880482,-0.022614447,0.013095749,-0.0056167697,-0.019827833,-0.056268178,-0.0045182006,0.006594764,0.023672827,-0.0024717806,-0.0020430707,0.011179951,-0.012760819,0.033332195,-0.025226898,0.012385697,0.0092842495,0.004411023,-0.0015708199,-0.012606751,0.0050607864,0.0023964215,-0.011789523,-0.0013924699,-0.0055162907,0.039843228,0.015286188,0.004863178,0.0035234597,0.011581866,0.032769512,-0.0071072066,0.010496695,0.005677057,-0.0008909128,-0.004565091,0.006095719,0.0043138936,0.016317772,0.009485207,0.028723564,0.0027062313,0.027022121,-0.0021770427,-0.016344566,0.013142638,-0.0036306372,0.028134089,0.0154603515,0.014334988,0.012747422,0.027196284,-0.00059156946,-0.038396332,-0.018769456,0.031349413,-0.0050708344,-0.0021904397,-0.02355225,0.005904809,0.010201956,-0.005600023,0.019211562,-0.009297647,-0.006544525,0.012767517,-0.007689984,0.015138819,0.0039856625,-0.013852689,0.0062564854,0.0028385285,0.005677057,-0.011441196,0.030170461,-0.026191497,-0.010697653,-0.008748362,0.005087581,-0.0051612654,-0.0010600523,-0.0071875895,0.005301936,0.014080442,-0.021261333,-0.020042188,-0.00302274,0.024047947,0.015393365,0.004273702,0.021435495,-0.0051713134,-0.026097717,-0.012693833,-0.0054760994,-0.016009636,0.007348356,0.03207286,0.0031248934,-0.00302274,0.015138819,0.026513029,-0.012144548,-0.0042937975,0.0042569553,-0.0031232187,0.012392396,-0.0029992948,-0.009190469,0.015031641,-0.010791432,0.017644092,-0.00090933393,0.016076623,0.009980903,-0.024865175,0.023565648,0.00604548,-0.015406762,-0.061841406,-0.015781883,0.012224931,0.009264153,-0.012834503,0.008172283,-0.010322531,0.015353174,0.0056837555,0.0010508416,0.000782898,-0.0034430765,0.021140758,-0.003788054,0.051766723,-0.023404881,0.020618267,-0.011347416,-0.02207856,0.009806739,-0.009552193,0.0043440373,0.0062564854,-0.00085407053,-0.011762728,-0.001682184,-0.013772306,0.005315333,0.010128272,-0.010744542,0.0062363897,-0.0013598143,0.01780486,-0.005814378,0.0039186766,-0.0051813615,-0.0036172399,-0.016317772,0.025709197,-0.045791578,0.0040091076,0.0056301667,-0.001555748,-0.02649963,-0.023190526,0.0050708344,-0.01860869,0.014710109,0.014160824,-0.022400092,-0.019868026,-0.01799242,-0.018447924,-0.024007754,0.017068014,-0.0146699175,0.013698622,0.008333049,0.006822516,0.0075158207,0.012178041,-0.0011412727,-0.005151218,0.010503393,0.0018203425,-0.0114211,-0.026432646,-0.011454593,0.022828802,-0.0118699055,-0.009645973,0.0005865455,0.0017500073,0.010912007,-0.029018302,-0.021824013,-0.0021669946,-0.010289038,0.007067015,-0.0052952375,-0.017483326,-0.036949437,0.004323941,0.0022758467,0.020296736,0.007522519,0.011514881,-0.011320621,0.01832735,-0.029714957,-0.004059347,-0.009980903,0.0037411638,-0.030867115,0.010496695,-0.005955049,0.00495026,-0.01937233,-0.007348356,0.035341773,-0.040298734,-0.016572317,-0.09538796,0.014978053,0.012231629,0.008158886,-0.012894791,-0.018729264,-0.02002879,-0.010932103,-0.014388576,-0.017764667,-0.01394647,0.0035301582,0.032019272,-0.011836413,-0.0066081616,-0.00404595,-0.0050708344,0.005358874,0.003046185,-0.0053890175,-0.015996238,0.0059885415,-0.006514381,-0.019412521,-0.013296706,-0.0074153417,-0.018715868,-0.0021050326,-0.01361154,-0.002659341,0.005834474,-0.037110202,-0.0096794665,0.049462408,0.0048095896,-0.025146516,-0.001741634,0.014281399,0.0058880625,-0.036386754,-0.01613021,-0.021381907,-0.009170373,-0.0021720186,-0.012814407,0.014428768,0.018742662,0.019533096,0.017295765,0.009893821,0.012224931,0.03563651,-0.025454652,0.008547404,-0.014388576,-0.021207744,-0.004678967,0.018300554,0.0013413931,-0.0038416428,0.02789294,0.011796221,0.0092775505,0.0025705849,0.014777095,-0.008641184,-0.01765749,0.004940212,0.0024198666,-0.0020681904,-0.0063804095,-0.007844051,0.009793342,0.028053705,0.0011906748,0.0043674824,0.016679496,0.009424919,-0.016719686,0.032823104,0.017309163,0.0146699175,-0.021140758,0.0043373387,0.0077703674,-0.01846132,-0.010342627,0.0061225137,0.011240238,0.025521638,-0.002684461,0.004588536,0.0046320767,-0.00780386,-0.02355225,0.0016445045,0.010637364,0.012814407,0.00007441718,0.02398096,-0.0015071833,0.0002008531,-0.0052416488,-0.030706348,-0.0114211,0.010195258,-0.019693863,-0.033948466,-0.0029004905,0.003955519,0.019667067,0.0023813497,-0.00006944557,0.017121602,-0.0072545754,-0.00026145444,0.005733995,-0.022373298,-0.026593411,0.007622998,-0.0014887622,0.033707317,0.00061668915,-0.016157005,0.023337897,0.01603643,-0.005754091,0.008111996,0.01361154,-0.023324499,-0.004273702,-0.02936663,-0.013879484,-0.01413403,-0.020913005,0.0032203484,-0.005878015,0.013196227,-0.011347416,0.07534577,0.025990538,-0.019171372,-0.0055263387,-0.004246908,0.011193348,0.008031612,0.012633545,-0.01037612,-0.043326497,0.024101535,-0.00437753,0.006477539,-0.012921585,-0.02002879,-0.018715868,-0.010175162,0.01613021,-0.0146699175,0.009967506,0.008741663,0.0138660865,0.0027347005,-0.005258395,-0.031992476,-0.0026945088,0.020591473,0.017242176,-0.008862237,-0.0066416543,-0.01361154,-0.008507213,-0.010570379,-0.010771337,0.019948408,-0.01456274,-0.003126568,0.00021006368,0.00732826,-0.0011513205,-0.0080852015,0.030384814,-0.011722537,-0.027651789,0.0110727735,-0.02103358,-0.017550312,-0.01717519,-0.043889176]');
INSERT INTO ROOMS(hotelName,roomName,embedding) values('Mallorca Rocks','Royal Executive Suite','[-0.00024350086,-0.008863842,-0.015439393,-0.028827215,-0.027327988,0.0068122707,-0.008508762,-0.009889629,-0.0030987284,0.01576817,-0.007857783,0.0067267884,-0.0053492105,-0.015689265,-0.018884981,-0.004622612,0.0095477,-0.021317936,0.022909218,0.007857783,0.012151618,-0.020147488,-0.004800152,-0.014965953,0.01599174,-0.031325925,-0.012776295,-0.009672635,0.009047958,-0.008101079,0.009942233,-0.0090742605,0.0049842675,-0.021817677,-0.011191587,-0.003353531,-0.0046785045,0.002912969,0.0031546205,-0.0063519822,0.011494063,0.016688747,-0.0082720425,0.014939651,-0.024513653,0.006158003,0.0030773578,-0.015268429,-0.009955384,0.00817341,0.0082720425,0.016767655,-0.015018558,-0.030983996,-0.005050023,0.007127897,-0.043766867,0.0011367484,0.0059377225,-0.0037382005,0.018937586,-0.020371057,-0.020857647,0.00041199935,-0.008318072,0.0024066516,-0.015071162,0.01717534,-0.010192104,-0.006246773,0.03269364,-0.00016428603,-0.0067596664,0.00021349991,0.021291634,-0.019634595,0.00017558776,0.008725756,0.006072521,-0.019660898,0.013769203,-0.007331739,-0.028011845,-0.020581475,0.02340896,0.026657283,-0.01658354,0.03411396,-0.012789446,-0.007686819,0.0197135,0.022475233,-0.013979621,0.0051453686,-0.0501057,0.0064769173,0.003938755,0.017938102,0.01705698,-0.018043311,0.012486971,0.0018312909,-0.039611116,-0.009712089,-0.039242886,-0.016912317,-0.015597207,-0.016886014,0.00638486,0.005184822,-0.02469777,0.0185036,0.023553623,-0.02457941,0.0050697494,-0.014387305,0.02816966,-0.017819742,-0.012434366,-0.01838524,0.007857783,0.010948292,0.03056316,-0.028958725,0.0071476237,-0.0008034501,-0.0043497267,-0.038138196,0.010238132,0.0274595,0.026407411,-0.017977556,0.021304784,-0.0019940357,-0.024329538,-0.0013405904,-0.010836508,0.023474716,0.0034521641,-0.032167595,0.02041051,0.015321033,-0.017254245,-0.007831481,0.0011104462,0.011428307,0.009278102,0.014492514,0.031457435,-0.029931907,0.012861777,-0.01766193,0.028564192,0.0064308885,0.014400456,0.00009493451,-0.0076013366,0.030116022,-0.03390354,-0.013585088,-0.010494579,0.023606228,-0.004928375,0.014808141,0.027617313,0.013328642,0.009534549,0.036323342,-0.0030790016,0.014637176,-0.010849658,0.0069766594,-0.03390354,0.0068582995,0.012960411,0.036612667,-0.014282096,-0.03161525,0.0060856724,0.0026992636,-0.01563666,0.009981686,0.028485285,0.022343721,-0.006864875,0.009389887,0.0172937,0.004113007,0.03390354,-0.026170691,0.018082764,0.03303557,0.012796022,-0.017438361,-0.66996974,-0.01885868,-0.0057568946,-0.0063749966,0.015847078,0.012999864,0.014466212,0.03414026,-0.003511344,-0.036375947,-0.0012320938,-0.013177404,0.012605331,-0.012940684,-0.015899682,-0.020200092,-0.006572263,0.010711572,-0.012493546,0.0003335037,-0.011632149,0.022764556,-0.007233106,-0.0023507595,0.024316387,-0.015820775,-0.0016701899,0.008620547,-0.012815748,0.019752955,0.013460153,0.033351194,0.004760699,0.008258892,0.048869494,0.003600114,-0.033482704,0.011487487,0.0052900305,0.0417679,-0.023330053,0.012302855,0.010553759,-0.00012914793,-0.0047245333,0.0033732576,0.009823873,-0.011217889,-0.002386925,-0.006996386,0.0050829006,-0.015978588,-0.01265136,0.028458985,0.008429856,-0.0010414028,0.026091786,-0.019792408,-0.009574002,-0.016399425,0.010698421,-0.0161101,-0.010560335,-0.028511588,0.010435399,0.019279515,-0.009153167,0.006891177,-0.01887183,-0.021317936,-0.001989104,0.015439393,0.0036954596,0.010172377,0.008791511,0.01074445,0.03214129,-0.007824905,-0.0147949895,-0.00611855,-0.0058588157,-0.0076605165,-0.024382142,0.022370024,0.007233106,-0.025776159,-0.042556964,-0.005460995,0.018806076,-0.008686302,0.012914382,0.0092518,0.0000074745517,0.004609461,0.0067793927,0.012993288,0.00045782272,0.026446866,0.030116022,-0.032036085,-0.0014457993,-0.007009537,-0.011743934,0.0062270467,0.0012353816,0.0011926405,-0.02017379,0.006062658,0.04726506,-0.0009501671,-0.0017145749,0.0114743365,0.01015265,-0.010514306,-0.011651876,-0.026933456,0.014295247,0.006411162,-0.01922691,-0.008600821,0.02112067,-0.004481238,0.019621443,-0.029879302,0.017530419,0.021541504,0.004711382,-0.014847593,0.002605562,-0.00021185602,0.019858163,-0.008199712,0.04729136,-0.0053393473,0.011099529,-0.0034488763,0.02972149,-0.025565742,0.007279135,-0.011060077,-0.013769203,-0.013769203,-0.0073646167,0.0056385347,0.005165095,-0.027669918,-0.0075158547,-0.00004679943,-0.031247018,-0.013558785,-0.035271253,0.009909355,-0.016452027,0.01588653,0.030194929,-0.009422764,-0.008206287,-0.011875445,-0.023185393,-0.008304921,0.019161155,-0.00071098143,-0.052972637,0.0024954216,-0.009468793,-0.001903622,0.007956416,0.023658833,0.001844442,-0.028143357,0.010724723,0.010369644,0.016741352,0.0153473355,0.0054807216,-0.011388854,-0.0060955356,-0.022988126,0.013506182,0.00026466593,0.010836508,0.03356161,-0.023737738,-0.0052604405,0.033245984,0.027038665,0.0027025514,0.017569872,-0.018411541,-0.015242127,-0.015544602,0.014216341,-0.009948809,0.0012855201,0.01563666,0.005424829,-0.008798087,0.011908323,0.008909871,-0.0063717086,0.019253213,-0.005533326,0.004155748,-0.0074698254,0.030905088,-0.030694671,0.0064341766,-0.00043521926,0.039558515,-0.002092669,0.010290737,-0.023461565,-0.03164155,-0.0061744424,0.028669402,0.022422628,0.013210282,0.017359454,0.0035738118,-0.018898133,0.01993707,-0.0167019,0.0022603455,0.007726272,-0.013624541,-0.0051223543,0.006483493,0.018122219,0.027249083,0.0028505013,-0.018306334,0.0058062114,-0.015031709,-0.005931147,0.0014540186,0.017859196,-0.0015173083,-0.024013912,-0.0005252221,-0.01003429,-0.0027765264,0.015334184,0.024750372,-0.026473168,0.016530935,-0.0048363176,0.024316387,0.018003859,-0.0078117545,-0.012440942,-0.013979621,0.0022734967,0.005224275,0.02017379,0.023251148,0.02518436,0.0022488383,0.0013677146,0.009955384,0.02496079,-0.010297312,0.008679727,0.0119412,-0.015965438,0.003833546,-0.02434269,0.0026367959,-0.007187077,0.024382142,-0.0026006303,0.022711953,0.0015896393,0.013322066,0.010139499,-0.019397875,-0.00057084,-0.003294351,-0.014637176,0.0009912642,0.008311496,0.014150585,-0.021633562,0.029589979,0.0058160746,-0.00073563977,-0.031141808,-0.01863511,-0.00620732,-0.0034653153,0.05460337,0.011303372,0.015097464,-0.023790343,0.00028932423,-0.01885868,-0.034298074,0.0068582995,-0.026762491,0.021225877,-0.008692878,0.0032746242,-0.011125832,-0.012756568,-0.010356492,0.025210662,0.0048626196,-0.033377495,-0.008745482,0.0019233486,-0.01343385,-0.0052045486,-0.0071213213,-0.00979757,0.0028159795,0.0030921528,0.010665543,-0.029458467,-0.016189005,0.026460016,0.0064341766,-0.010323615,-0.018911283,-0.0033190092,0.003777654,0.10878591,0.017859196,-0.0037118983,0.015202673,-0.009067684,-0.018648261,-0.019424178,-0.035113443,-0.008771785,-0.008515338,-0.018030161,0.030431649,0.011783387,0.0049711163,0.017688232,0.0077525745,0.021068064,-0.036428552,0.016267912,-0.0007327629,-0.012730266,0.008929598,-0.019963372,0.040663205,0.0040505393,-0.0039288914,0.022882916,0.015610358,-0.014808141,-0.03366682,0.015728718,0.022698801,-0.008245741,0.015242127,0.0039420426,-0.009159742,-0.003016534,-0.00087701407,0.018003859,-0.008245741,0.029326957,0.01647833,0.011743934,-0.004931663,0.014729233,-0.00573388,-0.020752437,0.009468793,0.003059275,0.00076029805,0.008127381,0.017648779,0.004126158,-0.0035639484,0.003059275,0.0059837513,-0.0045174034,-0.011980654,0.009435915,-0.02293552,-0.020002825,-0.021567807,0.009883053,-0.008771785,-0.034666304,-0.008574518,-0.0074632503,0.0012452449,-0.022790859,-0.012322582,0.016741352,0.0028735157,-0.017504117,0.016031193,0.024198027,0.0027847458,0.015978588,-0.022159606,0.007160775,0.018450996,-0.0025562453,-0.006792544,-0.035507973,-0.010928566,-0.020489417,0.00043809606,0.008837541,-0.010080319,-0.0098107215,0.0072265305,0.010106621,-0.0114085805,0.017635627,-0.014742385,0.0051157787,-0.007884085,-0.01910855,-0.0029935194,0.0005256331,0.009455642,0.016912317,-0.017924951,0.0031694155,-0.0023458276,0.024250632,-0.01217792,-0.0009871545,0.0022603455,-0.02147575,-0.005523463,0.008521914,-0.03187827,-0.025394777,-0.015728718,-0.020213243,-0.0020104747,-0.017714534,0.0013249735,0.009883053,-0.00083098526,0.0032466783,-0.026275901,0.014939651,-0.0037382005,-0.0020236257,0.0030280412,0.014965953,0.012513273,-0.0037677905,0.031457435,0.005987039,0.0032664048,-0.015491998,-0.0029770806,-0.013019591,-0.0232906,-0.018543053,0.0052144118,-0.0021584246,-0.023974458,-0.04021607,0.010468277,-0.011224465,0.0032844876,-0.005474146,-0.008515338,-0.008561367,0.0014063459,-0.023067033,0.01600489,-0.0075881854,0.0018510176,-0.02698606,0.010060593,-0.002151849,-0.020344755,-0.0028505013,-0.007785452,0.00010305121,0.004053827,0.026683586,0.0021600684,0.009455642,0.008429856,0.02340896,-0.006690623,0.0043990435,-0.014216341,-0.0038532726,0.030852484,0.010875961,0.013624541,0.0044878135,0.010632666,-0.014808141,0.023330053,0.00033494213,-0.016899165,-0.011618998,-0.019411026,0.0011359263,-0.0190954,-0.03161525,-0.021028612,-0.015202673,0.0016751216,0.02935326,0.011724207,0.0065689753,0.017451512,0.020555172,-0.028222265,0.029853001,-0.0345874,0.005046735,0.015307882,0.014531967,-0.0044976766,-0.0023754176,0.030247534,0.004070266,0.017385757,-0.004790289,0.012618482,0.023777192,0.03032644,-0.008390402,-0.002211029,0.0041524605,-0.021081217,-0.02711757,-0.0310366,0.013348368,-0.047002036,-0.008429856,-0.0031496887,-0.00039514952,0.031957176,-0.014347852,-0.013532483,0.01682026,-0.009140016,0.021054914,0.0070950193,0.00614814,0.009942233,-0.011316523,0.0002560355,-0.014019074,-0.014268945,-0.020265847,0.017109582,0.042451754,-0.02484243,-0.0026696736,0.0073843435,-0.0026006303,-0.002870228,-0.017609324,0.01862196,-0.007358041,0.001361139,0.00070029614,0.01635997,0.0036921718,0.044950467,-0.015123767,-0.01467663,-0.010645817,0.011711056,-0.015939135,0.012920957,-0.018832378,0.011513789,0.0034192863,-0.03248322,0.0035935384,-0.020699834,-0.018608809,-0.0061152624,-0.012138466,0.028511588,-0.024290085,-0.0043858923,0.015426242,0.009140016,-0.015807625,0.0047376845,0.018253729,0.019542538,-0.020278998,-0.025026547,0.03295666,0.005898269,0.010113197,-0.0054905848,-0.011592696,0.00072618737,-0.00060823845,-0.026473168,-0.011185012,-0.012848626,0.009179469,-0.0059706,-0.003629704,-0.006851724,0.007417221,-0.002927764,-0.011928049,-0.022291116,-0.00061399204,-0.025894519,0.012072711,0.0143610025,-0.0013767559,0.001405524,0.014019074,0.012085862,-0.008653425,0.007279135,0.0040472513,0.018911283,-0.0072528324,0.008548216,-0.0059541613,-0.005605657,0.020936554,-0.027038665,-0.0149791045,-0.0153473355,-0.0049448144,-0.010704997,0.0034061354,0.009830449,0.008929598,0.00775915,-0.00018966354,-0.0019200608,-0.038611636,0.0060232044,0.009350433,-0.010816781,0.0076802433,-0.00594101,-0.0053524985,0.046186667,0.006161291,-0.0013003151,-0.022343721,0.0016932043,-0.0026598102,0.02543423,0.0062040323,-0.027170176,-0.028248565,-0.010658968,-0.010869386,0.024263782,0.00053508545,0.0062928023,0.025486834,0.0018641687,0.017780289,0.015557753,-0.008896721,-0.013230008,-0.013269462,-0.0045864466,-0.022869766,-0.02542108,-0.023422113,0.012112165,0.0028751595,-0.030116022,-0.01622846,-0.00041467068,-0.054182537,0.023540473,-0.02376404,0.021462597,0.043424938,-0.0060527944,0.007358041,0.009107138,-0.002077874,0.0038729995,-0.015794473,-0.01612325,0.025697252,-0.03498193,-0.0021452734,-0.015728718,-0.021594109,0.023198543,0.020436812,0.005533326,0.003981496,-0.014150585,-0.0002679537,-0.011073227,0.0074895523,0.030905088,0.03521865,0.03435068,0.0070621413,-0.023198543,-0.008725756,0.023790343,0.0046061734,-0.02315909,0.010935141,0.008633698,-0.011231041,0.007838056,-0.008738907,0.015031709,0.019200608,0.0028324185,0.0057273046,-0.0058653913,-0.0004931663,-0.0035507975,0.013834959,-0.029221747,-0.005096052,0.00032713366,-0.023711435,-0.0322465,0.008482461,-0.024973942,-0.015136918,-0.027748825,0.000047647056,-0.0021929462,0.0051420806,0.0008449583,0.023671983,-0.008318072,0.0027535118,0.038637936,-0.020476265,-0.0064933565,-0.035060838,-0.011099529,-0.01766193,0.006378284,0.005927859,-0.009140016,-0.009409613,0.0010586637,-0.019568838,-0.021068064,-0.013479879,-0.005165095,0.011270494,0.02244893,0.21231139,0.013460153,-0.021659864,0.03427177,0.019923918,0.013992772,0.015491998,0.012874928,-0.017412059,0.0083377985,-0.027485803,0.0014762111,0.01838524,0.0025841915,-0.0023080183,-0.010205255,-0.023211693,-0.03592881,0.0006760488,-0.015584055,0.0065032197,0.0021337662,0.0053985273,-0.01612325,0.027959242,-0.0083377985,-0.038874656,0.00310366,0.009120289,0.043346033,0.007009537,0.012743417,0.01420319,0.03364052,-0.001990748,-0.0010175665,0.016517784,0.0045765834,0.014242643,0.007219955,-0.015820775,0.0080287475,-0.0104880035,-0.02292237,0.015899682,0.006046219,-0.02398761,0.019266363,0.0012657936,-0.0010816781,-0.027669918,0.008390402,-0.0048034396,0.018240578,0.022080699,0.012697388,0.024408445,0.024421595,-0.019174306,0.026249599,-0.016557237,0.031115506,-0.03140483,-0.022001794,0.022593593,0.012993288,-0.019371573,0.011257343,0.016031193,-0.01170448,-0.00078536733,-0.009225498,-0.023330053,-0.009435915,-0.02602603,-0.01658354,0.024513653,-0.008745482,0.029826699,0.013354944,0.00020949294,-0.0037513517,-0.0011572969,0.0062040323,0.0046028853,-0.041741595,0.013742901,0.024263782,0.00047385064,-0.005960737,-0.0021995218,-0.032167595,-0.01182284,0.0034488763,0.018358938,0.026512621,-0.020436812,0.005444556,-0.026433714,0.002298155,-0.03032644,0.02519751,0.014413607,-0.012033258,-0.020620927,0.0053656492,-0.0073974947,0.014808141,0.01983186,-0.003807244,-0.023685133,-0.011553243,0.009705513,0.0034916175,0.011448034,-0.0054281172,-0.0042083524,-0.038006682,-0.0031546205,0.0025841915,0.010658968,-0.015689265,0.0007372836,0.0161101,0.0013701804,0.00465549,-0.024171725,0.008607396,0.0052012606,-0.04789631,0.017346302,0.008370676,0.018424693,-0.011928049,-0.0015090889,-0.0044253455,0.015176371,0.0197135,-0.0001809304,0.0018427981,0.028090753,0.009758118,-0.0004187804,-0.0043957555,-0.0128289,0.0021485612,0.012789446,-0.03474521,-0.0011071584,-0.0025677525,-0.01563666,-0.038874656,0.0027863896,-0.039821535,0.025026547,-0.009001929,-0.013427274,-0.021515202,-0.0003628882,0.02327745,-0.024526805,-0.009146591,0.012980137,-0.03200978,-0.016504632,0.012184495,-0.16896535,0.015255278,0.008725756,-0.023961307,0.0073120124,0.0006965974,0.026065484,0.014992256,-0.028117055,0.007962992,0.002035133,0.0022439067,-0.06407217,-0.015597207,0.023474716,0.012756568,0.010665543,-0.0042806836,0.0063322554,-0.0063749966,0.012506697,-0.021081217,0.010323615,0.012138466,0.022001794,-0.015478847,-0.020042278,0.010836508,0.003820395,-0.016991222,-0.006664321,0.0061415643,0.02435584,0.006190881,-0.0005642644,0.006615004,-0.005197973,0.013341793,0.0055530528,0.0138086565,-0.013953319,0.018043311,0.004510828,-0.002003899,0.0042116405,0.022133304,0.0096266065,0.025092302,0.0131971305,0.008002445,0.0003626827,-0.038506426,0.01062609,-0.004780425,0.038874656,0.020239545,0.008364101,0.016886014,0.0056155203,-0.0026367959,-0.014610874,-0.030247534,-0.001595393,-0.017885499,0.009179469,-0.016609842,-0.0015164864,0.0172937,0.0017819742,0.019134853,-0.010770752,-0.00641445,-0.004787001,-0.017767139,0.022988126,0.0059673125,-0.008515338,0.0050335843,0.0051026274,-0.013953319,-0.0149791045,0.037217617,-0.004464799,-0.0155314505,0.0019496508,0.0040439637,-0.022435779,0.020962857,0.010481428,-0.0022471945,0.011415157,-0.02496079,-0.009705513,-0.008607396,0.013105073,0.012309431,0.014702932,0.021146972,-0.020752437,-0.003323941,0.006618292,0.006033068,-0.022948673,0.01265136,0.032877754,0.013716599,0.0042116405,0.008771785,0.020949705,-0.022540988,0.004491101,0.015071162,0.011625574,0.021922886,-0.011211314,0.015228976,-0.011697905,-0.013742901,0.023487868,0.001992392,0.022948673,0.01516322,-0.01766193,0.0025562453,0.0030395484,-0.005388664,-0.05739141,-0.01361139,-0.003629704,0.008226014,-0.0021880146,0.0020828056,-0.00228336,0.015491998,-0.0073251636,-0.008811238,-0.0025726843,-0.019174306,0.003978208,-0.0055201747,0.050184604,-0.006467054,0.0004639873,-0.025092302,0.010810206,0.027380593,0.0028652963,-0.0035606606,0.030747276,-0.022330571,0.0044746622,-0.012289705,-0.02339581,-0.0040209494,0.0044450723,0.013821808,0.030668369,0.0054412684,-0.010139499,0.005750319,-0.013927016,0.009245224,-0.0029540663,-0.006864875,0.017911801,-0.021199577,0.013466728,-0.0018608809,-0.006470342,-0.029984511,-0.032193895,0.023014428,-0.015123767,0.0053097573,0.021659864,-0.0048922095,-0.0062566367,-0.0034127107,-0.023356356,-0.010573486,0.005434693,0.011803114,0.021633562,0.005017145,-0.006309241,-0.012217374,0.022777708,0.023264298,-0.015452544,0.03997935,-0.01443991,-0.0025825475,-0.007805179,-0.0025989865,0.014992256,-0.0005059064,0.017267397,-0.020278998,-0.008265467,0.010553759,-0.03214129,0.0008449583,-0.026696736,-0.03303557,0.02411912,0.005661549,-0.016070645,-0.019634595,0.017846044,0.007305437,0.0208971,0.03269364,0.002589123,-0.004504252,-0.005957449,-0.015833925,-0.00081454637,0.00056631933,-0.013144526,-0.025592044,0.0028373501,-0.01575502,-0.008160259,-0.0062730755,0.012375186,0.0073711923,-0.045818437,-0.011329674,-0.09484574,0.0045075403,0.004402331,-0.0044253455,0.0001711698,-0.0023589788,0.0069043282,0.0013307271,-0.0041228705,-0.006753091,-0.026407411,0.014111132,0.015807625,0.005543189,-0.02411912,-0.009698938,0.016189005,-0.004612749,0.01587338,0.0017869059,0.001888827,0.0063914354,0.014887047,-0.023974458,-0.0017112871,-0.00022356873,-0.0011819552,0.00066495256,-0.022146454,-0.011138983,0.017504117,-0.026210146,-0.013585088,0.08179985,-0.008870418,-0.03963742,-0.009028231,0.0036625818,0.009416189,-0.02935326,-0.010284161,-0.030484254,0.0009090699,0.0016578607,0.009896204,0.03279885,0.012638208,0.006246773,-0.0071344725,-0.004007798,-0.026512621,0.019634595,-0.0006057726,0.010317039,-0.0025414503,-0.00022932234,0.012881504,0.0030674944,0.02029215,-0.022777708,0.014992256,0.0038466973,0.021778224,0.008002445,0.016031193,0.0013200418,-0.02076559,-0.0015937492,-0.0049809795,0.004609461,-0.024434747,0.0033864086,0.0061810175,-0.000058049784,0.0027995408,-0.003203937,0.03858533,-0.0011482555,-0.04847496,0.044398118,0.025855066,-0.028906122,-0.020594625,0.015294731,-0.003659294,-0.0018230715,-0.0076210634,-0.0072068037,-0.002296511,0.026104936,-0.0051124906,0.017714534,-0.01658354,0.00048700173,-0.006309241,0.0076473653,0.013821808,-0.0057766214,0.019489933,0.024776675,-0.017122734,0.010113197,-0.0024050076,0.0038729995,-0.02113382,-0.006910904,-0.0092518,-0.0110403495,0.02315909,-0.007279135,0.016452027,0.00829177,0.020962857,0.030773578,-0.011638725,0.01056691,-0.0009583865,-0.02578931,-0.039821535,0.0056286715,0.005460995,0.013558785,0.025105452,-0.018240578,-0.018911283,0.028564192,-0.009001929,0.0055004484,-0.00781833,0.0030280412,-0.01970035,-0.011125832,-0.0012255183,-0.005296606,-0.008535065,0.0042905468,-0.028458985,-0.0053820885,0.0012879861,0.05786485,0.0072857104,-0.017556721,0.010954867,-0.021344237,0.030905088,0.011803114,-0.00062426634,-0.019174306,-0.04631818,0.01910855,-0.00858767,0.012388337,-0.011513789,-0.006378284,-0.0012222305,-0.009534549,0.0064473273,0.0013668926,0.0027485802,0.01981871,-0.0005597438,0.009942233,-0.0031217427,-0.027564708,-0.006924055,0.0015205961,0.0055859303,-0.0073448904,0.00228336,0.013052468,-0.006335543,-0.034455884,-0.011020623,0.012901231,0.0014967597,-0.0009616743,-0.007785452,-0.015058011,0.020252697,-0.0015904614,0.00913344,-0.011500638,-0.029090237,0.0048922095,-0.022619894,-0.014400456,-0.0008449583,-0.023487868]');

/*Basic test query*/
/*For more documentation about pgvector and possible comparations , see https://github.com/pgvector/pgvector#docker*/

/*Searching by a room name: Ocean View Luxury*/
 SELECT   Id
          ,HotelName
         ,RoomName
         ,CreatedDate
         ,'Ocean View Luxury' SearchedRoomName
         ,embedding <=>
          '[0.0041769226,0.0067320974,0.006930199,-0.017070316,-0.0059833406,0.039271127,-0.030997867,-0.00406612,-0.00028351197,-0.003248531,-0.0017526958,0.014934848,-0.0087164715,-0.020857751,-0.0136858,-0.0008914573,0.017258344,-0.014249886,0.025545036,0.012074126,-0.035483696,0.023517013,0.020951765,-0.020320525,0.005724801,-0.006225092,-0.01822535,-0.010140117,0.0035121068,0.0030369987,0.02628372,0.015780976,-0.01324259,-0.0062351646,-0.01954155,-0.007400271,-0.005365532,-0.012644927,0.021247238,0.0086157415,0.012517337,-0.01604959,-0.0017157615,-0.012309162,0.000031032072,0.009052237,-0.006503777,-0.005946406,-0.012799379,-0.0019759797,0.017701555,0.03532253,0.00737341,-0.026015108,0.013994705,0.0070645055,-0.019232646,-0.0058758957,0.02541073,-0.01561981,0.008823916,-0.011402595,-0.043568928,-0.0026894815,-0.023275262,0.014464776,-0.026888099,0.019420674,-0.0053923936,-0.023745334,0.018413378,0.01563324,-0.014303609,-0.006104216,0.009414864,-0.01868199,-0.009743914,0.0020599212,0.017231483,0.00023209788,0.006497062,0.0018131335,-0.021690449,0.016895719,0.0012137921,0.021233808,-0.015028862,0.018520823,0.00055611157,-0.03126648,-0.0015705429,0.029842835,-0.007709175,-0.009253697,-0.020025052,0.007004068,-0.007870343,0.0076285913,-0.015404919,0.00077058177,0.00695706,0.01650623,-0.027693935,-0.014155872,-0.040184412,-0.012067411,0.0010543036,-0.0130277,0.018802866,0.0011004714,-0.015149738,0.010576612,0.033093043,-0.010160263,0.0006711112,0.0054024663,0.012705365,-0.0013548137,-0.011342158,-0.0089045,0.0086157415,0.020132497,-0.005009621,0.005513269,0.00034520886,-0.012221863,-0.022979788,-0.020495124,0.0060269902,0.012980693,0.026391165,0.0069973525,0.011147413,0.0018618195,-0.021771032,0.015995868,-0.023275262,0.021878477,-0.015686963,-0.010898947,0.006077355,0.043971844,-0.0065675727,-0.0032518886,0.010999677,0.004388455,-0.015002001,0.01630477,0.02234855,-0.014491637,0.009193258,-0.03062181,0.011086975,0.00672874,-0.0005833925,0.03277071,-0.007447278,0.016586814,-0.040748496,-0.00039305544,0.0029329113,0.014397623,-0.0056845094,0.015539226,0.0425482,0.011060114,0.03277071,0.009092528,-0.0075681536,0.005348744,-0.0045126877,0.030648671,-0.007118228,-0.004297798,0.014437915,0.022469426,0.0070443596,-0.013793245,-0.008091948,-0.017701555,-0.035456832,-0.014397623,0.016371924,0.005083489,0.0028892618,0.011805514,0.01063705,-0.006292245,0.03540311,-0.028043132,0.012926971,0.01975644,0.017728416,-0.0102005545,-0.6756138,-0.018185057,-0.019675856,-0.0016175502,0.055065535,0.007165235,0.005493123,0.021865048,0.0018483889,-0.021891909,-0.01411558,0.026780654,0.009065667,0.010039387,0.0035826175,-0.0134373335,-0.0076957443,-0.0032938593,-0.01541835,0.012920255,-0.006245238,-0.0013976238,-0.000007731786,0.014451345,0.010328146,-0.006903338,-0.0043582357,-0.009199974,-0.030944144,0.01693601,-0.00035570154,0.023624457,-0.015928714,-0.010623619,0.04824278,-0.032985598,-0.007621876,0.021462128,-0.00021719828,0.031669397,0.0071719503,0.0101334015,0.026444888,0.0021203589,-0.008300122,0.008870924,0.016425647,-0.020481693,-0.0017090462,-0.01630477,0.037740037,0.018655129,-0.01670769,0.01563324,0.0067522433,-0.028338606,0.03231407,-0.01975644,0.023772195,0.0015839735,0.0024342996,0.0052950215,-0.020333957,-0.03408691,-0.00794421,0.007574869,-0.019689286,0.017083747,0.007534577,-0.016385354,-0.009804351,0.036128365,-0.0069167684,0.004472396,0.006910053,-0.011765222,0.03602092,-0.028687801,-0.012947116,0.016989732,0.03019203,-0.008239685,-0.016398786,-0.015391489,0.016465938,-0.015109446,-0.043971844,-0.014034997,0.019058047,-0.025142118,0.011409311,0.041339442,0.017782139,-0.0041198423,-0.0063761864,0.011348872,-0.014008136,0.03172312,0.014706527,-0.036611866,0.0021656873,-0.01802389,0.0076957443,0.0036497705,0.0075480076,-0.0010668947,-0.0047577964,-0.010025957,0.019004324,-0.008568735,0.0016032801,-0.00624188,-0.022093367,0.0038176533,0.012463614,-0.02429599,0.0028993348,-0.0031914508,-0.012221863,-0.022670884,0.0086493185,-0.001438755,0.017647833,-0.010475882,0.0011290114,0.027667074,-0.002859043,-0.026364304,0.006114289,0.007004068,0.015552657,0.00078443205,0.0077226055,0.0068395426,-0.0015932071,0.0065608574,-0.002412475,-0.0065977913,0.0031948085,-0.006497062,-0.02234855,0.008468005,-0.008326983,0.00047846578,0.0048115193,-0.026525471,-0.013162007,-0.005375605,-0.03040692,0.0077024596,-0.014505068,-0.01629134,-0.005939691,0.033683993,-0.018708851,-0.0048820297,0.008944792,-0.016855426,-0.02387964,-0.0058658225,0.023557305,-0.0062956023,-0.012960547,0.0045328336,0.013215729,-0.005345386,0.010784787,0.0067421705,-0.011792083,-0.024672046,0.011355588,0.0010005811,0.003998967,0.012463614,0.00521108,0.009690192,-0.011281719,-0.016345063,0.021784464,-0.006262026,0.02387964,-0.0010543036,-0.015230321,0.0048383805,0.013376896,0.013726092,0.02409453,0.03123962,0.019192355,-0.002837218,0.012510621,0.038492154,-0.0034046618,0.0123696,-0.011463033,-0.00402247,0.020669721,0.027250726,0.016841996,0.021838186,0.019662425,0.017271776,0.013061277,-0.009273842,0.026525471,-0.025074964,-0.0038982371,-0.020333957,0.017003164,0.013618647,0.030111447,-0.019380383,-0.014773681,-0.013350035,0.02084432,0.017043455,0.012107703,0.014236456,0.013282882,-0.0040560467,0.007259249,0.016533092,0.012201717,0.00012318396,-0.014599082,0.010623619,-0.0065306383,-0.002051527,-0.0013934267,-0.012181571,-0.030809838,0.015042293,-0.0018886807,0.012705365,-0.004892103,0.0030067798,0.0076084454,-0.026350874,0.005627429,0.00575502,0.032502096,0.027344739,0.010415445,-0.009482017,-0.004200426,0.006611222,0.032475237,0.013551494,0.0018819654,-0.003569187,-0.005560276,-0.021032348,-0.010119971,0.014518498,-0.0011776973,-0.013665655,0.00025476204,0.0058255307,0.0132358745,0.015176599,-0.0045563374,0.017822431,-0.005288306,-0.0011499968,0.010160263,0.008917931,-0.004015755,-0.001351456,0.016143603,-0.011516755,0.00082724215,-0.025101826,0.022227673,0.009790921,-0.0029446632,-0.015552657,-0.0075480076,-0.0041937106,-0.0075412923,0.02167702,-0.024578031,-0.014625943,0.015807837,0.018520823,0.009435009,-0.02105921,-0.020871181,0.0044656806,-0.013994705,0.020978626,0.015109446,-0.010563182,-0.00966333,-0.031427648,-0.010294569,-0.022093367,0.016868858,-0.026941821,-0.012060695,-0.007420417,0.016882287,-0.022482855,0.0016360172,-0.013162007,0.0003040776,0.010710918,-0.017271776,0.001400142,-0.01670769,-0.03177684,-0.0068328273,-0.013061277,-0.007836766,-0.014182733,-0.011765222,-0.0039217407,-0.010039387,-0.006775747,0.01892374,-0.00025287337,-0.0028053205,-0.017473234,-0.018399948,0.01097953,0.09197287,-0.015807837,-0.00418028,0.009992381,0.01249719,-0.009743914,-0.024497448,-0.015458642,0.0026122553,0.016183896,-0.01108026,0.0060605668,-0.0015478788,0.0018886807,0.021985922,0.008488151,0.0010987925,-0.03532253,-0.00290605,-0.009260411,-0.0056375023,-0.007642022,-0.0072458186,0.021166654,0.0049928324,0.01999819,0.027102988,0.02715671,0.008830632,-0.00877691,0.011859236,0.0055636335,0.016667398,-0.009394717,0.0054998384,-0.021636726,-0.0032132755,-0.004086266,0.019917607,-0.0059564793,0.018628268,0.026646348,0.014343901,-0.02104578,-0.018749144,0.013632078,-0.009844643,0.031857427,0.0030655386,0.015928714,0.020884613,0.00456641,0.012779234,-0.009925227,-0.018211918,0.017755277,-0.011966681,-0.0051674303,0.009670045,-0.04077536,-0.015874991,-0.041339442,-0.015364627,-0.012248724,-0.012806095,-0.023906501,0.014666235,-0.00041844771,-0.029923419,-0.015015432,0.016909149,0.0073129716,-0.02841919,-0.0030017432,0.021381544,0.008535158,0.0033291145,-0.011436172,0.005862465,0.018695422,0.01844024,0.0071047973,-0.033469103,-0.008414282,-0.01009311,-0.0005808743,0.04015755,-0.023369277,0.010086395,0.023154387,0.022469426,0.009770775,0.020871181,0.015928714,0.015794408,-0.01139588,0.0117853675,-0.001453025,-0.0001826774,-0.02300665,0.041124552,-0.017647833,0.0038948795,-0.014934848,0.009287273,-0.0028791889,-0.016318202,0.009045522,-0.0040526893,0.0058758957,0.0048148767,-0.0030739328,-0.019447535,0.01075121,-0.04236017,0.033093043,-0.0068093236,0.009938657,-0.016546521,0.003790792,0.0077024596,-0.03663873,0.01951469,-0.013410472,0.0069369143,0.0031410859,-0.008192677,0.005318525,0.025531607,0.0046906434,0.020293664,-0.010999677,-0.012349454,-0.02520927,-0.00846129,-0.008958222,-0.016882287,-0.0024561244,-0.009636469,-0.026297152,-0.015767546,-0.0045932718,-0.0020851034,-0.002069994,0.010583327,-0.028553495,-0.0026978755,-0.01281281,-0.012799379,0.04762497,0.0121882865,-0.010865371,-0.009038806,0.008454574,-0.018708851,-0.04021127,-0.014706527,-0.016734552,0.02038768,0.017849293,0.00867618,-0.0031142246,0.023960223,0.006245238,0.010489313,-0.0019205784,0.009126105,-0.008891069,-0.021421837,0.013766384,0.020924903,0.007836766,0.025598759,-0.009347711,-0.014021566,0.015069154,0.007971073,-0.01608988,-0.031938013,-0.009314134,0.0027146637,-0.011355588,-0.017500097,-0.0021237165,0.007850196,-0.006903338,0.045476075,0.015472072,-0.0004071156,-0.014008136,-0.0012037192,-0.022039644,0.016855426,-0.009703622,-0.0019507974,0.004042616,0.007319687,-0.0039519593,-0.019205784,0.020602569,0.010945954,-0.012074126,0.005744947,0.016210757,0.030433781,0.03671931,-0.00505327,-0.0036497705,-0.014599082,-0.010610188,-0.0012465293,-0.029278748,-0.0034197713,-0.04794731,0.0025937883,0.030487504,-0.0192998,0.043488342,-0.0036497705,-0.018574545,-0.016197326,-0.004912249,0.02606883,-0.0024275843,0.017567249,0.0034365596,-0.003569187,-0.021247238,-0.0033089686,0.0007311293,-0.018776005,0.0077226055,0.019877315,-0.009260411,-0.011046683,0.00922012,0.0050868466,0.0005359656,-0.016546521,0.031454507,0.0053420286,0.016452508,-0.019743009,0.002031381,0.00236211,0.025491314,-0.0031242976,-0.0015638276,-0.015472072,0.0060907854,-0.033469103,0.007205527,-0.015136307,0.004955898,0.013014269,-0.009609608,-0.004472396,0.0065339957,-0.008078517,-0.00857545,-0.022724606,0.019702718,-0.01604959,-0.006386259,0.007689029,0.013121715,0.0011021502,-0.009831212,0.010630335,0.01823878,-0.026377736,-0.0063526826,0.011671208,0.016210757,0.018937172,-0.002927875,0.000024264302,-0.019058047,0.0018030605,-0.004042616,-0.0013069671,-0.010059534,0.011147413,-0.0036665588,0.0028036416,-0.03666559,0.015740685,-0.0026508684,-0.0171509,-0.02084432,-0.0013094853,-0.029869696,-0.000571221,0.0151900295,0.011798798,0.0064668427,0.008877639,0.028123716,-0.035537418,0.018749144,0.008998514,0.0068563307,-0.01826564,0.037928067,0.0041668494,0.0021942274,0.0009846322,-0.008642603,-0.029144442,-0.0130277,-0.014531929,0.0064500547,-0.011268289,0.013887259,-0.0053151674,-0.0066951634,0.00429444,-0.015928714,-0.033683993,0.022670884,0.0032636402,-0.014048427,0.0002545522,-0.0044656806,0.028526634,0.028848968,-0.02150242,-0.0051573575,-0.01805075,-0.0064802733,0.009737198,0.031561952,-0.003402983,-0.02475263,-0.01281281,-0.019178923,-0.0068563307,0.021945631,0.00014920578,-0.009293988,0.018802866,0.02130096,0.014491637,0.0022999935,-0.0025635692,-0.0026894815,-0.024927229,0.0066481563,-0.019286368,-0.037928067,-0.009146252,0.036396977,0.0103012845,-0.01455879,-0.0030672175,-0.003821011,-0.04238703,0.00456641,0.00011583909,-0.006194873,0.02627029,0.0032653192,0.013376896,0.01248376,0.01183909,0.0052245106,0.007420417,0.00083773484,0.0036329823,-0.025048103,0.016586814,-0.016801704,-0.021435266,-0.004955898,0.006708594,0.012396461,-0.00158901,0.009052237,0.0031091883,0.007192096,-0.006020275,-0.0024846643,0.013202298,0.032851294,0.017204622,-0.04762497,-0.0032770708,0.026794083,0.010328146,0.00004037055,0.0018937172,0.0053017368,-0.009965519,0.010294569,-0.023651319,0.0016032801,0.011348872,-0.006151223,-0.013014269,0.011966681,0.0021841542,0.012994124,0.013833537,-0.014209595,0.009790921,-0.013497772,-0.016868858,-0.00781662,0.00130277,-0.023960223,-0.0037303544,-0.020226512,0.0025551752,-0.01951469,0.0032451733,0.011093691,0.012409892,-0.010784787,-0.007145089,0.024591463,-0.018211918,-0.007984503,-0.022885773,0.000021982145,-0.013135145,-0.0021707236,0.028392328,-0.01216814,-0.00997895,0.0034886033,-0.009032091,-0.0009779169,0.015015432,-0.0070174984,0.005791954,0.011006392,0.22026214,-0.0119196735,-0.029439917,0.02798941,0.0071585197,0.025947955,0.018171627,0.0028120358,-0.0022395556,0.042037837,-0.01476025,-0.018816296,0.024927229,-0.0009905081,-0.018762574,-0.02780138,-0.019622134,-0.016009297,-0.0219322,0.0018416736,0.0076285913,-0.011812229,-0.009475301,-0.0005389036,0.022254534,-0.018319365,-0.02234855,0.0035557563,0.0038982371,0.022952927,0.006990637,-0.017849293,-0.0037706462,0.01606302,-0.011698069,0.003169626,0.007964357,-0.0050633433,0.031669397,0.030138308,-0.020911474,0.025142118,-0.0026357588,-0.021515852,0.024980951,0.009045522,-0.0056408597,-0.010307999,0.01845367,-0.009394717,-0.016009297,0.01713747,-0.009555886,0.015069154,0.017620971,-0.006174727,0.009757345,-0.010005811,-0.018789435,-0.0041735647,-0.010381868,0.028338606,-0.018950602,0.0020599212,-0.018789435,0.0055871373,-0.008138955,0.0013162006,0.013282882,-0.008105379,0.0036531282,-0.019944469,-0.012450184,-0.0067018787,-0.0070913667,-0.015673531,0.013645508,0.0077964743,0.031964872,-0.00017270936,-0.005996771,-0.020132497,-0.04125886,-0.012611351,0.0014496674,-0.05146613,0.014585651,-0.0018970749,-0.0028724736,0.010999677,0.008380706,-0.024201974,0.00056870276,-0.006164654,0.028284883,0.013564925,0.00090656674,0.019689286,-0.020535415,0.010328146,0.0103684375,0.0020532059,0.015109446,-0.005949764,-0.027089559,-0.00814567,0.0059564793,0.01932666,-0.0033257569,0.005345386,-0.0059934137,-0.016667398,0.007212242,-0.0014807257,-0.025813648,-0.00092335505,0.0011248143,-0.03975463,0.017782139,0.0077024596,0.0030202104,-0.029251887,-0.002867437,0.0021556143,0.002352037,-0.009757345,-0.009246981,0.0033828372,-0.0062653837,-0.042010974,0.018601406,0.013954413,0.016882287,-0.01909834,-0.0064802733,0.023597596,0.025155548,-0.026861237,0.012571059,-0.017889583,0.0056173564,-0.009065667,0.013222444,-0.0032988957,-0.010341576,-0.030594949,0.018117905,-0.024886936,-0.007252534,0.0030067798,-0.008837347,-0.0282043,0.008112093,-0.0087500485,0.024564601,0.0005107832,-0.03580603,-0.008011364,-0.016694259,0.023758763,-0.011140699,0.011731645,0.03454355,-0.0267135,-0.020468263,-0.004751081,-0.17438315,0.01842681,-0.0042608636,-0.027317878,-0.015337766,0.006104216,0.017822431,-0.0001473171,-0.015874991,-0.0032586039,0.0212741,-0.012765803,-0.04579841,-0.02038768,0.009918512,-0.015566087,-0.024484018,-0.008353845,-0.008528443,-0.0016360172,0.017956737,-0.011926389,0.022738038,-0.008635888,0.0047175046,-0.00008850568,-0.008414282,0.019635564,-0.0018148123,-0.010731064,0.004103054,0.020871181,0.04364951,-0.006020275,-0.00657093,0.015780976,-0.019393813,0.007668883,-0.009858074,0.015404919,-0.0028170722,0.020266803,0.024269128,0.019729579,-0.033281073,0.02782824,0.014451345,0.004794731,0.034113772,0.0018685348,0.007232388,-0.027774518,0.0054561887,0.0021337895,0.01908491,0.020347387,0.020965196,0.011154129,0.0008008006,-0.0018584619,-0.03172312,-0.017325498,-0.010260993,-0.022254534,-0.0031511588,-0.022442564,-0.01172493,0.00933428,-0.0044858265,-0.0002851908,-0.022778329,-0.0055065537,0.0035456833,-0.011342158,0.008870924,0.01650623,-0.0052547297,0.0033794793,0.011664492,0.0075010005,-0.037095368,0.023584167,-0.038707044,0.0212741,-0.0014605798,0.013054561,-0.032851294,0.012886679,-0.0116242,0.0072189574,0.009199974,-0.015378058,-0.00037962483,-0.009475301,0.028043132,0.015042293,0.025451023,0.033307932,-0.01651966,-0.0045630527,-0.015901852,-0.004841738,-0.02279176,0.02366475,0.022644022,-0.0019323302,0.018856589,0.017661264,0.03841157,-0.01391412,-0.0009166397,0.014612513,0.011348872,0.019689286,-0.02237541,-0.016412215,0.011402595,-0.020239942,0.011677923,0.0044958997,0.012779234,0.0016670756,-0.02624343,0.01588842,-0.014599082,0.0000025805411,-0.05466262,-0.03690734,0.01844024,0.016237618,-0.033979464,0.015539226,-0.00433809,0.022079937,0.014451345,0.0076957443,0.016855426,-0.009408148,-0.00645677,-0.012389746,0.0364507,-0.017526958,-0.009213405,-0.017647833,-0.0016016013,-0.01118099,0.0049491827,-0.010502744,-0.0053521013,0.0024611608,-0.017083747,-0.011792083,-0.014867695,0.04510002,0.015176599,-0.004109769,0.028016271,0.00072903075,0.009166397,-0.009388003,-0.008427713,0.0013741201,-0.0050196936,0.013309743,0.024443725,-0.033146765,0.014666235,0.0068361848,-0.0060303477,-0.019729579,-0.03255582,0.014679666,0.002002841,0.022697745,-0.005603926,0.00705779,0.017298637,0.007950926,-0.020763736,0.004153419,0.016358493,-0.010710918,0.01083851,0.0225903,-0.009529023,0.0006463485,0.00082598306,0.011248143,-0.015270613,0.0151228765,-0.003925098,0.0019239361,-0.0045093303,-0.017016593,0.022120228,0.00877691,0.0027264156,0.013020985,0.0051875766,0.030917283,-0.0361015,0.0034248077,-0.04211842,-0.011879382,-0.000100834564,0.003295538,-0.007957642,-0.022818621,-0.00005487667,-0.008528443,-0.023369277,0.021247238,-0.018117905,0.0073666945,0.012893394,-0.020441402,-0.012443468,0.011496609,0.022106798,-0.018171627,-0.0062653837,-0.033979464,0.013511202,-0.019420674,-0.004492542,0.016197326,-0.051546715,-0.010885516,-0.1011057,0.0130679915,0.029708529,-0.006245238,-0.009905081,-0.015928714,-0.0087164715,0.0015420029,0.005093562,-0.00035549168,-0.009992381,-0.0037505003,0.026149414,0.0052077225,-0.029386193,-0.023342416,0.003821011,0.009985665,0.007843481,0.0018433525,-0.0022664168,0.007346548,0.015002001,-0.0048853876,-0.023396138,-0.0009250339,-0.025974816,0.013329889,-0.008011364,-0.0051103504,0.016009297,-0.0137059465,-0.005929618,0.08617085,-0.03714909,-0.017285205,-0.0011785368,-0.0005300897,0.0009099244,-0.03800865,-0.012839671,-0.018655129,0.0150557235,0.021112932,-0.014706527,0.010744495,-0.007917349,0.011288435,0.0023956867,-0.0052446565,0.0006732098,0.021314392,-0.025437592,0.010408729,0.006020275,-0.009784206,0.007534577,0.007071221,0.012759088,-0.010361723,0.026431458,0.004183638,0.021972492,-0.018399948,0.002217731,0.0048786723,-0.009340995,0.007185381,0.009011945,-0.0053588166,-0.022509716,-0.00027511784,0.013108283,0.016103312,0.010375153,-0.021448698,0.020602569,0.006114289,-0.014639374,0.029225025,0.016600244,-0.0035759022,-0.042252727,0.013289597,0.0018332794,-0.009804351,-0.015713824,0.011617485,0.008656033,0.008353845,-0.01474682,0.017983599,0.0044958997,-0.0017728417,0.0066280104,0.0074338475,0.0020011622,-0.026552333,0.008756763,0.038733903,-0.009025375,0.015780976,0.0019256149,-0.015351197,-0.02062943,0.001808097,-0.022845482,-0.03510764,0.0149885705,0.0059061144,0.026646348,-0.00542597,-0.0016452508,0.023194678,-0.007977787,0.008279976,0.0031729836,-0.04211842,-0.02453774,-0.003315684,-0.01020727,0.023745334,0.0133701805,-0.018802866,-0.012174856,0.03274385,-0.004042616,-0.008830632,0.015942145,-0.01892374,-0.002895977,-0.02322154,0.014209595,-0.0014731709,-0.024228835,0.012060695,-0.02216052,0.006386259,-0.020078775,0.052674886,0.017862722,-0.0053588166,0.003208239,-0.018561115,0.02084432,-0.008729902,0.03129334,-0.012779234,-0.026968682,0.0077024596,-0.0037269967,-0.004257506,0.0039586746,-0.032716986,-0.01868199,-0.008729902,-0.0014723316,-0.017701555,0.002011235,0.0072928257,0.0064433394,0.026001677,-0.00076722406,-0.016600244,-0.014612513,-0.0026475107,0.01541835,-0.023503583,-0.03295874,0.0025064892,0.011617485,-0.031535093,-0.009038806,0.005405824,-0.022093367,0.007971073,-0.013088138,-0.023745334,0.02366475,-0.005973268,0.023476722,-0.029225025,-0.02844605,0.019286368,-0.01259792,-0.01474682,-0.012752373,-0.02064286]'
         as vector_distance
FROM     Rooms
ORDER BY vector_distance limit 5




