import unittest
from klongpy import KlongInterpreter
from utils import *

#
# DO NOT MODIFY: this file generated by gen_py_suite.py
#
class TestCoreSuite(unittest.TestCase):

    def assert_eval_cmp(self, a, b, klong=None):
        self.assertTrue(eval_cmp(a, b, klong=klong))

    def assert_eval_test(self, a, klong=None):
        self.assertTrue(eval_test(a, klong=klong))

    def test_atom(self):
        self.assert_eval_cmp('@:foo', '1')
        self.assert_eval_cmp('@0', '1')
        self.assert_eval_cmp('@123', '1')
        self.assert_eval_cmp('@-1', '1')
        self.assert_eval_cmp('@1.23', '1')
        self.assert_eval_cmp('@1e5', '1')
        self.assert_eval_cmp('@""', '1')
        self.assert_eval_cmp('@"string"', '0')
        self.assert_eval_cmp('@[]', '1')
        self.assert_eval_cmp('@[1 2 3]', '0')
        self.assert_eval_cmp('@{x}', '1')
        self.assert_eval_cmp('@:{}', '1')
        self.assert_eval_cmp('@:{[1 2]}', '1')

    def test_list(self):
        self.assert_eval_cmp(',:foo', '[:foo]')
        self.assert_eval_cmp(',0', '[0]')
        self.assert_eval_cmp(',123', '[123]')
        self.assert_eval_cmp(',-1', '[-1]')
        self.assert_eval_cmp(',1.23', '[1.23]')
        self.assert_eval_cmp(',1e5', '[1e5]')
        self.assert_eval_cmp(',0cx', '"x"')
        self.assert_eval_cmp(',"string"', '["string"]')
        self.assert_eval_cmp(',[]', '[[]]')
        self.assert_eval_cmp(',[1 2 3]', '[[1 2 3]]')

    def test_enumerate(self):
        self.assert_eval_cmp('!0', '[]')
        self.assert_eval_cmp('!1', '[0]')
        self.assert_eval_cmp('!3', '[0 1 2]')
        self.assert_eval_cmp('!10', '[0 1 2 3 4 5 6 7 8 9]')

    def test_size(self):
        self.assert_eval_cmp('#0', '0')
        self.assert_eval_cmp('#1', '1')
        self.assert_eval_cmp('#123', '123')
        self.assert_eval_cmp('#-123', '123')
        self.assert_eval_cmp('#[]', '0')
        self.assert_eval_cmp('#[1]', '1')
        self.assert_eval_cmp('#[1 2 3 4 5]', '5')
        self.assert_eval_cmp('#[[1] [2]]', '2')
        self.assert_eval_cmp('#:{}', '0')
        self.assert_eval_cmp('#:{[1 2]}', '1')
        self.assert_eval_cmp('#""', '0')
        self.assert_eval_cmp('#"x"', '1')
        self.assert_eval_cmp('#"hello world"', '11')

    def test_grade_down(self):
        self.assert_eval_cmp('>[]', '[]')
        self.assert_eval_cmp('>[1]', '[0]')
        self.assert_eval_cmp('>[1 2 3]', '[2 1 0]')
        self.assert_eval_cmp('>[1 3 2]', '[1 2 0]')
        self.assert_eval_cmp('>[2 1 3]', '[2 0 1]')
        self.assert_eval_cmp('>[2 3 1]', '[1 0 2]')
        self.assert_eval_cmp('>[3 1 2]', '[0 2 1]')
        self.assert_eval_cmp('>[3 2 1]', '[0 1 2]')
        self.assert_eval_cmp('>[0.0 0.1 -0.1]', '[1 0 2]')
        self.assert_eval_cmp('>[:foo :bar :baz]', '[0 2 1]')
        self.assert_eval_cmp('>"foobar"', '[5 2 1 0 3 4]')
        self.assert_eval_cmp('>[[0 1] [0 2]]', '[1 0]')
        self.assert_eval_cmp('>[[0 2] [0 1]]', '[0 1]')
        self.assert_eval_cmp('>["this" "is" "a" "test"]', '[0 3 1 2]')

    def test_grade_up(self):
        self.assert_eval_cmp('<[]', '[]')
        self.assert_eval_cmp('<[1]', '[0]')
        self.assert_eval_cmp('<[1 2 3]', '[0 1 2]')
        self.assert_eval_cmp('<[1 3 2]', '[0 2 1]')
        self.assert_eval_cmp('<[2 1 3]', '[1 0 2]')
        self.assert_eval_cmp('<[2 3 1]', '[2 0 1]')
        self.assert_eval_cmp('<[3 1 2]', '[1 2 0]')
        self.assert_eval_cmp('<[3 2 1]', '[2 1 0]')
        self.assert_eval_cmp('<[0.0 0.1 -0.1]', '[2 0 1]')
        self.assert_eval_cmp('<[:foo :bar :baz]', '[1 2 0]')
        self.assert_eval_cmp('<"foobar"', '[4 3 0 1 2 5]')
        self.assert_eval_cmp('<[[0 1] [0 2]]', '[0 1]')
        self.assert_eval_cmp('<[[0 2] [0 1]]', '[1 0]')
        self.assert_eval_cmp('<["this" "is" "a" "test"]', '[2 1 3 0]')

    def test_group(self):
        self.assert_eval_cmp('=[]', '[]')
        self.assert_eval_cmp('=[1]', '[[0]]')
        self.assert_eval_cmp('=[1 2 3]', '[[0] [1] [2]]')
        self.assert_eval_cmp('=[1 2 1 3 1 2 3]', '[[0 2 4] [1 5] [3 6]]')
        self.assert_eval_cmp('=[1 1 1 1 1]', '[[0 1 2 3 4]]')
        self.assert_eval_cmp('=""', '[]')
        self.assert_eval_cmp('="x"', '[[0]]')
        self.assert_eval_cmp('="abc"', '[[0] [1] [2]]')
        self.assert_eval_cmp('="abacabc"', '[[0 2 4] [1 5] [3 6]]')
        self.assert_eval_cmp('="xxxxx"', '[[0 1 2 3 4]]')

    def test_first(self):
        self.assert_eval_cmp('*[]', '[]')
        self.assert_eval_cmp('*[1]', '1')
        self.assert_eval_cmp('*[1 2 3]', '1')
        self.assert_eval_cmp('*""', '""')
        self.assert_eval_cmp('*"x"', '0cx')
        self.assert_eval_cmp('*"abc"', '0ca')

    def test_transpose(self):
        self.assert_eval_cmp('+[]', '[]')
        self.assert_eval_cmp('+[1]', '[1]')
        self.assert_eval_cmp('+[1 2 3]', '[1 2 3]')
        self.assert_eval_cmp('+[[1 2 3]]', '[[1] [2] [3]]')
        self.assert_eval_cmp('+[[1 2 3] [4 5 6]]', '[[1 4] [2 5] [3 6]]')
        self.assert_eval_cmp('+[[1 2] [3 4] [5 6]]', '[[1 3 5] [2 4 6]]')

    def test_floor(self):
        self.assert_eval_cmp('_0', '0')
        self.assert_eval_cmp('_1', '1')
        self.assert_eval_cmp('_1.23', '1')
        self.assert_eval_cmp('_1.999', '1')
        self.assert_eval_cmp('_1e9', '1e9')
        self.assert_eval_cmp('_-1', '-1')
        self.assert_eval_cmp('_-1.23', '-2')
        self.assert_eval_cmp('_-1.99', '-2')
        self.assert_eval_cmp('_-1e9', '-1e9')
        self.assert_eval_cmp('_[0 [1 2.2] -9.99]', '[0 [1 2.0] -10.0]')

    def test_negate(self):
        self.assert_eval_cmp('-0', '0')
        self.assert_eval_cmp('-1', '-1')
        self.assert_eval_cmp('-1.23', '-1.23')
        self.assert_eval_cmp('-1e9', '-1e9')
        self.assert_eval_cmp('-[0 [1] -1.23]', '[0 [-1] 1.23]')

    def test_not(self):
        self.assert_eval_cmp('~:foo', '0')
        self.assert_eval_cmp('~0', '1')
        self.assert_eval_cmp('~123', '0')
        self.assert_eval_cmp('~-1', '0')
        self.assert_eval_cmp('~1.23', '0')
        self.assert_eval_cmp('~1e5', '0')
        self.assert_eval_cmp('0ca~0ca', '1')
        self.assert_eval_cmp('0ca~0cb', '0')
        self.assert_eval_cmp('0cb~0ca', '0')
        self.assert_eval_cmp('~""', '1')
        self.assert_eval_cmp('~"string"', '0')
        self.assert_eval_cmp('~[]', '1')
        self.assert_eval_cmp('~[0]', '[1]')
        self.assert_eval_cmp('~[1 2 3]', '[0 0 0]')
        self.assert_eval_cmp('~{x}', '0')
        self.assert_eval_cmp('~:{}', '0')
        self.assert_eval_cmp('~:{[1 2]}', '0')
        self.assert_eval_cmp('~[0 1 [] [2] "" "x"]', '[1 0 1 [0] 1 0]')

    def test_format(self):
        self.assert_eval_cmp('$0', '"0"')
        self.assert_eval_cmp('$1', '"1"')
        self.assert_eval_cmp('$1.23', '"1.23"')
        self.assert_eval_cmp('$-1', '"-1"')
        self.assert_eval_cmp('$-1.23', '"-1.23"')
        self.assert_eval_cmp('$:foo', '":foo"')
        self.assert_eval_cmp('$0cx', '"x"')
        self.assert_eval_cmp('$""', '""')
        self.assert_eval_cmp('$"test"', '"test"')
        self.assert_eval_cmp('$["x" [:y] 0]', '["x" [":y"] "0"]')

    def test_range(self):
        self.assert_eval_cmp('?[]', '[]')
        self.assert_eval_cmp('?[1]', '[1]')
        self.assert_eval_cmp('?[1 2 3]', '[1 2 3]')
        self.assert_eval_cmp('?[1 2 1 3 1 2 3]', '[1 2 3]')
        self.assert_eval_cmp('?[1 1 1 1 1]', '[1]')
        self.assert_eval_cmp('?""', '""')
        self.assert_eval_cmp('?"x"', '"x"')
        self.assert_eval_cmp('?"abc"', '"abc"')
        self.assert_eval_cmp('?"abacabc"', '"abc"')
        self.assert_eval_cmp('?"xxxxx"', '"x"')

    def test_reciprocal(self):
        self.assert_eval_cmp('%1', '1.0')
        self.assert_eval_cmp('%2', '0.5')
        self.assert_eval_cmp('%4', '0.25')
        self.assert_eval_cmp('%10', '0.1')
        self.assert_eval_cmp('%0.01', '100')
        self.assert_eval_cmp('%0.1', '10')
        self.assert_eval_cmp('%0.5', '2')
        self.assert_eval_cmp('%-1', '-1.0')
        self.assert_eval_cmp('%-2', '-0.5')
        self.assert_eval_cmp('%-4', '-0.25')
        self.assert_eval_cmp('%-10', '-0.1')
        self.assert_eval_cmp('%-0.01', '-100.0')
        self.assert_eval_cmp('%-0.1', '-10.0')
        self.assert_eval_cmp('%-0.5', '-2.0')
        self.assert_eval_cmp('%[1 [-2] 0.5]', '[1.0 [-0.5] 2.0]')

    def test_reverse(self):
        self.assert_eval_cmp('|[]', '[]')
        self.assert_eval_cmp('|[1]', '[1]')
        self.assert_eval_cmp('|[1 2 3]', '[3 2 1]')
        self.assert_eval_cmp('|[[1 2 3] [4 5 6]]', '[[4 5 6] [1 2 3]]')
        self.assert_eval_cmp('|""', '""')
        self.assert_eval_cmp('|"a"', '"a"')
        self.assert_eval_cmp('|"abc"', '"cba"')
        self.assert_eval_cmp('|"abcdef"', '"fedcba"')

    def test_shape(self):
        self.assert_eval_cmp('^:foo', '0')
        self.assert_eval_cmp('^123', '0')
        self.assert_eval_cmp('^"string"', '[6]')
        self.assert_eval_cmp('^{x}', '0')
        self.assert_eval_cmp('^:{}', '0')
        self.assert_eval_cmp('^:{[1 2]}', '0')
        self.assert_eval_cmp('^[]', '0')
        self.assert_eval_cmp('^[1]', '[1]')
        self.assert_eval_cmp('^[1 2]', '[2]')
        self.assert_eval_cmp('^[1 2 3]', '[3]')
        self.assert_eval_cmp('^[[1 2] [3 4]]', '[2 2]')
        self.assert_eval_cmp('^[[1 2 3] [4 5 6]]', '[2 3]')
        self.assert_eval_cmp('^[[1 2] [3 4] [5 6]]', '[3 2]')
        self.assert_eval_cmp('^[[1] [2] [3] [4]]', '[4 1]')
        self.assert_eval_cmp('^[[[1] [2]] [[3] [4]]]', '[2 2 1]')
        self.assert_eval_cmp('^["abc" "def"]', '[2 3]')

    def test_expand___where(self):
        self.assert_eval_cmp('&0', '[]')
        self.assert_eval_cmp('&1', '[0]')
        self.assert_eval_cmp('&2', '[0 0]')
        self.assert_eval_cmp('&10', '[0 0 0 0 0 0 0 0 0 0]')
        self.assert_eval_cmp('&[0]', '[]')
        self.assert_eval_cmp('&[1]', '[0]')
        self.assert_eval_cmp('&[2]', '[0 0]')
        self.assert_eval_cmp('&[1 2 3]', '[0 1 1 2 2 2]')
        self.assert_eval_cmp('&[0 3]', '[1 1 1]')
        self.assert_eval_cmp('&[3 0]', '[0 0 0]')
        self.assert_eval_cmp('&[2 0 3]', '[0 0 2 2 2]')

    def test_char(self):
        self.assert_eval_cmp(':#65', '0cA')
        self.assert_eval_cmp(':#97', '0ca')
        self.assert_eval_cmp('#:#10', '10')
        self.assert_eval_cmp(':#[65 66 67]', '[0cA 0cB 0cC]')
        self.assert_eval_cmp(':#[65 [66] 67]', '[0cA [0cB] 0cC]')

    def test_amend(self):
        self.assert_eval_cmp('[]:=[]', '[]')
        self.assert_eval_cmp('[]:=[99]', '[]')
        self.assert_eval_cmp('[1]:=[2 0]', '[2]')
        self.assert_eval_cmp('[1 2 3]:=[9]', '[1 2 3]')
        self.assert_eval_cmp('[1 2 3]:=[9 0]', '[9 2 3]')
        self.assert_eval_cmp('[1 2 3]:=[9 0 1]', '[9 9 3]')
        self.assert_eval_cmp('[1 2 3]:=[9 0 1 2]', '[9 9 9]')
        self.assert_eval_cmp('[1 [2] 3]:=[[9] 1]', '[1 [9] 3]')
        self.assert_eval_cmp('[1 [2 3] 3]:=[[9 9] 1]', '[1 [9 9] 3]')
        self.assert_eval_cmp('"":=[]', '""')
        self.assert_eval_cmp('"":=[1]', '""')
        self.assert_eval_cmp('"x":=[0c0 0]', '"0"')
        self.assert_eval_cmp('"abc":=[0c_]', '"abc"')
        self.assert_eval_cmp('"abc":=[0c_ 0]', '"_bc"')
        self.assert_eval_cmp('"abc":=[0c_ 0 1]', '"__c"')
        self.assert_eval_cmp('"abc":=[0c_ 0 1 2]', '"___"')
        self.assert_eval_cmp('"":=["x"]', '""')
        self.assert_eval_cmp('"x":=["y" 0]', '"y"')
        self.assert_eval_cmp('"abc":=["x"]', '"abc"')
        self.assert_eval_cmp('"abc":=["_" 0]', '"_bc"')
        self.assert_eval_cmp('"abcabc":=["__" 0 4]', '"__ca__"')
        self.assert_eval_cmp('"abcabc":=["xyz" 0 3]', '"xyzxyz"')
        self.assert_eval_cmp('"abx":=["cde" 2]', '"abcde"')
        self.assert_eval_cmp('"abc":=["def" 3]', '"abcdef"')

    def test_amend_in_depth(self):
        self.assert_eval_cmp('[1 2 3]:-[9 0]', '[9 2 3]')
        self.assert_eval_cmp('[1 2 3]:-[9 1]', '[1 9 3]')
        self.assert_eval_cmp('[1 2 3]:-[9 2]', '[1 2 9]')
        self.assert_eval_cmp('[[1 2] [3 4]]:-[9 0 0]', '[[9 2] [3 4]]')
        self.assert_eval_cmp('[[1 2] [3 4]]:-[9 0 1]', '[[1 9] [3 4]]')
        self.assert_eval_cmp('[[1 2] [3 4]]:-[9 1 0]', '[[1 2] [9 4]]')
        self.assert_eval_cmp('[[1 2] [3 4]]:-[9 1 1]', '[[1 2] [3 9]]')
        klong = create_test_klong()
        klong('A::[[[0 1] [2 3]] [[4 5] [6 7]]]')
        self.assert_eval_cmp('A:-[:x 0 0 0]', '[[[:x 1] [2 3]] [[4 5] [6 7]]]', klong=klong)
        self.assert_eval_cmp('A:-[:x 0 0 1]', '[[[0 :x] [2 3]] [[4 5] [6 7]]]', klong=klong)
        self.assert_eval_cmp('A:-[:x 0 1 0]', '[[[0 1] [:x 3]] [[4 5] [6 7]]]', klong=klong)
        self.assert_eval_cmp('A:-[:x 0 1 1]', '[[[0 1] [2 :x]] [[4 5] [6 7]]]', klong=klong)
        self.assert_eval_cmp('A:-[:x 1 0 0]', '[[[0 1] [2 3]] [[:x 5] [6 7]]]', klong=klong)
        self.assert_eval_cmp('A:-[:x 1 0 1]', '[[[0 1] [2 3]] [[4 :x] [6 7]]]', klong=klong)
        self.assert_eval_cmp('A:-[:x 1 1 0]', '[[[0 1] [2 3]] [[4 5] [:x 7]]]', klong=klong)
        self.assert_eval_cmp('A:-[:x 1 1 1]', '[[[0 1] [2 3]] [[4 5] [6 :x]]]', klong=klong)

    def test_define(self):
        klong = create_test_klong()
        klong('A::1;               t("A::1"                 ; A ; 1)')
        klong('A::[1 2 3];         t("A::[1 2 3]"           ; A ; [1 2 3])')
        klong('A::"hello, world!"; t("A::""hello, world!""" ; A ; "hello, world!")')
        klong('A:::foobar;         t("A:::foobar"           ; A ; :foobar)')

    def test_divide(self):
        self.assert_eval_cmp('0%1', '0')
        self.assert_eval_cmp('1%1', '1')
        self.assert_eval_cmp('2%1', '2')
        self.assert_eval_cmp('1%2', '0.5')
        self.assert_eval_cmp('0%1.0', '0')
        self.assert_eval_cmp('1%1.0', '1.0')
        self.assert_eval_cmp('2%1.0', '2.0')
        self.assert_eval_cmp('1%2.0', '0.5')
        self.assert_eval_cmp('(-0)%1', '0')
        self.assert_eval_cmp('(-1)%1', '-1')
        self.assert_eval_cmp('(-2)%1', '-2')
        self.assert_eval_cmp('(-1)%2', '-0.5')
        self.assert_eval_cmp('(-0)%1.0', '0')
        self.assert_eval_cmp('(-1)%1.0', '-1.0')
        self.assert_eval_cmp('(-2)%1.0', '-2.0')
        self.assert_eval_cmp('(-1)%2.0', '-0.5')
        self.assert_eval_cmp('[1 2 3 4 5]%2.', '[0.5 1.0 1.5 2.0 2.5]')
        self.assert_eval_cmp('2.0%[2 4 8 10]', '[1.0 0.5 0.25 0.2]')
        self.assert_eval_cmp('[10 [20] 30]%[1 2 3]', '[10 [10] 10]')

    def test_integer_divide(self):
        self.assert_eval_cmp('0:%1', '0')
        self.assert_eval_cmp('1:%1', '1')
        self.assert_eval_cmp('2:%1', '2')
        self.assert_eval_cmp('1:%2', '0')
        self.assert_eval_cmp('(-0):%1', '0')
        self.assert_eval_cmp('(-1):%1', '-1')
        self.assert_eval_cmp('(-2):%1', '-2')
        self.assert_eval_cmp('(-1):%2', '-0')
        self.assert_eval_cmp('[1 2 3 4 5]:%2', '[0 1 1 2 2]')
        self.assert_eval_cmp('100:%[2 4 8 10]', '[50 25 12 10]')
        self.assert_eval_cmp('[10 [20] 30]:%[1 2 3]', '[10 [10] 10]')

    def test_drop(self):
        self.assert_eval_cmp('0_[]', '[]')
        self.assert_eval_cmp('1_[]', '[]')
        self.assert_eval_cmp('10_[]', '[]')
        self.assert_eval_cmp('0_[1]', '[1]')
        self.assert_eval_cmp('1_[1]', '[]')
        self.assert_eval_cmp('10_[1]', '[]')
        self.assert_eval_cmp('0_[1 2 3]', '[1 2 3]')
        self.assert_eval_cmp('1_[1 2 3]', '[2 3]')
        self.assert_eval_cmp('2_[1 2 3]', '[3]')
        self.assert_eval_cmp('3_[1 2 3]', '[]')
        self.assert_eval_cmp('4_[1 2 3]', '[]')
        self.assert_eval_cmp('2_[[1] [2] [3]]', '[[3]]')
        self.assert_eval_cmp('0_""', '""')
        self.assert_eval_cmp('1_""', '""')
        self.assert_eval_cmp('10_""', '""')
        self.assert_eval_cmp('0_"a"', '"a"')
        self.assert_eval_cmp('1_"a"', '""')
        self.assert_eval_cmp('10_"a"', '""')
        self.assert_eval_cmp('0_"abc"', '"abc"')
        self.assert_eval_cmp('1_"abc"', '"bc"')
        self.assert_eval_cmp('2_"abc"', '"c"')
        self.assert_eval_cmp('3_"abc"', '""')
        self.assert_eval_cmp('4_"abc"', '""')
        self.assert_eval_cmp(':foo_:{}', ':{}')
        self.assert_eval_cmp(':foo_:{[:foo bar] [:goo baz]}', ':{[:goo baz]}')
        self.assert_eval_cmp(':foo_:{[:goo baz]}', ':{[:goo baz]}')

    def test_cut(self):
        self.assert_eval_cmp('[]:_[]', '[[]]')
        self.assert_eval_cmp('[]:_[1]', '[[1]]')
        self.assert_eval_cmp('[]:_[1 2 3]', '[[1 2 3]]')
        self.assert_eval_cmp('0:_[]', '[[]]')
        self.assert_eval_cmp('0:_[1]', '[[] [1]]')
        self.assert_eval_cmp('1:_[1]', '[[1] []]')
        self.assert_eval_cmp('[0]:_[]', '[[]]')
        self.assert_eval_cmp('[0 0]:_[]', '[[] []]')
        self.assert_eval_cmp('[0]:_[1]', '[[] [1]]')
        self.assert_eval_cmp('[1]:_[1]', '[[1] []]')
        self.assert_eval_cmp('[0 1]:_[1]', '[[] [1] []]')
        self.assert_eval_cmp('[0]:_!10', '[[] [0 1 2 3 4 5 6 7 8 9]]')
        self.assert_eval_cmp('[10]:_!10', '[[0 1 2 3 4 5 6 7 8 9] []]')
        self.assert_eval_cmp('[1 4 7]:_!10', '[[0] [1 2 3] [4 5 6] [7 8 9]]')
        self.assert_eval_cmp('(!6):_!5', '[[] [0] [1] [2] [3] [4] []]')
        self.assert_eval_cmp('[]:_""', '[""]')
        self.assert_eval_cmp('[]:_"a"', '["a"]')
        self.assert_eval_cmp('[]:_"abc"', '["abc"]')
        self.assert_eval_cmp('[0 0]:_"a"', '["" "" "a"]')
        self.assert_eval_cmp('0:_""', '[""]')
        self.assert_eval_cmp('0:_"a"', '["" "a"]')
        self.assert_eval_cmp('1:_"a"', '["a" ""]')
        self.assert_eval_cmp('[0]:_"a"', '["" "a"]')
        self.assert_eval_cmp('[1]:_"a"', '["a" ""]')
        self.assert_eval_cmp('[0 1]:_"a"', '["" "a" ""]')
        self.assert_eval_cmp('[0]:_"abcdef"', '["" "abcdef"]')
        self.assert_eval_cmp('[6]:_"abcdef"', '["abcdef" ""]')
        self.assert_eval_cmp('[1 3 5]:_"abcdef"', '["a" "bc" "de" "f"]')
        self.assert_eval_cmp('(!7):_"abcdef"', '["" "a" "b" "c" "d" "e" "f" ""]')

    def test_equal(self):
        self.assert_eval_cmp('0=0', '1')
        self.assert_eval_cmp('1=1', '1')
        self.assert_eval_cmp('123=123', '1')
        self.assert_eval_cmp('1.23=1.23', '1')
        self.assert_eval_cmp('(-1)=-1', '1')
        self.assert_eval_cmp('(-123)=-123', '1')
        self.assert_eval_cmp('(-1.23)=-1.23', '1')
        self.assert_eval_cmp('123.0=123', '1')
        self.assert_eval_cmp('123=123.0', '1')
        self.assert_eval_cmp('0=1', '0')
        self.assert_eval_cmp('1=0', '0')
        self.assert_eval_cmp('123=-123', '0')
        self.assert_eval_cmp('(-123)=123', '0')
        self.assert_eval_cmp('1.23=123', '0')
        self.assert_eval_cmp('123=1.23', '0')
        self.assert_eval_cmp('0ca=0ca', '1')
        self.assert_eval_cmp('0ca=0cz', '0')
        self.assert_eval_cmp('0cz=0ca', '0')
        self.assert_eval_cmp('""=""', '1')
        self.assert_eval_cmp('"x"="x"', '1')
        self.assert_eval_cmp('"x"="y"', '0')
        self.assert_eval_cmp('"y"="x"', '0')
        self.assert_eval_cmp('"test"="test"', '1')
        self.assert_eval_cmp('"test"="tesz"', '0')
        self.assert_eval_cmp('"tesz"="test"', '0')
        self.assert_eval_cmp('"test"="tes"', '0')
        self.assert_eval_cmp('"tes"="test"', '0')
        self.assert_eval_cmp(':foo=:foo', '1')
        self.assert_eval_cmp(':foo=:bar', '0')
        self.assert_eval_cmp(':bar=:foo', '0')
        self.assert_eval_cmp(':foo=:fob', '0')
        self.assert_eval_cmp(':fob=:foo', '0')
        self.assert_eval_cmp(':foo=:fo', '0')
        self.assert_eval_cmp(':fo=:foo', '0')
        self.assert_eval_cmp('[1 2 3]=[1 2 3]', '[1 1 1]')
        self.assert_eval_cmp('1=[1 1 1]', '[1 1 1]')
        self.assert_eval_cmp('[1 1 1]=2', '[0 0 0]')
        self.assert_eval_cmp('[1 [2 [:x]]]=[1 [2 [:x]]]', '[1 [1 [1]]]')
        self.assert_eval_cmp('[1 [0 [:x]]]=[1 [2 [:x]]]', '[1 [0 [1]]]')

    def test_find(self):
        self.assert_eval_cmp('[]?0', '[]')
        self.assert_eval_cmp('[0]?0', '[0]')
        self.assert_eval_cmp('[0]?1', '[]')
        self.assert_eval_cmp('[1]?0', '[]')
        self.assert_eval_cmp('[1 2 3]?2', '[1]')
        self.assert_eval_cmp('[1 1 1]?1', '[0 1 2]')
        self.assert_eval_cmp('[1 2 1 2 1 2]?2', '[1 3 5]')
        self.assert_eval_cmp('[[1] [2] [3]]?[2]', '[1]')
        self.assert_eval_cmp('""?0ca', '[]')
        self.assert_eval_cmp('"a"?0ca', '[0]')
        self.assert_eval_cmp('"a"?0cb', '[]')
        self.assert_eval_cmp('"b"?0ca', '[]')
        self.assert_eval_cmp('"abc"?0cb', '[1]')
        self.assert_eval_cmp('"aaa"?0ca', '[0 1 2]')
        self.assert_eval_cmp('"abcabcabc"?0cc', '[2 5 8]')
        self.assert_eval_cmp('""?""', '[0]')
        self.assert_eval_cmp('""?"a"', '[]')
        self.assert_eval_cmp('"a"?"a"', '[0]')
        self.assert_eval_cmp('"a"?"b"', '[]')
        self.assert_eval_cmp('"b"?"a"', '[]')
        self.assert_eval_cmp('"abc"?"b"', '[1]')
        self.assert_eval_cmp('"aaa"?"a"', '[0 1 2]')
        self.assert_eval_cmp('"abcabcabc"?"abc"', '[0 3 6]')
        self.assert_eval_cmp('"abbbbbbbc"?"bbb"', '[1 2 3 4 5]')
        self.assert_eval_cmp(':{}?:foo', '1%0')
        self.assert_eval_cmp(':{[:foo :bar]}?:foo', ':bar')
        self.assert_eval_cmp(':{[:foo :bar]}?:bar', '1%0')
        self.assert_eval_cmp(':{[:foo :bar]}?123', '1%0')

    def test_format2(self):
        self.assert_eval_cmp('0$0', '"0"')
        self.assert_eval_cmp('0$123', '"123"')
        self.assert_eval_cmp('0$-123', '"-123"')
        self.assert_eval_cmp('0$1.23', '"1.23"')
        self.assert_eval_cmp('0$-1.23', '"-1.23"')
        self.assert_eval_cmp('10$0', '"0         "')
        self.assert_eval_cmp('10$123', '"123       "')
        self.assert_eval_cmp('10$-123', '"-123      "')
        self.assert_eval_cmp('10$1.23', '"1.23      "')
        self.assert_eval_cmp('10$-1.23', '"-1.23     "')
        self.assert_eval_cmp('3$123', '"123"')
        self.assert_eval_cmp('4$123', '"123 "')
        self.assert_eval_cmp('4$-123', '"-123"')
        self.assert_eval_cmp('5$-123', '"-123 "')
        self.assert_eval_cmp('4$1.23', '"1.23"')
        self.assert_eval_cmp('5$1.23', '"1.23 "')
        self.assert_eval_cmp('5$-1.23', '"-1.23"')
        self.assert_eval_cmp('6$-1.23', '"-1.23 "')
        self.assert_eval_cmp('(-10)$0', '"         0"')
        self.assert_eval_cmp('(-10)$123', '"       123"')
        self.assert_eval_cmp('(-10)$-123', '"      -123"')
        self.assert_eval_cmp('(-10)$1.23', '"      1.23"')
        self.assert_eval_cmp('(-10)$-1.23', '"     -1.23"')
        self.assert_eval_cmp('(-3)$123', '"123"')
        self.assert_eval_cmp('(-4)$123', '" 123"')
        self.assert_eval_cmp('(-4)$-123', '"-123"')
        self.assert_eval_cmp('(-5)$-123', '" -123"')
        self.assert_eval_cmp('(-4)$1.23', '"1.23"')
        self.assert_eval_cmp('(-5)$1.23', '" 1.23"')
        self.assert_eval_cmp('(-5)$-1.23', '"-1.23"')
        self.assert_eval_cmp('(-6)$-1.23', '" -1.23"')
        self.assert_eval_cmp('0$"test"', '"test"')
        self.assert_eval_cmp('4$"test"', '"test"')
        self.assert_eval_cmp('5$"test"', '"test "')
        self.assert_eval_cmp('10$"test"', '"test      "')
        self.assert_eval_cmp('(-4)$"test"', '"test"')
        self.assert_eval_cmp('(-5)$"test"', '" test"')
        self.assert_eval_cmp('(-10)$"test"', '"      test"')
        self.assert_eval_cmp('4$:foo', '":foo"')
        self.assert_eval_cmp('5$:foo', '":foo "')
        self.assert_eval_cmp('10$:foo', '":foo      "')
        self.assert_eval_cmp('(-4)$:foo', '":foo"')
        self.assert_eval_cmp('(-5)$:foo', '" :foo"')
        self.assert_eval_cmp('(-10)$:foo', '"      :foo"')
        self.assert_eval_cmp('0.0$123.45', '"123.45"')
        self.assert_eval_cmp('3.2$123.45', '"123.45"')
        self.assert_eval_cmp('4.2$123.45', '" 123.45"')
        self.assert_eval_cmp('3.3$123.45', '"123.450"')
        self.assert_eval_cmp('5.3$123.45', '"  123.450"')
        self.assert_eval_cmp('0.0$-123.45', '"-123.45"')
        self.assert_eval_cmp('4.2$-123.45', '"-123.45"')
        self.assert_eval_cmp('5.2$-123.45', '" -123.45"')
        self.assert_eval_cmp('4.3$-123.45', '"-123.450"')
        self.assert_eval_cmp('6.3$-123.45', '"  -123.450"')

    def test_form(self):
        self.assert_eval_cmp('0:$""', '1.0%0')
        self.assert_eval_cmp('0.0:$""', '1.0%0')
        self.assert_eval_cmp(':x:$""', '1.0%0')
        self.assert_eval_cmp('"":$""', '""')
        self.assert_eval_cmp('0:$"123"', '123')
        self.assert_eval_cmp('0:$"-123"', '-123')
        self.assert_eval_cmp('0:$"1.23"', '1.0%0')
        self.assert_eval_cmp('0:$"-1.23"', '1.0%0')
        self.assert_eval_cmp('0.0:$"123"', '123.0')
        self.assert_eval_cmp('0.0:$"-123"', '-123.0')
        self.assert_eval_cmp('0.0:$"1.23"', '1.23')
        self.assert_eval_cmp('0.0:$"-1.23"', '-1.23')
        self.assert_eval_cmp(':x:$"foo"', ':foo')
        self.assert_eval_cmp(':x:$":foo"', ':foo')
        self.assert_eval_cmp('0c0:$""', '1.0%0')
        self.assert_eval_cmp('0c0:$"x"', '0cx')
        self.assert_eval_cmp('0c0:$"xx"', '1.0%0')
        self.assert_eval_cmp('"":$"foo bar baz"', '"foo bar baz"')

    def test_at___index(self):
        self.assert_eval_cmp('[]@[]', '[]')
        self.assert_eval_cmp('[1]@[]', '[]')
        self.assert_eval_cmp('[1]@0', '1')
        self.assert_eval_cmp('[1]@[0]', '[1]')
        self.assert_eval_cmp('[1]@[0 0 0]', '[1 1 1]')
        self.assert_eval_cmp('(!10)@[1 3 5 9]', '[1 3 5 9]')
        self.assert_eval_cmp('(!10)@!10', '[0 1 2 3 4 5 6 7 8 9]')
        self.assert_eval_cmp('[[1] [2] [3]]@[0 1 2]', '[[1] [2] [3]]')
        self.assert_eval_cmp('""@[]', '""')
        self.assert_eval_cmp('"x"@[]', '""')
        self.assert_eval_cmp('"x"@0', '0cx')
        self.assert_eval_cmp('"x"@[0]', '"x"')
        self.assert_eval_cmp('"x"@[0 0 0]', '"xxx"')
        self.assert_eval_cmp('"abcdefghij"@[1 3 5 9]', '"bdfj"')
        self.assert_eval_cmp('"abcdefghi"@!9', '"abcdefghi"')

    def test_at___index_2(self):
        self.assert_eval_cmp('{123}@[]', '123')
        self.assert_eval_cmp('{x}@[456]', '456')
        self.assert_eval_cmp('{x+y}@[5 7]', '12')
        self.assert_eval_cmp('{x+y+z}@[5 7 9]', '21')

    def test_join(self):
        self.assert_eval_cmp('0,1', '[0 1]')
        self.assert_eval_cmp('[],[]', '[]')
        self.assert_eval_cmp('[0],[]', '[0]')
        self.assert_eval_cmp('[],[1]', '[1]')
        self.assert_eval_cmp('[0],[1]', '[0 1]')
        self.assert_eval_cmp('[[0]],[1]', '[[0] 1]')
        self.assert_eval_cmp('[0],[[1]]', '[0 [1]]')
        self.assert_eval_cmp('[1 2 3],4', '[1 2 3 4]')
        self.assert_eval_cmp('1,[2 3 4]', '[1 2 3 4]')
        self.assert_eval_cmp('[1 2 3],[4 5 6]', '[1 2 3 4 5 6]')
        self.assert_eval_cmp('"",""', '""')
        self.assert_eval_cmp('"a",""', '"a"')
        self.assert_eval_cmp('"","b"', '"b"')
        self.assert_eval_cmp('"a","b"', '"ab"')
        self.assert_eval_cmp('"abc",0cd', '"abcd"')
        self.assert_eval_cmp('0ca,"bcd"', '"abcd"')
        self.assert_eval_cmp('"abc","def"', '"abcdef"')
        self.assert_eval_cmp('["abc"],"def"', '["abc" "def"]')
        self.assert_eval_cmp('"abc",["def"]', '["abc" "def"]')
        self.assert_eval_cmp('["abc"],["def"]', '["abc" "def"]')

    def test_less(self):
        self.assert_eval_cmp('0<0', '0')
        self.assert_eval_cmp('0<1', '1')
        self.assert_eval_cmp('1<0', '0')
        self.assert_eval_cmp('1<1', '0')
        self.assert_eval_cmp('(-1)<0', '1')
        self.assert_eval_cmp('(-1)<1', '1')
        self.assert_eval_cmp('(-1)<-1', '0')
        self.assert_eval_cmp('0<-1', '0')
        self.assert_eval_cmp('1<-1', '0')
        self.assert_eval_cmp('1.23<4.56', '1')
        self.assert_eval_cmp('(-1.23)<4.56', '1')
        self.assert_eval_cmp('1.23<-4.56', '0')
        self.assert_eval_cmp('(-1.23)<-4.56', '0')
        self.assert_eval_cmp('4.56<1.23', '0')
        self.assert_eval_cmp('(-4.56)<1.23', '1')
        self.assert_eval_cmp('4.56<-1.23', '0')
        self.assert_eval_cmp('(-4.56)<-1.23', '1')
        self.assert_eval_cmp('123<123.0', '0')
        self.assert_eval_cmp('123<123.1', '1')
        self.assert_eval_cmp('123.0<123', '0')
        self.assert_eval_cmp('123.1<123', '0')
        self.assert_eval_cmp('123<123', '0')
        self.assert_eval_cmp('0ca<0ca', '0')
        self.assert_eval_cmp('0ca<0cz', '1')
        self.assert_eval_cmp('0cz<0ca', '0')
        self.assert_eval_cmp('""<""', '0')
        self.assert_eval_cmp('"a"<"a"', '0')
        self.assert_eval_cmp('"a"<"b"', '1')
        self.assert_eval_cmp('"b"<"a"', '0')
        self.assert_eval_cmp('"b"<"b"', '0')
        self.assert_eval_cmp('"test"<"test"', '0')
        self.assert_eval_cmp('"tesz"<"test"', '0')
        self.assert_eval_cmp('"test"<"tesz"', '1')
        self.assert_eval_cmp('"tests"<"test"', '0')
        self.assert_eval_cmp('"test"<"tests"', '1')
        self.assert_eval_cmp(':foo<:foo', '0')
        self.assert_eval_cmp(':foo<:bar', '0')
        self.assert_eval_cmp(':bar<:foo', '1')
        self.assert_eval_cmp(':foo<:fob', '0')
        self.assert_eval_cmp(':fob<:foo', '1')
        self.assert_eval_cmp(':foo<:fooo', '1')
        self.assert_eval_cmp(':fooo<:foo', '0')
        self.assert_eval_cmp('[1 [3] 5]<[2 [3] 4]', '[1 [0] 0]')

    def test_match(self):
        self.assert_eval_cmp('0~0', '1')
        self.assert_eval_cmp('1~1', '1')
        self.assert_eval_cmp('123~123', '1')
        self.assert_eval_cmp('1.23~1.23', '1')
        self.assert_eval_cmp('(-1)~-1', '1')
        self.assert_eval_cmp('(-123)~-123', '1')
        self.assert_eval_cmp('(-1.23)~-1.23', '1')
        self.assert_eval_cmp('123.0~123', '1')
        self.assert_eval_cmp('123~123.0', '1')
        self.assert_eval_cmp('0~1', '0')
        self.assert_eval_cmp('1~0', '0')
        self.assert_eval_cmp('123~-123', '0')
        self.assert_eval_cmp('(-123)~123', '0')
        self.assert_eval_cmp('1.23~123', '0')
        self.assert_eval_cmp('123~1.23', '0')
        self.assert_eval_cmp('""~""', '1')
        self.assert_eval_cmp('"x"~"x"', '1')
        self.assert_eval_cmp('"x"~"y"', '0')
        self.assert_eval_cmp('"y"~"x"', '0')
        self.assert_eval_cmp('"test"~"test"', '1')
        self.assert_eval_cmp('"test"~"tesz"', '0')
        self.assert_eval_cmp('"tesz"~"test"', '0')
        self.assert_eval_cmp('"test"~"tes"', '0')
        self.assert_eval_cmp('"tes"~"test"', '0')
        self.assert_eval_cmp(':foo~:foo', '1')
        self.assert_eval_cmp(':foo~:bar', '0')
        self.assert_eval_cmp(':bar~:foo', '0')
        self.assert_eval_cmp(':foo~:fob', '0')
        self.assert_eval_cmp(':fob~:foo', '0')
        self.assert_eval_cmp(':foo~:fo', '0')
        self.assert_eval_cmp(':fo~:foo', '0')
        self.assert_eval_cmp('[1 2 3]~[1 2 3]', '1')
        self.assert_eval_cmp('[1 2 3]~[0 2 3]', '0')
        self.assert_eval_cmp('[1 2 3]~[1 0 3]', '0')
        self.assert_eval_cmp('[1 2 3]~[1 2 0]', '0')
        self.assert_eval_cmp('[1 [2 [:x]]]~[1 [2 [:x]]]', '1')
        self.assert_eval_cmp('[1 [0 [:x]]]~[1 [2 [:x]]]', '0')
        self.assert_eval_cmp('[0 [2 [:x]]]~[1 [2 [:x]]]', '0')
        self.assert_eval_cmp('[1 [2 [:y]]]~[1 [2 [:x]]]', '0')
        self.assert_eval_cmp(':{[1 2] [3 4]}~:{[1 2] [3 4]}', '1')
        self.assert_eval_cmp(':{[1 2] [3 4]}~:{[3 4] [1 2]}', '1')
        self.assert_eval_cmp(':{[1 2] [3 4]}~:{[1 2] [0 4]}', '0')
        self.assert_eval_cmp(':{[1 2] [3 4]}~:{[1 0] [3 4]}', '0')
        self.assert_eval_cmp(':{[1 2]}~:{[1 2] [3 4]}', '0')
        self.assert_eval_cmp(':{[1 2] [3 4]}~:{[3 4]}', '0')
        self.assert_eval_cmp('123~:foo', '0')
        self.assert_eval_cmp('123~"123"', '0')
        self.assert_eval_cmp('123~[1 2 3]', '0')
        self.assert_eval_cmp('123~:{[123 456]}', '0')
        self.assert_eval_cmp(':foo~123', '0')
        self.assert_eval_cmp('"123"~123', '0')
        self.assert_eval_cmp('[1 2 3]~123', '0')
        self.assert_eval_cmp(':{[123 456]}~123', '0')
        self.assert_eval_cmp(':foo~"foo"', '0')
        self.assert_eval_cmp(':foo~[f o o]', '0')
        self.assert_eval_cmp(':foo~:{[:foo :bar]}', '0')
        self.assert_eval_cmp('"foo"~:foo', '0')
        self.assert_eval_cmp('[f o o]~:foo', '0')
        self.assert_eval_cmp(':{[:foo bar]}~:foo', '0')
        self.assert_eval_cmp('[1 2 3]~"123"', '0')
        self.assert_eval_cmp('[1 2 3]~:{[1 2]}', '0')
        self.assert_eval_cmp('"123"~[1 2 3]', '0')
        self.assert_eval_cmp(':{[1 2]}~[1 2]', '0')
        self.assert_eval_cmp('"12"~:{[1 2]}', '0')
        self.assert_eval_cmp(':{[1 2]}~"12"', '0')

    def test_max(self):
        self.assert_eval_cmp('0|0', '0')
        self.assert_eval_cmp('0|1', '1')
        self.assert_eval_cmp('1|0', '1')
        self.assert_eval_cmp('1|1', '1')
        self.assert_eval_cmp('123|456', '456')
        self.assert_eval_cmp('123|-456', '123')
        self.assert_eval_cmp('(-123)|456', '456')
        self.assert_eval_cmp('(-123)|-456', '-123')
        self.assert_eval_cmp('456|123', '456')
        self.assert_eval_cmp('456|-123', '456')
        self.assert_eval_cmp('(-456)|123', '123')
        self.assert_eval_cmp('(-456)|-123', '-123')
        self.assert_eval_cmp('1.23|4.56', '4.56')
        self.assert_eval_cmp('1.23|-4.56', '1.23')
        self.assert_eval_cmp('(-1.23)|4.56', '4.56')
        self.assert_eval_cmp('(-1.23)|-4.56', '-1.23')
        self.assert_eval_cmp('4.56|1.23', '4.56')
        self.assert_eval_cmp('4.56|-1.23', '4.56')
        self.assert_eval_cmp('(-4.56)|1.23', '1.23')
        self.assert_eval_cmp('(-4.56)|-1.23', '-1.23')
        self.assert_eval_cmp('123|123.1', '123.1')
        self.assert_eval_cmp('123.1|123', '123.1')
        self.assert_eval_cmp('[1 2 3 4]|2', '[2 2 3 4]')
        self.assert_eval_cmp('2|[1 2 3 4]', '[2 2 3 4]')
        self.assert_eval_cmp('[1 5 3]|[4 2 6]', '[4 5 6]')
        self.assert_eval_cmp('[1 [2] 3]|2', '[2 [2] 3]')

    def test_min(self):
        self.assert_eval_cmp('0&0', '0')
        self.assert_eval_cmp('0&1', '0')
        self.assert_eval_cmp('1&0', '0')
        self.assert_eval_cmp('1&1', '1')
        self.assert_eval_cmp('123&456', '123')
        self.assert_eval_cmp('123&-456', '-456')
        self.assert_eval_cmp('(-123)&456', '-123')
        self.assert_eval_cmp('(-123)&-456', '-456')
        self.assert_eval_cmp('456&123', '123')
        self.assert_eval_cmp('456&-123', '-123')
        self.assert_eval_cmp('(-456)&123', '-456')
        self.assert_eval_cmp('(-456)&-123', '-456')
        self.assert_eval_cmp('1.23&4.56', '1.23')
        self.assert_eval_cmp('1.23&-4.56', '-4.56')
        self.assert_eval_cmp('(-1.23)&4.56', '-1.23')
        self.assert_eval_cmp('(-1.23)&-4.56', '-4.56')
        self.assert_eval_cmp('4.56&1.23', '1.23')
        self.assert_eval_cmp('4.56&-1.23', '-1.23')
        self.assert_eval_cmp('(-4.56)&1.23', '-4.56')
        self.assert_eval_cmp('(-4.56)&-1.23', '-4.56')
        self.assert_eval_cmp('123&123.1', '123')
        self.assert_eval_cmp('123.1&123', '123')
        self.assert_eval_cmp('[1 2 3 4]&2', '[1 2 2 2]')
        self.assert_eval_cmp('2&[1 2 3 4]', '[1 2 2 2]')
        self.assert_eval_cmp('[1 5 3]&[4 2 6]', '[1 2 3]')
        self.assert_eval_cmp('[1 [2] 3]&2', '[1 [2] 2]')

    def test_minus(self):
        self.assert_eval_cmp('0-0', '0')
        self.assert_eval_cmp('0-1', '-1')
        self.assert_eval_cmp('1-0', '1')
        self.assert_eval_cmp('1-1', '0')
        self.assert_eval_cmp('456-123', '333')
        self.assert_eval_cmp('456--123', '579')
        self.assert_eval_cmp('(-456)-123', '-579')
        self.assert_eval_cmp('(-456)--123', '-333')
        self.assert_eval_cmp('123-456', '-333')
        self.assert_eval_cmp('123--456', '579')
        self.assert_eval_cmp('(-123)-456', '-579')
        self.assert_eval_cmp('(-123)--456', '333')
        self.assert_eval_cmp('4.56-1.23', '3.33')
        self.assert_eval_cmp('4.56--1.23', '5.79')
        self.assert_eval_cmp('(-4.56)-1.23', '-5.79')
        self.assert_eval_cmp('(-4.56)--1.23', '-3.33')
        self.assert_eval_cmp('1.23-4.56', '-3.33')
        self.assert_eval_cmp('1.23--4.56', '5.79')
        self.assert_eval_cmp('(-1.23)-4.56', '-5.79')
        self.assert_eval_cmp('(-1.23)--4.56', '3.33')
        self.assert_eval_cmp('[1 2 3 4]-1', '[0 1 2 3]')
        self.assert_eval_cmp('1-[1 2 3 4]', '[0 -1 -2 -3]')
        self.assert_eval_cmp('[1 2 3]-[4 5 6]', '[-3 -3 -3]')
        self.assert_eval_cmp('[1 [2] 3]-1', '[0 [1] 2]')

    def test_more(self):
        self.assert_eval_cmp('0>0', '0')
        self.assert_eval_cmp('0>1', '0')
        self.assert_eval_cmp('1>0', '1')
        self.assert_eval_cmp('1>1', '0')
        self.assert_eval_cmp('(-1)>0', '0')
        self.assert_eval_cmp('(-1)>1', '0')
        self.assert_eval_cmp('(-1)>-1', '0')
        self.assert_eval_cmp('0>-1', '1')
        self.assert_eval_cmp('1>-1', '1')
        self.assert_eval_cmp('1.23>4.56', '0')
        self.assert_eval_cmp('(-1.23)>4.56', '0')
        self.assert_eval_cmp('1.23>-4.56', '1')
        self.assert_eval_cmp('(-1.23)>-4.56', '1')
        self.assert_eval_cmp('4.56>1.23', '1')
        self.assert_eval_cmp('(-4.56)>1.23', '0')
        self.assert_eval_cmp('4.56>-1.23', '1')
        self.assert_eval_cmp('(-4.56)>-1.23', '0')
        self.assert_eval_cmp('123>123.0', '0')
        self.assert_eval_cmp('123>123.1', '0')
        self.assert_eval_cmp('123.0>123', '0')
        self.assert_eval_cmp('123.1>123', '1')
        self.assert_eval_cmp('123>123', '0')
        self.assert_eval_cmp('0ca>0ca', '0')
        self.assert_eval_cmp('0ca>0cz', '0')
        self.assert_eval_cmp('0cz>0ca', '1')
        self.assert_eval_cmp('"">""', '0')
        self.assert_eval_cmp('"a">"a"', '0')
        self.assert_eval_cmp('"a">"b"', '0')
        self.assert_eval_cmp('"b">"a"', '1')
        self.assert_eval_cmp('"b">"b"', '0')
        self.assert_eval_cmp('"test">"test"', '0')
        self.assert_eval_cmp('"tesz">"test"', '1')
        self.assert_eval_cmp('"test">"tesz"', '0')
        self.assert_eval_cmp('"tests">"test"', '1')
        self.assert_eval_cmp('"test">"tests"', '0')
        self.assert_eval_cmp(':foo>:foo', '0')
        self.assert_eval_cmp(':foo>:bar', '1')
        self.assert_eval_cmp(':bar>:foo', '0')
        self.assert_eval_cmp(':foo>:fob', '1')
        self.assert_eval_cmp(':fob>:foo', '0')
        self.assert_eval_cmp(':foo>:fooo', '0')
        self.assert_eval_cmp(':fooo>:foo', '1')
        self.assert_eval_cmp('[1 [3] 5]>[2 [3] 4]', '[0 [0] 1]')

    def test_plus(self):
        self.assert_eval_cmp('0+0', '0')
        self.assert_eval_cmp('0+1', '1')
        self.assert_eval_cmp('1+0', '1')
        self.assert_eval_cmp('1+1', '2')
        self.assert_eval_cmp('456+123', '579')
        self.assert_eval_cmp('456+-123', '333')
        self.assert_eval_cmp('(-456)+123', '-333')
        self.assert_eval_cmp('(-456)+-123', '-579')
        self.assert_eval_cmp('123+456', '579')
        self.assert_eval_cmp('123+-456', '-333')
        self.assert_eval_cmp('(-123)+456', '333')
        self.assert_eval_cmp('(-123)+-456', '-579')
        self.assert_eval_cmp('4.56+1.23', '5.79')
        self.assert_eval_cmp('4.56+-1.23', '3.33')
        self.assert_eval_cmp('(-4.56)+1.23', '-3.33')
        self.assert_eval_cmp('(-4.56)+-1.23', '-5.79')
        self.assert_eval_cmp('1.23+4.56', '5.79')
        self.assert_eval_cmp('1.23+-4.56', '-3.33')
        self.assert_eval_cmp('(-1.23)+4.56', '3.33')
        self.assert_eval_cmp('(-1.23)+-4.56', '-5.79')
        self.assert_eval_cmp('[1 2 3 4]+1', '[2 3 4 5]')
        self.assert_eval_cmp('1+[1 2 3 4]', '[2 3 4 5]')
        self.assert_eval_cmp('[1 2 3]+[4 5 6]', '[5 7 9]')
        self.assert_eval_cmp('[1 [2] 3]+1', '[2 [3] 4]')

    def test_power(self):
        self.assert_eval_cmp('(:_0^0)|1~0^0', '1')
        self.assert_eval_cmp('0^1', '0')
        self.assert_eval_cmp('0^2', '0')
        self.assert_eval_cmp('0^3', '0')
        self.assert_eval_cmp('1^0', '1')
        self.assert_eval_cmp('1^1', '1')
        self.assert_eval_cmp('1^2', '1')
        self.assert_eval_cmp('1^3', '1')
        self.assert_eval_cmp('2^0', '1')
        self.assert_eval_cmp('2^1', '2')
        self.assert_eval_cmp('2^2', '4')
        self.assert_eval_cmp('2^3', '8')
        self.assert_eval_cmp('2^-1', '0.5')
        self.assert_eval_cmp('2^-2', '0.25')
        self.assert_eval_cmp('2^-3', '0.125')
        self.assert_eval_cmp('(-1)^0', '1')
        self.assert_eval_cmp('(-1)^1', '-1')
        self.assert_eval_cmp('(-1)^2', '1')
        self.assert_eval_cmp('(-1)^3', '-1')
        self.assert_eval_cmp('(-2)^0', '1')
        self.assert_eval_cmp('(-2)^1', '-2')
        self.assert_eval_cmp('(-2)^2', '4')
        self.assert_eval_cmp('(-2)^3', '-8')
        self.assert_eval_cmp('(-1)^-1', '-1')
        self.assert_eval_cmp('(-1)^-2', '1')
        self.assert_eval_cmp('(-1)^-3', '-1')
        self.assert_eval_cmp('(-2)^-1', '-0.5')
        self.assert_eval_cmp('(-2)^-2', '0.25')
        self.assert_eval_cmp('(-2)^-3', '-0.125')
        self.assert_eval_cmp('[1 2 [3] 4 5]^2', '[1 4 [9] 16 25]')
        self.assert_eval_cmp('2^[1 2 [3] 4 5]', '[2 4 [8] 16 32]')
        self.assert_eval_cmp('1^0.5', '1')
        self.assert_eval_test('t("4^0.5"           ; rndn(4^0.5;10)     ; 2)' )
        self.assert_eval_test('t("16^0.25"         ; rndn(16^0.25;10)   ; 2)' )
        self.assert_eval_test('t("256^0.125"       ; rndn(256^0.125;10) ; 2)' )

    def test_rotate(self):
        self.assert_eval_cmp('0:+0', '0')
        self.assert_eval_cmp('1:+0', '0')
        self.assert_eval_cmp('2:+0', '0')
        self.assert_eval_cmp('(-1):+0', '0')
        self.assert_eval_cmp('(-2):+0', '0')
        self.assert_eval_cmp('0:+[]', '[]')
        self.assert_eval_cmp('1:+[]', '[]')
        self.assert_eval_cmp('2:+[]', '[]')
        self.assert_eval_cmp('(-2):+[]', '[]')
        self.assert_eval_cmp('(-1):+[]', '[]')
        self.assert_eval_cmp('0:+[1]', '[1]')
        self.assert_eval_cmp('1:+[1]', '[1]')
        self.assert_eval_cmp('2:+[1]', '[1]')
        self.assert_eval_cmp('(-2):+[1]', '[1]')
        self.assert_eval_cmp('(-1):+[1]', '[1]')
        self.assert_eval_cmp('0:+!5', '[0 1 2 3 4]')
        self.assert_eval_cmp('1:+!5', '[4 0 1 2 3]')
        self.assert_eval_cmp('2:+!5', '[3 4 0 1 2]')
        self.assert_eval_cmp('(-2):+!5', '[2 3 4 0 1]')
        self.assert_eval_cmp('(-1):+!5', '[1 2 3 4 0]')
        self.assert_eval_cmp('5:+!5', '[0 1 2 3 4]')
        self.assert_eval_cmp('(-5):+!5', '[0 1 2 3 4]')
        self.assert_eval_cmp('12:+!5', '[3 4 0 1 2]')
        self.assert_eval_cmp('(-12):+!5', '[2 3 4 0 1]')
        self.assert_eval_cmp('0:+""', '""')
        self.assert_eval_cmp('1:+""', '""')
        self.assert_eval_cmp('2:+""', '""')
        self.assert_eval_cmp('(-1):+""', '""')
        self.assert_eval_cmp('(-2):+""', '""')
        self.assert_eval_cmp('0:+"x"', '"x"')
        self.assert_eval_cmp('1:+"x"', '"x"')
        self.assert_eval_cmp('2:+"x"', '"x"')
        self.assert_eval_cmp('(-1):+"x"', '"x"')
        self.assert_eval_cmp('(-2):+"x"', '"x"')
        self.assert_eval_cmp('0:+"abcdef"', '"abcdef"')
        self.assert_eval_cmp('1:+"abcdef"', '"fabcde"')
        self.assert_eval_cmp('2:+"abcdef"', '"efabcd"')
        self.assert_eval_cmp('(-1):+"abcdef"', '"bcdefa"')
        self.assert_eval_cmp('(-2):+"abcdef"', '"cdefab"')
        self.assert_eval_cmp('8:+"abcdef"', '"efabcd"')
        self.assert_eval_cmp('(-8):+"abcdef"', '"cdefab"')

    def test_remainder(self):
        self.assert_eval_cmp('0!1', '0')
        self.assert_eval_cmp('1!1', '0')
        self.assert_eval_cmp('2!1', '0')
        self.assert_eval_cmp('1!2', '1')
        self.assert_eval_cmp('17!5', '2')
        self.assert_eval_cmp('(-17)!5', '-2')
        self.assert_eval_cmp('17!-5', '2')
        self.assert_eval_cmp('(-17)!-5', '-2')
        self.assert_eval_cmp('246!123', '0')
        self.assert_eval_cmp('123!123', '0')

    def test_take(self):
        self.assert_eval_cmp('0#[]', '[]')
        self.assert_eval_cmp('1#[]', '[]')
        self.assert_eval_cmp('3#[]', '[]')
        self.assert_eval_cmp('0#[1]', '[]')
        self.assert_eval_cmp('1#[1]', '[1]')
        self.assert_eval_cmp('3#[1]', '[1 1 1]')
        self.assert_eval_cmp('(-1)#[1]', '[1]')
        self.assert_eval_cmp('(-3)#[1]', '[1 1 1]')
        self.assert_eval_cmp('0#!5', '[]')
        self.assert_eval_cmp('1#!5', '[0]')
        self.assert_eval_cmp('5#!5', '[0 1 2 3 4]')
        self.assert_eval_cmp('9#!5', '[0 1 2 3 4 0 1 2 3]')
        self.assert_eval_cmp('(-1)#!5', '[4]')
        self.assert_eval_cmp('(-3)#!5', '[2 3 4]')
        self.assert_eval_cmp('(-7)#!5', '[3 4 0 1 2 3 4]')
        self.assert_eval_cmp('0#""', '""')
        self.assert_eval_cmp('1#""', '""')
        self.assert_eval_cmp('3#""', '""')
        self.assert_eval_cmp('0#"x"', '""')
        self.assert_eval_cmp('1#"x"', '"x"')
        self.assert_eval_cmp('3#"x"', '"xxx"')
        self.assert_eval_cmp('(-1)#"x"', '"x"')
        self.assert_eval_cmp('(-3)#"x"', '"xxx"')
        self.assert_eval_cmp('0#"abcdef"', '""')
        self.assert_eval_cmp('1#"abcdef"', '"a"')
        self.assert_eval_cmp('3#"abcdef"', '"abc"')
        self.assert_eval_cmp('10#"abcdef"', '"abcdefabcd"')
        self.assert_eval_cmp('(-1)#"abcdef"', '"f"')
        self.assert_eval_cmp('(-3)#"abcdef"', '"def"')
        self.assert_eval_cmp('(-9)#"abcdef"', '"defabcdef"')

    def test_reshape(self):
        self.assert_eval_cmp('0:^1', '1')
        self.assert_eval_cmp('0:^[]', '[]')
        self.assert_eval_cmp('0:^[1 2 3]', '[1 2 3]')
        self.assert_eval_cmp('1:^1', '[1]')
        self.assert_eval_cmp('2:^1', '[1 1]')
        self.assert_eval_cmp('5:^1', '[1 1 1 1 1]')
        self.assert_eval_cmp('[1]:^1', '[1]')
        self.assert_eval_cmp('[2]:^1', '[1 1]')
        self.assert_eval_cmp('[5]:^1', '[1 1 1 1 1]')
        self.assert_eval_cmp('[1 1]:^1', '[[1]]')
        self.assert_eval_cmp('[1 1 1]:^1', '[[[1]]]')
        self.assert_eval_cmp('[2 2 2]:^1', '[[[1 1] [1 1]] [[1 1] [1 1]]]')
        self.assert_eval_cmp('1:^!10', '[0]')
        self.assert_eval_cmp('3:^!10', '[0 1 2]')
        self.assert_eval_cmp('[3]:^!10', '[0 1 2]')
        self.assert_eval_cmp('[3 3]:^!10', '[[0 1 2] [3 4 5] [6 7 8]]')
        self.assert_eval_cmp('5:^[[1 2] [3 4]]', '[[1 2] [3 4] [1 2] [3 4] [1 2]]')
        self.assert_eval_cmp('[2 2]:^[1 2 3 4]', '[[1 2] [3 4]]')
        self.assert_eval_cmp('[3 3]:^[1 2 3 4]', '[[1 2 3] [4 1 2] [3 4 1]]')
        self.assert_eval_cmp('[2 -1]:^!8', '[[0 1 2 3] [4 5 6 7]]')
        self.assert_eval_cmp('[-1 2]:^!8', '[[0 1] [2 3] [4 5] [6 7]]')
        self.assert_eval_cmp('[2 -1]:^!7', '[[0 1 2] [3 4 5]]')
        self.assert_eval_cmp('[-1 2]:^!7', '[[0 1] [2 3] [4 5]]')
        self.assert_eval_cmp('0:^"foo"', '"foo"')
        self.assert_eval_cmp('1:^"x"', '"x"')
        self.assert_eval_cmp('1:^"xyz"', '"x"')
        self.assert_eval_cmp('3:^"xyz"', '"xyz"')
        self.assert_eval_cmp('[3]:^"xyz"', '"xyz"')
        self.assert_eval_cmp('[3 3]:^"xyz"', '["xyz" "xyz" "xyz"]')
        self.assert_eval_cmp('[5 2]:^"xyz"', '["xy" "zx" "yz" "xy" "zx"]')
        self.assert_eval_cmp('[2 5]:^"xyz"', '["xyzxy" "zxyzx"]')
        self.assert_eval_cmp('[3 -1]:^!10', '[[0 1 2 3 4] [5 6 7 8 9] [0 1 2 3 4]]')
        self.assert_eval_cmp('[-1 3]:^!10', '[[0 1 2] [3 4 5] [6 7 8] [9 0 1] [2 3 4]]')

    def test_split(self):
        self.assert_eval_cmp('1:#[]', '[]')
        self.assert_eval_cmp('1:#[1]', '[[1]]')
        self.assert_eval_cmp('1:#[1 2]', '[[1] [2]]')
        self.assert_eval_cmp('1:#[1 2 3]', '[[1] [2] [3]]')
        self.assert_eval_cmp('2:#[1 2 3]', '[[1 2] [3]]')
        self.assert_eval_cmp('3:#[1 2 3]', '[[1 2 3]]')
        self.assert_eval_cmp('4:#[1 2 3]', '[[1 2 3]]')
        self.assert_eval_cmp('[2]:#!10', '[[0 1] [2 3] [4 5] [6 7] [8 9]]')
        self.assert_eval_cmp('[2 3]:#!10', '[[0 1] [2 3 4] [5 6] [7 8 9]]')
        self.assert_eval_cmp('1:#""', '[]')
        self.assert_eval_cmp('1:#"x"', '["x"]')
        self.assert_eval_cmp('1:#"xy"', '["x" "y"]')
        self.assert_eval_cmp('1:#"xyz"', '["x" "y" "z"]')
        self.assert_eval_cmp('2:#"xyz"', '["xy" "z"]')
        self.assert_eval_cmp('3:#"xyz"', '["xyz"]')
        self.assert_eval_cmp('4:#"xyz"', '["xyz"]')
        self.assert_eval_cmp('[2]:#"abcdefghijk"', '["ab" "cd" "ef" "gh" "ij" "k"]')
        self.assert_eval_cmp('[2 3]:#"abcdefghijk"', '["ab" "cde" "fg" "hij" "k"]')

    def test_undefined(self):
        self.assert_eval_cmp(':_:foo', '0')
        self.assert_eval_cmp(':_0', '0')
        self.assert_eval_cmp(':_123', '0')
        self.assert_eval_cmp(':_-1', '0')
        self.assert_eval_cmp(':_1.23', '0')
        self.assert_eval_cmp(':_1e5', '0')
        self.assert_eval_cmp(':_""', '0')
        self.assert_eval_cmp(':_"string"', '0')
        self.assert_eval_cmp(':_[]', '0')
        self.assert_eval_cmp(':_[1 2 3]', '0')
        self.assert_eval_cmp(':_{x}', '0')
        self.assert_eval_cmp(':_:{}', '0')
        self.assert_eval_cmp(':_:{[1 2]}', '0')
        self.assert_eval_cmp(':_1.0%0.0', '1')
        self.assert_eval_cmp(':_1.0%0', '1')
        self.assert_eval_cmp(':_1%0.0', '1')
        self.assert_eval_cmp(':_1%0', '1')
        self.assert_eval_cmp(':_:{[1 2]}?3', '1')

    def test_times(self):
        self.assert_eval_cmp('0*0', '0')
        self.assert_eval_cmp('0*1', '0')
        self.assert_eval_cmp('1*0', '0')
        self.assert_eval_cmp('1*1', '1')
        self.assert_eval_cmp('456*123', '56088')
        self.assert_eval_cmp('456*-123', '-56088')
        self.assert_eval_cmp('(-456)*123', '-56088')
        self.assert_eval_cmp('(-456)*-123', '56088')
        self.assert_eval_cmp('123*456', '56088')
        self.assert_eval_cmp('123*-456', '-56088')
        self.assert_eval_cmp('(-123)*456', '-56088')
        self.assert_eval_cmp('(-123)*-456', '56088')
        self.assert_eval_cmp('4.56*1.23', '5.6088')
        self.assert_eval_cmp('4.56*-1.23', '-5.6088')
        self.assert_eval_cmp('(-4.56)*1.23', '-5.6088')
        self.assert_eval_cmp('(-4.56)*-1.23', '5.6088')
        self.assert_eval_cmp('1.23*4.56', '5.6088')
        self.assert_eval_cmp('1.23*-4.56', '-5.6088')
        self.assert_eval_cmp('(-1.23)*4.56', '-5.6088')
        self.assert_eval_cmp('(-1.23)*-4.56', '5.6088')
        self.assert_eval_cmp('[1 2 3 4]*3', '[3 6 9 12]')
        self.assert_eval_cmp('3*[1 2 3 4]', '[3 6 9 12]')
        self.assert_eval_cmp('[1 2 3]*[4 5 6]', '[4 10 18]')
        self.assert_eval_cmp('[1 [2] 3]*3', '[3 [6] 9]')

    def test_each(self):
        klong = create_test_klong()
        klong('D:::{[1 2] [3 4] [5 6]}')
        self.assert_eval_cmp(",'[]", '[]', klong=klong)
        self.assert_eval_cmp(",'[1]", '[[1]]', klong=klong)
        self.assert_eval_cmp(",'[1 2 3]", '[[1] [2] [3]]', klong=klong)
        klong('f::{x*x}')
        self.assert_eval_cmp("f'[]", '[]', klong=klong)
        self.assert_eval_cmp("f'[2]", '[4]', klong=klong)
        self.assert_eval_cmp("f'[2 3 4]", '[4 9 16]', klong=klong)
        self.assert_eval_cmp("{x+1}'[]", '[]', klong=klong)
        self.assert_eval_cmp("{x+1}'[1]", '[2]', klong=klong)
        self.assert_eval_cmp("{x+1}'[1 2 3]", '[2 3 4]', klong=klong)
        self.assert_eval_cmp("*':{}", '[]', klong=klong)
        self.assert_eval_cmp("*':{[1 2]}", '[1]', klong=klong)
        self.assert_eval_cmp("s@<s::*'D", '[1 3 5]', klong=klong)
        self.assert_eval_cmp("{1_x}':{}", '[]', klong=klong)
        self.assert_eval_cmp("{1_x}':{[1 2]}", '[[2]]', klong=klong)
        self.assert_eval_cmp('#\'""', '""', klong=klong)
        self.assert_eval_cmp('{x}\'""', '""', klong=klong)
        self.assert_eval_cmp('#\'"test"', '[116 101 115 116]', klong=klong)
        self.assert_eval_cmp('{x}\'"foof"', '"foof"', klong=klong)
        self.assert_eval_test('t("{x;0cx}\'""test"""       ; {x;0cx}\'"test"         ; "xxxx")', klong=klong )
        self.assert_eval_test('t("{x;-1}\'""test"""        ; {x;-1}\'"test"          ; [-1 -1 -1 -1])', klong=klong )
        self.assert_eval_cmp("s@<s::{1_x}'D", '[[2] [4] [6]]', klong=klong)

    def test_each2(self):
        self.assert_eval_cmp("[],'[]", '[]')
        self.assert_eval_cmp("[1],'[2]", '[[1 2]]')
        self.assert_eval_cmp("[1 2 3],'[4 5 6]", '[[1 4] [2 5] [3 6]]')
        self.assert_eval_cmp("[]{y-x}'[]", '[]')
        self.assert_eval_cmp("[1]{y-x}'[2]", '[1]')
        self.assert_eval_cmp("[1 2 3]{y-x}'[4 5 6]", '[3 3 3]')
        self.assert_eval_cmp('""+\'""', '""')
        self.assert_eval_cmp('""{x+y}\'""', '""')
        self.assert_eval_test('t("""test""{x;y}\'""foof""" ; "test"{x;y}\'"foof"   ; "foof")' )
        self.assert_eval_test('t("""test""{y;x}\'""foof""" ; "test"{y;x}\'"foof"   ; "test")' )
        self.assert_eval_cmp('"tst",\'"foo"', '["tf" "so" "to"]')

    def test_each_left(self):
        self.assert_eval_cmp('0,:\[]', '[]')
        self.assert_eval_cmp('0,:\[1]', '[[0 1]]')
        self.assert_eval_cmp('0,:\[1 2 3]', '[[0 1] [0 2] [0 3]]')
        self.assert_eval_cmp('0{(,,x),y}:\[]', '[]')
        self.assert_eval_cmp('0{(,,x),y}:\[1]', '[[[0] 1]]')
        self.assert_eval_cmp('0{(,,x),y}:\[1 2 3]', '[[[0] 1] [[0] 2] [[0] 3]]')
        self.assert_eval_cmp('1{x-#y}:\\"test"', '[-115 -100 -114 -115]')
        self.assert_eval_cmp('0c!,:\\"test"', '["!t" "!e" "!s" "!t"]')

    def test_each_right(self):
        self.assert_eval_cmp('0,:/[]', '[]')
        self.assert_eval_cmp('0,:/[1]', '[[1 0]]')
        self.assert_eval_cmp('0,:/[1 2 3]', '[[1 0] [2 0] [3 0]]')
        self.assert_eval_cmp('0{(,,x),y}:/[]', '[]')
        self.assert_eval_cmp('0{(,,x),y}:/[1]', '[[[1] 0]]')
        self.assert_eval_cmp('0{(,,x),y}:/[1 2 3]', '[[[1] 0] [[2] 0] [[3] 0]]')
        self.assert_eval_cmp('1{(#x)-y}:/"test"', '[115 100 114 115]')
        self.assert_eval_cmp('0c!,:/"test"', '["t!" "e!" "s!" "t!"]')

    def test_each_pair(self):
        self.assert_eval_cmp(",:'[]", '[]')
        self.assert_eval_cmp(",:'[1]", '[1]')
        self.assert_eval_cmp(",:'[1 2]", '[[1 2]]')
        self.assert_eval_cmp(",:'[1 2 3]", '[[1 2] [2 3]]')
        self.assert_eval_cmp("-:'!5", '[-1 -1 -1 -1]')
        klong = create_test_klong()
        klong('f::{y,x}')
        self.assert_eval_cmp("f:'[]", '[]', klong=klong)
        self.assert_eval_cmp("f:'[1]", '[1]', klong=klong)
        self.assert_eval_cmp("f:'!5", '[[1 0] [2 1] [3 2] [4 3]]', klong=klong)
        self.assert_eval_cmp("{y-x}:'[]", '[]', klong=klong)
        self.assert_eval_cmp("{y-x}:'[1]", '[1]', klong=klong)
        self.assert_eval_cmp("{y-x}:'!5", '[1 1 1 1]', klong=klong)
        self.assert_eval_cmp(',:\'""', '""', klong=klong)
        self.assert_eval_cmp(',:\'"x"', '"x"', klong=klong)
        self.assert_eval_cmp(',:\'"test"', '["te" "es" "st"]', klong=klong)

    def test_over(self):
        self.assert_eval_cmp(',/[]', '[]')
        self.assert_eval_cmp(',/[1]', '1')
        self.assert_eval_cmp(',/[1 2]', '[1 2]')
        self.assert_eval_cmp(',/[1 2 3]', '[1 2 3]')
        self.assert_eval_cmp('-/[1 2 3]', '-4')
        klong = create_test_klong()
        klong('f::{y-x}')
        self.assert_eval_cmp('f/[]', '[]', klong=klong)
        self.assert_eval_cmp('f/[1]', '1', klong=klong)
        self.assert_eval_cmp('f/[1 2]', '1', klong=klong)
        self.assert_eval_cmp('f/[1 2 3]', '2', klong=klong)
        self.assert_eval_cmp('{(,x),y}/[]', '[]', klong=klong)
        self.assert_eval_cmp('{(,x),y}/[1]', '1', klong=klong)
        self.assert_eval_cmp('{(,x),y}/[1 2]', '[1 2]', klong=klong)
        self.assert_eval_cmp('{(,x),y}/!5', '[[[[0 1] 2] 3] 4]', klong=klong)
        self.assert_eval_cmp('+/""', '""', klong=klong)
        self.assert_eval_cmp(',/""', '""', klong=klong)
        self.assert_eval_cmp(',/"a"', '0ca', klong=klong)
        self.assert_eval_cmp(',/"abc"', '"abc"', klong=klong)

    def test_over_neutral(self):
        self.assert_eval_cmp('1,/2', '[1 2]')
        self.assert_eval_cmp('[],/[]', '[]')
        self.assert_eval_cmp('[],/[1]', '[1]')
        self.assert_eval_cmp('[],/[1 2]', '[1 2]')
        self.assert_eval_cmp('[],/[1 2 3]', '[1 2 3]')
        self.assert_eval_cmp('4+/[1 2 3]', '10')
        self.assert_eval_cmp('5{(,x),y}/[]', '5')
        self.assert_eval_cmp('5{(,x),y}/[1]', '[5 1]')
        self.assert_eval_cmp('5{(,x),y}/[1 2]', '[[5 1] 2]')
        self.assert_eval_cmp('5{(,x),y}/!5', '[[[[[5 0] 1] 2] 3] 4]')
        self.assert_eval_cmp('0c0,/""', '0c0')
        self.assert_eval_cmp('0c0,/"a"', '"0a"')
        self.assert_eval_cmp('0c0,/"abc"', '"0abc"')

    def test_converge(self):
        self.assert_eval_cmp(',/:~[]', '[]')
        self.assert_eval_cmp(',/:~[1]', '1')
        self.assert_eval_cmp(',/:~[1 2 3]', '[1 2 3]')
        self.assert_eval_cmp(',/:~[1 [2] 3]', '[1 2 3]')
        self.assert_eval_cmp(',/:~[[1] [[2]] [3]]', '[1 2 3]')
        self.assert_eval_cmp(',/:~[[[[[0]]]]]', '0')
        self.assert_eval_cmp('{_x%2}:~0', '0')
        self.assert_eval_cmp('{_x%2}:~1', '0')
        self.assert_eval_cmp('{_x%2}:~1000', '0')

    def test_iterate(self):
        self.assert_eval_cmp('0,:*1', '1')
        self.assert_eval_cmp('1,:*1', '[1]')
        self.assert_eval_cmp('2,:*1', '[[1]]')
        self.assert_eval_cmp('3,:*1', '[[[1]]]')
        self.assert_eval_cmp('0{1,x}:*[]', '[]')
        self.assert_eval_cmp('1{1,x}:*[]', '[1]')
        self.assert_eval_cmp('2{1,x}:*[]', '[1 1]')
        self.assert_eval_cmp('5{1,x}:*[]', '[1 1 1 1 1]')

    def test_while(self):
        self.assert_eval_test('t("{x;0}{x}:~0"                ; {x;0}{x}:~0                ; 0)' )
        self.assert_eval_cmp('{x<0}{x+1}:~0', '0')
        self.assert_eval_cmp('{x<1}{x+1}:~0', '1')
        self.assert_eval_cmp('{x<10}{x+1}:~0', '10')
        self.assert_eval_cmp('{(#x)<5}{x,x}:~[1 2 3 4 5]', '[1 2 3 4 5]')
        self.assert_eval_cmp('{(#x)<5}{1,x}:~1', '[1 1 1 1 1]')

    def test_scan_over(self):
        self.assert_eval_cmp(',\[]', '[]')
        self.assert_eval_cmp(',\[1]', '[1]')
        self.assert_eval_cmp(',\[1 2]', '[1 [1 2]]')
        self.assert_eval_cmp(',\[1 2 3]', '[1 [1 2] [1 2 3]]')
        self.assert_eval_cmp('-\[1 2 3]', '[1 -1 -4]')
        klong = create_test_klong()
        klong('f::{y-x}')
        self.assert_eval_cmp('f\[]', '[]', klong=klong)
        self.assert_eval_cmp('f\[1]', '[1]', klong=klong)
        self.assert_eval_cmp('f\[1 2]', '[1 1]', klong=klong)
        self.assert_eval_cmp('f\[1 2 3]', '[1 1 2]', klong=klong)
        self.assert_eval_cmp('{(,x),y}\[]', '[]', klong=klong)
        self.assert_eval_cmp('{(,x),y}\[1]', '[1]', klong=klong)
        self.assert_eval_cmp('{(,x),y}\[1 2]', '[1 [1 2]]', klong=klong)
        self.assert_eval_cmp('{(,x),y}\!4', '[0 [0 1] [[0 1] 2] [[[0 1] 2] 3]]', klong=klong)
        self.assert_eval_cmp('+\\""', '""', klong=klong)
        self.assert_eval_cmp(',\\""', '""', klong=klong)
        self.assert_eval_cmp(',\\"a"', '[0ca]', klong=klong)
        self.assert_eval_cmp(',\\"abc"', '[0ca "ab" "abc"]', klong=klong)

    def test_scan_over_neutral(self):
        self.assert_eval_cmp('1,\\2', '[1 [1 2]]')
        self.assert_eval_cmp('[],\[]', '[]')
        self.assert_eval_cmp('[],\[1]', '[[] [1]]')
        self.assert_eval_cmp('[],\[1 2]', '[[] [1] [1 2]]')
        self.assert_eval_cmp('[],\[1 2 3]', '[[] [1] [1 2] [1 2 3]]')
        self.assert_eval_cmp('4+\[1 2 3]', '[4 5 7 10]')
        self.assert_eval_cmp('5{(,x),y}\[]', '5')
        self.assert_eval_cmp('5{(,x),y}\[1]', '[5 [5 1]]')
        self.assert_eval_cmp('5{(,x),y}\[1 2]', '[5 [5 1] [[5 1] 2]]')
        self.assert_eval_cmp('3{(,x),y}\!3', '[3 [3 0] [[3 0] 1] [[[3 0] 1] 2]]')
        self.assert_eval_cmp('0cz,\\""', '0cz')
        self.assert_eval_cmp('0c0,\\"a"', '[0c0 "0a"]')
        self.assert_eval_cmp('0c0,\\"abc"', '[0c0 "0a" "0ab" "0abc"]')

    def test_scan_converging(self):
        self.assert_eval_cmp(',/\~[]', '[[]]')
        self.assert_eval_cmp(',/\~[1]', '[[1] 1]')
        self.assert_eval_cmp(',/\~[1 2 3]', '[[1 2 3]]')
        self.assert_eval_cmp(',/\~[1 [2] 3]', '[[1 [2] 3] [1 2 3]]')
        self.assert_eval_cmp(',/\~[[1] [2] [3]]', '[[[1] [2] [3]] [1 2 3]]')
        self.assert_eval_cmp(',/\~[[[0]]]', '[[[[0]]] [[0]] [0] 0]')
        self.assert_eval_cmp('{_x%2}\~0', '[0]')
        self.assert_eval_cmp('{_x%2}\~1', '[1 0]')
        self.assert_eval_cmp('{_x%2}\~1000', '[1000 500 250 125 62 31 15 7 3 1 0]')

    def test_scan_iterating(self):
        self.assert_eval_cmp('0,\*1', '1')
        self.assert_eval_cmp('1,\*1', '[1 [1]]')
        self.assert_eval_cmp('2,\*1', '[1 [1] [[1]]]')
        self.assert_eval_cmp('3,\*1', '[1 [1] [[1]] [[[1]]]]')
        self.assert_eval_cmp('0{1,x}\*[]', '[]')
        self.assert_eval_cmp('1{1,x}\*[]', '[[] [1]]')
        self.assert_eval_cmp('2{1,x}\*[]', '[[] [1] [1 1]]')
        self.assert_eval_cmp('5{1,x}\*[]', '[[] [1] [1 1] [1 1 1] [1 1 1 1] [1 1 1 1 1]]')

    def test_scan_while(self):
        self.assert_eval_test('t("{x;0}{x}\~0"      ; {x;0}{x}\~0      ; [])' )
        self.assert_eval_cmp('{x<0}{x+1}\~0', '[]')
        self.assert_eval_cmp('{x<1}{x+1}\~0', '[0]')
        self.assert_eval_cmp('{x<10}{x+1}\~0', '[0 1 2 3 4 5 6 7 8 9]')
        self.assert_eval_cmp('{(#x)<5}{1,x}\~1', '[1 [1 1] [1 1 1] [1 1 1 1]]')
        self.assert_eval_cmp('{(#x)<5}{x,x}\~[1 2 3 4 5]', '[]')

    def test_conditional(self):
        self.assert_eval_test('t(":[0;1;2]"           ;:[0;1;2]           ;2)' )
        self.assert_eval_test('t(":[0.0;1;2]"         ;:[0.0;1;2]         ;2)' )
        self.assert_eval_test('t(":[[];1;2]"          ;:[[];1;2]          ;2)' )
        self.assert_eval_test('t(":["""";1;2]"        ;:["";1;2]          ;2)' )
        self.assert_eval_test('t(":[1;2;3]"           ;:[1;2;3]           ;2)' )
        self.assert_eval_test('t(":[0.1;2;3]"         ;:[0.1;2;3]         ;2)' )
        self.assert_eval_test('t(":[""x"";2;3]"       ;:["x";2;3]         ;2)' )
        self.assert_eval_test('t(":[:foo;2;3]"        ;:[:foo;2;3]        ;2)' )
        self.assert_eval_test('t(":[:{};2;3]"         ;:[:{};2;3]         ;2)' )
        self.assert_eval_test('t(":[[1];2;3]"         ;:[[1];2;3]         ;2)' )
        self.assert_eval_test('t(":[0;:[0;1;2];3]"    ;:[0;:[0;1;2];3]    ;3)' )
        self.assert_eval_test('t(":[0;:[1;1;2];3]"    ;:[0;:[1;1;2];3]    ;3)' )
        self.assert_eval_test('t(":[1;:[0;1;2];3]"    ;:[1;:[0;1;2];3]    ;2)' )
        self.assert_eval_test('t(":[1;:[1;1;2];3]"    ;:[1;:[1;1;2];3]    ;1)' )
        self.assert_eval_test('t(":[0;1:|2;3;4]"      ;:[0;1:|2;3;4]      ;3)' )
        self.assert_eval_test('t(":[0.0;1:|2;3;4]"    ;:[0.0;1:|2;3;4]    ;3)' )
        self.assert_eval_test('t(":[[];1:|2;3;4]"     ;:[[];1:|2;3;4]     ;3)' )
        self.assert_eval_test('t(":["""";1:|2;3;4]"   ;:["";1:|2;3;4]     ;3)' )
        self.assert_eval_test('t(":[1;2:|2;3;4]"      ;:[1;2:|2;3;4]      ;2)' )
        self.assert_eval_test('t(":[0.1;2:|2;3;4]"    ;:[0.1;2:|2;3;4]    ;2)' )
        self.assert_eval_test('t(":[""x"";2:|2;3;4]"  ;:["x";2:|2;3;4]    ;2)' )
        self.assert_eval_test('t(":[:foo;2:|2;3;4]"   ;:[:foo;2:|2;3;4]   ;2)' )
        self.assert_eval_test('t(":[:{};2:|2;3;4]"    ;:[:{};2:|2;3;4]    ;2)' )
        self.assert_eval_test('t(":[[1];2:|2;3;4]"    ;:[[1];2:|2;3;4]    ;2)' )
        self.assert_eval_test('t(":[0;2:|0;3;4]"      ;:[0;2:|0;3;4]      ;4)' )
        self.assert_eval_test('t(":[0;2:|1;3;4]"      ;:[0;2:|1;3;4]      ;3)' )
        self.assert_eval_test('t(":[1;2:|0;3;4]"      ;:[1;2:|0;3;4]      ;2)' )
        self.assert_eval_test('t(":[1;2:|1;3;4]"      ;:[1;2:|1;3;4]      ;2)' )
        self.assert_eval_test('t(":[0;2:|0;3:|0;4;5]" ;:[0;2:|0;3:|0;4;5] ;5)' )

    def test_function_application(self):
        self.assert_eval_cmp('{0}:()', '0')
        self.assert_eval_cmp('{1,2,3}:()', '[1 2 3]')
        self.assert_eval_cmp('{x}:(1)', '1')
        self.assert_eval_cmp('{0}:()', '0')
        self.assert_eval_cmp('{1,2,3}:()', '[1 2 3]')
        self.assert_eval_cmp('{x}:(1)', '1')
        self.assert_eval_cmp('{x,x}:(1)', '[1 1]')
        self.assert_eval_cmp('{x,x,x}:(1)', '[1 1 1]')
        self.assert_eval_cmp('{(x+1),(x+2),x+3}:(1)', '[2 3 4]')
        self.assert_eval_test('t("{x,y}:(1;2)"           ; {x,y}:(1;2)           ; [1 2])' )
        self.assert_eval_test('t("{(x+y),x+y}:(1;2)"     ; {(x+y),x+y}:(1;2)     ; [3 3])' )
        self.assert_eval_test('t("{x,y,z}:(1;2;3)"       ; {x,y,z}:(1;2;3)       ; [1 2 3])' )
        self.assert_eval_test('t("{x,x,y,y,z,z}:(1;2;3)" ; {x,x,y,y,z,z}:(1;2;3) ; [1 1 2 2 3 3])' )
        self.assert_eval_test('t("{x;y;z}:(1;2;3)"       ; {x;y;z}:(1;2;3)       ; 3)' )
        self.assert_eval_cmp('{*/1+!x}:(10)', '3628800')
        klong = create_test_klong()
        klong('f0::{123}')
        self.assert_eval_cmp('f0()', '123', klong=klong)
        klong('f1::{:[x=0;[];1,f1(x-1)]}')
        self.assert_eval_cmp('f1(0)', '[]', klong=klong)
        self.assert_eval_cmp('f1(1)', '[1]', klong=klong)
        self.assert_eval_cmp('f1(2)', '[1 1]', klong=klong)
        self.assert_eval_cmp('f1(10)', '[1 1 1 1 1 1 1 1 1 1]', klong=klong)
        klong('f1b::{:[x=0;1;(,f1b(x-1)),,f1b(x-1)]}')
        self.assert_eval_cmp('f1b(0)', '1', klong=klong)
        self.assert_eval_cmp('f1b(1)', '[1 1]', klong=klong)
        self.assert_eval_cmp('f1b(2)', '[[1 1] [1 1]]', klong=klong)
        self.assert_eval_cmp('f1b(3)', '[[[1 1] [1 1]] [[1 1] [1 1]]]', klong=klong)
        klong('f2::{:[0=y;1;x*f2(x;y-1)]}')
        self.assert_eval_test('t("f2(1;0)" ; f2(1;0) ; 1)', klong=klong )
        self.assert_eval_test('t("f2(2;0)" ; f2(2;0) ; 1)', klong=klong )
        self.assert_eval_test('t("f2(3;0)" ; f2(3;0) ; 1)', klong=klong )
        self.assert_eval_test('t("f2(2;1)" ; f2(2;1) ; 2)', klong=klong )
        self.assert_eval_test('t("f2(2;2)" ; f2(2;2) ; 4)', klong=klong )
        self.assert_eval_test('t("f2(2;5)" ; f2(2;5) ; 32)', klong=klong )
        klong('f3::{:[0=x;:[y=0;z;f3(x;y-1;z+1)];f3(x-1;y;z+1)]}')
        self.assert_eval_test('t("f3(0;0;0)" ; f3(0;0;0) ; 0)', klong=klong )
        self.assert_eval_test('t("f3(0;0;3)" ; f3(0;0;3) ; 3)', klong=klong )
        self.assert_eval_test('t("f3(0;3;3)" ; f3(0;3;3) ; 6)', klong=klong )
        self.assert_eval_test('t("f3(3;0;0)" ; f3(3;0;0) ; 3)', klong=klong )
        self.assert_eval_test('t("f3(3;0;3)" ; f3(3;0;3) ; 6)', klong=klong )
        self.assert_eval_test('t("f3(3;3;0)" ; f3(3;3;0) ; 6)', klong=klong )
        self.assert_eval_test('t("f3(3;3;3)" ; f3(3;3;3) ; 9)', klong=klong )
        klong('fr::{:[0=x;[];1,.f(x-1)]}')
        self.assert_eval_cmp('fr(0)', '[]', klong=klong)
        self.assert_eval_cmp('fr(1)', '[1]', klong=klong)
        self.assert_eval_cmp('fr(3)', '[1 1 1]', klong=klong)
        self.assert_eval_cmp('fr(10)', '[1 1 1 1 1 1 1 1 1 1]', klong=klong)

    def test_projection(self):
        self.assert_eval_test('t("{x-y}:(1;)@2"        ; {x-y}:(1;)@2        ; -1)' )
        self.assert_eval_test('t("{x-y}:(;2)@2"        ; {x-y}:(;2)@3        ; 1)' )
        self.assert_eval_test('t("{x-y*z}:(1;2;)@4"    ; {x-y*z}:(1;2;)@4    ; -7)' )
        self.assert_eval_test('t("{x-y*z}:(1;;3)@4"    ; {x-y*z}:(1;;3)@4    ; -11)' )
        self.assert_eval_test('t("{x-y*z}:(;2;3)@4"    ; {x-y*z}:(;2;3)@4    ; -2)' )
        self.assert_eval_test('t("{x-y*z}:(1;;)@[4 5]" ; {x-y*z}:(1;;)@[4 5] ; -19)' )
        self.assert_eval_test('t("{x-y*z}:(;2;)@[4 5]" ; {x-y*z}:(;2;)@[4 5] ; -6)' )
        self.assert_eval_test('t("{x-y*z}:(;;3)@[4 5]" ; {x-y*z}:(;;3)@[4 5] ; -11)' )
        klong = create_test_klong()
        klong('f2::{x-y}')
        klong('f3::{x-y*z}')
        self.assert_eval_test('t("f2(1;)@2"      ; f2(1;)@2      ; -1)', klong=klong )
        self.assert_eval_test('t("f2(;2)@2"      ; f2(;2)@3      ; 1)', klong=klong )
        self.assert_eval_test('t("f3(1;2;)@4"    ; f3(1;2;)@4    ; -7)', klong=klong )
        self.assert_eval_test('t("f3(1;;3)@4"    ; f3(1;;3)@4    ; -11)', klong=klong )
        self.assert_eval_test('t("f3(;2;3)@4"    ; f3(;2;3)@4    ; -2)', klong=klong )
        self.assert_eval_test('t("f3(1;;)@[4 5]" ; f3(1;;)@[4 5] ; -19)', klong=klong )
        self.assert_eval_test('t("f3(;2;)@[4 5]" ; f3(;2;)@[4 5] ; -6)', klong=klong )
        self.assert_eval_test('t("f3(;;3)@[4 5]" ; f3(;;3)@[4 5] ; -11)', klong=klong )

    def test_monad_contexts(self):
        klong = create_test_klong()
        klong('f::{,x}')
        klong('g::{x,y}')
        self.assert_eval_cmp(',1', '[1]', klong=klong)
        self.assert_eval_cmp(",'[1 2 3]", '[[1] [2] [3]]', klong=klong)
        self.assert_eval_cmp("f'[1 2 3]", '[[1] [2] [3]]', klong=klong)
        self.assert_eval_cmp("{,x}'[1 2 3]", '[[1] [2] [3]]', klong=klong)
        self.assert_eval_test('t("g(;0)\'[1 2 3]"     ; g(;0)\'[1 2 3]     ; [[1 0] [2 0] [3 0]])', klong=klong )
        self.assert_eval_test('t("{x,y}(0;)\'[1 2 3]" ; {x,y}(0;)\'[1 2 3] ; [[0 1] [0 2] [0 3]])', klong=klong )

    def test_dyad_contexts(self):
        klong = create_test_klong()
        klong('f::{x,y}')
        klong('g::{x,y,z}')
        self.assert_eval_cmp('1,2', '[1 2]', klong=klong)
        self.assert_eval_cmp('0,:\[1 2 3]', '[[0 1] [0 2] [0 3]]', klong=klong)
        self.assert_eval_cmp('0{x,y}[1 2 3]', '[0 1 2 3]', klong=klong)
        self.assert_eval_cmp('0{x,y}:/[1 2 3]', '[[1 0] [2 0] [3 0]]', klong=klong)
        self.assert_eval_cmp('0f[1 2 3]', '[0 1 2 3]', klong=klong)
        self.assert_eval_cmp('9f:/[1 2 3]', '[[1 9] [2 9] [3 9]]', klong=klong)
        self.assert_eval_test('t("[1 2 3]g(;0;)[4 5 6]"  ; [1 2 3]g(;0;)[4 5 6]  ; [1 2 3 0 4 5 6])', klong=klong )
        self.assert_eval_test('t("[1 2 3]g(;0;)\'[4 5 6]" ; [1 2 3]g(;0;)\'[4 5 6] ; [[1 0 4] [2 0 5] [3 0 6]])', klong=klong )
        self.assert_eval_test('t("1{x,y,z}(;0;)2"          ; 1{x,y,z}(;0;)2          ; [1 0 2])', klong=klong )
        self.assert_eval_test('t("[1 2]{x,y,z}(;0;)\'[3 4]" ; [1 2]{x,y,z}(;0;)\'[3 4] ; [[1 0 3] [2 0 4]])', klong=klong )

    def test_local_variables(self):
        klong = create_test_klong()
        klong('fv::{[a];a::1;a} ; t("fv()"     ; fv()     ; 1)')
        klong('a::2             ; t("a,fv(),a" ; a,fv(),a ; [2 1 2])')

    def test_symbol_identity(self):
        self.assert_eval_cmp(':test~:test', '1')
        self.assert_eval_cmp(':test~*[test]', '1')
        self.assert_eval_cmp('(*[test])~:test', '1')
        self.assert_eval_cmp('(*[test])~*[test]', '1')
        self.assert_eval_cmp(':{[foo bar]}?:foo', ':bar')

    def test_dictionaries__in_situ_mutation(self):
        klong = create_test_klong()
        klong("D:::{};{D,x,x}'!5")
        self.assert_eval_test('t("D:::{};{D,x,x}\'!5;D" ; s@<s::*\'D ; [0 1 2 3 4])', klong=klong )

    def test_dictionaries__creation(self):
        klong = create_test_klong()
        klong("uniq::{[d];d:::{};{d,x,x}'x;d@<d::*'d}")
        self.assert_eval_cmp('uniq(!5)', '[0 1 2 3 4 ]', klong=klong)
        self.assert_eval_cmp('uniq(!7)', '[0 1 2 3 4 5 6]', klong=klong)
        self.assert_eval_cmp('uniq(!3)', '[0 1 2]', klong=klong)

    def test_real_number_similarity(self):
        klong = create_test_klong()
        klong('s::{(x+2%x)%2}:~2')
        self.assert_eval_cmp('(s+10*.e)~s', '1', klong=klong)

    def test_modules(self):
        klong = create_test_klong()
        klong('a::0')
        self.assert_eval_cmp('a', '0', klong=klong)
        klong('.module(:test)')
        klong('a::1')
        klong('g::{a}')
        klong('f::{g()}')
        klong('s::{a::x}')
        klong('.module(0)')
        self.assert_eval_cmp('a', '1', klong=klong)
        self.assert_eval_cmp('g()', '1', klong=klong)
        self.assert_eval_cmp('s(2)', '2', klong=klong)
        self.assert_eval_cmp('g()', '2', klong=klong)
        klong('a::0 ; t("g()"  ; g()  ; 2)')
        klong('g::0 ; t("f()"  ; f()  ; 2)')

    def test_forward_reference(self):
        klong = create_test_klong()
        klong('fw::0')
        klong('.module(:fwd)')
        klong('fw::1')
        klong('fwd::{fw}')
        klong('fw::2')
        klong('.module(0)')
        klong('fw::3')
        self.assert_eval_cmp('fwd()', '2', klong=klong)

    def test_regression_tests(self):
        klong = create_test_klong()
        klong('a::!8192')
        klong('.tc(.oc("test.tmp"));.w(a);.cc(.tc(0))')
        klong('.fc(.ic("test.tmp"));t(".r" ; .r() ; a);.cc(.fc(0))')
        klong('.df("test.tmp")')

    if __name__ == '__main__':
        unittest.main()
