# Documentation

Documentation is generated by using Sphinx and published on RTD

---------------

## Documentation

Documentation is automatically created on each merge to the development
branch, as well as with each pull request and available
[📚 here at Read the Docs][ref-rtd-micropython-winbond]

### Install required packages

```bash
# create and activate virtual environment
python3 -m venv .venv
source .venv/bin/activate

# install and upgrade required packages
pip install -U -r docs/requirements.txt
```

### Create documentation

Some usefull checks have been disabled in the `docs/conf.py` file. Please
check the documentation build output locally before opening a PR.

```bash
# perform link checks
sphinx-build docs/ docs/build/linkcheck -d docs/build/docs_doctree/ --color -blinkcheck -j auto -W

# create documentation
sphinx-build docs/ docs/build/html/ -d docs/build/docs_doctree/ --color -bhtml -j auto -W
```

The created documentation can be found at `docs/build/html`.

<!-- Links -->
[ref-rtd-micropython-winbond]: https://micropython-winbond.readthedocs.io/en/latest/
