# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

<!--
## [x.y.z] - yyyy-mm-dd
### Added
### Changed
### Removed
### Fixed
-->
## [0.5.4] - 2024-05-30
### Fixed
- sleep changed to microsecond sleep to speed up flashing
## [0.5.3] - 2024-05-30
### Fixed
- fixed string formatting for compatibility with micropython
## [0.5.2] - 2023-11-15
### Fixed
- await function no longer caught in loop and has timeout of 2 seconds 
- writeblocks no longer fails for invalid block lengths
- packages no longer raises exception but prints warning if memory is untested
## [0.5.1] - 2023-05-16
### Fixed
- Return type of `manufacturer` and `device` property fixed to be integers instead of strings, see #6
- Better example string for the create file example in `main.py`

## [0.5.0] - 2023-05-14
### Added
- Properties for `manufacturer`, `mem_type`, `device`, `capacity`
- BE-ESP32-01 specific pin and SPI definition in `boot.py`
- Validate `package.json` file with every test workflow run but without version validation

### Removed
- Verbose print statements

## [0.4.0] - 2023-03-24
### Added
- `package.json` for `mip` installation with MicroPython v1.19.1 or newer
- Instructions for installation with `mip` on  MicroPython v1.19.1 or newer in `README`
- `.editorconfig` for common editor settings
- `.readthedocs.yaml` definition file for ReadTheDocs
- `docs` folder containing example files and configurations
- `.yamllint` to lint all used YAML files
- `yamllint` package to the `requirements-test.txt` file
- Run YAML linter on test workflow
- Create release candidate tag on PRs and release tags on merges to main branch

### Removed
- No longer used `update_version.py` file removed from flake8 exclude list

### Fixed
- Path to `docs/conf.py` in flake8 file
- Fixed uncovered YAML syntax issues in all workflow files
- Removed unused files from `.gitignore` file
- Doc string and typing hints for Winbond init function

## [0.3.0] - 2022-11-03
### Added
- Deploy to [Test Python Package Index](https://test.pypi.org/) on every PR
  build with a [PEP440][ref-pep440] compliant `-rc<BUILDNUMBER>.dev<PR_NUMBER>`
  meta data extension
- Test release workflow `.github/workflows/test-release.yaml` running only on
  PRs is archiving and uploading built artifacts to
  [Test Python Package Index](https://test.pypi.org/)
- `.flake8` definition file

### Changed
- Version is specified by `winbond/version.py` and autogenerated
  on each deploy.

### Fixed
- All uncovered flake8 warnings of `winbond`

## [0.2.0] - 2022-02-21
### Added
- `setup.py` and `sdist_upip.py` taken from
  [pfalcon's picoweb repo][ref-pfalcon-picoweb-sdist-upip] and PEP8 improved
- `MIT License`

### Changed
- Moved `winbond.py` into folder named `winbond`
- Update README usage description of micropython lib deploy to [PyPi][ref-pypi]
- Renamed `test_winbond.py` to `usage_example.py`

## [0.1.0] - 2022-02-17
### Added
- This changelog file
- Default python `.gitignore` file
- MicroPython `boot` and `main` files
- `README` and `requirements.txt` files
- `winbond.py` file based on [crizeo's answer on the MicroPython
  Forum][ref-upy-forum-winbond-driver] with my extension to use flash chips
  without hardware reset pins, extended documentation and PEP8 fixes

<!-- Links -->
[Unreleased]: https://github.com/brainelectronics/micropython-winbond/compare/0.5.1...main

[0.5.1]: https://github.com/brainelectronics/micropython-winbond/tree/0.5.1
[0.5.0]: https://github.com/brainelectronics/micropython-winbond/tree/0.5.0
[0.4.0]: https://github.com/brainelectronics/micropython-winbond/tree/0.4.0
[0.3.0]: https://github.com/brainelectronics/micropython-winbond/tree/0.3.0
[0.2.0]: https://github.com/brainelectronics/micropython-winbond/tree/0.2.0
[0.1.0]: https://github.com/brainelectronics/micropython-winbond/tree/0.1.0

[ref-pep440]: https://peps.python.org/pep-0440/
[ref-upy-forum-winbond-driver]: https://forum.micropython.org/viewtopic.php?f=16&t=3899&start=10
[ref-pypi]: https://pypi.org/
[ref-pfalcon-picoweb-sdist-upip]: https://github.com/pfalcon/picoweb/blob/b74428ebdde97ed1795338c13a3bdf05d71366a0/sdist_upip.py
