import { RulesetFunctionContext } from '@stoplight/spectral-core'

type MessageFn = ({ path }: { path: (string | number)[] }) => string

/**
 * When the input is falsy, return a message that is generated by the provided function
 */
export const truthyWithMessage = (fn: MessageFn) => (input: string, _: unknown, context: RulesetFunctionContext) => {
  const messages = []

  if (!input) {
    const message = fn({ path: context.path })
    messages.push({ message })
  }

  return messages
}
