## Description

Connect your Botpress chatbot with Mailchimp, a popular email marketing platform. With this integration, you can easily manage your email campaigns and subscribers directly from your chatbot.

To set up the integration, you’ll need to provide your Mailchimp API key and Server Prefix (e.g. us19). Once the integration is set up, you can use the built-in actions to add customer to campaign or list, send mass campaigns, and more.

For more detailed instructions on how to set up and use the Botpress Mailchimp integration, please refer to our documentation.

## Prerequisites

Before enabling the Botpress Mailchimp Integration, please ensure that you have the following:

- A Botpress cloud account.
- Access to a Mailchimp account.
- API key generated from your Mailchimp account.

## Enable Integration

To enable the Mailchimp integration in Botpress, follow these steps:

- Access your Botpress admin panel.
- Navigate to the “Integrations” section.
- Locate the Mailchimp integration and click on “Enable” or “Configure.”
- Login to your Mailchimp account.
- Generate an API key for your Mailchimp account by following the instructions [here](https://mailchimp.com/help/about-api-keys/#Generate_an_API_key).
- Note the url prefix (e.g. us19) for your Mailchimp account by looking at the url of the Mailchimp admin panel.
- Paste the API Key and Server Prefix into the Botpress Mailchimp integration configuration.
- Save the configuration.

## Usage

Once the integration is enabled, you can start sending and receiving emails within your Botpress chatbot. The integration offers actions such as `addCustomerToCampaign`, `addCustomerToList`, and `sendMassEmailCampaign` that can be used to interact with your Mailchimp account.

For more detailed information and examples, refer to the Botpress documentation or the Mailchimp documentation for configuring the integration.
