# JavaScript Naming Conventions Guide for this Project

## Variables
Use camel case for variable names. Example: `let dogName = 'Scooby-Doo';`

## Booleans
Prefix Boolean variables with 'is' or 'has'. Example: `const hasCollar = true;`

## Functions
Name functions with descriptive verbs. Example: `const fetchDogToy = () => { /* ... */ };`

## Constants
Use uppercase for constants. Example: `const MAX_DOG_AGE = 20;`

## Functional Components
Use Pascal case for functional components. Example: `const DogProfile = () => { /* ... */ };`

## Hooks
Prefix custom hooks with 'use'. Example: `const useDogData = () => { /* ... */ };`

## Private Functions
Prefix private functions with an underscore within a module. Example: `const _calculateDogAge = () => { /* ... */ };`

## Global Variables
Use camel case or uppercase. Example: `let currentDog = 'Buddy'; const WORLD_DOG_DAY = 'August 26';`

## File Names
For files that export React components, use Pascal case. Example: `DogProfile.jsx`

## Global Variables
Use camel case or uppercase. Example: `let currentDog = 'Buddy'; const WORLD_DOG_DAY = 'August 26';`

## File Names
For files that export React components, use Pascal case. Example: `DogProfile.jsx`

# Getting Started with React App

## Available Scripts

In the project directory, you can run:

### `npm run dev`

Runs the Vite development server.

Open http://localhost:5173/ to view it in your browser.

The page will reload when you make changes.\
You may also see any lint errors in the console.

### `npm run build`

Builds the app for production using Vite.

### `npm run lint`

Runs ESLint on the project files.

### `npm run preview`

Sets up a local preview server for the production build.

### `npm run test`

Launches the test runner in the interactive watch mode.

### `npm run test:coverage`

Runs Vitest and collects coverage information.

