# Contributing to Bluejay

Bluejay is an open source project so we appreciate your help and
feedback!

Here are instructions to get you started. They are probably not perfect, 
please let us know if anything feels wrong or incomplete.

## Guidelines

### Issues

Any significant improvement should be added as a GitHub issue so we can
discuss.

Please submit issues to the correct repositories:

- [Blueprint](https://github.com/blue-jay/blueprint/issues) - issues
related to the Blueprint source code
- [Jay](https://github.com/blue-jay/jay/issues) - issues related to
the Jay source code
- [Core](https://github.com/blue-jay/core/issues) - issues related to
the Core source code
- [BlueJay Docs](https://github.com/blue-jay/blue-jay.github.io.hugo/issues)
- Issues related to the BlueJay website or documentation

When submitting an issue, please answer these questions:

- Which commit are you using?
- Which operating system, processor architecture, and Go version are you using?
- What did you do?
- What did you expect to see?
- What did you actually see?

### Pull Requests

Send your pull request to the **master** branch with an explanation so
we can merge it quickly.

Any small changes like typo fixes are also worth a pull request.

Please separate out features and fixes into individual pull requests
and reference the issue if it exists.

Things like typos fixes can be grouped together into a single pull
request.
