function cp437_to_unicode(cp437) {
    switch(cp437) {
        case 1: return "\u263A";
        case 2: return "\u263B";
        case 3: return "\u2665";
        case 4: return "\u2666";
        case 5: return "\u2663";
        case 6: return "\u2660";
        case 7: return "\u2022";
        case 8: return "\u25D8";
        case 9: return "\u25CB";
        case 10: return "\u25D9";
        case 11: return "\u2642";
        case 12: return "\u2640";
        case 13: return "\u266A";
        case 14: return "\u266B";
        case 15: return "\u263C";
        case 16: return "\u25BA";
        case 17: return "\u25C4";
        case 18: return "\u2195";
        case 19: return "\u203C";
        case 20: return "\u00B6";
        case 21: return "\u00A7";
        case 22: return "\u25AC";
        case 23: return "\u21A8";
        case 24: return "\u2191";
        case 25: return "\u2193";
        case 26: return "\u2192";
        case 27: return "\u2190";
        case 28: return "\u221F";
        case 29: return "\u2194";
        case 30: return "\u25B2";
        case 31: return "\u25BC";
        case 127: return "\u2302";
        case 128: return "\u00C7";
        case 129: return "\u00FC";
        case 130: return "\u00E9";
        case 131: return "\u00E2";
        case 132: return "\u00E4";
        case 133: return "\u00E0";
        case 134: return "\u00E5";
        case 135: return "\u00E7";
        case 136: return "\u00EA";
        case 137: return "\u00EB";
        case 138: return "\u00E8";
        case 139: return "\u00EF";
        case 140: return "\u00EE";
        case 141: return "\u00EC";
        case 142: return "\u00C4";
        case 143: return "\u00C5";
        case 144: return "\u00C9";
        case 145: return "\u00E6";
        case 146: return "\u00C6";
        case 147: return "\u00F4";
        case 148: return "\u00F6";
        case 149: return "\u00F2";
        case 150: return "\u00FB";
        case 151: return "\u00F9";
        case 152: return "\u00FF";
        case 153: return "\u00D6";
        case 154: return "\u00DC";
        case 155: return "\u00A2";
        case 156: return "\u00A3";
        case 157: return "\u00A5";
        case 158: return "\u20A7";
        case 159: return "\u0192";
        case 160: return "\u00E1";
        case 161: return "\u00ED";
        case 162: return "\u00F3";
        case 163: return "\u00FA";
        case 164: return "\u00F1";
        case 165: return "\u00D1";
        case 166: return "\u00AA";
        case 167: return "\u00BA";
        case 168: return "\u00BF";
        case 169: return "\u2310";
        case 170: return "\u00AC";
        case 171: return "\u00BD";
        case 172: return "\u00BC";
        case 173: return "\u00A1";
        case 174: return "\u00AB";
        case 175: return "\u00BB";
        case 176: return "\u2591";
        case 177: return "\u2592";
        case 178: return "\u2593";
        case 179: return "\u2502";
        case 180: return "\u2524";
        case 181: return "\u2561";
        case 182: return "\u2562";
        case 183: return "\u2556";
        case 184: return "\u2555";
        case 185: return "\u2563";
        case 186: return "\u2551";
        case 187: return "\u2557";
        case 188: return "\u255D";
        case 189: return "\u255C";
        case 190: return "\u255B";
        case 191: return "\u2510";
        case 192: return "\u2514";
        case 193: return "\u2534";
        case 194: return "\u252C";
        case 195: return "\u251C";
        case 196: return "\u2500";
        case 197: return "\u253C";
        case 198: return "\u255E";
        case 199: return "\u255F";
        case 200: return "\u255A";
        case 201: return "\u2554";
        case 202: return "\u2569";
        case 203: return "\u2566";
        case 204: return "\u2560";
        case 205: return "\u2550";
        case 206: return "\u256C";
        case 207: return "\u2567";
        case 208: return "\u2568";
        case 209: return "\u2564";
        case 210: return "\u2565";
        case 211: return "\u2559";
        case 212: return "\u2558";
        case 213: return "\u2552";
        case 214: return "\u2553";
        case 215: return "\u256B";
        case 216: return "\u256A";
        case 217: return "\u2518";
        case 218: return "\u250C";
        case 219: return "\u2588";
        case 220: return "\u2584";
        case 221: return "\u258C";
        case 222: return "\u2590";
        case 223: return "\u2580";
        case 224: return "\u03B1";
        case 225: return "\u00DF";
        case 226: return "\u0393";
        case 227: return "\u03C0";
        case 228: return "\u03A3";
        case 229: return "\u03C3";
        case 230: return "\u00B5";
        case 231: return "\u03C4";
        case 232: return "\u03A6";
        case 233: return "\u0398";
        case 234: return "\u03A9";
        case 235: return "\u03B4";
        case 236: return "\u221E";
        case 237: return "\u03C6";
        case 238: return "\u03B5";
        case 239: return "\u2229";
        case 240: return "\u2261";
        case 241: return "\u00B1";
        case 242: return "\u2265";
        case 243: return "\u2264";
        case 244: return "\u2320";
        case 245: return "\u2321";
        case 246: return "\u00F7";
        case 247: return "\u2248";
        case 248: return "\u00B0";
        case 249: return "\u2219";
        case 250: return "\u00B7";
        case 251: return "\u221A";
        case 252: return "\u207F";
        case 253: return "\u00B2";
        case 254: return "\u25A0";
        case 0:
        case 255: return "\u00A0";
        default: return String.fromCharCode(cp437);
    }
}

function cp437_to_unicode_bytes(cp437) {
    return Buffer.from(cp437_to_unicode(cp437));
}

function unicode_to_cp437(unicode) {
    switch(unicode) {
        case 0x263A: return 1;
        case 0x263B: return 2;
        case 0x2665: return 3;
        case 0x2666: return 4;
        case 0x2663: return 5;
        case 0x2660: return 6;
        case 0x2022: return 7;
        case 0x25D8: return 8;
        case 0x25CB: return 9;
        case 0x25D9: return 10;
        case 0x2642: return 11;
        case 0x2640: return 12;
        case 0x266A: return 13;
        case 0x266B: return 14;
        case 0x263C: return 15;
        case 0x25BA: return 16;
        case 0x25C4: return 17;
        case 0x2195: return 18;
        case 0x203C: return 19;
        case 0x00B6: return 20;
        case 0x00A7: return 21;
        case 0x25AC: return 22;
        case 0x21A8: return 23;
        case 0x2191: return 24;
        case 0x2193: return 25;
        case 0x2192: return 26;
        case 0x2190: return 27;
        case 0x221F: return 28;
        case 0x2194: return 29;
        case 0x25B2: return 30;
        case 0x25BC: return 31;
        case 0x2302: return 127;
        case 0x00C7: return 128;
        case 0x00FC: return 129;
        case 0x00E9: return 130;
        case 0x00E2: return 131;
        case 0x00E4: return 132;
        case 0x00E0: return 133;
        case 0x00E5: return 134;
        case 0x00E7: return 135;
        case 0x00EA: return 136;
        case 0x00EB: return 137;
        case 0x00E8: return 138;
        case 0x00EF: return 139;
        case 0x00EE: return 140;
        case 0x00EC: return 141;
        case 0x00C4: return 142;
        case 0x00C5: return 143;
        case 0x00C9: return 144;
        case 0x00E6: return 145;
        case 0x00C6: return 146;
        case 0x00F4: return 147;
        case 0x00F6: return 148;
        case 0x00F2: return 149;
        case 0x00FB: return 150;
        case 0x00F9: return 151;
        case 0x00FF: return 152;
        case 0x00D6: return 153;
        case 0x00DC: return 154;
        case 0x00A2: return 155;
        case 0x00A3: return 156;
        case 0x00A5: return 157;
        case 0x20A7: return 158;
        case 0x0192: return 159;
        case 0x00E1: return 160;
        case 0x00ED: return 161;
        case 0x00F3: return 162;
        case 0x00FA: return 163;
        case 0x00F1: return 164;
        case 0x00D1: return 165;
        case 0x00AA: return 166;
        case 0x00BA: return 167;
        case 0x00BF: return 168;
        case 0x2310: return 169;
        case 0x00AC: return 170;
        case 0x00BD: return 171;
        case 0x00BC: return 172;
        case 0x00A1: return 173;
        case 0x00AB: return 174;
        case 0x00BB: return 175;
        case 0x2591: return 176;
        case 0x2592: return 177;
        case 0x2593: return 178;
        case 0x2502: return 179;
        case 0x2524: return 180;
        case 0x2561: return 181;
        case 0x2562: return 182;
        case 0x2556: return 183;
        case 0x2555: return 184;
        case 0x2563: return 185;
        case 0x2551: return 186;
        case 0x2557: return 187;
        case 0x255D: return 188;
        case 0x255C: return 189;
        case 0x255B: return 190;
        case 0x2510: return 191;
        case 0x2514: return 192;
        case 0x2534: return 193;
        case 0x252C: return 194;
        case 0x251C: return 195;
        case 0x2500: return 196;
        case 0x253C: return 197;
        case 0x255E: return 198;
        case 0x255F: return 199;
        case 0x255A: return 200;
        case 0x2554: return 201;
        case 0x2569: return 202;
        case 0x2566: return 203;
        case 0x2560: return 204;
        case 0x2550: return 205;
        case 0x256C: return 206;
        case 0x2567: return 207;
        case 0x2568: return 208;
        case 0x2564: return 209;
        case 0x2565: return 210;
        case 0x2559: return 211;
        case 0x2558: return 212;
        case 0x2552: return 213;
        case 0x2553: return 214;
        case 0x256B: return 215;
        case 0x256A: return 216;
        case 0x2518: return 217;
        case 0x250C: return 218;
        case 0x2588: return 219;
        case 0x2584: return 220;
        case 0x258C: return 221;
        case 0x2590: return 222;
        case 0x2580: return 223;
        case 0x03B1: return 224;
        case 0x00DF: return 225;
        case 0x0393: return 226;
        case 0x03C0: return 227;
        case 0x03A3: return 228;
        case 0x03C3: return 229;
        case 0x00B5: return 230;
        case 0x03C4: return 231;
        case 0x03A6: return 232;
        case 0x0398: return 233;
        case 0x03A9: return 234;
        case 0x03B4: return 235;
        case 0x221E: return 236;
        case 0x03C6: return 237;
        case 0x03B5: return 238;
        case 0x2229: return 239;
        case 0x2261: return 240;
        case 0x00B1: return 241;
        case 0x2265: return 242;
        case 0x2264: return 243;
        case 0x2320: return 244;
        case 0x2321: return 245;
        case 0x00F7: return 246;
        case 0x2248: return 247;
        case 0x00B0: return 248;
        case 0x2219: return 249;
        case 0x00B7: return 250;
        case 0x221A: return 251;
        case 0x207F: return 252;
        case 0x00B2: return 253;
        case 0x25A0: return 254;
        case 0x00A0: return 255;
        default:
            if (unicode >= 0 && unicode <= 127) return unicode;
            return 0;
    }
}

module.exports = {cp437_to_unicode, cp437_to_unicode_bytes, unicode_to_cp437};
