<a name="v2.0"></a>
# [v2.0](https://github.com/blocksecteam/rustle/releases/tag/v2.0) - 07 Apr 2023

## What's Changed

* add support for macOS, refer to [README](/README.md#macos-setup) for more

**Full Changelog**: https://github.com/blocksecteam/rustle/compare/v1.3...v2.0


[Changes][v2.0]


<a name="v1.3"></a>
# [v1.3](https://github.com/blocksecteam/rustle/releases/tag/v1.3) - 13 Jan 2023

## What's Changed

* add 3 new detectors
    * [unclaimed-storage-fee](/docs/detectors/unclaimed-storage-fee.md): find functions without balance check before storage unregister (based on [NEP-145](https://github.com/near/NEPs/blob/master/neps/nep-0145.md))
    * [nft-approval-check](/docs/detectors/nft-approval-check.md): find `nft_transfer` without checking `approval id` (based on [NEP-171](https://github.com/near/NEPs/blob/master/neps/nep-0171.md))
    * [nft-owner-check](/docs/detectors/nft-owner-check.md): find approve or revoke functions without owner check (based on [NEP-178](https://github.com/near/NEPs/blob/master/neps/nep-0178.md))
* add new detector group `nep-ft`, `nep-storage` and `nep-nft`

**Full Changelog**: https://github.com/blocksecteam/rustle/compare/v1.2...v1.3

[Changes][v1.3]


<a name="v1.2"></a>
# [v1.2](https://github.com/blocksecteam/rustle/releases/tag/v1.2) - 16 Dec 2022

## What's Changed

* add 6 new detectors
    * [public-interface](/docs/detectors/public-interface.md): find all public interfaces
    * [dup-collection-id](/docs/detectors/dup-collection-id.md): find duplicate id uses in collections
    * [storage-gas](/docs/detectors/storage-gas.md): find missing balance checks for storage expansion
    * [unregistered-receiver](/docs/detectors/unregistered-receiver.md): find transfer functions with no panic on unregistered transfer receivers
    * [unsaved-changes](/docs/detectors/unsaved-changes.md): find changes to collections that are not saved
    * [nep${id}-interface](/docs/detectors/nep-interface.md): do interface integrity check for different NEP specification
* add support for rustc v1.65.0
* integrate clang-tidy for code optimization


**Full Changelog**: https://github.com/blocksecteam/rustle/compare/v1.1...v1.2


[Changes][v1.2]


<a name="v1.1"></a>
# [v1.1](https://github.com/blocksecteam/rustle/releases/tag/v1.1) - 10 Nov 2022

## Changes

* docs: add [examples](/examples) for every detector
* feat: bump LLVM version to 15 (but we are still working on supporting Rust v1.65.0, refer to this [PR](https://github.com/rust-lang/rust/pull/99464/) for more)
* feat: add unit test scripts
* feat: add `--output` flag to [rustle](/rustle) script
* feat: split vulnerabilities into different severity groups in the audit report
* fix several bugs

**Full Changelog**: https://github.com/blocksecteam/rustle/compare/v1.0...v1.1

[Changes][v1.1]


<a name="v1.0"></a>
# [v1.0](https://github.com/blocksecteam/rustle/releases/tag/v1.0) - 01 Nov 2022

We are thrilled to release [Rustle](https://github.com/blocksecteam/rustle): the first automatic auditor offered by [BlockSec](https://blocksec.com/) for NEAR community.

Rustle has several great features:

* Rustle can currently detect 20+ types of issues in the NEAR contract. See the section Detectors for the full detector list.
* Rustle is easy to use. We provide thorough installation commands and tutorials. Furthermore, we also prepare a docker for users for quick start.
* Rustle is rather swift, most of the NEAR contracts can be analyzed within 3 minutes.
* Rustle is user-friendly with reports in both CSV and JSON format. We also provide a script to help you import the result to [Notion](https://www.notion.so/).

[Changes][v1.0]


[v2.0]: https://github.com/blocksecteam/rustle/compare/v1.3...v2.0
[v1.3]: https://github.com/blocksecteam/rustle/compare/v1.2...v1.3
[v1.2]: https://github.com/blocksecteam/rustle/compare/v1.1...v1.2
[v1.1]: https://github.com/blocksecteam/rustle/compare/v1.0...v1.1
[v1.0]: https://github.com/blocksecteam/rustle/tree/v1.0

<!-- Generated by https://github.com/rhysd/changelog-from-release v3.7.0 -->
