# wgrib2: -v -v0 -v2

## Introduction

Wgrib2 has multiple levels of verbosity. The lowest level (0) is
the default and set by
-v0. The next level is 1 and is set by
-v. Really verbose is set by
-v2. Debugging is set by level 99.
Note that the verbosity can be changed multiple times on
the command line.

## Usage

```
-v0
-v
-v2
```

### Example

```
-$ wgrib2 fcst.grb
1:4:d=2007032600:HGT:1000 mb:anl:
2:422561:d=2007032600:HGT:1000 mb:3 hour fcst:
-$ wgrib2 fcst.grb -v
1:4:d=2007032600:HGT Geopotential Height [gpm]:1000 mb:anl:
2:422561:d=2007032600:HGT Geopotential Height [gpm]:1000 mb:3 hour fcst:
-$ wgrib2 fcst.grb -v2
1:4:00Z26mar2007:HGT Geopotential Height [gpm]:lvl1=100000*10**0 lvl2=missing lvl1=(100,100000) lvl2=(255,missing):1000 mb:anl:
2:422561:00Z26mar2007:HGT Geopotential Height [gpm]:lvl1=100000*10**0 lvl2=missing lvl1=(100,100000) lvl2=(255,missing):1000 mb:3 hour fcst:
```

See also:

---

> Description: misc not verbose (v=0)

_Docs derived from <https://www.cpc.ncep.noaa.gov/products/wesley/wgrib2/v0.html>_
