# Changelog - Version 1 series

# v0.1        9/2005: alpha release

# v0.1.1  12/15/2005  added scan flags for various grids, fixed some scan code,
             malloced a large array that caused a seg fault if stack was too small

# v0.1.1a  4/28/2006 fix for lambert2ll Naoya Suda -  Thanks, remove some debug statements

# v0.1.1b  5/4/2006 gaussian grid Sec3.c, grb2.h, rename nxny() to get_nxny() better grid output

# v0.1.1c  5/23/2006 added -processid option (ex which fcst model)
         5/24/2006 added -range option for partial http transfers

# v0.1.1.d 5/31/2006 change in -grid .. location of print nl

# v0.1.1.e 6/2006 some time and level upgrades

# v0.1.2   6/2006 -text now prints "nx ny" rather than "ndata 1", fixed binary/text output of WE:NS files
         7/2006   added the gaussian/polar/merc projections, make various FILE.c routines reentrant
         7/2006   added more packing types
     7/2006   -flush -> flush buffers for -lola lola
     8/2006   -del renamed to -colon, modified read_inventory and write "rec_no:location"
          routines so that -colon , would work .. make comma seperated files
          added info about spherical harmonics
          moved PackVals into packing, triggered by verbose mode
          better info about various Gaussian and lat-lon grids
          decided to get critical values by code_table_X_Y(sec) and flag_table_X_Y(sec) calls
          changed (projection)2ll calls to use sec rather than gdas
          changed uint to unsigned int .. gcc extension
          fixed -lola  bug report from D. Duncalf
          added -no_append -no_flush, renamed -nof77 to -no_f77 to be consistent with new names

# v0.1.3     9/2006   added -vt and -VT verf time
          added warning to bad lat-lon grid
          better testing for lat lon values
          mod for AIX compilation

# v0.1.4   9/2006   fixed problem with decoding of fields with bitmaps

# v0.1.4a          added a test for failed memory allocation
          change to makefile for people without . on their path (suggested by Kristian Nilssen)
     9/2006   change for Windows geo.c allocate memory explicitly
                         closest() needs to be made faster

# v0.1.4b  9/2006   fixed comment for f_order, default order is we:sn not we:ns
          altered text_fmt to change format in init stage
                  added -verf which is a macro like -s but uses -vt rather than -t
    10/2006   f_lola, f_lat can take negative longitudes

# v0.1.4c    10/2006   made f_lola much faster
    10/2006   f_lola uses append flag
    10/2006   grid type stubs,

# v0.1.4d 11/2006   add order we:ns, add error check for lat-lon with -order != we:sn
          fix some minor scan code bugs
    11/2006   text_format, text_col and header are used by -lola with text option
                  added the -is -not options

# v0.1.4e    11/2006   fixed bug in un-scanning code: WE|EW:SN, (we:ns and we:sn were ok)
          added code for complex packing with spatial diff. undefined values
          added -match -not and -last
          upgraded g2clib 1.0.4
          -f77 and -no_f77 are renamed to -header and -no_header, last name change, promise
          change to the "main" makefile g2clib-1.0.2 -> g2clib-1.0.4
    12/2006   added flag_table_3.5/3.9/3.10
    12/2006   modified -t and -vt to produce datecode in grads format when -v2 used

# v0.1.4f 1/2007    Many mods from Manfred Schwarb, remove wrtieee_header, libg2c -> libgrib2c,
                  error checks for thinned grids
                  error check on verftime 
                  many cleanup patches form M. Schwarb - no effect on code operation
                  better thinned grid support .. in lat-lon grids
          uint8 fixed for numbers > 2 GB (ok, if I had 2GB grib record, I could check the fix)
          scan of spectral fields changed to unknown, scan handles some thinned grids
          ilat works with thinned grids, ijlat doesn't
                  fixed Level.c () m under ground, removed factor of 1/100.  found by Caser Tejeda Hernandez
          binary files written by -Lola now have header support
          many patches by M Schwarb (31 for this release)!

# v0.1.4gbeta 1/2007    Manfred Schwarb wrote program to download tables from the web documentation.
                  The code writes a code fragment (body of a switch statement) which is then
                  included by the code.
            code_table0.dat    CodeTable_1.3.dat  CodeTable_3.1.dat  ncep_tableC.dat
            CodeTable_1.2.dat  CodeTable_1.4.dat  gribtab.dat

# v0.1.4g 2/2007    -help (string) is now case insensitive, -ens for ensemble info, -s includes -ens, aliases,

# v0.1.4h 2/2007     more tables, process is now an alias

# v0.1.5 3/2007      updated ftime so to handle product definition template 4.8 better (still has rough points)
           replace exit() with fatal_error
           moved #define MATCH to makefile
                   add netcdf, thanks Kristian Nilssen
           added code table 4.10
           added ensemble info to -verf

# v0.1.5a 4/2007     Netcdf conversion to time fixed, a local-UTC conversion problem

# v0.1.5b 4/2007     Netcdf module update: multiple times allowed, by Sergey Varlamov
                   cname - multiple gribtable support, -tigge for modified TIGGE names
                   Help: output format change
           some more ensemble support: derived products, pdt=12, N_ens,

# v0.1.5c 6/2007     updated Netcdf.c  by Sergey Varlamov
    7/2007     modified grib2/makefile and grib2/wgrib2/makefile (fixed clean)
        8/2007     update to makefile -l netcdf -> -lnetcdf (S. Varlamov)
                   netcdf: update format, more metadata (S. Varamov)
                   Sec3 - mercator grid had wrong variable dimension location (Boi Vuong)
                   Support for grid 204, some other minor grids added
           API for closest/closest_init made more general for future changes
                   modified makefiles to be easier to change to pre-compiled libraries

# v0.1.5d 9/2007     changed to new version of g2clib (1.0.5), updated makefiles,minor netcdf changes 

# v0.1.5e 10/2007       would segfault if -netcdf and undefined variable (fixed cname), modified makefile
10/2007            scaled2FLT has less roundoff error
                   -spread doesn't print out undef values
           added more NCEP levels
           added g2ctl support -lev0 -ctl_inv (both are preliminary)
           added -undefine option
11/2007           added -ijundefine option
11/2007           allow inventories to start with blanks
           use tigge table if produced as a tigge product (secondary table)

# v0.1.5f 11/2007    
11/2007           VerfTime.c fixed when not a forecast
           updated -CodeTable_5.0 and -packing
           updated CodeTable_4.10.dat
           added CodeTable_3.11 (thinned regional vs global grid)
           thinned grid support for lat-lon and the various thinned Gaussian grids
12/2007           grib2 output routines -grib_out, -undefine
1/2008           fix spelling mistake (matchs -> matches)
           update gribtab.dat .. ie variable names
           noticed so corrections to the table when variables changed numbers!!!
               added -undefine_val
                   added fflush_mode to FILE.c
           added makefile_all_libs
           some updates to documentation
           update to Netcdf.c vsm

# v0.1.6 1/2008  ---------------------------------------
           fixed error compiling Tigge.c without no TIGGE option
           more descriptive Sec_len
           removed from add_time .. numerical precision problem
           write to stdout "-text -"
           write to stdout "-spread -"
           update to Netcdf.c vsm
           bug fix to GrADS, geo vsm
           lat-lon now double precision vsm
           I realized that I have been neglecting to put vsm's
               netcdf contributions into the Change log.
                       The change log should be all contributors, not mine.
2/2008           -vector_dir prints whether N/S or grid winds
           ffopen added, allows multiple opens to same file
           -if works (previously just stub)  
                       -if REG_EX -grib file    will do -grib if REG_EX
           LatD for lambert-conformal vsm
           updated Sec3 vsm
           make verification time consistent with grads (pdt=8) now at end of interval
    `      -grid -scan now shows the output_order as well as input order (scan)
          makefiles .. -lm put at the end of ldflags
          lambertll - used fixed radius of earth (different than normal)
            now uses value from code table 3.2

# v0.1.6.1 2/2008  ---------------------------------------
          minor fix to lambertll (->latD) vsm
                  change to g2clib/makefiles, fix INC= declaration
                  f_h now uses CALL_ARG0, getting ready for double precision decode
          change to makefile_all_libs (use gmake for compiling wgrib2)
                  vsm: bug fix to Netcdf.c (serious bug)
                  vsm: restructuring Netcdf code for use by HDF library

# v0.1.6.2 2/2008  ---------------------------------------
          fixed version code
              thinned grids -> go to "raw" mode,  done by adding 
                      output_type_wanted (fix error in display)

# v0.1.6.2a 2/2008  ---------------------------------------
                 in makefiles got rid of space after -L and -I
                 added grid_def, not_if
                 removed decode flags from grib/GRIB options
            termendous speedup in -grib option 1:41 -> 3 sec

# v0.1.7.0 2/2008 ----------------------------------------
                 added -limit for nomads software
         fixed major bug in -i command, problem if grib file uses
                  submessages and don't extract previous submessage.

# v0.1.7.1 3/2008 ----------------------------------------
         fixed -v -grid, added code table 5.7
         added verf-time for more code-table 4.0 9..14
                 makefiles (Manfred Schwarb) gunzip -n, use &&
                 lola is correctly called an output function
         -V by Manfred Schwarb
         Bbox by Arlindo da Silva
                 update -packing
                 error checking fix scan.c Manfred Schwarb
                 fixed thined grid bug/changed scan order of grib_out 
                      now in grid order (we:sn default)
         sec8 now uses 55 instead of '7' for compatibility non-ascii
         reads single precision ieee-grib

# v0.1.7.2 3/2008 ----------------------------------------
                 -order should now work on 1 x ny or ny x 1 grids (lat/lon do not however)
         fixed broken makefile_all_libs

# v0.1.7.2a 3/2008 ----------------------------------------
                 fixed problem in makefile* (tmp.tar renamed to tmp?.tar)
                 fixed problems in makefile_all_libs
                 for CFSRR: update gribtable, update levels

# v0.1.7.2b 3/2008 ----------------------------------------
        added: -little_endian and -big_endian for ieee output
        -grid: dlat and dlon now use code_table_3.3 to see if undefined
        jpeg packing
        ieee packing
        precision for jpeg
        scaling for jpeg
        various set_ routines
        Manfred Schwarb: big cleanup signed/unsigned, remove extern from wgrib2.h
                    print statements, signed/unsigned conversions in lola/geo fixed

# v0.1.7.4   4/2008 ---------------------------------------- (internal release)
        wgrib.c:  up to 8 parameters for mysql 
        csv.c: added Niklas Sondell, Storm Weather Center
        mysql.c: added Niklas Sondell, Storm Weather Center
        ijsmall_domain, small_domain added
        wgrib2/makefile: mysql support

# v0.1.7.5   5/2008 ----------------------------------------
        added: set_flag_table_3_3 in order to fix some polar stereographic files
        fixed Wrt_grib.c (tail not written)
        fixed small_domain

# v0.1.7.6   5/2008 ----------------------------------------
        fixed small_domain
        fixed problem with makefile_all_libs

# v0.1.7.7   5/2008 ----------------------------------------
        fixed netcdf=0 mysql=1 problem in makefile
        grib_ieee -- keep original scan order
        fixed f_set_date

# v0.1.7.7a   6/2008 ----------------------------------------
        fixed typo in small_domain
        ij_undefined now uses ix=1..nx iy=1..ny
        -stats now has cos-weighted means

# v0.1.7.7b   6/2008 ----------------------------------------
        sec3 - rotated lat-lon/gaussian, rotation pole, streach pole, factor fixed
        upgraded gribtable
        fixed GDS problems with writing *data in we:sn order, now write in original order
           affects -grib_ieee -grib_out
        broken makefile_all_libs

# v0.1.7.7c   6/2008 ----------------------------------------
        updated header to f_ieee
        added Mysql_speed by Niklas Sondell (I can't test Mysql, WNE)
        radar and satellite products now return verf_time
                 updated gribtab.dat
        changed check in nxny in cases of undefined grids
        the default -s is moved from front to back of arg list
        worked on time codes: Product Definition Template 4.8
        added fix_ncep -- support for strange NCEP time codes codes
        added AAIG - support for Ascii ArcInfo Grid files (lat-lon grid)

# v0.1.7.7d   7/2008 ----------------------------------------
        added makefile_all_libs_new, this makefile has
          configuration options in main makefile
        added code_table_4.11
        continued to improve -fix_ncep
        improved Sec4 - time range = 8
        new g2clib: v 1.1.7 (added fix from 1.0.5)
        replaced code_table_3_3 by flag_table_3_3
        jpeg and simple unpacking doesn't use g2clib, use -g2clib to use g2clib
        Jose F. Nieves: Lambert/polar always uses dx&dy. Thanks
        added -match_inv
        changed -match/-not/-if/-not_if to use match_inv instead of -s (added vt=)
        updated Mysql_speed, Niklas Sondell, Storm Weather Center

# v0.1.7.7e   9/2008 ----------------------------------------
        libpng is created as a static library in makefile_all_libs*
          (previously used default: sharded/dynamic library)
        support for NCEP e-grid (grid template=32768)
        added -ctl_ens for g2ctl
        fixed +/- ensemble member (got it backwards)
            changed ens= to ENS=
# v0.1.7.7f   9/2008 ------------------- internal release ---------------------
        makefile_all_libs_new:  libpng: -disable-shared
                    test to see if make == gnu-make
        rm grib2.h in Grib.c
        direct call to dec_png rather than go through g2clib
        Nick Lott - level 241 added
        added png packing info
        updated gribtab.dat (fix LOUV for marine branch) .. update mk_gribtab.sh
        added count function, modified wgrib2.c to send mode == -2 messages to stderr
        added grid_changes .. check for only 1 grid type
        -for option added: select range of records to process
        added -prob

# v0.1.7.7g   10/2008 ----------------------------------------
        added import_text and import_ieee, fixed rdieee_file
        set_data_bin renamed as import_bin
        modified f_lev0 for more levels
        support for PDT=9
        added set_byte
        changed description of fcst/anl ave/acc
          0-6 hour acc -> 0-6 hour acc fcst
        fixed up description for 1 hour anl
        tested decode of ECMWF thinned gaussian files .. allowed now
        fixed bug in g2clib 1.1.7 (AIX)
        wrt_time: century fixed
        fixed grib_out: problem when #bits required > 16
           wrong sign, affects jpeg and simple output
        f_lev0, layer between two hybrid levels added (105)

# v0.1.7.7h   12/2008 ----------------------------------------
        examined all codes that handle the polar stereographic
        projection.  wgrib2, g2ctl and grib2ctl were based on
        the same code which had to be modified to handle
        the south pole projection.

# v0.1.7.7i   12/2008 ----------------------------------------
        warning if find a grib1 message
        Mod_grib.c unsigned char *p -> char *p;
               removed unused utmp
        int8: added flt2scaled
        fixed return Prob.c
        fixed sprintf %@ to @ in sprintf Sec4.c
        units.c added include <string.h>
        Import_text: error messages fixed
        added #groups for complex packing: -v -packing
        replaced integer_power by the duplicate Int_Power

        For a constant field:
            NCEP routines (1/09): data(*) = reference_value
            WMO standard: data(*) = reference_value*10**(-dec_scaling)

        For jpeg/png/simple/complex packing (not spectral), you can get
            NCEP routines (1/09) by -g2clib 1
            WMO standard by -g2clib 0
            The default value of g2clib will depend on the installation

        Modified grib_out so that dec_scale is set to zero for constant fields
          as a result, the constant fields are NCEP-library compatible 

# v0.1.7.8   1/2009 ----------------------------------------
        changed Sec4.c so that when NCEP prints TMIN/TMAX
        old: 264:30420217:d=2004021912:TMIN:2 m above ground:66-72 hour missing fcst:
        new: 264:30420217:d=2004021912:TMIN:2 m above ground:66-72 hour fcst:
        the missing refers to a missing statistical operator (ex. ave, acc, min, max)
        this verion is 1 hour newer than v0.1.7.8 .. for operations

# v0.1.7.8a  1/2009 --------------------------------------------------
        modified -set for better help/error message
        -code_table_4.4 prints units
        fixed normalize_time_units (missing breaks in switch)
        -ftime: enabled product defn template template 11 (ensemble stat processing)
        updated grib table, FRPRATE -> FPRATE, IPPRATE -> IPRATE, add FRZR (NCEP)

# v0.1.7.8b  1/2009 --------------------------------------------------
        linked in g2clib 1.1.8 (change to wgrib2)
        linked in libpng 1.2.34
        f_lev0 .. added level 241 (N in sequence) for WW3 data
            and filled other missing NCEP local levels
        added -fix_ncep_2, NCEP operations has probability for less than negative value
            wrong, used 2's complement to store integer rather than signed number.
            NCEP operations knows of the problem but can't fix it because of 
            downstream software.
        changed -prob: prob>N to prob >N, prob<N prob <N, prob>N <N to prob =N
        -lev0 .. handle factions of a PV unit in control file

# v0.1.7.8c  1/2009 (internal)
        -fix_ncep_2 alters in memory data now, like other fix_ncep

# v0.1.7.8d  1/2009 --------------------------------------------------
        fixed makefile_all_libs_new for nomads.ncep.noaa.gov
        fixed internal simple unpack routine for nbits == 0 and bitmap
        fixed error message for jpeg writing.
        added fix_ncep_3 .. preliminary
        fix_ncep_2/3/4 are now setup function
        fixed makefile_all_libs_new typo:   DEFS+=-DUSE_NETDEF
        added -set_ijval
        fixed -if/-not_if to include all class types (minus setup)
        fixed typo in mercator2ll, removed print statement

# v0.1.7.8e  2/2009 --------------------------------------------------
        added missing makefile to g2clib
        fixed png bug in g2clib (big endian 64-bit only)
        change lambert conformal geo code for orientation angle
           being bigger than +/- pi
        added include <string.h> in Grib.c from Arlindo da Silva
        renamed copy_sec to copy and added copy_data routines
        inv_out[INV_BUFFER] can overflow with help command
        update of grib name table

# v0.1.7.8f  3/2009 (internal release) ------------------------------
        added -wind_speed, prototype for functions to make calculated grib files
        fixed description of -set_ijval
        added -config

# v0.1.7.8g  3/2009 ------------------------------
        added -ncep_norm
        added -unix_time by Pablo Romero
        added -set_rename  (removed 6/2009)
        makefile restructured, added config.h, support for netcdf5
        -config shows last wgrib2 compile (not Config.c compile)
        rename makefile_all_libs_new -> makefile, remove old makefiles
        added some code in verftime for code table 1.2 (sig of RT)
        vertical level description added carets: "Potential vorticity [K m^-2 kg^-1 s^-1]
          to be consistent with grib name descriptions
        updated code table 4.3 .. uses NCEP specific codes
        updated code table 3.1, 3.2, 4.11
        added more info to -Sec4
        fixed -set_var

# v0.1.7.8h  4/2009 ------------------------------
        added -fi (nop output operation)
        undocumented -plus and -times removed to be replaced by -rpn
        -for N is now the same as -for N:INT_MAX:1
        -for N::M is same as N:INT_MAX:M
        added -n -for_n
        added -get_bytes
        fixed -set (broken 1/09)
        updated grib table
        mastertab between 0..4 is set to 1 in cname
        added -rpn
        fixed problems with -set_lev, handles pdt=0..14 (old=0 only)
        update level.c
        init_sec added to NCEP_norm, Wind_speed.c
        Netcdf.c added more filtering illegal characters in names

# v0.1.7.8i  5/2009 ------- old version posted on web site, posted for couple hours and replaced by 1.7.8j
        -Sec_len shows correct section 5 length
        change in g2clib makefile to use ${CFLAGS}
        removed -set_rename
        moved (config.c,Configure.c) -> Config.c & modified makefiles
        new gribtable

# v0.1.7.8j  6/2009 ------------------------------
        removed a debug statement in geo.c
        added semicolon after match_inv 
        N_ens works for more pdts
        more table specific code should be moved to Code_Values.c
           f_lev, f_lev0 use fixed_surfaces()
           this is in preparation for chemistry templates.
        Sergey Varlamov: add netcdf4 to Netcdf.c etc
        Reinoud Bokhorst: added -tosubmsg, thanks
        Fix rd_grib2_msg: Reinoud Bokhorst pointed out that code table 
           6.0=254 was handled incorrectly
        Reinoud Bokhorst: added Checksum.c and crc32.c  thanks
        move reftime to Verftime.c, mod f_csv, AAIG, Sec1, Mysql
          to use reftime
        modified codetable_5_5, diagnostics for substitute missing 
          values complex packing
        Reinoud Bokhorst: Scan.c, fix translation tables with 
            multi-scan files and grib_out
        Reinoud Bokhorst: Grib.c, fixed sec[5] n points
        Reinoud Bokhorst: 0xSec check size of output writing to inv_out
        Pablo Romero: fixed a bug in makefile for mysql = -> +=
        Mod_grib: added extern to use_scale, dec_scale, bin_scale
        subtle change in min_val of grib_out routines now making a 
            new file reproduces old file
        changed -processid to add observational process id, new format
        added -spectral_bands (no test data)
        added internal code for for complex decoding
        added internal code for complex packing
        changed format of -packing -v for complex packing

# v0.1.8.0  8/2009 ------------------------------
        added data packing 200 - run length - preliminary
        added get_int
        fixed grib_out (jpeg/simple) when has binary scaling is used
            old: i = (int) (max_val - ref)*scale + 0.5;
            new: i = (int) ((max_val - ref)*scale + 0.5);
            found by a loss of precision
        restructured grib_out

# v0.1.8.1  8/2009 ------------------------------
        f_set_ftime now alters code table 1.2 and 1.3
        f_time now calls a2time_range
        f_metadata calls f_time or f_ave    
        f_RPN: added print_{min,max,rms,corr} corr/rms are 
            cosine(lat) weighted
        modified wgrib2, all functions (not just inv) can write to 
            inv_out in during execution
        added yrev to RPN.c, only applies to we:sn and we:ns files.
        added set_metadata: added field: scale=Dec_scaling,Bin_scaling
        unpk_run_length: fixed typo in bitmap secion
        set_lev: added: x m underground, x-x m below ground
        best_scaled_value: now handles zero
        fixed get_code*.sh
        added NCEP special levels to f_lev/f_metadata
        geo.c off by one in mercator from Jerry Stueve (VisiTech)
        mysql: tmpnam -> mkstemp from Jerry Stueve (VisiTech)
        mysql: LOAD LOCAL from Jerry Stueve (VisiTech)
        added f_set_pdt
        fixed undef_val? in fixed_surfaces, affects -v2 -lev

# v0.1.8.2  11/2009 ------------------------------
        fixed f_domain for domains that cross the prime meridian
        set_ave: "added N@N hour ave anl, missing=0",  "N@N hour ave (N hour fcst),missing=0"
        added if_n
        if_reg, if_n work if REGEX not installed
        complex_pack: replaced (int) (... +0.5) to floor(...+0.5)
        updated gribtab.dat, updated get_gribtab.sh
        updated Latlon to print out i, ix, iy for -lon when mode > 0
        -packing now shows abreviations (good for saving the packing type)
        -fix_ncep .. handle more of ncep table 4.10 codes
        added ncep level 236-236 for cfsrr (cnvgribcfs)
        added set_lev support for "N-N m below sea level", "(N)C ocean isotherm"
        removed (m) from "bottom of ocean mixed layer" "bottom of ocean isothermal layer"
            in CodeTable_4.5_ncep.dat (manual edit) NCEP_local_levels_test.h
        support for pdt 4.15, some additions for 4.13 and 4.14 in the CodeTables
        comments that bitstreams are supported up to 25 bits
        fixed set_lev "X-Y mb"
        fixed a bug in if_reg that was introduced in code cleanup
        added -start_ft .. for use with -b option in gribmap
        from Manfred Schwarb: include "mysql.h" -> include <mysql.h>
            Wrt_grib .. replaced strncat/strncpy with test & strcat/strcpy
            Mod_grib .. strncat/strncpy with strcat/strcpy (internal tables no need to 
                worry about bad guys)
        gcc caught problems in f_get_int(), Sec5 and VerfTime.
        from Manfred Schwarb: code cleanup, found bug in f_get_int(), same fix as previous line
            Thanks Manfred.
        replaced Sec5:nval() by #define GB2_Sec5_nval(sec) as part to move details to .h and Code*.c
        added some prototypes that so that gcc wouldn't complain.
        added some cleanup by Manfred Schwarb: RPN, Wind_speed, copy, Csv, Grib, Import, jpeg_pk,
            NCEP_norm, Small_grib, test_sec, unpk, unpk_complex, unpk_run_length, 
            Grads, Netcdf
        changed complex_pk:  size_t -> size_tail, changed size_m and size_h too
        added Manfred Schwarb, level.c: "1000 m above ground - 0 m above ground" -> 1000-0 m above ground"
            level.c: like above, 102, 107 and 108 layers
        -VT -T verbose 2 has new date code format
        added -start_FT
        added -set_grib_type same
        Manfred Schwarb cleanup Macros.c output format
        updated gribtable
        change: "124@6 hour ave (3 hour fcst)" to "124@6 hour ave(3 hour fcst)"
            to be consistent with "124@6 hour ave(0-3 hour fcst)"
    ----- preliminary version sent to NCDC, NCAR
        trailing space in "ocean isotherm layer " removed
        ftime: stat proc, ignore dt when units == 255 added is one case
        from Manfred Schwarb: fixed spelling errors, error messages in RPN and others
        -rpn: added ln, exp, ceil, pow
        from Manfred Schwarb: added extern, extern double *lat, *lon;
        from J. Johnston: space in makefile broke Mac compile, repeated previous missing "extern"
        set_ave: removed space from "ave (" -> "ave("
        Set4:  max valid 10-11 hour -> 10-11 hour max anl  -- consistent
        from Manfred Schwarb: Range, added unsigned: extern unsigned long int len;
        added more set_ave formats .. need more
        removed some changes to fix_ncep .. doesn't work for all cases
        Manfred more guard bits in jpeg2000 encoding - fixed jpeg_pk.c

# v0.1.8.3  3/2010 ------------------------------ 
        bug report from Manfred Schwarb: increase size of new_sec4 from 58 to 70 in Mod_grib
        from Manfred Schwarb, cleanup AAIG Bbox Checksum Cyclic Data LatLon Macro Sec3
            Small_grib Wrt_grib complex_pk geo, wgrib2 etc
        added set_grib_max_bits 
        -rpn: added acos, asin, atan, atan2
        -lev0: added "Xcm" for "X meters depth below land surface", corresponding to X_Ycm
        -lev0: added "clm" leve1 == 1 && level2 == 8
        debug: added seq_input .. need to remove later
        with Manfred Schwarb: added different flavors of regex, added -set_regex, mod match, not, if, not_if
        -set_ave: now understands '120@6 hour ave(anl),missing=0'
        added v98 to get debuging from -rpn
        Sec4: 1@1 month ave(120@6 hour ave)(0-6 hour ave fcst) -> 1@1 month ave(120@6 hour ave(0-6 hour ave fcst))
        set time to "anl" for radar and sat data pdt= 4.20, 4.30, 4.31
        added -spatial_proc for pdt 4.15
        added preliminary -spectral for satellite info for pdt 4.31
        changed ave: problem with making climo of feb-monthly means (leap years)
            change code to use reference time rather than validation time for "expectation"
        bitstream.c -- replaced error message for n_bits > 25 bit by 32-bit-cpu && n_bits > 25
        added grib to -lola 
        CHECK code (wgrib2) is improved
        preliminary code to use  latlon->ij codes, used by closest and closest_init
            only lat-lon grid supported right now
        -lola, -lon: now sensitive to lat/lon outside input domain
            will print UNDEF values lat/lon = 999 if request
            is outside the input domain and latlon->ij code is
            used.  need to consider other interpolation
            methods and vector interpolations
        fixed -grib_out: now use the append flag
        updated set_metadata
        modified wgrib2's copy of g2clib 1.1.8, added new code from NCO's g2clib 1.1.9 (template 4.15)

# v0.1.8.4-testing  5/2010 ------------------------------------------------

# v0.1.8.4  5/2010 ------------------------------------------------
        updated set_pdt to handle pdt 4.0 .. 4.31
        fixed set_date when PDT had stat_processing: only worked if pdt=8 && n=1
        old: master table <=4 is set to 0,  new: master table <=5 is set to 0
        changed makefile to use zlib 1.2.5 and pnglib 1.2.43
        updated LICENSEs
        if pdt=40, print chemical type, print msg for pdt=4.7
        modified radius_earth to use user defined radius
        ground work for ncep grid 32689
        -wind_speed: make test for U-V pair more restrictive,  init_sec not used
        -lola old: shape of earth = NCEP default, new: same as input file
        geo.c (projection)2ll: nx, ny, npnts from gdt not external variables
        made uint4_missing compatible with 64 bit machines
        -grid & -V: added vector_dir (N/S) or (earth)
        RPN: sets use_scale = 0, default 12 bits precision
        new_grid: interpolation to new grib2 grids
        sec3_lola() moved from Lola to sec3_grids.c, other grids, functionality
        added interpolation package

# v0.1.8.5  6/2010 ------ removed from web site .. incompatible with g2ctl --------------------------
        Manfred Schwarb: some cleanup patches,
        lev0 & hybrid layers:
            old hybrid level: hlevN -> hyN
            old hybrid layer: hlN_M -> hyN_M
            old hybrid layer: hlNp5 -> hyNp5
            old scheme was confusing and inconsistent
            done because h-ell looks like h-one
        new_grid: added gaussian
        fixed set_ave: "N-M hour ave anl"  used a hour time range
        added -new_grid_winds (grid|earth), only checked for lambert
        RPN.c: free stack when finished
        match inventory better: f_ens() -> f_misc()
        added support of multi-model ensemble from "ENS=?" to "MM-ENS=(run number)"
        change undefined ensemble info from "ENS=?" to "ENS=? table4.2=I pert=J"
        updated gribtab, two new variables, FROZR and TSNOW
        interpolation: gfortran support added, a few more NCEP grids
        g2ctl fix: -grid & -V: winds(N/S) -> winds(N/S):  and winds(earth) -> winds(earth):

# v0.1.8.6  7/2010 ------------------------------------------------
        sec3_grids,  added if (x0 < 0) x0 += 360;
        complex_pk: added code to modify section size, more compressed
        radius of earth code table 3.2=3: convert from km to m
        added -radius .. shows earth radius and major/minor axes
        added -set_radius, need to add user defined radius/minor/major axes
        -new_grid: added varibles ftn_npnts and ftn_nout for removing error messages 
            from AIX compiler
        fix problem with USE_REGEX = 0: reported by Y. Tosa
        added -if_rec option and parse_loop() code
        modified for, for_n, if_n to use parse_loop()
        mod: code_table_3_11, added new entry, changed old entry
        modified add_date.c, old: feb30 = jan1 + 1 month, now feb28/29 = jan1 + 1 month
        added -ncep_uv
        updated gribtab 10/1/2010
        added new operator to RPN.c:  alt_x_scan
        new_grid: fixed lambert conformal, polar stereographic (mk_kgds)
        fix AAIG: Hermann Peifer - longitude correction
        Macro.c -misc .. colons use  between fields rather than spaces
            affect inventories
        if fatal decode .. error message suggests to use -g2clib 0
        AAIG: new filename convention .. use extended names
        new_sec3: better precision (int) (X) -> (int) floor(X+0.5)
        cleanup WNE
        Rare bug in input routine: fails if NJB > max(64K,MGML)
           NJB = number of junk bytes between grib messages
           MGML = maximum grib message length prior to the problem
           In practice, nobody puts that much junk bytes between records.
        updated code_Table 4.3
        ExtVar.c - code for extended variable names -- getExtName can getName, -set_ext_name 0/1
        -csv, -netcdf now uses getExtName
        ECMWF uses funny table when master table <= 4.  Flag and remove defn.
        f_misc: missing chemical was "??? see code table 4.230" now "(number)"
        g2clib v1.2.1 (bug fixes ported)
        NOTE: rotated lat-lon grid: location is ALPHA adaped from grib2ctl.pl
        space projection - grid parameters are printed out

# v0.1.9.0  11/2010 ------------------------------------------------
        added ext_name to the match_inv
        -set_date: simpler code, fix seg fault, added date check, use old date code if not specified
            to change year -set_date YYYY, to set year and month, -set_date YYYYMM
        Ext_var.c undefined chemical changed from (1) to chemical_1
        added UDF.c, modified Config.c
        new_grid: added undefined wind rotation, improved error messages, 
                    fixed problem with V without U
        prelim support for grid template 3.130
        RPN: exc/swap .. was fixed but fix got lost (3/2012)
        cname.c  old alias master table <= 5 to current table, now range is 8
        added -set_lev "10C ocean isotherm"  (was "10C ocean isotherm level")

# v0.1.9.1  11/2010 --------- unplanned early release
        ---- NCEP operations plans to use master table 5 in Feb 2011 and 6 in June/July 2011
        ---- release support for master table 6 ASAP so people have time to upgrade

        removed free_sec4, not needed
        added -get_hex, -set_hex
        added -set background_process_id and -set analysis_or_forecast_process_id
        added -set_int
        added a check to geo for bad dlon in mercator2ll, should add more checks
        Manfred Schwarb:
            makefile cleanup
            multiple defn of msg_no, inv_no
            missing include <string.h> in complex_pk.c
            UDF.c : missing close
        f_csv, f_udf : added inv_out[0] = 0 before call f_XXX(CALL_ARGN);
        replace extern int new_GDS by extern int GDS_change_no.  (Handle -if bug)
          mod: grid_summary, lola, ijbox, ij, ijlat, ilat, lon, mysql_dump, mysql_speed
        new_grid: if negative x0 (longitude), add 360
        ncep_grid.c added grid 128 gaussian T382
        pipe support: flush_mode is for output pipes, seq_in_mode for input pipes
            -tosubmsg with flush_mode is now error
            wgrib2.c: recognize - as a synonym for stdin
            wgrib2.c: use -v98 for debug of code to recognize input grib type
            flag:  seq_input - can only read grib input sequentially
            wgrib2.c rd_grib_msg: add sequential reads
        makefile works with new cygwin 1.7.7-1
        changed error messages -ave, -NCEP_norm
        changed error message  "Warning: g2lib/g2clib jpeg deocde may differ from 
                    WMO standard, use -g2clib 0 for WMO standard
        updated gribtab.dat from NCO website
        changed set_date to new syntax: -set_date INITIAL_DATE:DT:BLOCKSIZE
            DT > 0   BLOCKSIZE > 0, compatible to old syntax

# v0.1.9.2  3/2011 --- withdrawn
        1st attempt at fixing set_date

# v0.1.9.2a  3/2011 -- withdrawn
        2nd attempt at fixing set_date

# v0.1.9.2b  3/2011 ---- withdrawn
        restore to 1.9.1 set_date, the new set_date worked but conflicted
        with the use by set_metadata

# v0.1.9.2c  3/2011 ------------------------------------------------
        added set_ts_dates 
        added Table 4.5 values 118 and 119 to Levels.c
        added code to detect wrong size of section 7 for simple and IEEE packing
        changed initial value of ipopts(2) from 0 to -1 (good for budget)
        in Latlon.c fatal_error("no val","") change to be more informative
        f_radius, fix when code_table 3.2==3 
        added axes_earth()
        closest: changed initial value for j to -1 in search for closest point
            in case field is all NULL
        note to developers: undefined lat/lon is now 999
           will change a format for -lon when outside of grid domain
        Config.h print MATCH_MAX, INT_MAX, ULONG_MAX
        increased MATCH_MAX 1000, N_ARGLIST  5000
        verftime(): support code table 1.2=3 (observation time)
            f_lev0() 2.5C ocean isotherm -> "2.5C" (old),  2p5C (new)
        Mysql_dump, Mysql_speed: replaced char temp_pathname[L_tmpnam]
           by char temp_pathname[STRING_SIZE] bug found by Alexander Ryan
        space_view: prelim space_view2ll and space_view2ij added
        added better error message when ipolates fails
        when table 4.11 == 2 for the outer loop, fix time stamp
            old: 2@3 hour ave(180-183 hour ave fcst)
            new: 2@3 hour ave(180-183 hour++ ave fcst)
            old version can be confused with table 4.11 = 1
        new convention for ftime
        when table 4.11 == 1  ...ave(...)
        when table 4.11 == 2  ...ave(...)++
        when table 4.11 == 3  ...ave LAF[...]--
        when table 4.11 == 4  ...ave LAF[...]++
        when table 4.11 == X  ...ave ?[...]
          this affect product definition template 8
        set_pdt: added more default sizes, add -set_pdt +N, copys 
                     parameter category and number
        prt_stat_tr: if Code Table 4.11 = reserved, ":reserved:" -> "CodeTable 4.11=reserved"
        prt_stat_tr: if Code Table 4.11 = missing, ":missing:" -> "CodeTable 4.11=missing"
        wgrib2.c do not print warning about g2clib/g2lib bug when reference value == 0.0
        added -n to f_match_inv().
        support for silly ncep grid 32768/32769 non-E grid.
        version 1 that was sent to eumetsat-data testers
        Netcdf.c: rewrote error message for -nc4 and netcdf4 not avail
        fix code to handle lat/lon == 999: f_domain(), closest_init(), closest()
        update makefile for hdf 1.8.6 and netcdf 4.1.1
        config() says version of Netcdf installed
        prelim version f_new_grid_vectors
        ffopen(): error check, - can be used for stdin, check for read & write 
                    of same file set flush_mode = 1 if output to a pipe or stdout
        Sander Hulst: Netcdf.c #if defined USE_NETCDF3 #undef NC_NETCDF4 $endif
           netcdf.h: NC_NETCDF4 .. implies netcdf v4 code
           Netcdf.h  NC_NETCDF4 .. implies support for netcdf4 file types
           3 lines patch converts netcdf.h to Netcdf.c defintion
        f_set_ave(): 3@1 hour XXX(0-1 hour max YYY),missing=0 .. XXX was replaced by YYY
        beta2:EUMETSAT  data testers
        f_set_ave: added, 0-1 hr ave(0-1 hour ave fcst++), 0-1 hr ave(1 hour fcst++)
            prt_stat_tr: added code ++ in 10-20 ave@1 hour fcst++
        seekgrib(): scan whole file for grib2 message, changes for grib1+grib2 ECMWF files
        added -fcst_ave

# v0.1.9.3  5/2011 -------------------------------------------------
            O. Poplawski: Netcdf.c #if define USE_NETCDF3 -> #if defined USE_NETCDF3

# v0.1.9.3a  5/2011 -------------------------------------------------
        added set_sec_size, allows you to remove section 2, realloc(sec4), build new GDT
        Internal match_inv had n=0..N rather than n=1..N-1, can break code if used =-if ":n=22"
        -set_flag_table_3.3 and -set_flag_table_3.4 are on default help screen
        support for irregular grids (grid template 3.130), irr_grid2ll() and Sec3.c
        removed error messages if stat(input_grib_file) fails
        added more info about Albers equal area projection
        prelim Cressman analysis
        got sample pdt 4.15: update -spatial_proc with verbose setting
        got sample pdt 4.15: -V, -verf : replaced f_ens() by f_misc()
        unget_input() .. fixed check for programming error
        -cvs add code to init vt[]
        cname.c: make parameter category >= 192 local, pointed out by Alister Long
        added WxText (NDFD local section 2 keys) to various functions
            -ij, -ijlat, -ilat, -lon, -csv, -spread
        Grads.c -ctl_inv to support template 4.15
        code_table_4.15: fix help message
        added -set  table_4.10 and -set table_4.11
        if n=1 and pdt 4.8 and code table 4.11=1
            :53-59 hour acc anl -> :53-59 hour acc fcst,anl++:
        code_table .4.11  3 and 4 need to be done right .. need convention
        dlat/dlon for lat-lon grids are changed from signed to unsigned values
            compatibility with ECMWF
        -Sec_len, if submessage and a repeated sec2/3 then *
        to_we_sn, to_we_ns, ij2p, check for valid scan
        Macro.c change f_ens() to f_misc()
        added end_inv and -crlf
        made on_line into a setup module
        changes for open64 compilers: opencc and openf95
        default optimization is -O3 from -O2

# v0.1.9.4  8/2011 -------------------------------------------------
        Spectral_band.c.. fixed sprintf to write to inv_out
        cleanup for openCC (C++), casts, and declarations,
          made argN: char * -> const char *
          had to add char *tptr for Netcdf_supp.c, changed set_metadata, replace arg1 by p
          removed code to test for cyclic on mercator grids .. not right
          did not fix ARG1..ARGN
        small_grib: added mercator and rotated lat-lon grids
        set HEADER:-1 for some uncommon options
        config.h added code to makefile for c and f95 compiler names
        -rpn: added print_diff, fix last_lat code: speedup no output difference
        Netcdf.c: changed illegal netcdf name code, turned off _FillValue for time variable
          added more units 
        fixed bug in -wind_speed introduced 1.8.5
        for pdt=5/9 .. change units to prob, for pdt=6/10, change units to %, affect NETCDF code
        irr_grid: limit -grid output to 300 lat-lon pairs otherwise inv_out would overflow
        added -grib_out_irr, write irr_grid grib message
        -set_ftime did not correctly set code_table 1.4 for forecasts (affected -set_metadata)
        added end_ft and end_FT which correspond to start_ft and start_FT
        added subtime.c which subtracts date codes and corresponds to addtime.c
        change print_ftime: format with unequal units .. add closing )
        change print_ftime: "(0 month+26 day)" -> 26 day  when 1st arg is 0
        change 0 month- 0-1 month ave@(6 hour fcst)++  -> 0-1 month ave@(fcst,dt=6 hour)
        added -fix_CFSv2_fcst
        changed start_ft, start_FT help message
        added -set_ens_num, -set_ensm_derived_fcst
        f_misc: added check for code table 4.3 - add "forecast/analysis error" if needed
                -------- new inner loop time code table 4.11
            code table 4.11 = 1:  29 day ave @1 day(420 hour fcst),missing=0
            code table 4.11 = 2:  420 hour-(420 hour+29 day) ave@(fcst,dt=1 day),missing=0
            code table 4.11 = 3:  ensemble ave-3 valid 420 hour,missing=0
            code table 4.11 = 4:  ensemble ave-4 valid 420 hour,missing=0
        fixed doc line for set_int
        updated help for -set_radius

# v0.1.9.5  12/2011 -------------------------------------------------
        -set_ave: old 28@1 year ave(120@6 hour aveanl),missing=0
              new 28@1 year ave(120@6 hour ave(anl)),missing=0
        O. Poplawski: in the "cleanup for openCC (C++), casts, and declarations", a typo in Mysql_speed.c

# v0.1.9.5.1  12/2011 -------------------------------------------------
        -radius fixed format: "IAU 1965 ave radisu=%.1lf m" to "IAU 1965 ave radius=%.1lf m"
        -radius fixed format: "oblate spheroid user defined major axis=%.1lf minor axis=%.1lf ave radius=%.1lf"
           to "oblate spheroid user defined major axis=%.1lf minor axis=%.1lf ave radius=%.1lf m"
        geo.c: lambert2ll .. fixed case where grid is not WE:SN
        geo.c: polar2ll .. fixed case where grid is not WE:SN
        rd_grib_msg: added code to check that section length >= 5 
        WxTalk: added support for grib variable: PWTHER (ncep + mdl)
                Regional Gaussian grid support:
           Small_grib: added Gaussian grid
           cyclic(): added gaussian grid (not thinned), modified ERROR 
           grb2.h added GDS_Gaussian_dlon 
           mk_kgds() .. allow regional gaussian grid
                   enabled everywhere except writing by IPOLATES
                preliminary work for using gctpc for geolocation
                makefile changes for gctpc, optimizations passed onto wgrib2, gctpc
        added log prescaling data template 5.61
        -misc includes chemical type for template 40..43,48 (before: only 40)\
        support for PDT 4.48
        calling convention for get_latlon (make library compatible)
        added code table 4.91
        fixed  -spectral_bands (note: no data to check)
        Earth.c  fixed translation of scaled numbers (no effect on output)
        2/10/2012: update gribtab, need to filter greek char and validation 
        prelim for code table 4.52 validation
        added location for code table 4.5 a/b, changed fixed_surface to use code_table_4_5a_location
        code_table_4.3 added location
        cname.c, get_gribtab.sh: search_gribtab fixed, problem with param cat >= 192
        OpenMP added to code
        makefile: NCEP CCS - fortran compiler changed xlf -> xlf_r, openmp
        changed f_set_var to search for mode >= 0, eliminate set_var(), use center when local table search
        support for template 4.52
        version 2 of extended variable name
                   from -misc:  colon -> period, space -> underscore
        version 2 of full
           (new extended name).(-lev)   space -> underscore
        extended name will be used when if flag is set (-set_ext_name 1): -s -S, -verf, -V, -csv,
                    -AAIG, -netcdf
        added a couple of lev0 defn: clm cb top, cb bottom
        if pdt == 44 or 48, use internal decode routines until g2clib support
        New_grid.c, makefile: intel fortran support
        Jeff Smith: patch for azimuth-range projection - Thanks Jeff
        added to variables to RPN: days_in_ref_month, days_in_verf_month
        fix f_fcst_ave, wouldn't handle more than one averaging time
        rpn: swap now works.
        gctpc: change proj.h, redefine sincos() -> gctpc_sincos() because
          would crash gcc 4.4, gcc 4.6 and icc

# v0.1.9.6  5/2012 -------------------------------------------------
        found by N Lott: conflict with Mysql:  changed check_date() -> check_datecode()
        found by N. Lott: conflict with Mysql:  days_in_month() -> num_days_in_month()

# v0.1.9.6a  5/2012 -------------------------------------------------
        gribtab.dat var0o7 -> SWDIR, error introduced v1.9.6, Thanks N. Lott
        Dusan Jovic (NCEP): added -gdt
        Dusan Jovic (NCEP): updated grb2.h mk_kgds.c for NCEP grid 32769, 32768
        updated CodeTables.c for NCEP grid 32769, 32768
        changed all center == 7   to center == NCEP  (same for ECMWF)
        Mod_grib.c: f_set():  added table_3.2, fixed problem when XX_loc(sec) returns NULL        
        New_grid.c: change error messages, add mercator
        sec3_grids.c: removed the creating the lat-lon values, remove last two args
        change Cress_lola.c, New_grid.c, Lola.c: sec3_lola .. few args
        use zlib 1.2.7
        Aerosol: allow for undefined intervals
        prt_code_table_4_91:  7:  X-Y  becomde >=X,<=Y, confusing in names
        makefile: use $(notdir $(FC)) and $(notddir $(CC)) instead of $(FC) and $(CC)
        gribtab.dat:  fixed POZ TOZ and POZT (added names)
        change cname.c "ERROR: local table=D" -> "ERROR: local table=0"
        fixed f_ctl_inv() for template 48 (levels)
        fixed: code_table_4.233, fixed PDT=48, use table 4.233 rather than 4.230
        fixed Sec3.c mercator grid: old: input WE:SN raw output rawoutput WE:SN res 48
                     removed "raw output  raw"
        Extname.c: table 4.3: added 9: climatology, 192: confidence Indicator

# v0.1.9.7  11/2012 -------------------------------------------------
        changed wgrib2 fprintf(inv_file, item_deliminator); to 
                      fprintf(inv_file,"%s", item_deliminator);
                changed grid_id.c to grid_ident.c because of MacOS problems 
            (grid_id.c == Grid_id.c)
        minor bug fix in g2clib
                updated version from 1.9.7-beta to 1.9.7a

# v0.1.9.7a  11/2012 ----- Mac Release ------------------------------
        small cleanup of makefile (C. R. Ferguson)
                changed g2clib = 0 -> internal decoders, 1 -> emulation of g2clib bugs, 
                2 -> g2clib
                added USE_G2CLIB, include/exclude g2clib decoders (still uses 2 small routines 
           from g2clib) result of changes: g2clib decoders are not used for decoding 
                   unless enabled In the future, g2clib decoders will be eliminated from the
           default configuration. (Needed for the debug configurations.)
        added -wind_dir
        minor edit of set_ts_dates (HEADER line) and error message string
        add rand to RPN.n returns uncorrelated random number field 0 to 1
        fixed OpenMP for unpk_complex.c, some optimization of unpk_complex
        removed OpenMP from iplib.2012. Never had a problem but C->fortran
          is already a problem.  Why add a complication?
        fixed makefile:  make clean
        cleanup GDT.c
        -ave, -fcst_ave: support pdt 4.1 (ensemble fcsts)
        added unsigned char *code_table_4_4_location(unsigned char **sec)
          updated with new pdt
        codetable 4.7 now has text descriptions
        updated f_ens for new codes
        -set_ftime works with more values of pdt
        updated Code_Values: forecast_time_in_units 
        struct gribtab_s -> struct gribtable_s: added range of valid mastertables
            useful for handling distinct mastertables
        added user gribtables: setup_user_gribtab, mod: wgrib2, Mod_grib.c, cnames.c, Config.c
        update to iplib.2012 to handle larger gaussian grids (from WCOSS version)
        fixed error message from -import_bin
        added -err_bin, -err_string, -eof_bin, -eof_string

# v0.1.9.8  5/2013 -----------------------------------
        fixed "decode" spelling mistake
        fixed code_table_0_0: reported by Matthew Foster, only affected -code_table_0.0
            and -disc (alias to previous options). All other codes used a macro
            which was correct
        update year code on Changes file
        updated makefile for new version of netcdf4
        fixed Ext_name.c for code table 4.3: added prob fcst, climatological thanks Manfred Schwarb
        added various Gaussian grids to ncep_grids.c
        better error message, f_g2clib
        can turn off png and jpeg2000 support by makefile
         if turn off png, jasper, proj4, netcdf3 and netcdf4, no external 
         libraries that need to be configured.  good for cross-compiling.
        0xSec fixed section number output for mode >= 2
        added lambertc grid defn for -new_grid: new_grid_lambertc, modified New_grid.c
        added radius_major and radius_minor to struct local in New_grid.c, so lambertc
          calculations don't have to be repeated if already done
        Wrt_grb.c fprintf(c,"#define PRODUCTNUMBER %d\n",i+9); -> fprintf(c,"#define PRODUCTNUMBER %d\n",i+10);
        use zlib-1.2.8
        fixed same_sec4_nottime (test_sec.c) .. fixes -ave, -fcst_ave for pdt 8 and 9
            works for pdt 0.15  bug report:  K. Havener .. thanks

# v0.1.9.9.beta3  8/2013 -----------------------------------

# v0.1.9.9  9/2013 -----------------------------------
        Prelim support for grid templates 3.4, 3.5 and 3.12
        update gribtable SWEATX ->SX, AMPFLX->ANPMFLX, APEMFLX->ANPEMFLX, AOSGO -> ASGSO
                   EVERF -> EVGFC, DECF -> DECFC, KSSEDW -> KSSEW,
                   gone: "2DSED" "FSEED" "DIRSED" "HSIGN" "PKDIR" "MNSTP" "DMSPR" "WFFRAC" "TEMM1"
                   gone: "DIR11" "DIR22" "DSPR11" "DSPR22" "WLEN" "RDSXX" "RDSYY" "RDSXY"
            7: name changes, 17 deletions, new variables added 32 differences total
                   TYABA lost description, new variables, some defn changed
        renamed VERSION to WGRIB2_VERSION
        isdigit(c) -> isdigit ((unsigned char) c)
        isalpha(c) -> isalpha ((unsigned char) c)
        tolower(c) -> tolower ((unsigned char) c)
        added -get_int2 -set_int2, -get_ieee, -set_ieee
                changed help for get/set_byte/hex/int from location to octet
        update to gctpc: changes by Orion Poplawski (Fedora)
        support for ens pdt: test_ts_dates.c, NCEP_norm.c test_sec.c, Sec4.c, Code_Values.c
           CodeTable.c
        mk_kgds.c: fix to 32768 and 32769 rotated lat-lon E and B staggered Arakawa grids
           old code didn't set flag table 3.3 correctly, didn't handle grid winds
           reported by NCAR.
        major changes to -merge_fcst: supports ensembles, many changes, old code had
            problems
        wind_speed, wind_dir: old: failed if mastertab > 6, now works for all mastertab != 255
            ie local table      
        Grads.c: f_ctl_inv, change probability numbers to keep trailing zeros  3 and 30 were
          causing grads variable name to be aliased .. can stll happen if scaling factor isn't constant
        Grads.c: f_ctl_inv prob interval was fixed a2,first,first -> a2,first,second
        set_ftime: all pdts now
        wgrib2/makefile: compile Mod_grib.c with ${FLAGS} instead of ${CFLAGS}, minor fix
        set_date: updated for more PDTs.
        f_code_table_4.11s: added
        -set_ens, so that -1 to be no change
        fix -udf_arg buf[2]
           want all calls to f_*() to use call_ARGN(buffer, NULL, arg1..argN)
           if (local == NULL) then call is recursive. must examine code to check local not used!              
        all code: CALL_ARG{N} -> call_ARG{N}
        netcdf/mysql*.c:  f_lev(...) -> f_lev(call_ARG0)
        wgrib2: f_match_inv(..) -> f_match_inv(call_ARG0) f_help -> f_help(call_ARG0)
        added -set table_4.3
        added -Werror=format-security to makefile by suggestion of Orion Poplawski
        modified   sprintf(inv_out, string) to sprintf(inv_out,"%s", string) by Orion Poplawski
          this changed -ens code 4.7  10 -> 10% 50 -> 50% and 90 -> 90%
        rpn: ln is fixed, popped stack by mistake
        added -Werror=format to makefile
        removed unused variable from geo.c 
        deleted empty file help.c, pot case insen fs prob found J. Taylor
        support for code table 3.20
        better but incomplete support for cross-section grids
        updated gribtab again.  web page copy needs to be edited by hand because Boi is not consistent
        update Grads: f_ctl_inv .. handle pdt == 15
        removed -Werror=format from makefile (jasper would not compile)
        Cyclic.c updated for mercator and thinned grids
        Scan.c removed unused int scatter
        experimental staggered bits support: stagger.c geo.c grb2.h, mk_kgds.c
        removed: int packing_nx() from jpeg_pk.c, optimization that probably never gets used
        added: inv_f77 in Macro.c
        added: new item to match_inv npts=
        added: BUILD_COMMENTS to makefile, Help.c and Config.c and customization comments can add here
            wanted for special hwrf build
        fixed: mk_kgds for grid 203 id mass and wind fields
        updated producedure for making gribtable, add sort and edit, updated gribtable.dat
        updated complex_pk.c static int find_nbits(int i) -> static int find_nbits(unsigned int i)
            minor speed ups, cleanup
        Earth.c  added code table 9. set_radius now handles user defined radius, major minor axes
        int8.c best_scaled_value() uses maximum scaled value < INT_MAX
        Netcdf.c  Fixed latlon grid longitudes.  COARDS wants longitude to be
           monotonic and left longitude can be any value. However, Some codes will not
           will not handle a left longitude of 180.5 but will work with -175.5.
           So left longitude is set to [-180,180) and longitudes are monotonic.
           Problem found by K. Havener who also did the testing.
        complex_pk: added nstruct (instead of ndata) for malloc of list and list_backup, save RAM
        fcst_ave: added test for valid dtime
        ave_test: added test for valid dtime
        rdieee: added to for read completion
        removed rd_bitstream(), 
        renamed rd_bitstream_offset() as rd_bitstream(), added 31 bit support
        removed rd_var_len_bitstream(), mk_bitstream()
        changed error add_bitstream to n_bits > 25, added error msg to add_many_bitsteam()
        Gctpc.c - enabled Albers equal area projection
        Gctpc.c - added staggering to gctpc_get_latlon
        stagger.c - added x[] and y[] args to stagger(), altered geo.c and wgrib2.h
        added support for staggered grids
        added set_ival
        updated set_ival to support a list of pointsZ
        complex_pk.c free(u) early, reduce footprint by 4*ndata bytes
        int8.c best_scaled_value() increases scaling (giving more precision) as long as 
                   val-floor(val) != 0 and val/10 < INT_MAX, this means val=1000 is kept as 1000.
           NOTE: the scaling factor and scaled value changes from previous versions of wgrib2
           NOTE: the scaled level1 and level2 have changed .. more precision
        gribtable: two SOILM with two different units kg/m/m and kg/m/m/m, both are deprecated
           rename SOILM (kg/m/m/m) to SOIL_M, so grib1 and grib2 tables are the same
           it is a deviation from NCO tables but NCO hasn't made a decision
           NOTE: SOIL_M is not in NCO tables    

