# -bin

## Introduction

The -bin option writes the grid values to a specified
file in binary format (C: float, Fortran: real). The default order is
WE:SN (see -order option) with f77 header/trailer (see -no_header).
The undefined value is 9.999e20. The file format remains unchanged from
wgrib except the order of grid points can now be specified.

When the header flag is on (default, or by the option -header),
, the header consists of an integer with the byte count of
the data. The size of the integer (4 or 8 bytes) depends on the native size
of the integer. Usually this size is compile time option. This is different
from the f77 header which is generated by -ieee which is always a 4 byte
integer.

When the header flag if off (by the option -no_header), the binary
grid points are written with no header. To read the data, you need to
know the size of the grid.

The default order of the grid point data is WE:SN. The order of
the grid point data can be changed to raw and WE:NS by use of the
-order option.

On most machines, the binary format is either big or little-endian single
precision IEEE.

## Usage

```
-bin file_name
     "-" sends the output to the terminal/stdout (results are unpredicatable in Windows)
```

### Example

```
$ wgrib2 test.grb2 -s | grep ":RH:2 m" | wgrib2 -i test.grb2 -bin data.bin
285:36796469:d=2005090200:RH:2 m above ground:60 hour fcst
```

```

      wgrib               ==>                 wgrib2

      -header -bin -o out.bin                 -header -order raw -bin out.bin
      -bin -o out.bin                         -order raw -bin out.bin

```

The above line extracts the 2 meter RH from file test.grb2 and writes it in data.bin

See also: [-text](./text.md),
[-netcdf](./netcdf.md),
[-spread](./spread.md),
[-ieee](./ieee.md)
[-no_header](./no_header.md)
[-header](./header.md)
[-order](./order.md)

---

> Description: out X write binary data to X

_Docs derived from <https://www.cpc.ncep.noaa.gov/products/wesley/wgrib2/bin.html>_
