% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facility_power.R
\name{simple_power}
\alias{simple_power}
\title{Power Analysis for Cancer Trial Enrollment Intervention}
\usage{
simple_power(
  effect_size = 1.25,
  N = 50,
  tau2_facility = 0.64,
  mean_rate = 11,
  R_boot = 100
)
}
\arguments{
\item{effect_size}{Expected intervention effect size (rate ratio)}

\item{N}{Number of trials per arm}

\item{tau2_facility}{Facility-level variance}

\item{mean_rate}{Baseline enrollment rate (default from empirical data)}

\item{R_boot}{Number of bootstrap iterations}
}
\value{
List containing power estimates and simulation details
}
\description{
Simulates power for detecting effects of interventions on enrollment rates
in cancer clinical trials. Uses empirically-derived parameters from
ClinicalTrials.gov cancer trial data. Uses a literature-based estimate for tau between facilities
}
