% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patient_power.R
\name{run_power_participant}
\alias{run_power_participant}
\title{Run Participant-Level Power Analysis}
\usage{
run_power_participant(
  effect_sizes1 = c(1.01, 1.05, 1.1, 1.25, 1.5, 2),
  effect_sizes2 = effect_sizes1,
  Ns = c(15, 30, 45, 60),
  tau2_trial = 1.19,
  K_trial = 360,
  minority_rate = 0.2,
  R_boot = 1000,
  n_cores = parallel::detectCores() - 1,
  results_dir = file.path(getwd(), "power_analysis_results"),
  seed = NULL
)
}
\arguments{
\item{effect_sizes1}{Numeric vector of main intervention effect sizes (rate ratios)}

\item{effect_sizes2}{Numeric vector of minority interaction effect sizes (rate ratios)}

\item{Ns}{Vector of sample sizes (number of facilities per arm)}

\item{tau2_trial}{Trial-level variance component (default: 1.19)}

\item{K_trial}{Total number of trials to simulate (default: 360)}

\item{minority_rate}{Expected proportion of minority participants (default: 0.2)}

\item{R_boot}{Number of bootstrap iterations (default: 1000)}

\item{n_cores}{Number of cores for parallel processing (default: all cores - 1)}

\item{results_dir}{Directory to save results (default: "power_analysis_results")}

\item{seed}{Random seed for reproducibility (default: NULL)}
}
\value{
A list containing:
\describe{
\item{power_table}{Data frame of power estimates by effect size and sample size}
\item{power_plot}{ggplot object visualizing power analysis results}
\item{full_results}{Complete simulation results and convergence information}
}
}
\description{
Performs power analysis for detecting intervention effects on minority enrollment
in clinical trials using participant-level simulations. Developed for ARPA-H
program evaluation of healthcare system interventions.
}
\details{
Uses mixed-effects logistic regression models to analyze:
\itemize{
\item Main intervention effects on enrollment probability
\item Interaction effects between intervention and minority status
\item Clustering of participants within facilities
}
}
\examples{
\dontrun{
# Basic analysis
results <- run_power_participant(
  effect_sizes1 = c(1.25, 1.50),
  effect_sizes2 = c(1.75, 2.00),
  Ns = c(30, 45),
  minority_rate = 0.3,
  R_boot = 100
)

# View results
print(results$power_table)
print(results$power_plot)
}

}
\seealso{
\code{\link{run_power_facility}} for facility-level analysis
}
