% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facility_power.R
\name{run_power_facility}
\alias{run_power_facility}
\title{Run Facility-Level Power Analysis}
\usage{
run_power_facility(
  effect_sizes = c(1.01, 1.05, 1.1, 1.25, 1.5, 2),
  Ns = c(15, 30, 45, 60),
  tau2_facility = 0.64,
  mean_rate = 5,
  R_boot = 1000,
  results_dir = file.path(getwd(), "power_analysis_results"),
  seed = NULL
)
}
\arguments{
\item{effect_sizes}{Numeric vector of intervention effect sizes (rate ratios)}

\item{Ns}{Vector of sample sizes (number of facilities per arm)}

\item{tau2_facility}{Facility-level variance component (default: 0.64)}

\item{mean_rate}{Mean monthly enrollment rate (default: 11)}

\item{R_boot}{Number of bootstrap iterations (default: 1000)}

\item{results_dir}{Directory to save results (default: "power_analysis_results")}

\item{seed}{Random seed for reproducibility (default: NULL)}

\item{n_cores}{Number of cores for parallel processing (default: all cores - 1)}
}
\value{
A list containing:
\describe{
\item{power_table}{Data frame of power estimates by effect size and sample size}
\item{power_plot}{ggplot object visualizing power analysis results}
\item{full_results}{Complete simulation results and convergence information}
}
}
\description{
Performs power analysis for detecting intervention effects on facility-level
enrollment rates in clinical trials. Developed for ARPA-H program evaluation
of healthcare system interventions.
}
\details{
Uses negative binomial mixed-effects models to analyze:
\itemize{
\item Intervention effects on enrollment rates
\item Facility-level random effects
\item Overdispersion in enrollment counts
}
}
\examples{
\dontrun{
# Basic analysis
results <- run_power_facility(
  effect_sizes = c(1.25, 1.50),
  Ns = c(30, 45),
  tau2_facility = 0.64,
  R_boot = 100
)

# View results
print(results$power_table)
print(results$power_plot)
}

}
\seealso{
\code{\link{run_power_participant}} for participant-level analysis
}
