% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facility_power.R, R/patient_power.R
\name{plot_power_results}
\alias{plot_power_results}
\title{Plot Power Analysis Results}
\usage{
plot_power_results(
  results_dir,
  analysis_type = c("trial", "participant"),
  alpha_levels = c(0.05, 0.01, 0.005)
)

plot_power_results(
  results_dir,
  analysis_type = c("trial", "participant"),
  alpha_levels = c(0.05, 0.01, 0.005)
)
}
\arguments{
\item{results_dir}{Directory containing power analysis results}

\item{analysis_type}{Character, either "trial" or "participant"}

\item{alpha_levels}{Numeric vector of significance levels to analyze}
}
\value{
A ggplot object visualizing power analysis results
}
\description{
Creates visualizations of power analysis results showing power to detect
intervention effects across different effect sizes and sample sizes.
}
\examples{
\dontrun{
plot <- plot_power_results(
  "power_analysis_results",
  analysis_type = "participant",
  alpha_levels = c(0.05, 0.01, 0.005)
)
print(plot)
}

}
\keyword{internal}
