% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facility_power.R
\name{grid_power}
\alias{grid_power}
\title{Grid Power Analysis for Cancer Trial Enrollment Intervention}
\usage{
grid_power(
  effect_sizes1 = c(1.01, 1.05, 1.1, 1.25, 1.5, 2),
  effect_sizes2 = effect_sizes1,
  Ns = c(15, 30, 45, 60),
  tau2_facility = 0.64,
  mean_rate = 11,
  R_boot = 1000,
  output_dir = getwd()
)
}
\arguments{
\item{effect_sizes1}{Vector of primary effect sizes to test}

\item{effect_sizes2}{Vector of secondary effect sizes to test (for interaction)}

\item{Ns}{Vector of sample sizes (trials per arm) to test}

\item{tau2_facility}{Facility-level variance}

\item{mean_rate}{Baseline enrollment rate (default from empirical data)}

\item{R_boot}{Number of bootstrap iterations}

\item{output_dir}{Directory to save results (defaults to current directory)}
}
\value{
Invisibly returns a list of all results
}
\description{
Performs a grid search of power analyses across different parameter combinations
and saves results to disk for later analysis and visualization.
}
