% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{analyze_trials}
\alias{analyze_trials}
\title{Analyze Clinical Trials Data}
\usage{
analyze_trials(
  studies,
  conditions,
  facilities,
  min_duration = 12,
  min_enrollment = 10
)
}
\arguments{
\item{studies}{Data frame of ClinicalTrials.gov studies}

\item{conditions}{Data frame of trial conditions}

\item{facilities}{Data frame of facility information}

\item{min_duration}{Minimum trial duration in months}

\item{min_enrollment}{Minimum enrollment count}
}
\value{
List containing processed trial data and comprehensive statistics
}
\description{
Main function for processing and analyzing ClinicalTrials.gov data.
This function focuses on extracting and summarizing real-world trial data,
which can then be used to inform power analysis parameters.
}
\seealso{
\code{\link{simple_power}} for using these results in power analysis
}
