% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{analyze_enrollment}
\alias{analyze_enrollment}
\title{Estimate Parameters for Power Analysis}
\usage{
analyze_enrollment(trial_data, min_rate = 1, max_rate = 200)
}
\arguments{
\item{trial_data}{Output from analyze_trials function}

\item{min_rate}{Minimum acceptable enrollment rate}

\item{max_rate}{Maximum acceptable enrollment rate}
}
\value{
List containing parameter estimates for power analysis
}
\description{
Analyzes enrollment patterns from real trial data to estimate parameters
needed for power analysis simulations. These parameters can be directly
used in \code{simple_power()} or \code{grid_bootstrap_power()}.
}
\details{
Estimates key parameters including:
\itemize{
\item Mean enrollment rate
\item Facility-level variance
\item Trial-level variance
\item Facility count distributions
}
}
\examples{
\dontrun{
# Workflow:
# 1. Analyze real trial data
trial_results <- analyze_trials(studies, conditions, facilities)

# 2. Estimate parameters
params <- estimate_power_parameters(trial_results)

# 3. Use in power analysis
# For trial-level analysis:
power_results <- simple_power(
  effect_size = 1.25,
  N = 50,
  tau2_facility = params$parameters$log_rate_variance,
  mean_rate = params$parameters$mean_rate
)

# For participant-level analysis:
bootstrap_results <- grid_bootstrap_power(
  effect_sizes1 = c(1.25, 1.5),
  tau2_trial = params$parameters$log_rate_variance
)
}
}
\seealso{
\code{\link{simple_power}} for trial-level power analysis
\code{\link{grid_bootstrap_power}} for participant-level analysis
}
