{*******************************************************}
{                                                       }
{       TFacturaElectronica                             }
{                                                       }
{       Copyright (C) 2022 Bambu Code SA de CV          }
{                                                       }
{*******************************************************}

unit Facturacion.GeneradorSello;

interface

uses Facturacion.Comprobante,
     Facturacion.OpenSSL;

type

  /// <summary>
  ///   Instancia base encargada de generar el sello del comprobante
  ///   independientemente de la versin.
  /// </summary>
  IGeneradorSello = Interface
    ['{28111CB2-59C9-4D2C-89F9-09E3CD447668}']
    /// <summary>
    ///   Instancia de OpenSSL usada para la encripcin.
    /// </summary>
    procedure Configurar(const aOpenSSL: IOpenSSL);
    /// <summary>
    ///   Se encarga de generar el respectivo sello segn la encripcin de la
    ///   versin implementada
    /// </summary>
    /// <param name="aCadenaOriginal">
    ///   Cadena Original del CFDI previamente generada
    /// </param>
    function GenerarSelloDeFactura(const aCadenaOriginal: TCadenaUTF8): TCadenaUTF8;
  End;

implementation

end.
