// Code generated by go-enum DO NOT EDIT.
// Version: 0.5.8
// Revision: 3d844c8ecc59661ed7aa17bfd65727bc06a60ad8
// Build Date: 2023-09-18T14:55:21Z
// Built By: goreleaser

package util

import (
	"fmt"
	"strings"
)

const (
	// HashAlgMd5 is a HashAlg of type Md5.
	HashAlgMd5 HashAlg = iota
	// HashAlgSha256 is a HashAlg of type Sha256.
	HashAlgSha256
	// HashAlgSha512 is a HashAlg of type Sha512.
	HashAlgSha512
)

var ErrInvalidHashAlg = fmt.Errorf("not a valid HashAlg, try [%s]", strings.Join(_HashAlgNames, ", "))

const _HashAlgName = "md5sha256sha512"

var _HashAlgNames = []string{
	_HashAlgName[0:3],
	_HashAlgName[3:9],
	_HashAlgName[9:15],
}

// HashAlgNames returns a list of possible string values of HashAlg.
func HashAlgNames() []string {
	tmp := make([]string, len(_HashAlgNames))
	copy(tmp, _HashAlgNames)
	return tmp
}

var _HashAlgMap = map[HashAlg]string{
	HashAlgMd5:    _HashAlgName[0:3],
	HashAlgSha256: _HashAlgName[3:9],
	HashAlgSha512: _HashAlgName[9:15],
}

// String implements the Stringer interface.
func (x HashAlg) String() string {
	if str, ok := _HashAlgMap[x]; ok {
		return str
	}
	return fmt.Sprintf("HashAlg(%d)", x)
}

// IsValid provides a quick way to determine if the typed value is
// part of the allowed enumerated values
func (x HashAlg) IsValid() bool {
	_, ok := _HashAlgMap[x]
	return ok
}

var _HashAlgValue = map[string]HashAlg{
	_HashAlgName[0:3]:  HashAlgMd5,
	_HashAlgName[3:9]:  HashAlgSha256,
	_HashAlgName[9:15]: HashAlgSha512,
}

// ParseHashAlg attempts to convert a string to a HashAlg.
func ParseHashAlg(name string) (HashAlg, error) {
	if x, ok := _HashAlgValue[name]; ok {
		return x, nil
	}
	return HashAlg(0), fmt.Errorf("%s is %w", name, ErrInvalidHashAlg)
}

const (
	// KeyAlgSecp256k1 is a KeyAlg of type Secp256k1.
	KeyAlgSecp256k1 KeyAlg = iota
	// KeyAlgSecp256r1 is a KeyAlg of type Secp256r1.
	KeyAlgSecp256r1
	// KeyAlgEd25519 is a KeyAlg of type Ed25519.
	KeyAlgEd25519
)

var ErrInvalidKeyAlg = fmt.Errorf("not a valid KeyAlg, try [%s]", strings.Join(_KeyAlgNames, ", "))

const _KeyAlgName = "secp256k1secp256r1ed25519"

var _KeyAlgNames = []string{
	_KeyAlgName[0:9],
	_KeyAlgName[9:18],
	_KeyAlgName[18:25],
}

// KeyAlgNames returns a list of possible string values of KeyAlg.
func KeyAlgNames() []string {
	tmp := make([]string, len(_KeyAlgNames))
	copy(tmp, _KeyAlgNames)
	return tmp
}

var _KeyAlgMap = map[KeyAlg]string{
	KeyAlgSecp256k1: _KeyAlgName[0:9],
	KeyAlgSecp256r1: _KeyAlgName[9:18],
	KeyAlgEd25519:   _KeyAlgName[18:25],
}

// String implements the Stringer interface.
func (x KeyAlg) String() string {
	if str, ok := _KeyAlgMap[x]; ok {
		return str
	}
	return fmt.Sprintf("KeyAlg(%d)", x)
}

// IsValid provides a quick way to determine if the typed value is
// part of the allowed enumerated values
func (x KeyAlg) IsValid() bool {
	_, ok := _KeyAlgMap[x]
	return ok
}

var _KeyAlgValue = map[string]KeyAlg{
	_KeyAlgName[0:9]:   KeyAlgSecp256k1,
	_KeyAlgName[9:18]:  KeyAlgSecp256r1,
	_KeyAlgName[18:25]: KeyAlgEd25519,
}

// ParseKeyAlg attempts to convert a string to a KeyAlg.
func ParseKeyAlg(name string) (KeyAlg, error) {
	if x, ok := _KeyAlgValue[name]; ok {
		return x, nil
	}
	return KeyAlg(0), fmt.Errorf("%s is %w", name, ErrInvalidKeyAlg)
}
