// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: logic/v1beta3/types.proto

package types

import (
	fmt "fmt"
	_ "github.com/cosmos/gogoproto/gogoproto"
	proto "github.com/cosmos/gogoproto/proto"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// Substitution represents a substitution made to the variables in the query to obtain the answer.
type Substitution struct {
	// variable is the name of the variable.
	Variable string `protobuf:"bytes,1,opt,name=variable,proto3" json:"variable,omitempty" yaml:"variable",omitempty`
	// expression is the value substituted for the variable, represented directly as a Prolog term (e.g., atom, number, compound).
	Expression string `protobuf:"bytes,2,opt,name=expression,proto3" json:"expression,omitempty" yaml:"expression",omitempty`
}

func (m *Substitution) Reset()         { *m = Substitution{} }
func (m *Substitution) String() string { return proto.CompactTextString(m) }
func (*Substitution) ProtoMessage()    {}
func (*Substitution) Descriptor() ([]byte, []int) {
	return fileDescriptor_bb923dc1eb7aeeab, []int{0}
}
func (m *Substitution) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Substitution) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Substitution.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Substitution) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Substitution.Merge(m, src)
}
func (m *Substitution) XXX_Size() int {
	return m.Size()
}
func (m *Substitution) XXX_DiscardUnknown() {
	xxx_messageInfo_Substitution.DiscardUnknown(m)
}

var xxx_messageInfo_Substitution proto.InternalMessageInfo

func (m *Substitution) GetVariable() string {
	if m != nil {
		return m.Variable
	}
	return ""
}

func (m *Substitution) GetExpression() string {
	if m != nil {
		return m.Expression
	}
	return ""
}

// Result represents the result of a query.
type Result struct {
	// error specifies the error message if the query caused an error.
	Error string `protobuf:"bytes,5,opt,name=error,proto3" json:"error,omitempty" yaml:"error",omitempty`
	// substitutions represent all the substitutions made to the variables in the query to obtain the answer.
	Substitutions []Substitution `protobuf:"bytes,2,rep,name=substitutions,proto3" json:"substitutions" yaml:"substitutions",omitempty`
}

func (m *Result) Reset()         { *m = Result{} }
func (m *Result) String() string { return proto.CompactTextString(m) }
func (*Result) ProtoMessage()    {}
func (*Result) Descriptor() ([]byte, []int) {
	return fileDescriptor_bb923dc1eb7aeeab, []int{1}
}
func (m *Result) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Result) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Result.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Result) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Result.Merge(m, src)
}
func (m *Result) XXX_Size() int {
	return m.Size()
}
func (m *Result) XXX_DiscardUnknown() {
	xxx_messageInfo_Result.DiscardUnknown(m)
}

var xxx_messageInfo_Result proto.InternalMessageInfo

func (m *Result) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

func (m *Result) GetSubstitutions() []Substitution {
	if m != nil {
		return m.Substitutions
	}
	return nil
}

// Answer represents the answer to a logic query.
type Answer struct {
	// has_more specifies if there are more solutions than the ones returned.
	HasMore bool `protobuf:"varint,2,opt,name=has_more,json=hasMore,proto3" json:"has_more,omitempty" yaml:"has_more",omitempty`
	// variables represent all the variables in the query.
	Variables []string `protobuf:"bytes,3,rep,name=variables,proto3" json:"variables,omitempty" yaml:"variables",omitempty`
	// results represent all the results of the query.
	Results []Result `protobuf:"bytes,4,rep,name=results,proto3" json:"results" yaml:"results",omitempty`
}

func (m *Answer) Reset()         { *m = Answer{} }
func (m *Answer) String() string { return proto.CompactTextString(m) }
func (*Answer) ProtoMessage()    {}
func (*Answer) Descriptor() ([]byte, []int) {
	return fileDescriptor_bb923dc1eb7aeeab, []int{2}
}
func (m *Answer) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Answer) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Answer.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Answer) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Answer.Merge(m, src)
}
func (m *Answer) XXX_Size() int {
	return m.Size()
}
func (m *Answer) XXX_DiscardUnknown() {
	xxx_messageInfo_Answer.DiscardUnknown(m)
}

var xxx_messageInfo_Answer proto.InternalMessageInfo

func (m *Answer) GetHasMore() bool {
	if m != nil {
		return m.HasMore
	}
	return false
}

func (m *Answer) GetVariables() []string {
	if m != nil {
		return m.Variables
	}
	return nil
}

func (m *Answer) GetResults() []Result {
	if m != nil {
		return m.Results
	}
	return nil
}

func init() {
	proto.RegisterType((*Substitution)(nil), "logic.v1beta3.Substitution")
	proto.RegisterType((*Result)(nil), "logic.v1beta3.Result")
	proto.RegisterType((*Answer)(nil), "logic.v1beta3.Answer")
}

func init() { proto.RegisterFile("logic/v1beta3/types.proto", fileDescriptor_bb923dc1eb7aeeab) }

var fileDescriptor_bb923dc1eb7aeeab = []byte{
	// 411 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x5c, 0x92, 0xb1, 0xae, 0xd3, 0x30,
	0x18, 0x85, 0xe3, 0xdb, 0x7b, 0x7b, 0x7b, 0x0d, 0x77, 0xb1, 0x00, 0xe5, 0xb6, 0xc2, 0x8e, 0x32,
	0xa0, 0x0e, 0x90, 0x08, 0xca, 0x00, 0x15, 0x12, 0x22, 0x13, 0x0b, 0x03, 0x65, 0x63, 0x41, 0x49,
	0xb1, 0x52, 0x4b, 0x49, 0x1c, 0xd9, 0x4e, 0x69, 0xdf, 0xa2, 0x23, 0x23, 0x6f, 0xc0, 0x6b, 0x74,
	0xec, 0x08, 0x4b, 0x84, 0xda, 0x37, 0xc8, 0x13, 0xa0, 0xda, 0x29, 0x75, 0xd8, 0x92, 0x7c, 0xff,
	0x39, 0xf9, 0xcf, 0xd1, 0x0f, 0xef, 0x32, 0x9e, 0xb2, 0x79, 0xb8, 0x7c, 0x9e, 0x50, 0x15, 0x4f,
	0x42, 0xb5, 0x2e, 0xa9, 0x0c, 0x4a, 0xc1, 0x15, 0x47, 0xb7, 0x1a, 0x05, 0x2d, 0x1a, 0x3e, 0x48,
	0x79, 0xca, 0x35, 0x09, 0x8f, 0x4f, 0x66, 0xc8, 0xdf, 0x00, 0x78, 0xff, 0x53, 0x95, 0x48, 0xc5,
	0x54, 0xa5, 0x18, 0x2f, 0xd0, 0x6b, 0x38, 0x58, 0xc6, 0x82, 0xc5, 0x49, 0x46, 0x5d, 0xe0, 0x81,
	0xf1, 0x4d, 0xf4, 0xb8, 0xa9, 0xc9, 0xdd, 0x3a, 0xce, 0xb3, 0xa9, 0x7f, 0x22, 0xfe, 0x53, 0x9e,
	0x33, 0x45, 0xf3, 0x52, 0xad, 0x67, 0xff, 0xc6, 0xd1, 0x5b, 0x08, 0xe9, 0xaa, 0x14, 0x54, 0x4a,
	0xc6, 0x0b, 0xf7, 0x42, 0x8b, 0x49, 0x53, 0x93, 0x91, 0x11, 0x9f, 0x99, 0x2d, 0xb7, 0x24, 0xd3,
	0xcb, 0xef, 0x3f, 0x08, 0xf0, 0x7f, 0x02, 0xd8, 0x9f, 0x51, 0x59, 0x65, 0x0a, 0xbd, 0x84, 0x57,
	0x54, 0x08, 0x2e, 0xdc, 0x2b, 0x6d, 0x86, 0xb7, 0x35, 0x01, 0x4d, 0x4d, 0x1e, 0xb5, 0x86, 0x47,
	0x64, 0x7b, 0x99, 0x61, 0xc4, 0xe0, 0xad, 0xb4, 0x22, 0x49, 0xf7, 0xc2, 0xeb, 0x8d, 0xef, 0xbd,
	0x18, 0x05, 0x9d, 0x42, 0x02, 0x3b, 0x76, 0xf4, 0x64, 0x5b, 0x13, 0xa7, 0xa9, 0x09, 0x36, 0xd6,
	0x1d, 0xbd, 0xfd, 0x8b, 0xae, 0x73, 0xbb, 0xf1, 0x6f, 0x00, 0xfb, 0xef, 0x0a, 0xf9, 0x8d, 0x0a,
	0xf4, 0x0a, 0x0e, 0x16, 0xb1, 0xfc, 0x92, 0x73, 0x41, 0x75, 0x03, 0x03, 0xbb, 0xbe, 0x13, 0xb1,
	0x0d, 0xaf, 0x17, 0xb1, 0xfc, 0xc0, 0x05, 0x45, 0x6f, 0xe0, 0xcd, 0xa9, 0x49, 0xe9, 0xf6, 0xbc,
	0xde, 0x31, 0x6f, 0x53, 0x93, 0x61, 0xb7, 0xf9, 0xce, 0x32, 0x67, 0x01, 0xfa, 0x08, 0xaf, 0x85,
	0xee, 0x4c, 0xba, 0x97, 0x3a, 0xed, 0xc3, 0xff, 0xd2, 0x9a, 0x46, 0x23, 0xaf, 0xcd, 0xe9, 0x1a,
	0xdb, 0x56, 0xd3, 0x59, 0xa8, 0xfd, 0x66, 0xb2, 0x45, 0xef, 0xb7, 0x7b, 0x0c, 0x76, 0x7b, 0x0c,
	0xfe, 0xec, 0x31, 0xd8, 0x1c, 0xb0, 0xb3, 0x3b, 0x60, 0xe7, 0xd7, 0x01, 0x3b, 0x9f, 0x83, 0x94,
	0xa9, 0x45, 0x95, 0x04, 0x73, 0x9e, 0x87, 0xf1, 0x8a, 0x17, 0xf4, 0x99, 0x3e, 0xa9, 0x39, 0xcf,
	0xcc, 0xeb, 0xd7, 0x70, 0x15, 0x9a, 0xeb, 0xd4, 0x57, 0x99, 0xf4, 0x35, 0x9e, 0xfc, 0x0d, 0x00,
	0x00, 0xff, 0xff, 0xbb, 0x60, 0x5d, 0x8c, 0xb3, 0x02, 0x00, 0x00,
}

func (m *Substitution) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Substitution) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Substitution) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Expression) > 0 {
		i -= len(m.Expression)
		copy(dAtA[i:], m.Expression)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Expression)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Variable) > 0 {
		i -= len(m.Variable)
		copy(dAtA[i:], m.Variable)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Variable)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Result) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Result) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Result) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Error) > 0 {
		i -= len(m.Error)
		copy(dAtA[i:], m.Error)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Error)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Substitutions) > 0 {
		for iNdEx := len(m.Substitutions) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Substitutions[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintTypes(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	return len(dAtA) - i, nil
}

func (m *Answer) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Answer) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Answer) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Results) > 0 {
		for iNdEx := len(m.Results) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Results[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintTypes(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.Variables) > 0 {
		for iNdEx := len(m.Variables) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Variables[iNdEx])
			copy(dAtA[i:], m.Variables[iNdEx])
			i = encodeVarintTypes(dAtA, i, uint64(len(m.Variables[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.HasMore {
		i--
		if m.HasMore {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	return len(dAtA) - i, nil
}

func encodeVarintTypes(dAtA []byte, offset int, v uint64) int {
	offset -= sovTypes(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *Substitution) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Variable)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Expression)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *Result) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Substitutions) > 0 {
		for _, e := range m.Substitutions {
			l = e.Size()
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	l = len(m.Error)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *Answer) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.HasMore {
		n += 2
	}
	if len(m.Variables) > 0 {
		for _, s := range m.Variables {
			l = len(s)
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	if len(m.Results) > 0 {
		for _, e := range m.Results {
			l = e.Size()
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	return n
}

func sovTypes(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozTypes(x uint64) (n int) {
	return sovTypes(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Substitution) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Substitution: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Substitution: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Variable", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Variable = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Expression", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Expression = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Result) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Result: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Result: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Substitutions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Substitutions = append(m.Substitutions, Substitution{})
			if err := m.Substitutions[len(m.Substitutions)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Error = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Answer) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Answer: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Answer: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HasMore", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.HasMore = bool(v != 0)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Variables", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Variables = append(m.Variables, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Results", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Results = append(m.Results, Result{})
			if err := m.Results[len(m.Results)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipTypes(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthTypes
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupTypes
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthTypes
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthTypes        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowTypes          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupTypes = fmt.Errorf("proto: unexpected end of group")
)
