// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: logic/v1beta3/params.proto

package types

import (
	fmt "fmt"
	_ "github.com/cosmos/gogoproto/gogoproto"
	proto "github.com/cosmos/gogoproto/proto"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// Params defines all the configuration parameters of the "logic" module.
type Params struct {
	// Interpreter specifies the parameter for the logic interpreter.
	Interpreter Interpreter `protobuf:"bytes,1,opt,name=interpreter,proto3" json:"interpreter" yaml:"interpreter"`
	// Limits defines the limits of the logic module.
	// The limits are used to prevent the interpreter from running for too long.
	// If the interpreter runs for too long, the execution will be aborted.
	Limits Limits `protobuf:"bytes,2,opt,name=limits,proto3" json:"limits" yaml:"limits"`
	// GasPolicy defines the parameters for calculating predicate invocation costs.
	GasPolicy GasPolicy `protobuf:"bytes,3,opt,name=gas_policy,json=gasPolicy,proto3" json:"gas_policy" yaml:"gas_policy"`
}

func (m *Params) Reset()      { *m = Params{} }
func (*Params) ProtoMessage() {}
func (*Params) Descriptor() ([]byte, []int) {
	return fileDescriptor_4697d60c461b684e, []int{0}
}
func (m *Params) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Params) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Params.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Params) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Params.Merge(m, src)
}
func (m *Params) XXX_Size() int {
	return m.Size()
}
func (m *Params) XXX_DiscardUnknown() {
	xxx_messageInfo_Params.DiscardUnknown(m)
}

var xxx_messageInfo_Params proto.InternalMessageInfo

func (m *Params) GetInterpreter() Interpreter {
	if m != nil {
		return m.Interpreter
	}
	return Interpreter{}
}

func (m *Params) GetLimits() Limits {
	if m != nil {
		return m.Limits
	}
	return Limits{}
}

func (m *Params) GetGasPolicy() GasPolicy {
	if m != nil {
		return m.GasPolicy
	}
	return GasPolicy{}
}

// Limits defines the limits of the logic module.
type Limits struct {
	// max_size specifies the maximum size, in bytes, that is accepted for a program.
	// A value of 0 means that there is no limit on the size of the program.
	MaxSize uint64 `protobuf:"varint,3,opt,name=max_size,json=maxSize,proto3" json:"max_size,omitempty" yaml:"max_size"`
	// max_result_count specifies the maximum number of results that can be requested for a query.
	// A value of 0 means that there is no limit on the number of results.
	MaxResultCount uint64 `protobuf:"varint,2,opt,name=max_result_count,json=maxResultCount,proto3" json:"max_result_count,omitempty" yaml:"max_result_count"`
	// max_user_output_size specifies the maximum number of bytes to keep in the user output. If the user output exceeds
	// this size, the interpreter will overwrite the oldest bytes with the new ones to keep the size constant.
	// A value of 0 means the user output is disabled.
	MaxUserOutputSize uint64 `protobuf:"varint,4,opt,name=max_user_output_size,json=maxUserOutputSize,proto3" json:"max_user_output_size,omitempty" yaml:"max_user_output_size"`
	// max_variables specifies the maximum number of variables that can be create by the interpreter.
	// A value of 0 means that there is no limit on the number of variables.
	MaxVariables uint64 `protobuf:"varint,5,opt,name=max_variables,json=maxVariables,proto3" json:"max_variables,omitempty" yaml:"max_variables"`
}

func (m *Limits) Reset()         { *m = Limits{} }
func (m *Limits) String() string { return proto.CompactTextString(m) }
func (*Limits) ProtoMessage()    {}
func (*Limits) Descriptor() ([]byte, []int) {
	return fileDescriptor_4697d60c461b684e, []int{1}
}
func (m *Limits) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Limits) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Limits.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Limits) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Limits.Merge(m, src)
}
func (m *Limits) XXX_Size() int {
	return m.Size()
}
func (m *Limits) XXX_DiscardUnknown() {
	xxx_messageInfo_Limits.DiscardUnknown(m)
}

var xxx_messageInfo_Limits proto.InternalMessageInfo

func (m *Limits) GetMaxSize() uint64 {
	if m != nil {
		return m.MaxSize
	}
	return 0
}

func (m *Limits) GetMaxResultCount() uint64 {
	if m != nil {
		return m.MaxResultCount
	}
	return 0
}

func (m *Limits) GetMaxUserOutputSize() uint64 {
	if m != nil {
		return m.MaxUserOutputSize
	}
	return 0
}

func (m *Limits) GetMaxVariables() uint64 {
	if m != nil {
		return m.MaxVariables
	}
	return 0
}

// Filter defines the parameters for filtering the set of strings which can designate anything.
// The filter is used to whitelist or blacklist strings.
type Filter struct {
	// whitelist specifies a list of strings that are allowed.
	// If this field is not specified, all strings (in the context of the filter) are allowed.
	Whitelist []string `protobuf:"bytes,1,rep,name=whitelist,proto3" json:"whitelist,omitempty" yaml:"whitelist"`
	// blacklist specifies a list of strings that are excluded from the set of allowed strings.
	// If a string is included in both whitelist and blacklist, it will be excluded. This means that
	// blacklisted strings prevails over whitelisted ones.
	// If this field is not specified, no strings are excluded.
	Blacklist []string `protobuf:"bytes,2,rep,name=blacklist,proto3" json:"blacklist,omitempty" yaml:"blacklist"`
}

func (m *Filter) Reset()         { *m = Filter{} }
func (m *Filter) String() string { return proto.CompactTextString(m) }
func (*Filter) ProtoMessage()    {}
func (*Filter) Descriptor() ([]byte, []int) {
	return fileDescriptor_4697d60c461b684e, []int{2}
}
func (m *Filter) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Filter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Filter.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Filter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Filter.Merge(m, src)
}
func (m *Filter) XXX_Size() int {
	return m.Size()
}
func (m *Filter) XXX_DiscardUnknown() {
	xxx_messageInfo_Filter.DiscardUnknown(m)
}

var xxx_messageInfo_Filter proto.InternalMessageInfo

func (m *Filter) GetWhitelist() []string {
	if m != nil {
		return m.Whitelist
	}
	return nil
}

func (m *Filter) GetBlacklist() []string {
	if m != nil {
		return m.Blacklist
	}
	return nil
}

// Interpreter defines the various parameters for the interpreter.
type Interpreter struct {
	// predicates_filter specifies the filter for the predicates that are allowed to be used by the interpreter.
	// The filter is used to whitelist or blacklist predicates represented as `<predicate_name>/[<arity>]`, for example:
	// `findall/3`, or `call`. If a predicate name without arity is included in the filter, then all predicates with that
	// name will be considered regardless of arity. For example, if `call` is included in the filter, then all predicates
	// `call/1`, `call/2`, `call/3`... will be allowed.
	PredicatesFilter Filter `protobuf:"bytes,1,opt,name=predicates_filter,json=predicatesFilter,proto3" json:"predicates_filter" yaml:"predicates_filter"`
	// bootstrap specifies the initial program to run when booting the logic interpreter.
	// If not specified, the default boot sequence will be executed.
	Bootstrap string `protobuf:"bytes,3,opt,name=bootstrap,proto3" json:"bootstrap,omitempty" yaml:"bootstrap"`
	// virtual_files_filter specifies the filter for the virtual files that are allowed to be used by the interpreter.
	// The filter is used to whitelist or blacklist virtual files represented as URI, for example:
	// `file:///path/to/file`, `cosmwasm:cw-storage:axone...?query=foo`
	// The filter is applied to the components of the URI, for example:
	// `file:///path/to/file` -> `file`, `/path/to/file`
	// `cosmwasm:cw-storage:axone...?query=foo` -> `cosmwasm`, `cw-storage`, `axone...`, `query=foo`
	// If a component is included in the filter, then all components with that name will be considered, starting from the
	// beginning of the URI. For example, if `file` is included in the filter, then all URIs that start with `file` will be
	// allowed, regardless of the rest of the components. But `file2` will not be allowed.
	// If the component is not included in the filter, then the component is ignored and the next component is considered.
	VirtualFilesFilter Filter `protobuf:"bytes,4,opt,name=virtual_files_filter,json=virtualFilesFilter,proto3" json:"virtual_files_filter" yaml:"filesystem_filter"`
}

func (m *Interpreter) Reset()         { *m = Interpreter{} }
func (m *Interpreter) String() string { return proto.CompactTextString(m) }
func (*Interpreter) ProtoMessage()    {}
func (*Interpreter) Descriptor() ([]byte, []int) {
	return fileDescriptor_4697d60c461b684e, []int{3}
}
func (m *Interpreter) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Interpreter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Interpreter.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Interpreter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Interpreter.Merge(m, src)
}
func (m *Interpreter) XXX_Size() int {
	return m.Size()
}
func (m *Interpreter) XXX_DiscardUnknown() {
	xxx_messageInfo_Interpreter.DiscardUnknown(m)
}

var xxx_messageInfo_Interpreter proto.InternalMessageInfo

func (m *Interpreter) GetPredicatesFilter() Filter {
	if m != nil {
		return m.PredicatesFilter
	}
	return Filter{}
}

func (m *Interpreter) GetBootstrap() string {
	if m != nil {
		return m.Bootstrap
	}
	return ""
}

func (m *Interpreter) GetVirtualFilesFilter() Filter {
	if m != nil {
		return m.VirtualFilesFilter
	}
	return Filter{}
}

// GasPolicy defines the policy for calculating predicate invocation costs and the resulting gas consumption.
// The gas policy is defined as a list of predicates and their associated unit costs, a default unit cost for predicates
// if not specified in the list, and a weighting factor that is applied to the unit cost of each predicate to yield.
type GasPolicy struct {
	// WeightingFactor is the factor that is applied to the unit cost of each predicate
	// to yield the gas value.
	// If set to 0, the value considered is 1.
	WeightingFactor uint64 `protobuf:"varint,1,opt,name=weighting_factor,json=weightingFactor,proto3" json:"weighting_factor,omitempty" yaml:"weighting_factor"`
	// DefaultPredicateCost is the default unit cost of a predicate when not specified in the PredicateCosts list.
	// If set to 0, the value considered is 1.
	DefaultPredicateCost uint64 `protobuf:"varint,2,opt,name=default_predicate_cost,json=defaultPredicateCost,proto3" json:"default_predicate_cost,omitempty" yaml:"default_predicate_cost"`
	// PredicateCosts is the list of predicates and their associated unit costs.
	PredicateCosts []PredicateCost `protobuf:"bytes,3,rep,name=predicate_costs,json=predicateCosts,proto3" json:"predicate_costs" yaml:"predicate_cost"`
}

func (m *GasPolicy) Reset()         { *m = GasPolicy{} }
func (m *GasPolicy) String() string { return proto.CompactTextString(m) }
func (*GasPolicy) ProtoMessage()    {}
func (*GasPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_4697d60c461b684e, []int{4}
}
func (m *GasPolicy) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GasPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GasPolicy.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GasPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GasPolicy.Merge(m, src)
}
func (m *GasPolicy) XXX_Size() int {
	return m.Size()
}
func (m *GasPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_GasPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_GasPolicy proto.InternalMessageInfo

func (m *GasPolicy) GetWeightingFactor() uint64 {
	if m != nil {
		return m.WeightingFactor
	}
	return 0
}

func (m *GasPolicy) GetDefaultPredicateCost() uint64 {
	if m != nil {
		return m.DefaultPredicateCost
	}
	return 0
}

func (m *GasPolicy) GetPredicateCosts() []PredicateCost {
	if m != nil {
		return m.PredicateCosts
	}
	return nil
}

// PredicateCost defines the unit cost of a predicate during its invocation by the interpreter.
type PredicateCost struct {
	// Predicate is the name of the predicate, optionally followed by its arity (e.g. "findall/3").
	// If no arity is specified, the unit cost is applied to all predicates with the same name.
	Predicate string `protobuf:"bytes,1,opt,name=predicate,proto3" json:"predicate,omitempty" yaml:"predicate"`
	// Cost is the unit cost of the predicate.
	// If set to 0, the value considered is 1.
	Cost uint64 `protobuf:"varint,2,opt,name=cost,proto3" json:"cost,omitempty" yaml:"cost"`
}

func (m *PredicateCost) Reset()         { *m = PredicateCost{} }
func (m *PredicateCost) String() string { return proto.CompactTextString(m) }
func (*PredicateCost) ProtoMessage()    {}
func (*PredicateCost) Descriptor() ([]byte, []int) {
	return fileDescriptor_4697d60c461b684e, []int{5}
}
func (m *PredicateCost) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PredicateCost) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PredicateCost.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PredicateCost) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PredicateCost.Merge(m, src)
}
func (m *PredicateCost) XXX_Size() int {
	return m.Size()
}
func (m *PredicateCost) XXX_DiscardUnknown() {
	xxx_messageInfo_PredicateCost.DiscardUnknown(m)
}

var xxx_messageInfo_PredicateCost proto.InternalMessageInfo

func (m *PredicateCost) GetPredicate() string {
	if m != nil {
		return m.Predicate
	}
	return ""
}

func (m *PredicateCost) GetCost() uint64 {
	if m != nil {
		return m.Cost
	}
	return 0
}

func init() {
	proto.RegisterType((*Params)(nil), "logic.v1beta3.Params")
	proto.RegisterType((*Limits)(nil), "logic.v1beta3.Limits")
	proto.RegisterType((*Filter)(nil), "logic.v1beta3.Filter")
	proto.RegisterType((*Interpreter)(nil), "logic.v1beta3.Interpreter")
	proto.RegisterType((*GasPolicy)(nil), "logic.v1beta3.GasPolicy")
	proto.RegisterType((*PredicateCost)(nil), "logic.v1beta3.PredicateCost")
}

func init() { proto.RegisterFile("logic/v1beta3/params.proto", fileDescriptor_4697d60c461b684e) }

var fileDescriptor_4697d60c461b684e = []byte{
	// 722 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x54, 0xcd, 0x6e, 0xd3, 0x4a,
	0x14, 0x8e, 0x93, 0xdc, 0xdc, 0x9b, 0xc9, 0x4d, 0x93, 0xfa, 0xa6, 0x17, 0x93, 0xd2, 0x38, 0x0c,
	0x9b, 0x6e, 0x48, 0x44, 0x2b, 0x75, 0x51, 0x89, 0x8d, 0x0b, 0x01, 0x24, 0x24, 0xa2, 0x41, 0xfc,
	0x88, 0x4d, 0x34, 0x71, 0xa6, 0xee, 0x08, 0x3b, 0x63, 0x79, 0x26, 0xad, 0xd3, 0x25, 0x4f, 0x80,
	0x58, 0x20, 0x16, 0x2c, 0x78, 0x9c, 0x2e, 0xbb, 0x64, 0x65, 0xa1, 0xf6, 0x0d, 0xfc, 0x04, 0xc8,
	0x33, 0x8e, 0x9d, 0xa4, 0xdd, 0xb0, 0xb3, 0xcf, 0xf7, 0x73, 0x3e, 0x9f, 0x73, 0x64, 0xd0, 0x76,
	0x99, 0x43, 0xed, 0xfe, 0xe9, 0xa3, 0x31, 0x11, 0x78, 0xbf, 0xef, 0xe3, 0x00, 0x7b, 0xbc, 0xe7,
	0x07, 0x4c, 0x30, 0xbd, 0x2e, 0xb1, 0x5e, 0x8a, 0xb5, 0x5b, 0x0e, 0x73, 0x98, 0x44, 0xfa, 0xc9,
	0x93, 0x22, 0xc1, 0x4f, 0x45, 0x50, 0x19, 0x4a, 0x95, 0xfe, 0x1e, 0xd4, 0xe8, 0x54, 0x90, 0xc0,
	0x0f, 0x88, 0x20, 0x81, 0xa1, 0x75, 0xb5, 0xdd, 0xda, 0x5e, 0xbb, 0xb7, 0xe2, 0xd2, 0x7b, 0x91,
	0x33, 0xac, 0xf6, 0x45, 0x64, 0x16, 0xe2, 0xc8, 0xd4, 0xe7, 0xd8, 0x73, 0x0f, 0xe1, 0x92, 0x18,
	0xa2, 0x65, 0x2b, 0xfd, 0x09, 0xa8, 0xb8, 0xd4, 0xa3, 0x82, 0x1b, 0x45, 0x69, 0xba, 0xb5, 0x66,
	0xfa, 0x52, 0x82, 0xd6, 0x56, 0xea, 0x57, 0x57, 0x7e, 0x4a, 0x02, 0x51, 0xaa, 0xd5, 0x11, 0x00,
	0x0e, 0xe6, 0x23, 0x9f, 0xb9, 0xd4, 0x9e, 0x1b, 0x25, 0xe9, 0x64, 0xac, 0x39, 0x3d, 0xc3, 0x7c,
	0x28, 0x71, 0xeb, 0x6e, 0x6a, 0xb6, 0xa9, 0xcc, 0x72, 0x25, 0x44, 0x55, 0x67, 0xc1, 0x3a, 0x2c,
	0x7f, 0xfb, 0x61, 0x16, 0xe0, 0xd7, 0x22, 0xa8, 0xa8, 0x0c, 0x7a, 0x0f, 0xfc, 0xe3, 0xe1, 0x70,
	0xc4, 0xe9, 0x39, 0x91, 0x2d, 0xca, 0xd6, 0x7f, 0x71, 0x64, 0x36, 0x94, 0xc9, 0x02, 0x81, 0xe8,
	0x6f, 0x0f, 0x87, 0xaf, 0xe9, 0x39, 0xd1, 0x9f, 0x82, 0x66, 0x52, 0x0d, 0x08, 0x9f, 0xb9, 0x62,
	0x64, 0xb3, 0xd9, 0x54, 0xc8, 0x8f, 0x2c, 0x5b, 0xdb, 0x71, 0x64, 0xde, 0xc9, 0x75, 0xcb, 0x0c,
	0x88, 0x36, 0x3c, 0x1c, 0x22, 0x59, 0x39, 0x4a, 0x0a, 0xfa, 0x10, 0xb4, 0x12, 0xd2, 0x8c, 0x93,
	0x60, 0xc4, 0x66, 0xc2, 0x9f, 0x09, 0x15, 0xa1, 0x2c, 0xad, 0xcc, 0x38, 0x32, 0xb7, 0x73, 0xab,
	0x75, 0x16, 0x44, 0x9b, 0x1e, 0x0e, 0xdf, 0x70, 0x12, 0xbc, 0x92, 0x45, 0x19, 0xec, 0x31, 0xa8,
	0x27, 0xdc, 0x53, 0x1c, 0x50, 0x3c, 0x76, 0x09, 0x37, 0xfe, 0x92, 0x56, 0x46, 0x1c, 0x99, 0xad,
	0xdc, 0x2a, 0x83, 0x21, 0xfa, 0xd7, 0xc3, 0xe1, 0xdb, 0xc5, 0xab, 0x1c, 0x8c, 0x06, 0x43, 0x50,
	0x19, 0x50, 0x37, 0x59, 0xe1, 0x01, 0xa8, 0x9e, 0x9d, 0x50, 0x41, 0x5c, 0xca, 0x85, 0xa1, 0x75,
	0x4b, 0xbb, 0x55, 0xcb, 0xb8, 0x88, 0x4c, 0x2d, 0x8e, 0xcc, 0xa6, 0xb2, 0xcb, 0x60, 0x88, 0x72,
	0x6a, 0xa2, 0x1b, 0xbb, 0xd8, 0xfe, 0x28, 0x75, 0xc5, 0xdb, 0x74, 0x19, 0x0c, 0x51, 0x4e, 0x85,
	0xdf, 0x8b, 0xa0, 0xb6, 0x74, 0x6b, 0xfa, 0x04, 0x6c, 0xfa, 0x01, 0x99, 0x50, 0x1b, 0x0b, 0xc2,
	0x47, 0xc7, 0x32, 0x54, 0x7a, 0xa2, 0xeb, 0xd7, 0xa4, 0x12, 0x5b, 0xdd, 0xf4, 0x00, 0x0c, 0xd5,
	0xe6, 0x86, 0x1a, 0xa2, 0x66, 0x5e, 0xcb, 0xbf, 0x72, 0xcc, 0x98, 0xe0, 0x22, 0xc0, 0xbe, 0x5c,
	0xff, 0xcd, 0xb4, 0x0b, 0x38, 0x49, 0xbb, 0x78, 0xd6, 0x29, 0x68, 0x9d, 0xd2, 0x40, 0xcc, 0xb0,
	0x9b, 0x98, 0xe7, 0x01, 0xcb, 0x7f, 0x10, 0x50, 0x0a, 0xe7, 0x5c, 0x10, 0x2f, 0x0b, 0xa8, 0xa7,
	0xa6, 0x83, 0x04, 0x52, 0xaa, 0x74, 0x31, 0x5f, 0x8a, 0xa0, 0x9a, 0xdd, 0xba, 0x3e, 0x00, 0xcd,
	0x33, 0x42, 0x9d, 0x13, 0x41, 0xa7, 0xce, 0xe8, 0x18, 0xdb, 0x82, 0xa9, 0xd9, 0xac, 0x1c, 0xe1,
	0x3a, 0x03, 0xa2, 0x46, 0x56, 0x1a, 0xc8, 0x8a, 0xfe, 0x0e, 0xfc, 0x3f, 0x21, 0xc7, 0x38, 0xb9,
	0xd3, 0x6c, 0x34, 0x23, 0x9b, 0xf1, 0xc5, 0x49, 0xdf, 0x8f, 0x23, 0x73, 0x47, 0xb9, 0xdd, 0xce,
	0x83, 0xa8, 0x95, 0x02, 0xc3, 0x45, 0xfd, 0x88, 0x71, 0xa1, 0x4f, 0x40, 0x63, 0x95, 0xc8, 0x8d,
	0x52, 0xb7, 0xb4, 0x5b, 0xdb, 0xbb, 0xb7, 0x36, 0x9a, 0x15, 0x99, 0xb5, 0x93, 0x4e, 0x68, 0x6b,
	0x6d, 0x85, 0x69, 0xaf, 0x0d, 0x7f, 0x99, 0xcd, 0xa1, 0x0b, 0xea, 0xab, 0x6d, 0x0f, 0x40, 0x35,
	0xa3, 0xc8, 0x81, 0xdc, 0x58, 0x67, 0x06, 0x43, 0x94, 0x53, 0xf5, 0x07, 0xa0, 0xbc, 0xf4, 0xd5,
	0x8d, 0x38, 0x32, 0x6b, 0x8a, 0xae, 0xfa, 0x4a, 0xd0, 0x7a, 0x7e, 0x71, 0xd5, 0xd1, 0x2e, 0xaf,
	0x3a, 0xda, 0xaf, 0xab, 0x8e, 0xf6, 0xf9, 0xba, 0x53, 0xb8, 0xbc, 0xee, 0x14, 0x7e, 0x5e, 0x77,
	0x0a, 0x1f, 0x7a, 0x0e, 0x15, 0x27, 0xb3, 0x71, 0xcf, 0x66, 0x5e, 0x1f, 0x87, 0x6c, 0x4a, 0x1e,
	0xca, 0x7f, 0xad, 0xcd, 0x5c, 0xf5, 0x3a, 0xe9, 0x87, 0x7d, 0xf5, 0xdf, 0x16, 0x73, 0x9f, 0xf0,
	0x71, 0x45, 0xc2, 0xfb, 0xbf, 0x03, 0x00, 0x00, 0xff, 0xff, 0xf3, 0x73, 0xf6, 0x1b, 0xcd, 0x05,
	0x00, 0x00,
}

func (m *Params) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Params) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Params) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	{
		size, err := m.GasPolicy.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintParams(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x1a
	{
		size, err := m.Limits.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintParams(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x12
	{
		size, err := m.Interpreter.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintParams(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *Limits) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Limits) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Limits) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.MaxVariables != 0 {
		i = encodeVarintParams(dAtA, i, uint64(m.MaxVariables))
		i--
		dAtA[i] = 0x28
	}
	if m.MaxUserOutputSize != 0 {
		i = encodeVarintParams(dAtA, i, uint64(m.MaxUserOutputSize))
		i--
		dAtA[i] = 0x20
	}
	if m.MaxSize != 0 {
		i = encodeVarintParams(dAtA, i, uint64(m.MaxSize))
		i--
		dAtA[i] = 0x18
	}
	if m.MaxResultCount != 0 {
		i = encodeVarintParams(dAtA, i, uint64(m.MaxResultCount))
		i--
		dAtA[i] = 0x10
	}
	return len(dAtA) - i, nil
}

func (m *Filter) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Filter) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Filter) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Blacklist) > 0 {
		for iNdEx := len(m.Blacklist) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Blacklist[iNdEx])
			copy(dAtA[i:], m.Blacklist[iNdEx])
			i = encodeVarintParams(dAtA, i, uint64(len(m.Blacklist[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Whitelist) > 0 {
		for iNdEx := len(m.Whitelist) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Whitelist[iNdEx])
			copy(dAtA[i:], m.Whitelist[iNdEx])
			i = encodeVarintParams(dAtA, i, uint64(len(m.Whitelist[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *Interpreter) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Interpreter) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Interpreter) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	{
		size, err := m.VirtualFilesFilter.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintParams(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x22
	if len(m.Bootstrap) > 0 {
		i -= len(m.Bootstrap)
		copy(dAtA[i:], m.Bootstrap)
		i = encodeVarintParams(dAtA, i, uint64(len(m.Bootstrap)))
		i--
		dAtA[i] = 0x1a
	}
	{
		size, err := m.PredicatesFilter.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintParams(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *GasPolicy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GasPolicy) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GasPolicy) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.PredicateCosts) > 0 {
		for iNdEx := len(m.PredicateCosts) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.PredicateCosts[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintParams(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.DefaultPredicateCost != 0 {
		i = encodeVarintParams(dAtA, i, uint64(m.DefaultPredicateCost))
		i--
		dAtA[i] = 0x10
	}
	if m.WeightingFactor != 0 {
		i = encodeVarintParams(dAtA, i, uint64(m.WeightingFactor))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *PredicateCost) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PredicateCost) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PredicateCost) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Cost != 0 {
		i = encodeVarintParams(dAtA, i, uint64(m.Cost))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Predicate) > 0 {
		i -= len(m.Predicate)
		copy(dAtA[i:], m.Predicate)
		i = encodeVarintParams(dAtA, i, uint64(len(m.Predicate)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintParams(dAtA []byte, offset int, v uint64) int {
	offset -= sovParams(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *Params) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Interpreter.Size()
	n += 1 + l + sovParams(uint64(l))
	l = m.Limits.Size()
	n += 1 + l + sovParams(uint64(l))
	l = m.GasPolicy.Size()
	n += 1 + l + sovParams(uint64(l))
	return n
}

func (m *Limits) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.MaxResultCount != 0 {
		n += 1 + sovParams(uint64(m.MaxResultCount))
	}
	if m.MaxSize != 0 {
		n += 1 + sovParams(uint64(m.MaxSize))
	}
	if m.MaxUserOutputSize != 0 {
		n += 1 + sovParams(uint64(m.MaxUserOutputSize))
	}
	if m.MaxVariables != 0 {
		n += 1 + sovParams(uint64(m.MaxVariables))
	}
	return n
}

func (m *Filter) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Whitelist) > 0 {
		for _, s := range m.Whitelist {
			l = len(s)
			n += 1 + l + sovParams(uint64(l))
		}
	}
	if len(m.Blacklist) > 0 {
		for _, s := range m.Blacklist {
			l = len(s)
			n += 1 + l + sovParams(uint64(l))
		}
	}
	return n
}

func (m *Interpreter) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.PredicatesFilter.Size()
	n += 1 + l + sovParams(uint64(l))
	l = len(m.Bootstrap)
	if l > 0 {
		n += 1 + l + sovParams(uint64(l))
	}
	l = m.VirtualFilesFilter.Size()
	n += 1 + l + sovParams(uint64(l))
	return n
}

func (m *GasPolicy) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.WeightingFactor != 0 {
		n += 1 + sovParams(uint64(m.WeightingFactor))
	}
	if m.DefaultPredicateCost != 0 {
		n += 1 + sovParams(uint64(m.DefaultPredicateCost))
	}
	if len(m.PredicateCosts) > 0 {
		for _, e := range m.PredicateCosts {
			l = e.Size()
			n += 1 + l + sovParams(uint64(l))
		}
	}
	return n
}

func (m *PredicateCost) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Predicate)
	if l > 0 {
		n += 1 + l + sovParams(uint64(l))
	}
	if m.Cost != 0 {
		n += 1 + sovParams(uint64(m.Cost))
	}
	return n
}

func sovParams(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozParams(x uint64) (n int) {
	return sovParams(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Params) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowParams
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Params: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Params: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Interpreter", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Interpreter.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Limits", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Limits.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GasPolicy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.GasPolicy.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipParams(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthParams
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Limits) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowParams
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Limits: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Limits: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxResultCount", wireType)
			}
			m.MaxResultCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxResultCount |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxSize", wireType)
			}
			m.MaxSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxSize |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxUserOutputSize", wireType)
			}
			m.MaxUserOutputSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxUserOutputSize |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxVariables", wireType)
			}
			m.MaxVariables = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxVariables |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipParams(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthParams
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Filter) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowParams
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Filter: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Filter: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Whitelist", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Whitelist = append(m.Whitelist, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Blacklist", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Blacklist = append(m.Blacklist, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipParams(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthParams
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Interpreter) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowParams
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Interpreter: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Interpreter: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PredicatesFilter", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.PredicatesFilter.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bootstrap", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Bootstrap = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VirtualFilesFilter", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.VirtualFilesFilter.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipParams(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthParams
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GasPolicy) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowParams
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GasPolicy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GasPolicy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WeightingFactor", wireType)
			}
			m.WeightingFactor = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.WeightingFactor |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DefaultPredicateCost", wireType)
			}
			m.DefaultPredicateCost = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DefaultPredicateCost |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PredicateCosts", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PredicateCosts = append(m.PredicateCosts, PredicateCost{})
			if err := m.PredicateCosts[len(m.PredicateCosts)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipParams(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthParams
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PredicateCost) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowParams
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PredicateCost: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PredicateCost: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Predicate", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Predicate = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cost", wireType)
			}
			m.Cost = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Cost |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipParams(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthParams
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipParams(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowParams
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowParams
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowParams
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthParams
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupParams
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthParams
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthParams        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowParams          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupParams = fmt.Errorf("proto: unexpected end of group")
)
