// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: logic/v1beta2/params.proto

package types

import (
	cosmossdk_io_math "cosmossdk.io/math"
	fmt "fmt"
	_ "github.com/cosmos/gogoproto/gogoproto"
	proto "github.com/cosmos/gogoproto/proto"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// Params defines all the configuration parameters of the "logic" module.
type Params struct {
	// Interpreter specifies the parameter for the logic interpreter.
	Interpreter Interpreter `protobuf:"bytes,1,opt,name=interpreter,proto3" json:"interpreter" yaml:"interpreter"`
	// Limits defines the limits of the logic module.
	// The limits are used to prevent the interpreter from running for too long.
	// If the interpreter runs for too long, the execution will be aborted.
	Limits Limits `protobuf:"bytes,2,opt,name=limits,proto3" json:"limits" yaml:"limits"`
	// GasPolicy defines the parameters for calculating predicate invocation costs.
	GasPolicy GasPolicy `protobuf:"bytes,3,opt,name=gas_policy,json=gasPolicy,proto3" json:"gas_policy" yaml:"gas_policy"`
}

func (m *Params) Reset()      { *m = Params{} }
func (*Params) ProtoMessage() {}
func (*Params) Descriptor() ([]byte, []int) {
	return fileDescriptor_3af0daa241de0fa3, []int{0}
}
func (m *Params) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Params) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Params.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Params) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Params.Merge(m, src)
}
func (m *Params) XXX_Size() int {
	return m.Size()
}
func (m *Params) XXX_DiscardUnknown() {
	xxx_messageInfo_Params.DiscardUnknown(m)
}

var xxx_messageInfo_Params proto.InternalMessageInfo

func (m *Params) GetInterpreter() Interpreter {
	if m != nil {
		return m.Interpreter
	}
	return Interpreter{}
}

func (m *Params) GetLimits() Limits {
	if m != nil {
		return m.Limits
	}
	return Limits{}
}

func (m *Params) GetGasPolicy() GasPolicy {
	if m != nil {
		return m.GasPolicy
	}
	return GasPolicy{}
}

// Limits defines the limits of the logic module.
type Limits struct {
	// max_size specifies the maximum size, in bytes, that is accepted for a program.
	// nil value or 0 value remove size limitation.
	MaxSize *cosmossdk_io_math.Uint `protobuf:"bytes,3,opt,name=max_size,json=maxSize,proto3,customtype=cosmossdk.io/math.Uint" json:"max_size,omitempty" yaml:"max_size"`
	// max_result_count specifies the maximum number of results that can be requested for a query.
	// nil value or 0 value remove max result count limitation.
	MaxResultCount *cosmossdk_io_math.Uint `protobuf:"bytes,2,opt,name=max_result_count,json=maxResultCount,proto3,customtype=cosmossdk.io/math.Uint" json:"max_result_count,omitempty" yaml:"max_result_count"`
	// max_user_output_size specifies the maximum number of bytes to keep in the user output. If the user output exceeds
	// this size, the interpreter will overwrite the oldest bytes with the new ones to keep the size constant.
	// nil value or 0 value means that no user output is used at all.
	MaxUserOutputSize *cosmossdk_io_math.Uint `protobuf:"bytes,4,opt,name=max_user_output_size,json=maxUserOutputSize,proto3,customtype=cosmossdk.io/math.Uint" json:"max_user_output_size,omitempty" yaml:"max_user_output_size"`
	// max_variables specifies the maximum number of variables that can be create by the interpreter.
	// nil value or 0 value means that no limit is set.
	MaxVariables *cosmossdk_io_math.Uint `protobuf:"bytes,5,opt,name=max_variables,json=maxVariables,proto3,customtype=cosmossdk.io/math.Uint" json:"max_variables,omitempty" yaml:"max_variables"`
}

func (m *Limits) Reset()         { *m = Limits{} }
func (m *Limits) String() string { return proto.CompactTextString(m) }
func (*Limits) ProtoMessage()    {}
func (*Limits) Descriptor() ([]byte, []int) {
	return fileDescriptor_3af0daa241de0fa3, []int{1}
}
func (m *Limits) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Limits) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Limits.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Limits) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Limits.Merge(m, src)
}
func (m *Limits) XXX_Size() int {
	return m.Size()
}
func (m *Limits) XXX_DiscardUnknown() {
	xxx_messageInfo_Limits.DiscardUnknown(m)
}

var xxx_messageInfo_Limits proto.InternalMessageInfo

// Filter defines the parameters for filtering the set of strings which can designate anything.
// The filter is used to whitelist or blacklist strings.
type Filter struct {
	// whitelist specifies a list of strings that are allowed.
	// If this field is not specified, all strings (in the context of the filter) are allowed.
	Whitelist []string `protobuf:"bytes,1,rep,name=whitelist,proto3" json:"whitelist,omitempty" yaml:"whitelist"`
	// blacklist specifies a list of strings that are excluded from the set of allowed strings.
	// If a string is included in both whitelist and blacklist, it will be excluded. This means that
	// blacklisted strings prevails over whitelisted ones.
	// If this field is not specified, no strings are excluded.
	Blacklist []string `protobuf:"bytes,2,rep,name=blacklist,proto3" json:"blacklist,omitempty" yaml:"blacklist"`
}

func (m *Filter) Reset()         { *m = Filter{} }
func (m *Filter) String() string { return proto.CompactTextString(m) }
func (*Filter) ProtoMessage()    {}
func (*Filter) Descriptor() ([]byte, []int) {
	return fileDescriptor_3af0daa241de0fa3, []int{2}
}
func (m *Filter) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Filter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Filter.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Filter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Filter.Merge(m, src)
}
func (m *Filter) XXX_Size() int {
	return m.Size()
}
func (m *Filter) XXX_DiscardUnknown() {
	xxx_messageInfo_Filter.DiscardUnknown(m)
}

var xxx_messageInfo_Filter proto.InternalMessageInfo

func (m *Filter) GetWhitelist() []string {
	if m != nil {
		return m.Whitelist
	}
	return nil
}

func (m *Filter) GetBlacklist() []string {
	if m != nil {
		return m.Blacklist
	}
	return nil
}

// Interpreter defines the various parameters for the interpreter.
type Interpreter struct {
	// predicates_filter specifies the filter for the predicates that are allowed to be used by the interpreter.
	// The filter is used to whitelist or blacklist predicates represented as `<predicate_name>/[<arity>]`, for example:
	// `findall/3`, or `call`. If a predicate name without arity is included in the filter, then all predicates with that
	// name will be considered regardless of arity. For example, if `call` is included in the filter, then all predicates
	// `call/1`, `call/2`, `call/3`... will be allowed.
	PredicatesFilter Filter `protobuf:"bytes,1,opt,name=predicates_filter,json=predicatesFilter,proto3" json:"predicates_filter" yaml:"predicates_filter"`
	// bootstrap specifies the initial program to run when booting the logic interpreter.
	// If not specified, the default boot sequence will be executed.
	Bootstrap string `protobuf:"bytes,3,opt,name=bootstrap,proto3" json:"bootstrap,omitempty" yaml:"bootstrap"`
	// virtual_files_filter specifies the filter for the virtual files that are allowed to be used by the interpreter.
	// The filter is used to whitelist or blacklist virtual files represented as URI, for example:
	// `file:///path/to/file`, `cosmwasm:cw-storage:axone...?query=foo`
	// The filter is applied to the components of the URI, for example:
	// `file:///path/to/file` -> `file`, `/path/to/file`
	// `cosmwasm:cw-storage:axone...?query=foo` -> `cosmwasm`, `cw-storage`, `axone...`, `query=foo`
	// If a component is included in the filter, then all components with that name will be considered, starting from the
	// beginning of the URI. For example, if `file` is included in the filter, then all URIs that start with `file` will be
	// allowed, regardless of the rest of the components. But `file2` will not be allowed.
	// If the component is not included in the filter, then the component is ignored and the next component is considered.
	VirtualFilesFilter Filter `protobuf:"bytes,4,opt,name=virtual_files_filter,json=virtualFilesFilter,proto3" json:"virtual_files_filter" yaml:"filesystem_filter"`
}

func (m *Interpreter) Reset()         { *m = Interpreter{} }
func (m *Interpreter) String() string { return proto.CompactTextString(m) }
func (*Interpreter) ProtoMessage()    {}
func (*Interpreter) Descriptor() ([]byte, []int) {
	return fileDescriptor_3af0daa241de0fa3, []int{3}
}
func (m *Interpreter) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Interpreter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Interpreter.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Interpreter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Interpreter.Merge(m, src)
}
func (m *Interpreter) XXX_Size() int {
	return m.Size()
}
func (m *Interpreter) XXX_DiscardUnknown() {
	xxx_messageInfo_Interpreter.DiscardUnknown(m)
}

var xxx_messageInfo_Interpreter proto.InternalMessageInfo

func (m *Interpreter) GetPredicatesFilter() Filter {
	if m != nil {
		return m.PredicatesFilter
	}
	return Filter{}
}

func (m *Interpreter) GetBootstrap() string {
	if m != nil {
		return m.Bootstrap
	}
	return ""
}

func (m *Interpreter) GetVirtualFilesFilter() Filter {
	if m != nil {
		return m.VirtualFilesFilter
	}
	return Filter{}
}

// GasPolicy defines the policy for calculating predicate invocation costs and the resulting gas consumption.
// The gas policy is defined as a list of predicates and their associated unit costs, a default unit cost for predicates
// if not specified in the list, and a weighting factor that is applied to the unit cost of each predicate to yield.
type GasPolicy struct {
	// WeightingFactor is the factor that is applied to the unit cost of each predicate
	// to yield the gas value.
	// If not provided or set to 0, the value is set to 1.
	WeightingFactor *cosmossdk_io_math.Uint `protobuf:"bytes,1,opt,name=weighting_factor,json=weightingFactor,proto3,customtype=cosmossdk.io/math.Uint" json:"weighting_factor,omitempty" yaml:"weighting_factor"`
	// DefaultPredicateCost is the default unit cost of a predicate when not specified in the PredicateCosts list.
	// If not provided or set to 0, the value is set to 1.
	DefaultPredicateCost *cosmossdk_io_math.Uint `protobuf:"bytes,2,opt,name=default_predicate_cost,json=defaultPredicateCost,proto3,customtype=cosmossdk.io/math.Uint" json:"default_predicate_cost,omitempty" yaml:"default_predicate_cost"`
	// PredicateCosts is the list of predicates and their associated unit costs.
	PredicateCosts []PredicateCost `protobuf:"bytes,3,rep,name=predicate_costs,json=predicateCosts,proto3" json:"predicate_costs" yaml:"predicate_cost"`
}

func (m *GasPolicy) Reset()         { *m = GasPolicy{} }
func (m *GasPolicy) String() string { return proto.CompactTextString(m) }
func (*GasPolicy) ProtoMessage()    {}
func (*GasPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_3af0daa241de0fa3, []int{4}
}
func (m *GasPolicy) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GasPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GasPolicy.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GasPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GasPolicy.Merge(m, src)
}
func (m *GasPolicy) XXX_Size() int {
	return m.Size()
}
func (m *GasPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_GasPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_GasPolicy proto.InternalMessageInfo

func (m *GasPolicy) GetPredicateCosts() []PredicateCost {
	if m != nil {
		return m.PredicateCosts
	}
	return nil
}

// PredicateCost defines the unit cost of a predicate during its invocation by the interpreter.
type PredicateCost struct {
	// Predicate is the name of the predicate, optionally followed by its arity (e.g. "findall/3").
	// If no arity is specified, the unit cost is applied to all predicates with the same name.
	Predicate string `protobuf:"bytes,1,opt,name=predicate,proto3" json:"predicate,omitempty" yaml:"predicate"`
	// Cost is the unit cost of the predicate.
	Cost *cosmossdk_io_math.Uint `protobuf:"bytes,2,opt,name=cost,proto3,customtype=cosmossdk.io/math.Uint" json:"cost,omitempty" yaml:"cost",omitempty`
}

func (m *PredicateCost) Reset()         { *m = PredicateCost{} }
func (m *PredicateCost) String() string { return proto.CompactTextString(m) }
func (*PredicateCost) ProtoMessage()    {}
func (*PredicateCost) Descriptor() ([]byte, []int) {
	return fileDescriptor_3af0daa241de0fa3, []int{5}
}
func (m *PredicateCost) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PredicateCost) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PredicateCost.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PredicateCost) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PredicateCost.Merge(m, src)
}
func (m *PredicateCost) XXX_Size() int {
	return m.Size()
}
func (m *PredicateCost) XXX_DiscardUnknown() {
	xxx_messageInfo_PredicateCost.DiscardUnknown(m)
}

var xxx_messageInfo_PredicateCost proto.InternalMessageInfo

func (m *PredicateCost) GetPredicate() string {
	if m != nil {
		return m.Predicate
	}
	return ""
}

func init() {
	proto.RegisterType((*Params)(nil), "logic.v1beta2.Params")
	proto.RegisterType((*Limits)(nil), "logic.v1beta2.Limits")
	proto.RegisterType((*Filter)(nil), "logic.v1beta2.Filter")
	proto.RegisterType((*Interpreter)(nil), "logic.v1beta2.Interpreter")
	proto.RegisterType((*GasPolicy)(nil), "logic.v1beta2.GasPolicy")
	proto.RegisterType((*PredicateCost)(nil), "logic.v1beta2.PredicateCost")
}

func init() { proto.RegisterFile("logic/v1beta2/params.proto", fileDescriptor_3af0daa241de0fa3) }

var fileDescriptor_3af0daa241de0fa3 = []byte{
	// 762 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x55, 0xcf, 0x6a, 0xdb, 0x48,
	0x18, 0xb7, 0x6c, 0xaf, 0x77, 0x3d, 0x5e, 0x27, 0x8e, 0x70, 0xb2, 0x5a, 0xef, 0xc6, 0x36, 0x73,
	0xca, 0x61, 0x57, 0x26, 0x59, 0xc8, 0xb2, 0x81, 0xa5, 0xa0, 0x94, 0xb4, 0xa5, 0x81, 0x86, 0x29,
	0x29, 0xa5, 0x3d, 0x98, 0xb1, 0x3c, 0x91, 0x87, 0x48, 0x1e, 0xa1, 0x19, 0x25, 0x72, 0x8e, 0x7d,
	0x80, 0xd2, 0x43, 0x0f, 0x3d, 0xf4, 0xd0, 0xc7, 0xc9, 0xa9, 0xe4, 0x58, 0x7a, 0x30, 0x25, 0x79,
	0x83, 0x3c, 0x41, 0xd1, 0x8c, 0x2c, 0xd9, 0x6a, 0xc0, 0xe4, 0x26, 0x7d, 0xbf, 0xef, 0xf7, 0x47,
	0xdf, 0x7c, 0x83, 0x40, 0xcb, 0x65, 0x0e, 0xb5, 0x7b, 0x67, 0xdb, 0x03, 0x22, 0xf0, 0x4e, 0xcf,
	0xc7, 0x01, 0xf6, 0xb8, 0xe9, 0x07, 0x4c, 0x30, 0xbd, 0x2e, 0x31, 0x33, 0xc1, 0x5a, 0x4d, 0x87,
	0x39, 0x4c, 0x22, 0xbd, 0xf8, 0x49, 0x35, 0xc1, 0x37, 0x45, 0x50, 0x39, 0x92, 0x2c, 0xfd, 0x25,
	0xa8, 0xd1, 0xb1, 0x20, 0x81, 0x1f, 0x10, 0x41, 0x02, 0x43, 0xeb, 0x6a, 0x5b, 0xb5, 0x9d, 0x96,
	0xb9, 0xa0, 0x62, 0x3e, 0xc9, 0x3a, 0xac, 0xd6, 0xe5, 0xb4, 0x53, 0xb8, 0x9d, 0x76, 0xf4, 0x09,
	0xf6, 0xdc, 0x3d, 0x38, 0x47, 0x86, 0x68, 0x5e, 0x4a, 0x7f, 0x08, 0x2a, 0x2e, 0xf5, 0xa8, 0xe0,
	0x46, 0x51, 0x8a, 0xae, 0xe7, 0x44, 0x0f, 0x25, 0x68, 0xad, 0x27, 0x7a, 0x75, 0xa5, 0xa7, 0x28,
	0x10, 0x25, 0x5c, 0x1d, 0x01, 0xe0, 0x60, 0xde, 0xf7, 0x99, 0x4b, 0xed, 0x89, 0x51, 0x92, 0x4a,
	0x46, 0x4e, 0xe9, 0x11, 0xe6, 0x47, 0x12, 0xb7, 0x7e, 0x4f, 0xc4, 0xd6, 0x94, 0x58, 0xc6, 0x84,
	0xa8, 0xea, 0xcc, 0xba, 0xf6, 0xca, 0x1f, 0x3e, 0x75, 0x0a, 0xf0, 0x6d, 0x09, 0x54, 0x54, 0x06,
	0xfd, 0x10, 0xfc, 0xe2, 0xe1, 0xa8, 0xcf, 0xe9, 0x05, 0x91, 0x16, 0x55, 0x6b, 0xfb, 0x72, 0xda,
	0xd1, 0xbe, 0x4e, 0x3b, 0x1b, 0x36, 0xe3, 0x1e, 0xe3, 0x7c, 0x78, 0x6a, 0x52, 0xd6, 0xf3, 0xb0,
	0x18, 0x99, 0xc7, 0x74, 0x2c, 0x6e, 0xa7, 0x9d, 0x55, 0x65, 0x31, 0xe3, 0x41, 0xf4, 0xb3, 0x87,
	0xa3, 0xe7, 0xf4, 0x82, 0xe8, 0x36, 0x68, 0xc4, 0xd5, 0x80, 0xf0, 0xd0, 0x15, 0x7d, 0x9b, 0x85,
	0x63, 0x21, 0x47, 0x50, 0xb5, 0xfe, 0x5b, 0xaa, 0xfa, 0x5b, 0xa6, 0x3a, 0xcf, 0x87, 0x68, 0xc5,
	0xc3, 0x11, 0x92, 0x95, 0xfd, 0xb8, 0xa0, 0x8f, 0x41, 0x33, 0x6e, 0x0a, 0x39, 0x09, 0xfa, 0x2c,
	0x14, 0x7e, 0x28, 0x54, 0xfc, 0xb2, 0x34, 0xfa, 0x7f, 0xa9, 0xd1, 0x1f, 0x99, 0x51, 0x5e, 0x03,
	0xa2, 0x35, 0x0f, 0x47, 0xc7, 0x9c, 0x04, 0xcf, 0x64, 0x51, 0x7e, 0xd4, 0x6b, 0x50, 0x8f, 0x7b,
	0xcf, 0x70, 0x40, 0xf1, 0xc0, 0x25, 0xdc, 0xf8, 0x49, 0x1a, 0xed, 0x2e, 0x35, 0x6a, 0x66, 0x46,
	0x29, 0x19, 0xa2, 0x5f, 0x3d, 0x1c, 0xbd, 0x98, 0xbd, 0xca, 0x03, 0xd1, 0x60, 0x04, 0x2a, 0x07,
	0xd4, 0x8d, 0x57, 0x67, 0x17, 0x54, 0xcf, 0x47, 0x54, 0x10, 0x97, 0x72, 0x61, 0x68, 0xdd, 0xd2,
	0x56, 0xd5, 0x32, 0x62, 0xa3, 0xdb, 0x69, 0xa7, 0xa1, 0xe4, 0x52, 0x18, 0xa2, 0xac, 0x35, 0xe6,
	0x0d, 0x5c, 0x6c, 0x9f, 0x4a, 0x5e, 0xf1, 0x2e, 0x5e, 0x0a, 0x43, 0x94, 0xb5, 0xc2, 0x8f, 0x45,
	0x50, 0x9b, 0xdb, 0x71, 0x7d, 0x08, 0xd6, 0xfc, 0x80, 0x0c, 0xa9, 0x8d, 0x05, 0xe1, 0xfd, 0x13,
	0x19, 0x2a, 0xb9, 0x1a, 0xf9, 0x2d, 0x56, 0x89, 0xad, 0x6e, 0xb2, 0x78, 0x86, 0xb2, 0xf9, 0x81,
	0x0d, 0x51, 0x23, 0xab, 0x65, 0x5f, 0x39, 0x60, 0x4c, 0x70, 0x11, 0x60, 0x3f, 0x59, 0xbb, 0x7c,
	0xda, 0x19, 0x1c, 0xa7, 0x9d, 0x3d, 0xeb, 0x14, 0x34, 0xcf, 0x68, 0x20, 0x42, 0xec, 0xc6, 0xe2,
	0x59, 0xc0, 0xf2, 0x3d, 0x02, 0x4a, 0xe2, 0x84, 0x0b, 0xe2, 0xa5, 0x01, 0xf5, 0x44, 0xf4, 0x20,
	0x86, 0x14, 0x2b, 0x39, 0x98, 0xcf, 0x45, 0x50, 0x4d, 0xef, 0x98, 0x3e, 0x04, 0x8d, 0x73, 0x42,
	0x9d, 0x91, 0xa0, 0x63, 0xa7, 0x7f, 0x82, 0x6d, 0xc1, 0xd4, 0x6c, 0xee, 0xb1, 0xde, 0x79, 0x3e,
	0x44, 0xab, 0x69, 0xe9, 0x40, 0x56, 0xf4, 0x10, 0x6c, 0x0c, 0xc9, 0x09, 0x8e, 0x6f, 0x40, 0x3a,
	0xb8, 0xbe, 0xcd, 0xf8, 0xec, 0x2a, 0x3d, 0x58, 0xea, 0xb5, 0xa9, 0xbc, 0xee, 0x56, 0x81, 0xa8,
	0x99, 0x00, 0x47, 0xb3, 0xfa, 0x3e, 0xe3, 0x42, 0x1f, 0x82, 0xd5, 0xc5, 0x46, 0x6e, 0x94, 0xba,
	0xa5, 0xad, 0xda, 0xce, 0x9f, 0xb9, 0xb1, 0x2e, 0xd0, 0xac, 0xcd, 0x64, 0xba, 0xeb, 0xb9, 0xe3,
	0x4f, 0xbc, 0x56, 0xfc, 0xf9, 0x6e, 0x0e, 0xdf, 0x6b, 0xa0, 0xbe, 0xe8, 0xbb, 0x0b, 0xaa, 0x69,
	0x4f, 0x32, 0xcd, 0xdc, 0x2e, 0xa4, 0x30, 0x44, 0x59, 0xab, 0xfe, 0x14, 0x94, 0xe7, 0x86, 0xf2,
	0xef, 0xd2, 0xa1, 0x24, 0x01, 0x65, 0xac, 0xbf, 0x98, 0x47, 0x05, 0xf1, 0x7c, 0x31, 0x41, 0x52,
	0xc4, 0x7a, 0x7c, 0x79, 0xdd, 0xd6, 0xae, 0xae, 0xdb, 0xda, 0xb7, 0xeb, 0xb6, 0xf6, 0xee, 0xa6,
	0x5d, 0xb8, 0xba, 0x69, 0x17, 0xbe, 0xdc, 0xb4, 0x0b, 0xaf, 0x4c, 0x87, 0x8a, 0x51, 0x38, 0x30,
	0x6d, 0xe6, 0xf5, 0x70, 0xc4, 0xc6, 0xe4, 0x6f, 0xf9, 0x23, 0xb1, 0x99, 0xab, 0x5e, 0x87, 0xbd,
	0xa8, 0xa7, 0x7e, 0x4a, 0x62, 0xe2, 0x13, 0x3e, 0xa8, 0x48, 0xf8, 0x9f, 0xef, 0x01, 0x00, 0x00,
	0xff, 0xff, 0x53, 0x14, 0xc3, 0x1a, 0xaa, 0x06, 0x00, 0x00,
}

func (m *Params) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Params) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Params) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	{
		size, err := m.GasPolicy.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintParams(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x1a
	{
		size, err := m.Limits.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintParams(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x12
	{
		size, err := m.Interpreter.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintParams(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *Limits) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Limits) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Limits) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.MaxVariables != nil {
		{
			size := m.MaxVariables.Size()
			i -= size
			if _, err := m.MaxVariables.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
			i = encodeVarintParams(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.MaxUserOutputSize != nil {
		{
			size := m.MaxUserOutputSize.Size()
			i -= size
			if _, err := m.MaxUserOutputSize.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
			i = encodeVarintParams(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.MaxSize != nil {
		{
			size := m.MaxSize.Size()
			i -= size
			if _, err := m.MaxSize.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
			i = encodeVarintParams(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.MaxResultCount != nil {
		{
			size := m.MaxResultCount.Size()
			i -= size
			if _, err := m.MaxResultCount.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
			i = encodeVarintParams(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}

func (m *Filter) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Filter) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Filter) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Blacklist) > 0 {
		for iNdEx := len(m.Blacklist) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Blacklist[iNdEx])
			copy(dAtA[i:], m.Blacklist[iNdEx])
			i = encodeVarintParams(dAtA, i, uint64(len(m.Blacklist[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Whitelist) > 0 {
		for iNdEx := len(m.Whitelist) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Whitelist[iNdEx])
			copy(dAtA[i:], m.Whitelist[iNdEx])
			i = encodeVarintParams(dAtA, i, uint64(len(m.Whitelist[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *Interpreter) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Interpreter) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Interpreter) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	{
		size, err := m.VirtualFilesFilter.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintParams(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x22
	if len(m.Bootstrap) > 0 {
		i -= len(m.Bootstrap)
		copy(dAtA[i:], m.Bootstrap)
		i = encodeVarintParams(dAtA, i, uint64(len(m.Bootstrap)))
		i--
		dAtA[i] = 0x1a
	}
	{
		size, err := m.PredicatesFilter.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintParams(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *GasPolicy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GasPolicy) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GasPolicy) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.PredicateCosts) > 0 {
		for iNdEx := len(m.PredicateCosts) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.PredicateCosts[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintParams(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.DefaultPredicateCost != nil {
		{
			size := m.DefaultPredicateCost.Size()
			i -= size
			if _, err := m.DefaultPredicateCost.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
			i = encodeVarintParams(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.WeightingFactor != nil {
		{
			size := m.WeightingFactor.Size()
			i -= size
			if _, err := m.WeightingFactor.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
			i = encodeVarintParams(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PredicateCost) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PredicateCost) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PredicateCost) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Cost != nil {
		{
			size := m.Cost.Size()
			i -= size
			if _, err := m.Cost.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
			i = encodeVarintParams(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Predicate) > 0 {
		i -= len(m.Predicate)
		copy(dAtA[i:], m.Predicate)
		i = encodeVarintParams(dAtA, i, uint64(len(m.Predicate)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintParams(dAtA []byte, offset int, v uint64) int {
	offset -= sovParams(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *Params) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Interpreter.Size()
	n += 1 + l + sovParams(uint64(l))
	l = m.Limits.Size()
	n += 1 + l + sovParams(uint64(l))
	l = m.GasPolicy.Size()
	n += 1 + l + sovParams(uint64(l))
	return n
}

func (m *Limits) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.MaxResultCount != nil {
		l = m.MaxResultCount.Size()
		n += 1 + l + sovParams(uint64(l))
	}
	if m.MaxSize != nil {
		l = m.MaxSize.Size()
		n += 1 + l + sovParams(uint64(l))
	}
	if m.MaxUserOutputSize != nil {
		l = m.MaxUserOutputSize.Size()
		n += 1 + l + sovParams(uint64(l))
	}
	if m.MaxVariables != nil {
		l = m.MaxVariables.Size()
		n += 1 + l + sovParams(uint64(l))
	}
	return n
}

func (m *Filter) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Whitelist) > 0 {
		for _, s := range m.Whitelist {
			l = len(s)
			n += 1 + l + sovParams(uint64(l))
		}
	}
	if len(m.Blacklist) > 0 {
		for _, s := range m.Blacklist {
			l = len(s)
			n += 1 + l + sovParams(uint64(l))
		}
	}
	return n
}

func (m *Interpreter) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.PredicatesFilter.Size()
	n += 1 + l + sovParams(uint64(l))
	l = len(m.Bootstrap)
	if l > 0 {
		n += 1 + l + sovParams(uint64(l))
	}
	l = m.VirtualFilesFilter.Size()
	n += 1 + l + sovParams(uint64(l))
	return n
}

func (m *GasPolicy) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.WeightingFactor != nil {
		l = m.WeightingFactor.Size()
		n += 1 + l + sovParams(uint64(l))
	}
	if m.DefaultPredicateCost != nil {
		l = m.DefaultPredicateCost.Size()
		n += 1 + l + sovParams(uint64(l))
	}
	if len(m.PredicateCosts) > 0 {
		for _, e := range m.PredicateCosts {
			l = e.Size()
			n += 1 + l + sovParams(uint64(l))
		}
	}
	return n
}

func (m *PredicateCost) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Predicate)
	if l > 0 {
		n += 1 + l + sovParams(uint64(l))
	}
	if m.Cost != nil {
		l = m.Cost.Size()
		n += 1 + l + sovParams(uint64(l))
	}
	return n
}

func sovParams(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozParams(x uint64) (n int) {
	return sovParams(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Params) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowParams
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Params: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Params: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Interpreter", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Interpreter.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Limits", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Limits.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GasPolicy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.GasPolicy.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipParams(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthParams
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Limits) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowParams
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Limits: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Limits: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxResultCount", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var v cosmossdk_io_math.Uint
			m.MaxResultCount = &v
			if err := m.MaxResultCount.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxSize", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var v cosmossdk_io_math.Uint
			m.MaxSize = &v
			if err := m.MaxSize.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxUserOutputSize", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var v cosmossdk_io_math.Uint
			m.MaxUserOutputSize = &v
			if err := m.MaxUserOutputSize.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxVariables", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var v cosmossdk_io_math.Uint
			m.MaxVariables = &v
			if err := m.MaxVariables.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipParams(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthParams
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Filter) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowParams
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Filter: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Filter: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Whitelist", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Whitelist = append(m.Whitelist, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Blacklist", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Blacklist = append(m.Blacklist, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipParams(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthParams
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Interpreter) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowParams
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Interpreter: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Interpreter: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PredicatesFilter", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.PredicatesFilter.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bootstrap", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Bootstrap = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VirtualFilesFilter", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.VirtualFilesFilter.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipParams(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthParams
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GasPolicy) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowParams
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GasPolicy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GasPolicy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WeightingFactor", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var v cosmossdk_io_math.Uint
			m.WeightingFactor = &v
			if err := m.WeightingFactor.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DefaultPredicateCost", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var v cosmossdk_io_math.Uint
			m.DefaultPredicateCost = &v
			if err := m.DefaultPredicateCost.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PredicateCosts", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PredicateCosts = append(m.PredicateCosts, PredicateCost{})
			if err := m.PredicateCosts[len(m.PredicateCosts)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipParams(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthParams
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PredicateCost) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowParams
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PredicateCost: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PredicateCost: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Predicate", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Predicate = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cost", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var v cosmossdk_io_math.Uint
			m.Cost = &v
			if err := m.Cost.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipParams(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthParams
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipParams(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowParams
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowParams
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowParams
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthParams
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupParams
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthParams
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthParams        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowParams          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupParams = fmt.Errorf("proto: unexpected end of group")
)
