---
name: Suggest a new Logic Predicate
about: Propose a new predicate to add to the logic module for availability in the Axone blockchain.
---

## 📝 Purpose

Implement a Prolog predicate to ...

## 🧪 Expected behavior

```prolog
foo(+A, ?B, -C) is det
```

Where:

- `A`: ...
- `B`: ...
- `C`: ...

## 🎯 Example

```prolog
example :-
  foo(A, B, C).
    ...
```

```prolog
?- example.
...
```

## ✅ Acceptance Criteria

- [ ] The predicate is implemented according to the described behavior and examples
- [ ] The predicate passes all test cases
- [ ] Documentation is updated accordingly.

## 🔗 References and linked predicate

- SWI-Prolog : ...
