/*
 * Copyright (C) 2023 Amazon.com, Inc. or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import { Metrics } from '@aws-lambda-powertools/metrics';
import { Tracer } from '@aws-lambda-powertools/tracer';
import { Logger } from '@aws-lambda-powertools/logger';

/**
 * Creating a global instance for the Powertools logger
 * to be used across the different applications.
 */
export const logger = new Logger({
  serviceName: process.env.POWERTOOLS_SERVICE_NAME
});

/**
 * Creating a global instance for the Powertools metrics
 * to be used across the different applications.
 */
export const metrics = new Metrics({
  defaultDimensions: {
    region: process.env.AWS_REGION ?? 'N/A',
    executionEnv: process.env.AWS_EXECUTION_ENV ?? 'N/A'
  }
});

/**
 * Creating a global instance for the Powertools tracer
 * to be used across the different applications.
 */
export const tracer = new Tracer();
