/*
 * Copyright (C) 2023 Amazon.com, Inc. or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import { CloudEvent } from '@project-lakechain/sdk';
import { Prompt } from './prompt';

/**
 * Defines the interface for an ontology classifier that can be
 * used to extract semantic ontology from a document.
 */
export interface OntologyClassifier {

  /**
   * @returns the type of the classifier.
   */
  classifierType(): string;

  /**
   * @returns an array of prompts to be sent to an LLM in order
   * to extract structured information.
   */
  getPrompts(): Prompt[];

  /**
   * A method that updates the given cloud event based on the answer
   * generated by the LLM and the prompt.
   * @param json the JSON object extracted from the LLM.
   * @param prompt the prompt used to generate the JSON object.
   * @param event the cloud event to update.
   */
  update(json: any, prompt: Prompt, event: CloudEvent): Promise<CloudEvent>;
}