/*
 * Copyright (C) 2023 Amazon.com, Inc. or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import { NagSuppressions } from 'cdk-nag';
import { Stack } from 'aws-cdk-lib';
import { Bucket } from 'aws-cdk-lib/aws-s3';

export const suppressNagS3EventTrigger = (stack: Stack, bucket: Bucket) => {

  NagSuppressions.addResourceSuppressions(bucket, [
    {id: 'AwsSolutions-S1', reason: 'Bucket provided by the user, not part of the middleware'},
    {id: 'AwsSolutions-S10', reason: 'Bucket provided by the user, not part of the middleware'}
  ], true);

  NagSuppressions.addResourceSuppressionsByPath(
      stack,
      '/NagStack/Cache/Storage/Resource',
      [
        {id: 'AwsSolutions-S1', reason: 'Ephemeral data transiting in S3 (data pipeline), no need to enable access logs'},
      ],
  );

  NagSuppressions.addResourceSuppressionsByPath(
      stack,
      '/NagStack/S3EventTrigger/Compute/ServiceRole/DefaultPolicy/Resource',
      [
        {id: 'AwsSolutions-IAM5', reason: 'Limited to the topic (using grantPublish on Lambda) and the s3 bucket'},
      ],
  );

  NagSuppressions.addResourceSuppressionsByPath(
      stack,
      '/NagStack/S3EventTrigger/Compute/Resource',
      [
        {id: 'AwsSolutions-L1', reason: 'Using NodeJS 18 which was the latest until very recently'},
      ],
  );

  NagSuppressions.addStackSuppressions(
      stack,
      [
        {id: 'AwsSolutions-IAM4', reason: 'Using standard managed policies (LambdaBasicExecutionRole)'},
      ],
  );

  NagSuppressions.addResourceSuppressionsByPath(
      stack,
      '/NagStack/BucketNotificationsHandler050a0587b7544547bf325f094a3db834/Role/DefaultPolicy/Resource',
      [
        {id: 'AwsSolutions-IAM5', reason: 'Policy generated by CDK with addEventNotification on a bucket'},
      ],
  );

};
