# 📝 Text Processing Pipelines

In this directory we provide several examples that showcase how to process text documents using different middlewares on AWS with Project Lakechain.

## 🌟 Examples

Below is a list of the different examples available in this directory.

Pipeline | Description
--- | ---
[Article Curation Pipeline](article-curation-pipeline) | A pipeline converting HTML articles into plain text.
[Email NLP Pipeline](email-nlp-pipeline) | An example showcasing how to analyze e-mails.
[Text Moderation Pipeline](text-moderation-pipeline) | An example showcasing how to moderate text documents using Amazon Comprehend.
[PDF Vision Pipeline](pdf-vision-pipeline) | An example showcasing how to transform PDF documents into text using a vision model.
[NLP Pipeline](nlp-pipeline) | A pipeline for analyzing the natural language in text-oriented documents.
[PII Redaction Pipeline](pii-redaction-pipeline) | A PII redaction pipeline using Project Lakechain.
[Text Splitting Pipeline](text-splitting-pipeline) | A pipeline for splitting text documents using different text splitting algorithms.
[JMESPath Parsing Pipeline](jmespath-parsing-pipeline) | An example showcasing how to transform JSON documents at scale.
