# 🤖 Generative Pipelines

In this directory we provide several examples that showcase how to process and transform documents using Generative AI on AWS using Project Lakechain.

## 🌟 Examples

Below is a list of the different examples available in this directory.

### Image Generation

Pipeline | Description
-------- | -----------
[Image Article Pipeline](image-article-pipeline) | An example showcasing how to automatically generate images for text articles using Amazon Bedrock.
[Image Generation Pipeline](image-generation-pipeline) | An example showcasing how to generate image using SDXL and Titan models on Amazon Bedrock.
[Image Outpainting Pipeline](image-outpainting-pipeline) | An example showcasing how to perform image outpainting using Amazon Titan.
[Image-to-Image Pipeline](image-to-image-pipeline) | An example showcasing how to transform images using Amazon Bedrock.
[SDXL Inpainting Pipeline](sdxl-inpainting-pipeline) | An example showcasing how to perform image inpainting using SDXL on Amazon Bedrock.
[Titan Inpainting Pipeline](titan-inpainting-pipeline) | An example showcasing how to perform image inpainting using Amazon Titan.
[Color Guided Image Pipeline](color-guided-image-pipeline) | An example showcasing how to perform color guided image generation using Amazon Titan.
[Image Conditioning Pipeline](image-conditioning-pipeline) | An example showcasing how to perform image conditioning generation using Amazon Titan.
