/*
 * Copyright (C) 2023 Amazon.com, Inc. or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import { z } from 'zod';

/**
 * The schema of the metadata of the document.
 */
const metadata = z.object({
  topics: z
    .array(z.string())
    .describe('The key topics of the document')
    .optional(),
  author: z
    .string()
    .describe('The author of the document')
    .optional(),
  type: z
    .enum(['article', 'book', 'paper', 'newspaper'])
    .describe('The type of the document'),
  language: z
    .string()
    .describe('The language of the document'),
  sentiment: z
    .enum(['positive', 'negative', 'neutral'])
    .describe('The sentiment of the document')
});

/**
 * The general schema of the data that we want to extract
 * from the processed documents.
 */
export const schema = z.object({
  title: z
    .string()
    .describe('The title of the document'),
  summary: z
    .string()
    .describe('A summary of the document'),
  metadata
});
