[**@cdklabs/generative-ai-cdk-constructs**](../../../README.md) • **Docs**

***

[@cdklabs/generative-ai-cdk-constructs](../../../README.md) / [bedrock](../README.md) / KnowledgeBaseProps

# Interface: KnowledgeBaseProps

Properties for a knowledge base

## Properties

### description?

> `readonly` `optional` **description**: `string`

The description of the knowledge base.

#### Default

```ts
- No description provided.
```

***

### embeddingsModel

> `readonly` **embeddingsModel**: [`BedrockFoundationModel`](../classes/BedrockFoundationModel.md)

The embeddings model for the knowledge base

***

### existingRole?

> `readonly` `optional` **existingRole**: `IRole`

Existing IAM role with a policy statement
granting permission to invoke the specific embeddings model.
Any entity (e.g., an AWS service or application) that assumes
this role will be able to invoke or use the
specified embeddings model within the Bedrock service.

***

### indexName?

> `readonly` `optional` **indexName**: `string`

The name of the vector index.
If vectorStore is not of type `VectorCollection`,
do not include this property as it will throw error.

#### Default

```ts
- 'bedrock-knowledge-base-default-index'
```

***

### instruction?

> `readonly` `optional` **instruction**: `string`

A narrative description of the knowledge base.

A Bedrock Agent can use this instruction to determine if it should
query this Knowledge Base.

#### Default

```ts
- No description provided.
```

***

### knowledgeBaseState?

> `readonly` `optional` **knowledgeBaseState**: `string`

Specifies whether to use the knowledge base or not when sending an InvokeAgent request.

***

### name?

> `readonly` `optional` **name**: `string`

The name of the knowledge base.

***

### tags?

> `readonly` `optional` **tags**: `Record`\<`string`, `string`\>

OPTIONAL: Tag (KEY-VALUE) bedrock agent resource

#### Default

```ts
- false
```

***

### vectorField?

> `readonly` `optional` **vectorField**: `string`

The name of the field in the vector index.
If vectorStore is not of type `VectorCollection`,
do not include this property as it will throw error.

#### Default

```ts
- 'bedrock-knowledge-base-default-vector'
```

***

### vectorIndex?

> `readonly` `optional` **vectorIndex**: [`VectorIndex`](../../opensearch_vectorindex/classes/VectorIndex.md)

The vector index for the OpenSearch Serverless backed knowledge base.
If vectorStore is not of type `VectorCollection`, do not include
this property as it will throw error.

#### Default

- A new vector index is created on the Vector Collection
if vector store is of `VectorCollection` type.

***

### vectorStore?

> `readonly` `optional` **vectorStore**: [`ExistingAmazonAuroraVectorStore`](../../amazonaurora/classes/ExistingAmazonAuroraVectorStore.md) \| [`AmazonAuroraVectorStore`](../../amazonaurora/classes/AmazonAuroraVectorStore.md) \| [`VectorCollection`](../../opensearchserverless/classes/VectorCollection.md) \| [`PineconeVectorStore`](../../pinecone/classes/PineconeVectorStore.md)

The vector store for the knowledge base. Must be either of
type `VectorCollection`, `RedisEnterpriseVectorStore`,
`PineconeVectorStore` or `AmazonAuroraVectorStore`.

#### Default

```ts
- A new OpenSearch Serverless vector collection is created.
```
